/*
	File:		ShPrpAcc.h

	Contains:	Interfaces to property accessor classes used with Object
				Support Library

	Written by:	Nick Pilch

	Copyright:	 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <7>	 3/24/94	eeh		bug# 1151750: scripting support for
									operations on draft
		 <6>	  2/8/94	JA		Minor tweaks for CodeWarrior.
		 <5>	 1/11/94	eeh		removed "frame" from objspec vocab
		 <4>	12/17/93	eeh		more tweaks....
		 <3>	 12/9/93	eeh		new classes: ShellSelfPropAccessor and
									ShellFramePropAccessor
		 <2>	11/15/93	eeh		added GetPropertyData and SetPropertyData
		 <1>	10/11/93	NP		first checked in

	To Do:
*/

#ifndef _SHPRPACC_
#define _SHPRPACC_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef __APPLEEVENTS__
#include "applevnt.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
	These classes aid with the getting and setting of properties for
	the callback routines for the Object Support Library. They encapulate the
	information necessary to represent a property and to get and set the
	property's value.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class ShellWinPropAccessor;

//==============================================================================
// Classes used by this interface
//==============================================================================

class PropAccessor;
class ODShell;
class ODWindow;

//==============================================================================
// ShellWinPropAccessor
//==============================================================================

class ShellPropAccessor
{
	public:
		ShellPropAccessor( DescType property, ODShell* shell ) ;

		virtual void GetPropertyData( AEDesc* result ) = 0;
		virtual void SetPropertyData( AEDesc* data ) = 0;

		DescType	GetProperty();
		ODShell*	GetShell() ;

protected :
	DescType	fProperty;

  private:

	ODShell*	fShell;
} ;

class ShellSelfPropAccessor : public ShellPropAccessor
{
	public:
		ShellSelfPropAccessor( DescType property, ODShell* shell ) ;

		void GetPropertyData( AEDesc* result ) ;
		void SetPropertyData( AEDesc* data ) ;
} ;

class ShellPartPropAccessor : public ShellPropAccessor
{
	public:
		ShellPartPropAccessor( DescType property, ODShell* shell,
				ODFrame* frame) ;

		void GetPropertyData( AEDesc* result ) ;
		void SetPropertyData( AEDesc* data ) ;

  private:
	ODFrame* fFrame ;
} ;

#ifdef TO_BE_DELETED
class XMPCLASS ShellFramePropAccessor : public ShellPropAccessor
{
	public:
#ifdef OLDSHELL
		ShellFramePropAccessor( DescType property, XMPShell* shell,
#else
		ShellFramePropAccessor( DescType property, ODShell* shell,
#endif
				XMPFrame* frame) ;

		void GetPropertyData( AEDesc* result ) ;
		void SetPropertyData( AEDesc* data ) ;

  private:
	XMPFrame* fFrame ;
} ;
#endif // TO_BE_DELETED

class ShellDraftPropAccessor : public ShellPropAccessor
{
	public:
		ShellDraftPropAccessor( DescType property, ODShell* shell,
				ODDraft* draft ) ;

		void GetPropertyData( AEDesc* result ) ;
		void SetPropertyData( AEDesc* data ) ;

  private:
	ODDraft* fDraft ;
} ;

class ShellWinPropAccessor : public ShellPropAccessor
{
  public:
	ShellWinPropAccessor(DescType property, ODShell* shell, ODWindow* window);

	void GetName(StringPtr name);
		// Caller must allocate storage

	void GetPropertyData( AEDesc* result ) ;
	void SetPropertyData( AEDesc* data ) ;

  private:
	ODWindow*	fWindow;
};

#endif // _SHPRPACC_
