/*
	File:		ShlEvtHd.h

	Contains:	Shell event handlers (and others, for now)

	Written by:	Eric House

	Copyright:	 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <4>	 3/24/94	eeh		bug# 1151750: scripting support for
									operations on draft
		 <3>	  2/8/94	JA		Minor tweaks for CodeWarrior.
		 <2>	 1/11/94	eeh		nuked FrameEventHandler class
		 <1>	11/19/93	eeh		first checked in

	To Do:
*/

#ifndef _SHLEVTHD_
#define _SHLEVTHD_

#ifndef __APPLEEVENTS__
#include "Applevnt.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifdef LATER
#ifndef _PROPACSR_
//ram#include "PropAcsr.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _FRAME_
#include "Frame.h"
#endif
#endif  //#ifdef LATER

//==============================================================================
// Theory of Operation
//==============================================================================

/*
	These classes handle events.  They represent the DO on which the event
	will act later.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class ShellEventHandler;
class ShellSaveEventHandler;
class HandlerObject;

//==============================================================================
// Classes used by this interface
//==============================================================================

class PropAccessor;
class ODShell;
class ODWindow;

//==============================================================================
// ShellWinPropAccessor
//==============================================================================

class HandlerObject
{
	public:
		HandlerObject( DescType theClass, ODObject* theObject,
				ODSLong refCon ) ;
		DescType GetClass() ;
		ODObject* GetObject() ;
		
		/*virtual*/ void Save( AEDesc* whereFileSpec ) ;
		/*virtual*/ void Close( AEDesc* whereFileSpec, DescType saveOptions ) ;
		/*virtual*/ void CountElements( DescType elemClass, AEDesc* result ) ;
		/*virtual*/ void Delete() ;
		/*virtual*/ void Clone( AEDesc* whereto, AEDesc* result ) ;
		
	protected:
		DescType fObjectClass ;
		ODObject* fTheObject ;
		ODSLong fRefcon ;

} ;

class ShellEventHandler : public HandlerObject
{
	public:
		ShellEventHandler( DescType theClass, ODObject* theObject,
				ODSLong refCon ) ;

		void Save( AEDesc* whereFileSpec ) ;
		void Close( AEDesc* whereFileSpec, DescType saveOptions ) ;
		void CountElements( DescType elemClass, AEDesc* result ) ;
		void Delete() ;
		void Clone( AEDesc* whereto, AEDesc* result ) ;
};

class PartEventHandler : public HandlerObject
{
	public:
		PartEventHandler( DescType theClass, ODFrame* frame,
				ODSLong refCon ) ;

};

#ifdef TO_BE_DELETED
class FrameEventHandler : public HandlerObject
{
	public:
		FrameEventHandler( DescType theClass, ODFrame* thePart,
				ODSLong refCon ) ;

};
#endif // TO_BE_DELETED

#endif
