/*
	File:		PrintLib.cpp

	Contains:	Library routines for printing (setting up for drawing in print DC)

	Written by:	Brad Tolman

	Change History (most recent first):

		 <1>	1/15/95	BT		first checked in
	
	THEORY OF OPERATION:

		PrintLib sets up the drawing environment for printing a GDI-based part so that
		it can start drawing onto a printer page. It provides both a one-time change

		Example using PrintLib:

		void PrintSomething( ODFacet *facet )
		{
			CPrint prt(facet);		// Creates a CPrint object on the stack, which
									// sets up the printing
			....printing code...
		}


		This can cause trouble with exceptions, because our exception package currently
		does NOT destruct objects when their scope disappears as a result of a Throw.
		You must do this manually:

		void PrintSomething( ODFacet *facet )
		{
			CPrint prt(facet);
			TRY{
				...drawing code that might Throw an exception...
			}CATCH_ALL{
				prt.EndPrint();
			}ENDTRY
		}

		This example function catches any exception and manually restores the old focus
		before letting the exception continue.
*/


#ifndef _PRINTLIB_
#define _PRINTLIB_
												  
class ODFacet;

class CPrint {
	public:
	CPrint( ODFacet *facet);
	~CPrint( )					{this->EndPrinting();}

	ODFacet			*CreatePrinterFacet(Environment *ev, ODFrame *rootFrame, ODSession *session);
	void			DeletePrinterFacet(Environment *ev);

	HDC 			GetPrinterDC();
	void 			SetDocName(char* docname);
	void 			SetDocName();
	DWORD 			GetPrintFlags();
	void 			SetPrintFlags(DWORD printFlags);
	LPPRINTDLG 		GetPrintRecord();
	ODBoolean 		HandlePageSetup();
	LPPRINTDLG		BeginPrinting(Environment *ev, ODFacet *facet);	// setup print record and bring up print dialog
	ODBoolean		StartPrintJob();
	ODBoolean 		NewPage();										// start drawing on a new printer page
	void 			EndPrinting();
	
	ODPoint	        fPrintScale;
	Rect            fPageSize;
	void 			*userData;	 									// Place to put user stuff

	protected:
	PRINTDLG 		fPrintRec;
	ODFacet			*fFacet;
	DOCINFO 		fDocInfo;

	ODBoolean		fPrintingStarted;

};


#endif //_PRINTLIB_
