/*
	File:		OSLToken.h

	Contains:	Routines to abstract the manipulation of tokens in the OSL

	Written by:	Nick Pilch

	Copyright:	 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <5>	  2/9/94	NP		Tiger Team cleanup.
		 <4>	 9/24/93	JA		Minor syntactic tweaks for THINK C++.
		 <3>	 8/19/93	NP		Changed const error code to a #define.
		 <2>	 8/16/93	NP		Adjusted for latest OSL proposal.
		 <1>	 8/11/93	NP		first checked in

	To Do:
*/

#ifndef _OSLTOKEN_
#define _OSLTOKEN_

#ifndef _CNTXTOSL_
#include "CntxtOSL.h"
#endif

#define errNotAValidToken -1730;

#ifdef __cplusplus
extern "C" {
#endif

DescType pascal OSLGetTokenDescType(OSLToken* token);
void pascal OSLSetTokenDescType(OSLToken* token, DescType appDescType);
Handle pascal OSLGetTokenDataHandle(OSLToken* token);
void pascal OSLSetTokenDataHandle(OSLToken* token, Handle appHandle);
OSErr pascal OSLGetTokenContext(OSLToken* token, OSLContext** context);
OSErr pascal OSLSetTokenContext(OSLToken* token, OSLContext* context);

GetCallbackCallerProc pascal OSLGetContextProc(OSLContext* context);
long pascal OSLGetContextRefCon(OSLContext* context);
void pascal OSLSetContextProc(OSLContext* context,
								GetCallbackCallerProc proc);
void pascal OSLSetContextRefCon(OSLContext* context, long refCon);

#ifdef __cplusplus
}
#endif

#endif // _OSLTOKEN_
