/*
	File:		ODUtils.h

	Contains:	utility functions for windows

	Written by:	Brad Nicholes

	Portions Copyright:	(c) 1993 by Apple Computer, Inc., all rights reserved.
						(c) 1993 by WordPerfect Corporation, all rights reserved.

	Change History (Windows)(most recent first):
	
	To Do:
*/

#ifndef _ODUTILW_
#define _ODUTILW_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

typedef struct _modulenode {
	struct _modulenode *		pNext;
	HANDLE						hModule;
} MODULENODE;

/* Global string array - loaded from our resources
 */
#define IDS_CLOSECAPTION        0
#define IDS_CLOSEPROMPT         1
#define IDS_USERTYPE            2
#define IDS_EXTENSION           3
#define IDS_FORMAT              4
#define IDS_EXIT				5
#define IDS_EXITANDRETURN		6
#define IDS_EMBEDDINGCAPTION	7
#define IDS_SAVECOPYAS      	8
#define IDS_FILEMENU        	9
#define IDS_EDITMENU           10
#define IDS_HELPMENU           11
#define CGLOBSTRINGS	       12 	/* ALWAYS UPDATE THIS COUNT !! */


typedef struct _instancenode {
	struct _instancenode *	pNext;
	HPROCESS						hTask;
	HINSTANCE					hInst;
	void *						pShell;
	MODULENODE *				pModuleList;
	HHOOK							hHook;

	/* OLE Interoperability per-process global variables				  OLE2
	 */																	//OLE2
	LPSTR 	gString[CGLOBSTRINGS];	/* Global string array */			//OLE2
	HLOCAL	ghStrings;			    /* Handle to global strings */		//OLE2
	BOOL	gChartIsRoot;			/* HACK: controls WM_ERASEBKGND */	//OLE2
	void	*gFactory;				/* OleWrapper's factory object */	//OLE2
	ODULong	gObjCount;				/* OleWrapper's factory use cnt */	//OLE2
	ODULong	gLockCount;				/* OleWrapper's factory lock cnt */	//OLE2
	void	*gpIMalloc;				/* IMalloc for this process */		//OLE2
	UINT	gUnique; 			    /* Process-unique number */			//OLE2
	void	*gDataFactory;			/* OleData's factory object */		//OLE2	
	ODULong	gDataObjCount;			/* OleData's factory use count */	//OLE2
	ODULong	gDataLockCount;			/* OleData's factory lock cnt */	//OLE2	
	void	*gResourceRegistry;
	long	gResourceCount;	
	void 	*pMemList;
	LCID	glcid;	   													//OLE2
	void	*gpTypeLib;													//OLE2
	FILETIME			LaunchDate;	/* Process launch date/time */		//OLE2
	ProcessSerialNumber	psn;		/* Process id */					//OLE2
} INSTANCENODE;
	
extern INSTANCENODE *pInstanceList;

LPSTR IntlToStr(ODIText* intlText, LPSTR pstr);
ODIText* StrToIntl(LPSTR pstr, ODIText** intlText);

ODBoolean ODExport EmptyRgn (HRGN Rgn);
HRGN ODExport InflateRGN(HRGN hRgn, ODSShort v);
void Expand(HRGN dst, HRGN src, int v, int method);
ODBoolean IsRgnRectangular (HRGN Rgn);

#ifdef LATER
				
XMPUShort* pascal ConvertRegionToAddress(HRGN region);
XMPUShort pascal GetGDIsegment(void);
XMPFixed  pascal ToFixed(XMPUShort value);
BOOL pascal RegisterTask (void);
#ifdef OLDSHELL
void* pascal GetCurrentShell (void);
#endif
INSTANCENODE* GetGlobals(void);
VOID pascal InstallCBTFilterHook ();
#endif

BOOL pascal AddModuleToTask (HMODULE hModule);
DWORD ODExport QueryTickCount();
HINSTANCE GetCurrentInstance (void);
long GetCurrentProcess(ProcessSerialNumberPtr pPSN);			
long SameProcess(ProcessSerialNumberPtr	pPSN1, ProcessSerialNumberPtr	pPSN2, BOOL	*pbSameProcess);
HRGN ODExport GetClipRegion (HDC);
													
#ifdef LATER
typedef HRGN (FAR PASCAL* GETCLIPRGNPROC)(HDC);									
VOID XMPCLASS pascal InitGetClipRegion();
BOOL pascal AddInstanceToList (HINSTANCE hInst, void *pShell);
							
#define fixed1		(0x00010000L)
#define FixedToInt(a) ((short)(((long)(a) + fixed1/2) >> 16))
#define IntToFixed(a) ((long)(a) << 16)
#define ff(a)		IntToFixed(a)

#ifdef DEBUG
void DebugString (char *pszString, ...);
#endif /* DEBUG */

#endif //LATER

#endif //_XMPUTILW_

