/*
	File:		ODUtils.h

	Contains:	utility functions

	Owned by:	Tantek elik

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <8>	10/13/94	JA		Took out the pragma lib_export.
		 <7>	10/12/94	RA		Export symbols for ODCopyAndRelease.
		 <6>	 10/4/94	JBS		1188214: added ODIncrementRefCountObject
									and ODCopyAndRelease
		 <5>	 8/19/94	T		#1182087 ODUtils.cpp is obsolete.  Removed
									C  functions.
		 <4>	 6/10/94	CC		ODReleaseObject macro takes environment
									argument.
		 <3>	  6/9/94	RR		Convert
		 <1>	  2/7/94	JA		first checked in
		----------------------------Renamed from Utility.h to ODUtils.h
		 <8>	11/18/93	JA		Added a comment explaining the purpose of
									the "do...while"s in the macros.
		 <7>	 11/7/93	T		add ODGetValuePtr
		 <6>	 9/08/93	jpa		Wrapped "do{...}while(0)" around macros to avoid ultra-nasty
		 								problems with any "else" statement following the macro.
		 <5>	  7/2/93	T		add ODName i/o calls
		 <4>	 6/27/93	T		add ODReleaseRefCntObject
		 <3>	  6/8/93	T		change ODDeleteField to ODDeleteObject
		 <2>	 4/29/93	T		change names of includefiles
		 <1>	 4/27/93	T		first checked in

	To Do:
	In Progress:
*/

#ifndef _ODUTILS_
#define _ODUTILS_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif


struct Environment;
class ODShape;
class ODTransform;


// The "do...while(0)" blocks wrapped around these macros are there to prevent syntactic
// problems if a macro call is immediately followed by an "else" statement, to keep
// the "else" from binding to the "if" in the macro body. The "while" loop is optimized
// out by the compiler and has no effect on the flow of control or code quality.  --Jens


#ifndef DEBUG_NODELETE
#define	ODDeleteObject(object)	\
	do{							\
		if (object!=kODNULL) {	\
			delete object;		\
			object = kODNULL;	\
		}						\
	}while(0)
#else
#define	ODDeleteObject(object)	\
	do{							\
		if (object!=kODNULL) {	\
			object = kODNULL;	\
		}						\
	}while(0)
#endif

#define	ODReleaseObject(ev, object) \
	do{								\
		if (object!=kODNULL) {		\
			object->Release(ev);	\
			object = kODNULL;		\
		}							\
	}while(0)

#define	ODIncrementRefCountObject(ev, object)	\
	do{											\
		if (object!=kODNULL) {					\
			object->IncrementRefCount(ev);		\
		}										\
	}while(0)


ODShape* ODCopyAndRelease( Environment*, ODShape* );
ODTransform* ODCopyAndRelease( Environment*, ODTransform* );


#endif //_ODUTILS_
