/*
	File:		ODMemory.h

	Contains:	Procedural interfaces to the Memory component

	Written by:	Michael Burbidge

	Copyright:	c 1993-4 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):
	
		 <2>	 11/6/94	SS		Fixes for C Compilers. Added init
									prototype.
		 <1>	10/24/94	jpa		first checked in
		 <7>	 9/29/94	RA		1189812: Mods for 68K build.
		 <6>	 9/14/94	jpa		Changed definition of opaque ODMemoryHeapID
									type. [1186692]
		 <5>	 8/17/94	jpa		Added ODBlockIsObject and ODIsBlockAnObject
									[1181510]
		 <4>	  8/8/94	jpa		Changed ODMemoryHeapID to a ptr to avoid
									confusion w/numbers.
		 <3>	 7/11/94	jpa		Hook SOM memory management into MMM. Added
									ODInitMemory.
		 <2>	 6/28/94	MB		Change ODRecoverHeap to ODRecoverHeapID
		 <1>	 6/20/94	MB		first checked in

	To Do:
	In Progress:
*/

#ifndef _ODMEMORY_
#define _ODMEMORY_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef __FRAGLOAD__
//bgn#include <FragLoad.h>
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

//========================================================================================
// Type definitions
//========================================================================================

typedef struct MemHeap MemHeap;
typedef MemHeap* ODMemoryHeapID;		// An anonymous pointer type

typedef ODULong ODBlockSize;

//========================================================================================
// Constant definitions
//========================================================================================

#define kDefaultHeapID ((ODMemoryHeapID) 0L)

//========================================================================================
// Constant definitions
//========================================================================================

#if 0
// This is obsolete... --jpa
#define ODNewSOMObjectInHeap(obj, cls, heap)										\
do{																					\
	SOMClass cls##Class = cls##NewClass(cls##_MajorVersion, cls##_MinorVersion);	\
	int size = _somGetInstanceSize(cls##Class);										\
	void *buffer = ODNewPtr(size,ODGetSystemHeap());								\
	obj = cls##Renew(buffer);														\
}while(0)
#endif

//========================================================================================
// Operations on heaps
//========================================================================================

#ifdef PLATFORM_MACINTOSH
pascal OSErr UtilitiesCFMInit( InitBlockPtr );

ODMemoryHeapID	ODGetDefaultHeap();
ODMemoryHeapID	ODGetSystemHeap();

ODMemoryHeapID	ODCreateHeap(ODULong initialSize, ODULong growBy, Boolean fromSysMemory,
							const char *name);
void			ODDestroyHeap(ODMemoryHeapID heapID);
#endif

//========================================================================================
// Operations on pointer based blocks
//========================================================================================

// ----- Allocation and freeing

#ifdef PLATFORM_MACINTOSH
#ifdef __cplusplus
void*		ODNewPtr(ODBlockSize size, ODMemoryHeapID heapID =kDefaultHeapID);
void*		ODNewPtrClear(ODBlockSize size, ODMemoryHeapID heapID =kDefaultHeapID);
#else
void*		ODNewPtr(ODBlockSize size, ODMemoryHeapID heapID);		// No default values for C
void*		ODNewPtrClear(ODBlockSize size, ODMemoryHeapID heapID);
#endif
#endif
#ifdef PLATFORM_WINDOWS
#ifdef DEBUG_VALIDATION
void* 		ODNewPtr(ODBlockSize size, ODMemoryHeapID heapID, LPSTR pFile, LONG lLineNum);
void* 		ODNewPtrClear(ODBlockSize size, ODMemoryHeapID heapID, LPSTR pFile, LONG lLineNum);

#define ODNewPtr(a,b) ODNewPtr(a,b,__FILE__,__LINE__)
#define ODNewPtrClear(a,b) ODNewPtrClear(a,b,__FILE__,__LINE__)
#else
void*		ODNewPtr(ODBlockSize size, ODMemoryHeapID heapID);		// No default values for C
void*		ODNewPtrClear(ODBlockSize size, ODMemoryHeapID heapID);
#endif
#endif
void*		ODReallocate(void *block, ODBlockSize newSize);
void 		ODDisposePtr(void *block);

// ----- Utilities

ODMemoryHeapID ODRecoverHeapID(const void *block);

//========================================================================================
// Operations on handle based blocks
//========================================================================================

// ----- Allocation and freeing

ODHandle	ODNewHandle(ODBlockSize howBig);
void		ODDisposeHandle(ODHandle handle);
ODHandle	ODCopyHandle(ODHandle handle);
#ifdef PLATFORM_WINDOWS
ODHandle 	ODReallocHandle(ODHandle curHandle, ODBlockSize howBig);
#endif

// ----- Block size accessors

ODULong		ODGetHandleSize(ODHandle handle);
void		ODSetHandleSize(ODHandle handle, ODBlockSize size);

// ----- Locking and unlocking

void*		ODLockHandle(ODHandle handle);
void		ODUnlockPtr(void* ptr);
void		ODUnlockHandle(ODHandle handle);

//========================================================================================
// Utility functions
//========================================================================================

void		ODBlockMove(const void *from, void *to, ODBlockSize size);

void		ODBlockIsObject( void *block, ODBoolean isObject );	// Called by ODObject::somInit
ODBoolean	ODIsBlockAnObject( const void *block );


#ifdef __cplusplus
}
#endif

#endif /*_ODMEMORY_*/
