/*
	File:		IText.h

	Contains:	Routines for manipulating ITexts.

	Written by:	Vincent Lo

	Copyright:	c 1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <1>	10/24/94	jpa		first checked in
		 <3>	 7/27/94	NP		Added CreateIText(unsigned long) and
									CopyIText.
		 <2>	  6/7/94	CG		Added GetITextStringLength.
		 <1>	  6/2/94	VL		first checked in

	To Do:
*/

#ifndef _ITEXT_
#define _ITEXT_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

ODExport ODIText*  CreateIText(ODScriptCode scriptCode, ODLangCode langCode, char* text);
//bgnODIText* CreateIText(ODScriptCode scriptCode, ODLangCode langCode, StringPtr text);
ODExport ODIText*  CreateIText(unsigned long maxLength);
	// Allocates and returns an ODIText of 0 length and of maxLength buffer size.
	//	Useful for passing to routines that will fill it in.
ODExport ODIText*  CopyIText(ODIText* original);
	// Allocates and returns an exact copy of the IText passed in.

void ODExport SetITextScriptCode(ODIText* iText, ODScriptCode scriptCode);
ODScriptCode ODExport GetITextScriptCode(ODIText* iText);

void ODExport SetITextLangCode(ODIText* iText, ODLangCode langCode);
ODLangCode ODExport GetITextLangCode(ODIText* iText);

void ODExport SetITextString(ODIText* iText, char* text);
//bgnvoid SetITextString(ODIText* iText, StringPtr text);

ODULong ODExport GetITextStringLength(ODIText* iText);
ODExport char*  GetCStringFromIText(ODIText* iText);
//bgnStringPtr GetPStringFromIText(ODIText* iText);

void ODExport DisposeIText(ODIText* iText);

#endif	// _ITEXT_
