/* FILE: ISTRCTR.H
 *
 * DESCRIPTION:
 *   Definition of XMPIStreamContainer class, a BENTO wrapper for the OLE2
 *   IStream interface.
 *
 * HISTORY:
 */
#ifndef _ISTRCTR_
#define _ISTRCTR_


#ifndef SOM_ODBentoContainer_xh
#include "CMCtr.xh"
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef SOM_ODRefCntObject_xh
#include "RefCtObj.xh"
#endif

#ifndef _BENTOHDR_
#include "BentoHdr.h"
#endif

#ifndef SOM_ODDocument_xh
#include "Document.xh"			// included for XMPDocumentID
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_TYPES__
#include "CMAPITyp.h"
#endif

#include <ole2.h>

/* THEORY OF OPERATION:
 *   A Container represents a physical collection of bytes, like a file or a
 *   section of memory or in this case an IStream within an OLE doc file.
 *
 *   XMPContainer objects are created through XMPStorageSystem object via:
 *  	- XMPStorageSystem::GetContainer
 *		- XMPStorageSystem::NewContainer which should do an implicit call to
 * 		  XMPStorageSystem::GetContainer.
 *
 *  Access to Container is not guaranteed to be exclusive.
 *
 *  For every XMPStorageSystem::GetContainer there should be a paranthetically
 *  correct XMPStorageSystem::ReleaseContainer.
 *
 *  A XMPContainer object is responsible for guaranteeing that multiple accesses
 *  to a Document use the same XMPDocument object.
 */

class	ODStorageSystem;
//bgnclass	XMPFar XMPSCollection;

class	ODIStreamContainer;

class ODIStreamContainer : public ODBentoContainer
{
	friend class ODStorageSystem;	

	protected:
		ODIStreamContainer();
		ODMethod ~ODIStreamContainer();

		ODMethod void 			InitContainer(ODStorageSystem*,ODContainerID);
		ODMethod ODContainer 	*Create();	
		ODMethod ODContainer 	*Open();
		ODMethod ODContainer 	*Close();
		ODMethod ODSize 		Purge(ODSize size);		

	public:
		ODMethod void			HandsOffStream();						//OLE2
		ODMethod void			AdoptNewStream(IStream *NewStream);		//OLE2
		ODMethod IStream 		*SetStream(IStream  *Stream);			//OLE2
};
#endif	// _ISTRCTR_
