/*
	File:		InfoUtil.h

	Contains:	function declarations Info getters & setters

	Written by:	Tantek elik

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <3>	10/31/94	CG		#1147225: Added GetThisKindFromList.
		 <2>	10/27/94	CG		#1147225: Added Editor and Kind popup Menu
									manipulation function protos and added
									Extern "C".
		 <1>	10/24/94	jpa		first checked in
		 <4>	 8/29/94	T		#1183567 StdTypIO routine implementation &
									fixup
		 <3>	 7/11/94	T		moved some functions to Info.cpp
		 <2>	 7/11/94	T		moved orphaned dialog functions to
									DlogUtil.h
		 <1>	  7/5/94	T		first checked in
		 <0>	  7/5/94	SV		SOMverted
		<12>	 3/31/94	eeh		bug #1153999: change defs of ODGetPOName,
									ODGetPOComments, and ODGetPOModifiedBy
		<11>	 3/28/94	CG		1153547: Changed parameter list for
									ODGetPOModifiedBy.
		<10>	 3/24/94	T		(no bug# yet) ShowPartFrameInfo returns a
									boolean indicating whether or not the User
									pressed OK
		 <9>	  3/1/94	JA		Made string consts extern. (1147295)
		 <8>	 2/15/94	T		fix 1143649
		 <7>	 1/11/94	T		add ODType	ODGetKind(ODPart* part);
		 <6>	12/14/93	T		added kODViewAs constants
		 <5>	12/11/93	T		changed ODGetPOModifiedBy to use Str32
									instead of IntlText because Str32 is the
									only type of username info we can extract
									from Mac
		 <4>	 12/8/93	T		#include "ODMem.h"
		 <3>	 12/8/93	T		added Getters & Setters for IconFamily on
									Part
		 <2>	 12/7/93	T		added Part & Frame Property getters and
									setters
		 <1>	11/18/93	T		first checked in

	To Do:
*/


#ifndef _INFOUTIL_
#define _INFOUTIL_

#ifndef _ODTYPES_
#include <ODTypes.h>
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef __CONTROLS__
//bgn#include <Controls.h>
#endif
#endif

#ifndef _EDITRSET_
#include "editrset.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================

// ViewAs ISOStr constants

#define kODViewAsSmallIcon	"OpenDoc:ViewAs:SmallIcon"
#define kODViewAsLargeIcon	"OpenDoc:ViewAs:LargeIcon"
#define kODViewAsThumbnail	"OpenDoc:ViewAs:Thumbnail"
#define kODViewAsFrame 		"OpenDoc:ViewAs:Frame"

//==============================================================================
// Scalar Types
//==============================================================================

typedef Handle	ODIconFamily;

//==============================================================================
// Classes used by this interface
//==============================================================================

class	ODFrame;
class	ODStorageUnit;
class	ODCategorySet;
class	ODPart;
class	ODPersistentObject;
class	ODTypeList;
class	EditorSet;
class	ODSession;

//==============================================================================
// Info functions
//==============================================================================
extern "C" {



//-------------------------------------------------------------------------------------
// Part & Frame Property getters and setters
// Note: 
//  all Getters expect you to pass in a buffer to be filled 
//  or kODNULL which causes it to create one for you
//  all Setters do NOT consume what you pass in, so it is safe to pass in
// 	a reference to your internal structures.  They are only accessed for the duration
// 	of the Setter API call.
// These conventions were adopted to reduce memory allocation/deallocation.
//-------------------------------------------------------------------------------------
// private by convention

ODIText*	ODGetPOName(ODPersistentObject* pstobj,ODIText* name);
void		ODSetPOName(ODPersistentObject* pstobj,ODIText* name);

ODIText*	ODGetPOComments(ODPersistentObject* pstobj,ODIText* comments);
void		ODSetPOComments(ODPersistentObject* pstobj,ODIText* comments);

ODULong	ODGetPOSize(ODPersistentObject* pstobj);
ODULong	ODGetPOCreationDate(ODPersistentObject* pstobj);
ODULong	ODGetPOModificationDate(ODPersistentObject* pstobj);
ODIText*	ODGetPOModifiedBy(ODPersistentObject* pstobj,ODIText* comments);

//-------------------------------------------------------------------------------------
// Part only Property getters and setters
//-------------------------------------------------------------------------------------
// private by convention
void	ODGetCategories(ODPart* part,ODCategorySet* comments);

ODType	ODGetKind(ODPart* part);

void	ODGetIconFamily(ODPart* part,ODIconFamily iconFamily);
void	ODSetIconFamily(ODPart* part,ODIconFamily iconFamily);

ODBoolean	ODGetIsStationery(ODPart* part);
void		ODSetIsStationery(ODPart* part,ODBoolean isStationery);

//-------------------------------------------------------------------------------------
// Frame only Property getters and setters
//-------------------------------------------------------------------------------------
// see Frame.h


//-------------------------------------------------------------------------------------
// Editor and Kind popup Menu manipulation functions
// copied from LinkDlgs.cpp (!with changes by T and CG)
//-------------------------------------------------------------------------------------
void AddTypesToMenu(ODTypeList* kindList, 
								HWND kindMenu, 
								ODSession* session);
void AddEditorsToMenu(EditorSet* editorList,
								HWND editorMenu, 
								ODSession* session);
void ContentValueTypes(ODStorageUnit* contentSU, ODTypeList* typeList);
void GetDestinationKindsList(
				ODTypeList*	kindList,
				ODTypeList*	translateToList,
				ODTypeList*	translateFromList,
				ODSession*		session);
ODBoolean GetThisEditorFromList(ODSShort editorItem, 
								EditorSet* editorsList, 
								ODEditor* editorID);
void GetThisKindFromList(ODSShort kindItem, 
							ODTypeList*	kindList, 
							ODType* kind);
}	// End of extern "C" {

#endif // _INFOUTIL_
