/*
	File:		DraftWn.h

	Contains:	definition of the DraftWin and DraftInfoRec classes

	Written by:	Tantek elik

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <3>	 8/29/94	T		#1183567 StdTypIO routine implementation &
									fixup
		 <2>	 6/27/94	T		added fEV to DraftWindow and
									DraftInfoRec
		 <1>	 6/27/94	T		first checked in
		 <0>	 6/27/94	SV		SOMverted
		<10>	  5/3/94	eeh		bug #1155857: param changes to MakeAList
									and GetUserStrings
		 <9>	 3/31/94	eeh		bug #1153999: made fModifiedBy a ODIText*
		 <8>	  2/8/94	JA		Minor tweaks for CodeWarrior.
		 <7>	 1/25/94	NP		T: implemented
		 <6>	 1/14/94	T		added some skeleton code from HI
		 <5>	 1/13/94	T		reworked apis for latest round of HI
									changes
		 <4>	 8/24/93	T		removed code made obsolete by HI Changes
		 <3>	 8/18/93	T		removed SetPreviousComment support
		 <2>	 8/11/93	T		move property & type constants to StdProps
									and StdTypes
		 <1>	 7/14/93	T		first checked in

	To Do:
*/

#ifndef _DRAFTWN_
#define _DRAFTWN_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif


#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef __DIALOGS__
//bgn#include <Dialogs.h>
#endif

#ifndef __LISTS__
//bgn#include <Lists.h>
#endif
#endif

//==============================================================================
// Constants
//==============================================================================

#define kDraftWinNone	0
#define kDraftWinOpen	1
#define	kDraftWinDone	2
#define kDraftWinCreate	3
#define	kDraftWinDelete	4
//==============================================================================
// Scalar Types
//==============================================================================

typedef	ODULong	DraftWinAction;
struct DWStringsArray ;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class DraftWindow;	// very platform dependent
class DraftInfoRec;

//==============================================================================
// Classes used by this interface
//==============================================================================

class DraftInfoRec 
{
	DraftInfoRec*	fNext;
	DraftInfoRec*	fFirst;
	ODDraft*		fDraft;
	ODStorageUnit*	fDraftProperties;
	ODDraftID		fDraftID;
	ODULong		fDraftNumber;
	ODULong		fCreated;
	ODIText*		fComment;
	ODIText*		fModifiedBy;
	Environment*		fEV;
	
public:

	DraftInfoRec();
	ODNVMethod	void	InitDraftInfoRec(ODDraft*	draft);
		// note: draft reference is consumed in Init and released in destructor
	ODVMethod	~DraftInfoRec();
	
	ODMethod	DraftInfoRec*	Next() 		{ return fNext; }
	ODMethod	ODULong		Number()	{ return fDraftNumber; }
	ODMethod	ODDraft*		Draft()		{ return fDraft;	}
	ODMethod	void			GetUserStrings(	LPSTR theStrings ) ;
	
// only call these on the first DraftInfoRec
	ODMethod	void	InternalizeHistory();
	ODMethod	void	VerifyUpdate();

protected:
	ODMethod	ODIText*	GetComment();
	ODMethod	void		SetComment(ODIText* newComment);

};


//==============================================================================
// DraftWindow
//==============================================================================

class DraftWindow
{	
  public:

	DraftWindow();
	ODNVMethod void 	InitDraftWindow(ODDraft* draft);
	ODVMethod 		~DraftWindow();

	ODMethod	DraftWinAction	Drafts(ODDraft* draft);
	ODMethod	ODDraft*			GetSelectedDraft()	{return fSelectedDraft;}
	
	ODMethod	void	DraftCreated(ODDraft* draft);	
	// used to init the Draft Properties
	// can be used independently of other methods including initialize


	ODMethod	ODSShort	CountDrafts() ;	

#ifdef PLATFORM_WINDOWS
	ODMethod	void 	BuildDraftList(HWND hDraftList);
	ODMethod	void 	UpdateSelectedDraft(WORD wSelIndex);
#endif

  protected:
  	ODMethod	ODBoolean	CreateDraft();
  	ODMethod	ODBoolean	RemoveSelectedDrafts();
	ODMethod	void	Print();
	
//	ODMethod	void	SelectAllDrafts();

#ifdef PLATFORM_MACINTOSH
	ODMethod	void	BuildDraftList(ListHandle listH);
	ODMethod	ListHandle MakeAList(DialogPtr dlgPtr, ODSShort itemNum,
			ODBoolean scrollH, ODBoolean scrollV, long refcon );
#endif

  private:
	Environment*		fEV;
	ODDraft*			fDraft;
	ODDocument*		fDocument;
//	ODPlatformWindow	fWindow;
	DraftInfoRec*		fDraftInfo;
	ODDraft*		fSelectedDraft;
	ODULong		fSelectedDraftNumber;
};



#endif	// _DRAFTWIN_
