/* $HEADER$ */
/*
	File:		DocShell.h

	Contains:	definition of DocShell class

	Written by: Brad Nicholes

	Copyright:	(c) 1993 by WordPerfect Corporation, all rights reserved.

*/


#ifndef _DOCSHELL_
#define _DOCSHELL_

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF
#include "plfmdef.h"
#endif

#ifndef _ODSHELL_
#include "odshell.h"
#endif

#ifndef SOM_ODMenuBar_xh
#include "menubar.xh"
#endif

#ifndef _PLFMFILE_
#include "PlfmFile.h"
#endif

#ifndef SOM_ODContainer_xh
#include "odctr.xh"
#endif

#ifndef SOM_ODDocument_xh
#include "document.xh"
#endif

#ifndef _OLEWRAP_H_
#include "olewrap.h"
#endif

#ifdef LATER
const DescType kXMPShellPropAccessor 		= 0x73706163;	// 'spac';
const DescType kXMPShellSelfPropAccessor	= 0x7368656C;	// 'shel';
#endif

ODBoolean CreateUntitledFileName(LPSTR lpFileName, BOOL bIsOLE);

//==============================================================================
// Classes defined in this interface
//==============================================================================
class ODExport DocShell;

//==============================================================================
// Classes used in this interface
//==============================================================================
class ODExport ODShell;
class OLEWrapper;
#ifdef LATER
class XMPCLASS XMPSemanticInterface;
#endif

						
class ODExport DocShell
{	

public:

	DocShell			*fpPrev;										//OLE2
	DocShell			*fpNext;										//OLE2

//-------------------------------------------------------------------------------------
// Constructor/Destructor
//-------------------------------------------------------------------------------------

	DocShell();
	virtual ~DocShell();

	ODMethod	ODBoolean	Initialize(LPSTR CmdLine,LPSTR PartType);	//OLE2

	ODMethod	BOOL	 	HandleDocumentEvents (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	ODMethod	ODShell*	GetShell() {return fShell;};
	ODMethod	void		SetShell(ODShell* shell) {fShell = shell;};

	ODMethod	void		SetDocShellWindow (HWND hWnd) { fDocWnd = hWnd; };
	ODMethod	HWND		GetDocShellWindow () { return fDocWnd; };
	ODMethod	void		SetRootWindow (HWND hWnd) { fRootWnd = hWnd; };

	ODMethod	PlatformFile* 	NewDocument(ODValueType PartType, ODBoolean bIsOLE);
	ODMethod	ODBoolean	CreateDocument(ODContainer* newContainer, LPSTR newRootPartType);
	ODMethod	ODContainer*	GetContainer () { return fContainer; };
	ODMethod	ODDocument*	GetDocument () { return fDocument; };
	ODMethod	ODDraft*	GetDraft() { return fDraft; };

	ODMethod	void 		Open();
	ODMethod	void		OpenFile(PlatformFile* file);
	ODMethod	void 		OpenDraft(ODDraft* draft);

	ODMethod	BOOL 		CloseDocumentWindow(HWND window, PlatformFile *file, ODULong saveOptions);
	ODMethod 	void 		DestroyDocumentWindow( HWND hDocWindow );
	ODMethod	void 		CloseRootWindow(HWND window, PlatformFile *file, ODULong saveOptions);
	ODMethod	void		CloseDraft(ODDraft* draft);

	ODMethod	void		Save(PlatformFile *file, BOOL bSaveOnly);
	ODMethod	ODBoolean	SaveAs(LPSTR pszFilename, BOOL bSaveSaveAs);
	ODMethod	void 		SaveDraft();
	ODMethod	BOOL		IsNewFile() { return fIsNew; };
	ODMethod	void		SetIsNewFile(BOOL b) { fIsNew = b; };

	/* Filename of this document										//OLE2
	 */																	//OLE2
	ODMethod	void		GetFileName(LPSTR, ULONG);    				//OLE2
																		//OLE2
	/* Methods to access the status bar text                   			//OLE2		
	 */																	//OLE2
	ODMethod	void		GetStatusBarText(LPSTR, ULONG);				//OLE2
	ODMethod	void		SetStatusBarText(LPSTR);					//OLE2
																		//OLE2
	/* Method to access the OleAutomation object for this document		//OLE2
	 */																	//OLE2
	ODMethod	void	*	GetDocObject();                       		//OLE2
	ODMethod	void		Revert();									//OLE2
	ODMethod	ODBoolean	HasWriteAccess();							//OLE2

	ODMethod	PlatformFile *	SelectFile();
	ODMethod	void 		LaunchFile(PlatformFile* file);

	ODMethod	OleWrapper *	GetOleWrapper() { return fOleWrapper;};
	ODMethod	void		SetOleWrapper(OleWrapper *pWrap) { fOleWrapper = pWrap;};
	ODMethod	void 		OnDataChange();
	ODMethod	void 		OleFixupMenu(HWND hwndWindow,HMENU hMenu);

	ODMethod	void		AdjustMenu();
	ODMethod	void 		UpdateUndoMenus();

	ODMethod	BOOL 		SelectRootPart(LPSTR* lpPartType);

	ODMethod	BOOL 		HandleNewCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleOpenCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleInsertCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleCloseCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleSaveCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleSaveAsCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleRevertCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleDraftCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePrintCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePageSetupCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleExitCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleUndoCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleRedoCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleCutCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleCopyCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePasteCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePasteAsCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleClearCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleSelectAllCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePartInfoCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandlePreferencesCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleViewAsWindowCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleContentsCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleSearchCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	ODMethod	BOOL 		HandleAboutCommand (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

#ifdef LATER
	ODMethod	void 		SetAEError(ODError error);
	ODMethod	ODError 	GetAEError();
	static 		ODError 	HandleOpenAppEvent(ODPart*	thePart,AppleEvent* message,AppleEvent* reply,ODSLong refCon);
	static 		ODError 	HandleOpenDocsEvent(ODPart* thePart,AppleEvent* message,AppleEvent* reply,ODSLong refCon);
	static 		ODError 	HandlePrintDocsEvent(ODPart* thePart,AppleEvent* message,AppleEvent* reply,ODSLong refCon);
	static 		ODError 	HandleQuitEvent(ODPart* thePart,AppleEvent* message,AppleEvent* reply,ODSLong refCon);
	static 		ODError 	HandleGetTerminology(ODPart* thePart,AppleEvent* message,AppleEvent* reply,ODSLong refCon);
#endif

private:
	ODMethod	PlatformFile*	CreateUntitledContainer(ODDocument** documentPtr, ODContainer** containerPtr, BOOL bIsOLE);
	ODMethod	ODBoolean	DoesUserCancelClose(PlatformFile *file, ODULong saveOptions);
	ODMethod	BOOL 		CopyFile(LPSTR pDestFile, LPSTR pSrcFile);

	ODMethod	ODBoolean	DoesUserOKRevert();
	ODMethod	void		Drafts();

	ODMethod	PlatformFile*	GetUserFile();
	ODMethod	void		GetUserFileName(char* fileName, ODULong maxLen);


private:
	ODShell*			fShell;
	HWND				fDocWnd;
	HWND				fRootWnd;
	ODContainer*		fContainer;
	ODDocument*			fDocument;
	ODDraft*			fDraft;
	ODDraftPermissions 	fPermissions;
	OleWrapper*			fOleWrapper;
	LPSTR				fszTempFile;
	BOOL				fIsNew;
#ifdef LATER
	ODError				fErrorFromOpenEvents;
#endif
	Environment*		fEV;
	LPVOID				fDocObject;										//OLE2

};

#endif /*DOCSHELL*/


