/*
	File:		DfltAcs.h

	Contains:	Implementation of Mac specific default accessors and handlers.

	Owned by:	Eric House

	Copyright:	 1995 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <4>	  2/3/95	eeh		1217393: mod. params to use new ODDesc etc.
		 <3>	 1/27/95	TJ		NP: Added forward class declarations.
		 <2>	 1/25/95	eeh		1214783: more implementation
		 <1>	  1/18/95	eeh		first checked in

	To Do:
*/

#ifndef _DFLTACS_
#define _DFLTACS_


#ifndef _CNTXTOSL_
#include "CntxtOSL.h"
#endif

class ODOSLToken;
class ODAppleEvent;
class DefaultAccessorSI;
class ODSession;
class ODPart;

#define DEFAULT_ACCESSOR_PARAMS	Environment		*ev,					\
								ODPart*			scriptlessPart,			\
								DescType		desiredClass,			\
								OSLToken*		container,				\
								DescType		containerClass,			\
								DescType		form,					\
								AEDesc*			selectionData,			\
								ODOSLToken*		value,					\
								ODSession*		session					\
								
typedef ODError (*PartAccessorProc)(DEFAULT_ACCESSOR_PARAMS);

ODError GetWildcardFromPart(DEFAULT_ACCESSOR_PARAMS);

ODError GetPartFromNULL(DEFAULT_ACCESSOR_PARAMS);

ODError GetPropFromNULL(DEFAULT_ACCESSOR_PARAMS);


typedef ODError (*EventHandlerProc)( Environment *ev,
				ODPart* thePart, AppleEvent* message,
				AppleEvent* reply, ODSession* session);

ODError HandleGetData(	Environment *ev,
							ODPart* thePart,
							AppleEvent* message,
							AppleEvent* reply,
							ODSession* session);

ODError HandleSetData(	Environment *ev,
								ODPart* thePart,
								AppleEvent* message,
								AppleEvent* reply,
								ODSession* session);
#endif

