/*
	File:		CntxtOSL.h

	Contains:	Additions to the OSL interface for OpenDoc support.

	Written by:	Nick Pilch

	Copyright:	c 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		<12>	  2/9/94	NP		Tiger Team cleanup.
		<11>	  2/7/94	NP		Tiger Team doings.
		<10>	10/22/93	NP		Added OSLCallObjectAccessor.
		 <9>	10/18/93	NP		Interface tweaks.
		 <8>	10/11/93	NP		Type name and parameter name tweaks.
		 <7>	 9/24/93	JA		Minor syntactic tweaks for THINK C++.
		 <6>	 9/20/93	NP		Added GetCurrentContext and
									SetCurrentContext.
		 <5>	  9/3/93	NP		Added "switch" descriptor type.
		 <4>	 8/19/93	NP		Changed const error code to a #define.
		 <3>	 8/18/93	NP		Mods for new context scheme.
		 <2>	 8/16/93	NP		Added constant.
		 <1>	 8/16/93	NP		first checked in

	To Do:
*/

/**/
/*											
	cApple Computer, Inc.  2/21/91 			
	      All Rights Reserved.				

*/

#ifndef _CNTXTOSL_
#define _CNTXTOSL_

#ifndef __AEOBJECTS__
#include "AEObject.h"
#endif

#define errNoDataHandle = -1731;

//enum
//{
// 	kSwitchDescType = LONGCONST('s','w','c','h')
//};

#define kSwitchDescType LONGCONST('s','w','c','h')

/************ Contexts ***************/

enum OSLCallbackSelector
{
	kCallbackFlagsGetter,
	kObjectAccessor,
	kCompareProc,
	kCountProc,
	kDisposeTokenProc,
	kMarkProc,
	kGetMarkTokenProc,
	kAdjustMarksProc,
	kGetErrDescProc
};
typedef enum OSLCallbackSelector OSLCallbackSelector;

typedef ProcPtr CallbackCallerProc;

#ifdef __cplusplus
extern "C" {
#endif

typedef
CallbackCallerProc (*GetCallbackCallerProc)(OSLCallbackSelector whichCallback);

#ifdef __cplusplus
}
#endif

struct OSLContext
{
	GetCallbackCallerProc	getCallerProc;
	long					refCon;
};
typedef struct OSLContext OSLContext;

/************ Tokens ***************/

typedef AEDesc OSLToken;

struct ContainedTokenRecord
{
	DescType	tokenClass;
	OSLToken	token;
};
typedef struct ContainedTokenRecord ContainedTokenRecord, *ContainedTokenRecPtr;
#ifdef CompileOnMac
typedef ContainedTokenRecPtr *ContainedTokenRecHandle;
#else	//WINDOWS
typedef HANDLE ContainedTokenRecHandle;
#endif	//CompileOnMac


/************ CallbackCallerProc real types ***************/

#ifdef __cplusplus
extern "C" {
#endif

typedef long (*CallbackFlagsGetter)(long contextRefCon);

typedef OSErr (*ObjectAccessorCaller)(DescType			desiredClass,
										const OSLToken*	containerToken,
										DescType		containerClass,
										DescType		keyForm,
										const AEDesc*	keyData,
										OSLToken*		value,
										Boolean*		procFound,
										long			contextRefCon);

typedef OSErr (*CompareProcCaller)(DescType			oper,
									const OSLToken*	obj1,
									const OSLToken*	obj2,
									Boolean*		result,
									long			contextRefCon);

typedef OSErr (*CountProcCaller)(DescType			desiredType,
									DescType		containerClass,
									const OSLToken*	container,
									long*			result,
									long			contextRefCon);

typedef OSErr (*DisposeTokenProcCaller)(OSLToken*	unneededToken,
										long		contextRefCon);

typedef OSErr (*GetMarkTokenProcCaller)(const OSLToken*	dContainerToken,
											DescType		containerClass,
											OSLToken*		result,
											long			contextRefCon);

typedef OSErr (*GetErrDescProcCaller)(DescPtr*	appDescPtr,
										long	contextRefCon);

typedef OSErr (*MarkProcCaller)(const OSLToken*		dToken,
										const OSLToken*	markToken,
										long			index,
										long			contextRefCon);

typedef OSErr (*AdjustMarksProcCaller)(long			newStart,
										long			newStop,
										const OSLToken*	markToken,
										long			contextRefCon);

#ifdef __cplusplus
}
#endif

/* typedefs providing type checking for procedure pointers */
#if 0
typedef OSErr pascal (*OSLAccessorProcPtr) ( DescType desiredClass,
		const OSLToken *container, DescType containerClass, DescType form,
		const AEDesc *selectionData, OSLToken *value, long LongInt ) ;

typedef OSErr pascal (*OSLCompareProcPtr)( DescType oper, const OSLToken *obj1,
										const OSLToken *obj2, Boolean *result ) ;
typedef OSErr pascal (*OSLCountProcPtr)( DescType desiredType,
										DescType containerClass,
										const OSLToken *container,
										long *result ) ;
typedef OSErr pascal (*OSLDisposeTokenProcPtr)( OSLToken *unneededToken ) ;

typedef OSErr pascal (*OSLGetMarkTokenProcPtr)( const OSLToken *dContainerToken,
												DescType containerClass,
												OSLToken *result ) ;


typedef pascal OSErr pascal (*OSLGetErrDescProcPtr)( DescPtr *appDescPtr ) ;

/* Note: app is supposed to dispose of dToken after marking */
typedef OSErr pascal (*OSLMarkProcPtr)( const OSLToken *dToken,
										const OSLToken *markToken, long index ) ;
typedef OSErr pascal (*OSLAdjustMarksProcPtr)( long newStart, long newStop,
											const OSLToken *markToken ) ;
#endif // 0


/* PUBLIC PROCEDURES */


#ifdef __cplusplus
extern "C" {
#endif

OSErr pascal  OSLObjectInit( void ) ;
/* Not done by inline, but by direct linking into code.  It sets up the pack
  such that further calls can be via inline */

OSErr pascal  OSLResolve		(	const AEDesc	*objectSpecifier,
					  				OSLToken		*theToken,
									OSLContext*		startingContext);

OSErr pascal OSLDisposeToken( OSLToken *theToken );

OSErr pascal OSLCallObjectAccessor(DescType		desiredClass,
									const AEDesc	*containerToken,
									DescType		containerClass,
									DescType		keyForm,
									const AEDesc	*keyData,
									AEDesc			*token);

OSErr GetCurrentContext( OSLContext** curContext );
OSErr SetCurrentContext( OSLContext* curContext );

#ifdef __cplusplus
}
#endif


/*
Here are the interfaces your callback procs must be written to:

pascal OSErr MyCompareProc( DescType comparisonOperator,
							const OSLToken *theObject, const OSLToken *descOrObj,
							Boolean *result ) ;
pascal OSErr MyCountProc( DescType desiredType, DescType containerClass,
							const OSLToken *container, long *result:  ) ;
pascal OSErr MyGetMarkToken( const OSLToken *containerToken,
								DescType containerClass, OSLToken *result ) ;
pascal OSErr MyMark( const OSLToken *theToken , const OSLToken *markToken,
						long markCount ) ;
pascal OSErr MyAdjustMarks( long newStart, long newStop,
							const OSLToken *markToken ) ;
pascal OSErr MyMyDisposeToken( OSLToken *unneededToken ) ;
pascal OSErr MyGetErrDesc( DescPtr *appDescPtr ) ;

pascal OSErr MyObjectAccessor( DescType desiredClass,
								const OSLToken *containerToken,
								DescType containerClass, DescType keyForm,
								const AEDesc *keyData, OSLToken *theToken,
								long *theRefcon ) ;

You'll probably want to have a number of these last ones.
A proc that finds a line within a document should be installed with 'line' and 'docu'
as the desiredClass and containerClass fields in the call to AEInstallObjectHandler().
*/

#endif // _CNTXTOSL_
