/************************************************************



Created: Monday, January 28, 1991 at 5:55 PM

    AppleEvents.h

    C Interface to the Macintosh Libraries





        Copyright Apple Computer, Inc.    1989-1990

        All rights reserved

	Change History:



	 8/19/93  BBB	Add #define of nilHandleErr, from errors.h

	 8/12/93  EKL	Add 68K inline for AEGetDescPtr and AEGetDescSize

	 8/12/93  BBB	Add HCONV hConv at start of param list for AE_FetchReply

	 8/11/93  BBB	Add entry for AEGetDescPtr; modify definition of AEGetDescSize

	 8/11/93  BBB	Add entry for AEGetDescSize

	 8/ 5/93  BBB	Change AETopic to kAETopic and  AE_CF_FORMAT to kAE_CF_FORMAT

	 7/20/93  BBB	Add #define of AETopic and #define of AE_CF_FORMAT, both for windows

	 7/ 8/93  BBB	Move DDE_AERec and DDE_SendBuff struct definitions to aeutil.h; change

	 				param list of AEProcessAppleEvent to PROCESS_AE_PARAMS; remove

					prototype of AE_DDE_Event - no longer exported; remove EventRecord

					& Point definitions in WINDOWS area of declarations

	 6/30/93  BBB	redefine errUnInitedUser to be -1733; add #define of typeIntlText, snatched from

	                MPW 3.3 AERegistry.h; add field 'SndrTask' to DDE_SendBuff

	 6/11/93  BBB	Rationalize use of WINDOWS,CompileOnMac, etc

	 1/28/93  BBB	AE_ProcessReply becomes private (not EXPORTed); remove myDDE_CallBack as 1st param

	 				to AEInit

	 1/22/93  BBB	Change AETargIDFromDDE to AEDDE_TargID

	11/ 2/92  BBB  Provide typedef for Str32 in section for AEMgr client; in Proto of AEDDE_Event, change

	               2nd&3rd params to HSZ

	10/30/92  BBB  Prototype for AEDDE_Event; remove EXPORT keyword - should only appear in function DEFINITIONS

	10/29/92  BBB  Change 'appName' & typeName fields of DDE_AERec to Str32; change corresponding params

	               in proto of AEProcessReply;  Change 'theReply' param. of AEProcessReply to HDDEDATA

				   from HANDLE

	 9/30/92  BBB  Remove HWND from all prototypes

	 9/24/92  BBB  change buildingAEM to buildingClient, reverse 0/1 values; use #elif WINDOWS contruct

	               rather than simple #else for #if CompileOnMac

	 9/22/92  BBB  Modify #define of ProcPtr to (FAR PASCAL * ..), from  ( FAR * ..)

	 9/18/92  BBB  AE_CreateDesc, AE_DuplicateDesc & AE_CreateList need to have HWND passed.

	 9/17/92  BBB  For Windows, reverse order of fields for ProcessSerialNumber & change reserved

	               process serial #'s to #define <value>L

	 9/11/92  BBB  Change *(PDWORD) to *(LPDWORD)

	 9/11/92  BBB  Add required typedefs and defines from Process.h

	 9/ 2/92  BBB  Modify #define of ProcPtr to (FAR * ..), not FAR (* ..)

	 8/27/92  BBB  Windows compiler tweaks

	 8/26/92  BBB  Prototype for AE_FetchReply; add DWORD DDEInst as param to AEInit

	 8/24/92  BBB  Add 'PFNCALLBACK myDDE_CallBack' to AE_Init prototype

	 8/21/92  BBB  Prototype for AE_ProcessReply

	 7/30/92  BBB  modify DDE_AERec

	 7/30/92  BBB  In proto of AEProcessAppleEvent, change currDDEWin back to currWin

	 7/13/92  BBB  Fix Windows typos

	 6/23/92  BBB  Where appropriate, explicitly make constants long

	 6/23/92  BBB  Remove references to typeAlias, in Windows implementation

	 6/19/92  BBB  Remove references to type comp, in Windows implementation

	 6/ 3/92  BBB  Remove 'const' from 1st param to AEPutArray..windows must modify dataHandle field

	               when new data is added to its end..why isn't this a problem on Mac?

	 5/27/92  BBB  Fix some Windows-specific typos

	 5/27/92  BBB  Character constants (and enums) are int's, which on Windows are 2 bytes, therefore the

	               #defines of the various AE constants won't work as specified.  Make them string

				   constants; the define includes a cast to render them as longs, as intended in

				   the design.

	 5/26/92  BBB  Add extra conditional around API-required defs/decls

	 5/19/92  BBB  In proto of AEProcessAppleEvent, change currWin to currDDEWin

	 5/ 8/92  BBB  Add typedefs for DDE_AERec & DDE_AERecPtr for Windows; make all EXPORTed

	               FAR

	 3/25/92  BBB  Add prototypes for AEInit & AERemoveMe, and errUnInitedUser

	 3/23/92  BBB  Add currWin parameter for all functions that need to be aware of

	               what application is calling it, if compiling on Windows; change 32-bit

				   enums to #defines, since Windows enums are limited to 16 bits

	 3/11/92  BBB  MPW seems to care about the ordering of func. def. keywords in some cases-

	               use PASCALFUNC-defined in PortoHdr.h

	 3/10/92  BBB  In Windows, 'pascal' modifier must FOLLOW datatype of function return -

	               it doesn't matter on Mac, so reverse all.

	 2/22/92  BBB  Remove all #includes...C files, must explicitly #include required headers;

	               move all types required by the API here, from Mac headers.

	 1/22/92  BBB  change most bracketing to use CompileOnMac - implies PortoHdr.h MUST

	               have been previously #included

	 1/ 2/92  BBB  add use of data-type defines, e.g. SHORT

	12/16/91  BBB  add conditionality



************************************************************/

#include "windows.h"
#include "ddeml.h"

#ifndef _ODTYPESF_
#include "odtypesf.h"
#endif

//plfmtype.h has some C++ specific stuff in it that can't be used in the OSL
//build, therefore, a derived file is being used - osldefs.h.  There is
//probably a better way to do this.
#if OSL_BUILD
#include "osldefs.h"
//ram#else
//#include "plfmtype.h"														
#endif	//OSL_BUILD

#ifndef __APPLEEVENTS__
#define __APPLEEVENTS__


#if PLATFORM_WINDOWS

	 // All DDE-based Apple Events use 'kAETopic' as the topic-specifier,

	 // and kAE_CF_FORMAT as data format specifier



#define kAETopic (LPCSTR)"AppleEvent"

#define kAE_CF_FORMAT CF_PRIVATEFIRST+1  //CF_PRIVATEFIRST from Windows.h

#define PROCESS_AE_PARAMS HCONV theConv, HSZ Service,HSZ Topic,HDDEDATA theData


//#if BuildingClient



	/*  Provide all types required by the API, without requiring any Mac headers. */



typedef long Size;          /* size of a block in bytes */

#ifndef OSL_BUILD
typedef unsigned char Boolean;
typedef long ( FAR  * ProcPtr)();
#endif

typedef unsigned long ResType;

typedef char FAR *Ptr;

typedef HANDLE Handle;  /* - a WINDOWS handle  (quite different) */

typedef unsigned char Str32[33];       // AEMgr uses it as a Pascal string



typedef void (pascal FAR *NMProcPtr)(struct NMRec FAR *);

struct QElem {

	 struct QElem FAR *qLink;

	 SHORT qType;

	 SHORT qData[1];

};

typedef struct QElem QElem;

typedef QElem FAR *QElemPtr;



//CAHA typedef unsigned char FAR *StringPtr;

struct NMRec {

	 QElemPtr qLink;     /*next queue entry*/

	 SHORT qType;        /*queue type -- ORD(nmType) = 8*/

	 SHORT nmFlags;      /*reserved*/

	 long nmPrivate;     /*reserved*/

	 SHORT nmReserved;   /*reserved*/

	 SHORT nmMark;       /*item to mark in Apple menu*/

	 Handle nmIcon;      /*handle to small icon*/

	 Handle nmSound;     /*handle to sound record*/

	 StringPtr nmStr;    /*string to appear in alert*/

	 NMProcPtr nmResp;   /*pointer to response routine*/

	 long nmRefCon;      /*for application use*/

};

typedef struct NMRec NMRec;

typedef NMRec FAR * NMRecPtr;



		  // from Process.h



/* type for unique process identifier */

//struct ProcessSerialNumber {       // NOTE: Reverse order from Mac

//   unsigned long lowLongOfPSN;

//    unsigned long highLongOfPSN;

//};



typedef struct ProcessSerialNumber ProcessSerialNumber;

typedef ProcessSerialNumber FAR *ProcessSerialNumberPtr;





/*************************************************************************

 *                            Process identifier.

 ************************************************************************

 Various reserved process serial numbers.

 NOTE : On Mac, these are enums

 */



#define kNoProcess  0L

#define kSystemProcess  1L

#define kCurrentProcess  2L





     // Junk for TargetID...from PPCTools.h, etc.

	

typedef SHORT ScriptCode;

typedef SHORT PPCPortKinds;

typedef unsigned long OSType;

typedef SHORT PPCLocationKind;



struct PPCPortRec {

    ScriptCode nameScript;                      /* script of name */

    Str32 name;                                 /* name of port as seen in browser */

    PPCPortKinds portKindSelector;              /* which variant */

    union {

        Str32 portTypeStr;                      /* pascal type string */

        struct {

            OSType creator;

            OSType type;

            } port;

        } u;

};



typedef struct PPCPortRec PPCPortRec;

typedef PPCPortRec FAR *PPCPortPtr;



struct EntityName {

    Str32 objStr;

    char pad1;                      /*Str32's aligned on even word boundries.*/

    Str32 typeStr;

    char pad2;

    Str32 zoneStr;

    char pad3;

};



typedef struct EntityName EntityName;

typedef EntityName FAR *EntityPtr;



struct LocationNameRec {

    PPCLocationKind locationKindSelector;       /* which variant */

    union {

        EntityName nbpEntity;                   /* NBP name entity */

        Str32 nbpType;                          /* just the NBP type string, for PPCOpen */

        } u;

};



typedef struct LocationNameRec LocationNameRec;

typedef LocationNameRec FAR *LocationNamePtr;





struct TargetID {

    long sessionID;

    PPCPortRec name;

    LocationNameRec location;

    PPCPortRec recvrName;

};



typedef struct TargetID TargetID;





#define noErr 0         /*All is well*/



//#endif   /* BuildingClient */

#endif  /* WINDOWS */



enum {

#if CompileOnMac

#define typeBoolean 'bool'

#define typeChar 'TEXT'

#define typeSMInt 'shor'

#define typeInteger 'long'

#define typeSMFloat 'sing'

#define typeFloat 'doub'

#define typeLongInteger 'long'

#define typeShortInteger 'shor'

#define typeLongFloat 'doub'

#define typeShortFloat 'sing'

#define typeExtended 'exte'

#define typeComp 'comp'

#define typeMagnitude 'magn'

#define typeAEList 'list'

#define typeAERecord 'reco'

#define typeTrue 'true'

#define typeFalse 'fals'

#define typeAlias 'alis'

#define typeEnumerated 'enum'

#define typeType 'type'

#define typeAppParameters 'appa'

#define typeProperty 'prop'

#define typeFSS 'fss '

#define typeKeyword 'keyw'

#define typeSectionH 'sect'

#define typeWildCard '****'



#define typeApplSignature 'sign'

#define typeSessionID 'ssid'

#define typeTargetID 'targ'

#define typeProcessSerialNumber 'psn '

#define typeNull 'null'                 /*the type of null/nonexistent data*/

#define typeIntlText 'itxt'



#define kCoreEventClass 'aevt'



#define kAEOpenApplication 'oapp'

#define kAEOpenDocuments 'odoc'

#define kAEPrintDocuments 'pdoc'

#define kAEQuitApplication 'quit'



#define kAECreatorType 'crea'

#define kAEQuitAll 'quia'

#define kAEShutDown 'shut'

#define kAERestart 'rest'

#define kAEApplicationDied 'obit'

#define keyProcessSerialNumber 'psn '



#define keyErrorNumber 'errn'

#define keyErrorString 'errs'



#define kAEAnswer 'ansr'



#define keyDirectObject '----'



                /* keyword used in install special handler */

#define keyPreDispatch 'phac'           /* PreHandler Accessor Call */

#define keySelectProc 'selh'            /* More selector Call */



                /* keywords used in attributes */

#define keyTransactionIDAttr 'tran'

#define keyReturnIDAttr 'rtid'

#define keyEventClassAttr 'evcl'

#define keyEventIDAttr 'evid'

#define keyAddressAttr 'addr'

#define keyOptionalKeywordAttr 'optk'

#define keyTimeoutAttr 'timo'

#define keyInteractLevelAttr 'inte'     /*this attribute is read only will be set in AESend*/

#define keyEventSourceAttr 'esrc'       /* this attribute is read only */

#define keyMissedKeywordAttr 'miss'     /* this attribute is read only */



#elif PLATFORM_WINDOWS    /* WINDOWS  -- MAKE STRING CONSTANTS, CAST TO REPRESENT THEM AS A LONG */

#define typeBoolean LONGCONST('b','o','o','l')

#define typeChar LONGCONST('T','E','X','T')

#define typeSMInt LONGCONST('s','h','o','r')

#define typeInteger LONGCONST('l','o','n','g')

#define typeSMFloat LONGCONST('s','i','n','g')

#define typeFloat LONGCONST('d','o','u','b')

#define typeLongInteger LONGCONST('l','o','n','g')

#define typeShortInteger LONGCONST('s','h','o','r')

#define typeLongFloat LONGCONST('d','o','u','b')

#define typeShortFloat LONGCONST('s','i','n','g')

#define typeExtended LONGCONST('e','x','t','e')

/*  No 64-bit integer in Windows

   #define typeComp LONGCONST('c','o','m','p')

*/

#define typeMagnitude LONGCONST('m','a','g','n')

#define typeAEList LONGCONST('l','i','s','t')

#define typeAERecord LONGCONST('r','e','c','o')

#define typeTrue LONGCONST('t','r','u','e')

#define typeFalse LONGCONST('f','a','l','s')

/* *****  No such concept as an Alias record on Windows

       #define typeAlias LONGCONST('a','l','i','s')

*/

#define typeEnumerated LONGCONST('e','n','u','m')

#define typeType LONGCONST('t','y','p','e')

#define typeAppParameters LONGCONST('a','p','p','a')

#define typeProperty LONGCONST('p','r','o','p')

#define typeFSS LONGCONST('f','s','s',' ')

#define typeKeyword LONGCONST('k','e','y','w')

#define typeSectionH LONGCONST('s','e','c','t')

#define typeWildCard LONGCONST('*','*','*','*')



#define typeApplSignature LONGCONST('s','i','g','n')

#define typeSessionID LONGCONST('s','s','i','d')

#define typeTargetID LONGCONST('t','a','r','g')

#define typeProcessSerialNumber LONGCONST('p','s','n',' ')

#define typeNull LONGCONST('n','u','l','l')                 /*the type of null/nonexistent data*/

#define typeIntlText  LONGCONST('i','t','x','t')



#define kCoreEventClass LONGCONST('a','e','v','t')



#define kAEOpenApplication LONGCONST('o','a','p','p')

#define kAEOpenDocuments LONGCONST('o','d','o','c')

#define kAEPrintDocuments LONGCONST('p','d','o','c')

#define kAEQuitApplication LONGCONST('q','u','i','t')



#define kAECreatorType LONGCONST('c','r','e','a')

#define kAEQuitAll LONGCONST('q','u','i','a')

#define kAEShutDown LONGCONST('s','h','u','t')

#define kAERestart LONGCONST('r','e','s','t')

#define kAEApplicationDied LONGCONST('o','b','i','t')

#define keyProcessSerialNumber LONGCONST('p','s','n',' ')



#define keyErrorNumber LONGCONST('e','r','r','n')

#define keyErrorString LONGCONST('e','r','r','s')



#define kAEAnswer LONGCONST('a','n','s','r')



#define keyDirectObject LONGCONST('-','-','-','-')



                /* keyword used in install special handler */

#define keyPreDispatch LONGCONST('p','h','a','c')           /* PreHandler Accessor Call */

#define keySelectProc LONGCONST('s','e','l','h')            /* More selector Call */



                /* keywords used in attributes */

#define keyTransactionIDAttr LONGCONST('t','r','a','n')

#define keyReturnIDAttr LONGCONST('r','t','i','d')

#define keyEventClassAttr LONGCONST('e','v','c','l')

#define keyEventIDAttr LONGCONST('e','v','i','d')

#define keyAddressAttr LONGCONST('a','d','d','r')

#define keyOptionalKeywordAttr LONGCONST('o','p','t','k')

#define keyTimeoutAttr LONGCONST('t','i','m','o')

#define keyInteractLevelAttr LONGCONST('i','n','t','e')     /*this attribute is read only will be set in AESend*/

#define keyEventSourceAttr LONGCONST('e','s','r','c')       /* this attribute is read only */

#define keyMissedKeywordAttr LONGCONST('m','i','s','s')     /* this attribute is read only */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





#define nilHandleErr -109    // from errors.h





/* constants for use in AESendMode */



#define kAENoReply  0x00000001            /* Sender doesn't want a reply to event */

#define kAEQueueReply  0x00000002         /* Sender wants a reply but won't wait */

#define kAEWaitReply  0x00000003          /* Sender wants a reply and will be waiting */



#define kAENeverInteract  0x00000010      /* Server should not interact with user */

#define kAECanInteract  0x00000020       /* Server may try to interact with user */

#define kAEAlwaysInteract  0x00000030     /* Server should always interact with user where appropriate */



#define kAECanSwitchLayer  0x00000040     /* Interaction may switch layer */



#define kAEDontReconnect  0x00000080      /* don't reconnect if there is a sessClosedErr from PPCToolbox */





#define kAEWantReceipt nReturnReceipt   /* Send wants a receipt of message */



               /* constants to be used in AESendPriority */



#define kAENormalPriority  0x00000000     /* Post message at the end of event queue */



#define kAEHighPriority nAttnMsg        /* Post message at the front of the event queue */



                /* special constants in generating events */



    kAnyTransactionID = 0,              /* no transaction is in use */

    kAutoGenerateReturnID = -1,         /* AECreateAppleEvent will generate a session-unique ID */



               /* constant for use AESend */

    kAEDefaultTimeout = -1,             /* timeout value determined by AEM */

    kNoTimeOut = -2,                    /* wait until reply comes back, however long it takes */



              /* dispatch parameter to AEResumeTheCurrentEvent takes a pointer to a dispatch

                table, or one of these two constants */

    kAENoDispatch = 0,

    kAEUseStandardDispatch = -1,



             /* Error messages in response to reading and writing event contents */

    errAECoercionFail = -1700,

    errAEDescNotFound = -1701,

    errAECorruptData = -1702,

    errAEWrongDataType = -1703,

    errAENotAEDesc = -1704

};

enum {

    errAEBadListItem = -1705,           /* Specified list item does not exist */

    errAENewerVersion = -1706,          /* Need newer version of AppleEvent Manager */

    errAENotAppleEvent = -1707,         /* The event is not in AppleEvent format */



/* Error messages in response to sending/receiving a message */

    errAEEventNotHandled = -1708,       /* The AppleEvent was not handled by any handler */

    errAEReplyNotValid = -1709,         /* AEResetTimer was passed an invalid reply parameter */

    errAEUnknownSendMode = -1710,       /* Mode wasn't NoReply, WaitReply, or QueueReply;     or Interaction level is unknown */

    errAEWaitCanceled = -1711,          /* In AESend, User cancelled out of wait loop for  reply or receipt */

    errAETimeout = -1712,               /* AppleEvent timed out */



    errAENoUserInteraction = -1713,     /* no user interaction allowed */

    errAENotASpecialFunction = -1714,   /* there is no special function with this keyword */

    errAEParamMissed = -1715,           /* a required parameter was not accessed */



    errAEUnknownAddressType = -1716,    /* The target address type is not known */

    errAEHandlerNotFound = -1717,       /* No handler in the dispatch tables fits the parameters to

                                              AEGetEventHandler or AEGetCoercionHandler */



    errAEReplyNotArrived = -1718,       /* the contents of the reply you are accessing have not arrived yet */

    errAEIllegalIndex = -1719           /* Index is out of range in a put operation */

#if PLATFORM_WINDOWS

    , errUnInitedUser  = -1733          /* Tried to use AEMgr w/out calling AE_Init */

#endif

};



typedef unsigned long AEKeyword;

typedef unsigned long AEEventClass;

typedef unsigned long AEEventID;

typedef ResType DescType;



/* tagged data, the standard AppleEvent data type */

#ifndef OSL_BUILD
struct AEDesc {

    DescType descriptorType;

    Handle dataHandle;

};
#endif



typedef struct AEDesc AEDesc;





typedef AEDesc AEAddressDesc;           /* an AEDesc which contains addressing data */

typedef AEDesc AEDescList;              /* a list of AEDesc is a special kind of AEDesc */

typedef AEDescList AERecord;            /* AERecord is a list of keyworded AEDesc */

typedef AERecord AppleEvent;            /* an AERecord that contains an AppleEvent */

typedef long AESendMode;                /* Type of parameter to AESend */

typedef SHORT AESendPriority;           /* Type of priority param of AESend */



enum {kAEInteractWithSelf,kAEInteractWithLocal,kAEInteractWithAll};

typedef unsigned char AEInteractAllowed;



enum {kAEUnknownSource,kAEDirectCall,kAESameProcess,kAELocalProcess,kAERemoteProcess};

typedef unsigned char AEEventSource;





/* types for AppleEvent Array support



 Basic data type of attibutes & parameters*/

struct AEKeyDesc {

    AEKeyword descKey;

    AEDesc descContent;

};



typedef struct AEKeyDesc AEKeyDesc;





enum {kAEDataArray,kAEPackedArray,kAEHandleArray,kAEDescArray,kAEKeyDescArray};

typedef unsigned char AEArrayType;





/* Array routines support these different types of elements*/

union AEArrayData {

    SHORT AEDataArray[1];

    char AEPackedArray[1];

    Handle AEHandleArray[1];

    AEDesc AEDescArray[1];

    AEKeyDesc AEKeyDescArray[1];

};



typedef union AEArrayData AEArrayData;

typedef AEArrayData FAR *AEArrayDataPointer;







typedef ProcPtr EventHandlerProcPtr;

typedef ProcPtr IdleProcPtr;

typedef ProcPtr EventFilterProcPtr;

#ifdef __cplusplus

extern "C" {

#endif



/*

      *********************************************************************

    The following calls apply to any AEDesc. Every result descriptor is created for you,

    so you will be responsible for memory management of the descriptors so created.

    Purgeable descriptor data is not supported: the AEM does not call LoadResource.

*/



OSErr FAR ODExport AECreateDesc(DescType typeCode,

                          Ptr dataPtr,

                          Size dataSize,

                          AEDesc FAR *result

#if CompileOnMac

  ) = {0x303C,0x0825,0xA816};

#elif PLATFORM_WINDOWS

       ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetDescSize(AEDesc theDesc, unsigned long FAR * size

#if CompileOnMac

  ) = {0x303C,0x045D,0xA816};

#elif PLATFORM_WINDOWS

       ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetDescPtr(const AEDesc FAR * theAEDesc, DescType desiredType,

                                   void FAR * dataPtr, Size maximumSize,

								   Size FAR * actualSize

#if CompileOnMac

  ) = {0x303C,0x0A5E,0xA816};

#elif PLATFORM_WINDOWS

       ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AECoercePtr(DescType typeCode,Ptr dataPtr,Size dataSize,DescType toType,

    AEDesc FAR *result

#if CompileOnMac

   ) = {0x303C,0x0A02,0xA816};

#elif PLATFORM_WINDOWS

         ) ; /* function definition in AECoerce.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AECoerceDesc(const AEDesc FAR *theAEDesc,

                          DescType toType,

                          AEDesc FAR *result		

#if CompileOnMac

   ) = {0x303C,0x0603,0xA816};

#elif PLATFORM_WINDOWS

         ) ; /* function definition in AECoerce.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AEDisposeDesc(AEDesc FAR *theAEDesc

#if CompileOnMac

  )  = {0x303C,0x0204,0xA816};

#elif PLATFORM_WINDOWS

         ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AEDuplicateDesc(const AEDesc FAR *theAEDesc,AEDesc FAR *result

#if CompileOnMac

     							 ) = {0x303C,0x0405,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



/*

    *********************************************************************

     The following calls apply to AEDescList.

      Since AEDescList is a subtype of AEDesc, the calls in the previous

      section can also be used for AEDescList. All list and array indices are 1-based.

      If the data was greater than maximumSize in the routines below, then actualSize will

      be greater than maximumSize, but only maximumSize bytes will actually be retrieved.

*/



OSErr FAR ODExport AECreateObject(Ptr factoringPtr,Size factoredSize,Boolean isRecord,

                                          AEDescList FAR *resultList, DescType objectType

#if CompileOnMac

                                         )  = {0x303C,0x0906,0xA816};

#elif PLATFORM_WINDOWS

      ) ; /* function definition in AEUtila.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AECreateList(Ptr factoringPtr,Size factoredSize,Boolean isRecord,

                                          AEDescList FAR *resultList

#if CompileOnMac

                                         )  = {0x303C,0x0706,0xA816};

#elif PLATFORM_WINDOWS

      ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AECountItems(const AEDescList FAR *theAEDescList,

                          long FAR *theCount

#if CompileOnMac

   ) = {0x303C,0x0407,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutPtr(const AEDescList FAR *theAEDescList,

                      long index,

                      DescType typeCode,

                      Ptr dataPtr,

                      Size dataSize

#if CompileOnMac

  ) = {0x303C,0x0A08,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutDesc(const AEDescList FAR *theAEDescList,

                       long index,

                       const AEDesc FAR *theAEDesc	

#if CompileOnMac

   ) = {0x303C,0x0609,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetNthPtr(const AEDescList FAR *theAEDescList,

                         long index,

                         DescType desiredType,

                         AEKeyword FAR *theAEKeyword,		

                         DescType FAR *typeCode,			

                         Ptr dataPtr,

                         Size maximumSize,

                         Size FAR *actualSize			

#if CompileOnMac

  )  = {0x303C,0x100A,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetNthDesc(const AEDescList FAR *theAEDescList,

                          long index,

                          DescType desiredType,

                          AEKeyword FAR *theAEKeyword,		

                          AEDesc FAR *result			

#if CompileOnMac

  )  = {0x303C,0x0A0B,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESizeOfNthItem(const AEDescList FAR *theAEDescList,

                             long index,

                             DescType FAR *typeCode,		

                             Size FAR *dataSize			

#if CompileOnMac

   ) = {0x303C,0x082A,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetArray(const AEDescList FAR *theAEDescList,	

                        AEArrayType arrayType,

                        AEArrayDataPointer arrayPtr,

                        Size maximumSize,

                        DescType FAR *itemType,			

                        Size FAR *itemSize,	

                        long FAR *itemCount	

#if CompileOnMac

  )  = {0x303C,0x0D0C,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutArray(AEDescList FAR *theAEDescList,	

                        AEArrayType arrayType,

                        AEArrayDataPointer arrayPtr,

                        DescType itemType,

                        Size itemSize,

                        long itemCount

#if CompileOnMac

  )  = {0x303C,0x0B0D,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEDeleteItem(const AEDescList FAR *theAEDescList,	

                          long index

#if CompileOnMac

  )  = {0x303C,0x040E,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */



OSErr FAR ODExport AEDeleteRange(const AEDescList FAR *theAEDescList,	

                          long index, long numberOfItems

#if CompileOnMac

  )  = {0x303C,0x060E,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*

    *********************************************************************

    The following calls apply to AERecord.

      Since AERecord is a subtype of AEDescList, the calls in the previous

      sections can also be used for AERecord

      an AERecord can be created by using AECreateList with isRecord set to true

*/



OSErr FAR ODExport AEPutKeyPtr(const AERecord FAR *theAERecord,	

                         AEKeyword theAEKeyword,

                         DescType typeCode,

                         Ptr dataPtr,

                         Size dataSize

#if CompileOnMac

  )  = {0x303C,0x0A0F,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutKeyDesc(const AERecord FAR *theAERecord,	

                          AEKeyword theAEKeyword,

                          const AEDesc FAR *theAEDesc	

#if CompileOnMac

 )   = {0x303C,0x0610,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetKeyPtr(const AERecord FAR *theAERecord,	

                         AEKeyword theAEKeyword,

                         DescType desiredType,

                         DescType FAR *typeCode,			

                         Ptr dataPtr,

                         Size maximumSize,

                         Size FAR *actualSize

#if CompileOnMac

  )  = {0x303C,0x0E11,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetKeyDesc(const AERecord FAR *theAERecord,	

                          AEKeyword theAEKeyword,

                          DescType desiredType,

                          AEDesc FAR *result

#if CompileOnMac

 )  = {0x303C,0x0812,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESizeOfKeyDesc(const AERecord FAR *theAERecord,	

                             AEKeyword theAEKeyword,

                             DescType FAR *typeCode,	

                             Size FAR *dataSize	

#if CompileOnMac

  )  = {0x303C,0x0829,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEDeleteKeyDesc(const AERecord FAR *theAERecord,	

                             AEKeyword theAEKeyword

#if CompileOnMac

 )   = {0x303C,0x0413,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*



        *********************************************************************

        The following calls are used to pack and unpack parameters from records of

        type AppleEvent. Since AppleEvent is a subtype of AERecord, the calls in the previous

        sections can also be used for variables of type AppleEvent. The next six calls

        are in fact identical to the six calls for AERecord.

*/



OSErr FAR ODExport AEPutParamPtr(const AppleEvent FAR *theAppleEvent,	

                           AEKeyword theAEKeyword,

                           DescType typeCode,

                           Ptr dataPtr,

                           Size dataSize

#if CompileOnMac

  )  = {0x303C,0x0A0F,0xA816};

#elif PLATFORM_WINDOWS

     );     /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c  */

#define AEPutParamPtr AEPutKeyPtr

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutParamDesc(const AppleEvent FAR *theAppleEvent,	

                            AEKeyword theAEKeyword,

                            const AEDesc FAR *theAEDesc	

#if CompileOnMac

 )   = {0x303C,0x0610,0xA816};

#elif PLATFORM_WINDOWS

      );    /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c */

#define AEPutParamDesc AEPutKeyDesc

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetParamPtr(const AppleEvent FAR *theAppleEvent,	

                           AEKeyword theAEKeyword,

                           DescType desiredType,

                           DescType FAR *typeCode,	

                           Ptr dataPtr,

                           Size maximumSize,

                           Size FAR *actualSize	

#if CompileOnMac

  )  = {0x303C,0x0E11,0xA816};

#elif PLATFORM_WINDOWS

      );    /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c */

#define AEGetParamPtr AEGetKeyPtr

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetParamDesc(const AppleEvent FAR *theAppleEvent,	

                            AEKeyword theAEKeyword,

                            DescType desiredType,

                            AEDesc FAR *result

#if CompileOnMac

  )  = {0x303C,0x0812,0xA816};

#elif PLATFORM_WINDOWS

       );   /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c */

#define AEGetParamDesc AEGetKeyDesc

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESizeOfParam(const AppleEvent FAR *theAppleEvent,	

                           AEKeyword theAEKeyword,

                           DescType FAR *typeCode,	

                           Size FAR *dataSize	

#if CompileOnMac

  )  = {0x303C,0x0829,0xA816};

#elif PLATFORM_WINDOWS

     );     /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c */

#define AESizeOfParam AESizeOfKeyDesc

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEDeleteParam(const AppleEvent FAR *theAppleEvent,	

                           AEKeyword theAEKeyword

#if CompileOnMac

  )  = {0x303C,0x0413,0xA816};

#elif PLATFORM_WINDOWS

     );      /*  AE*Param* vectors to AE*Key* ...defined in AEDFWrpp.c */

#define AEDeleteParam AEDeleteKeyDesc

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







/*

    *********************************************************************

    The following calls also apply to type AppleEvent.  Message attributes are far more restricted, and

    can only be accessed through the following 5 calls. The various list and record routines cannot be used

    to access the attributes of an event.

*/



OSErr FAR ODExport AEGetAttributePtr(const AppleEvent FAR *theAppleEvent,	

                               AEKeyword theAEKeyword,

                               DescType desiredType,

                               DescType FAR *typeCode,	

                               Ptr dataPtr,

                               Size maximumSize,

                               Size FAR *actualSize	

#if CompileOnMac

 )   = {0x303C,0x0E15,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEGetAttributeDesc(const AppleEvent FAR *theAppleEvent,	

                                AEKeyword theAEKeyword,

                                DescType desiredType,

                                AEDesc FAR *result	

#if CompileOnMac

   ) = {0x303C,0x0826,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESizeOfAttribute(const AppleEvent FAR *theAppleEvent,	

                               AEKeyword theAEKeyword,

                               DescType FAR *typeCode,	

                               Size FAR *dataSize	

#if CompileOnMac

 )  = {0x303C,0x0828,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutAttributePtr(const AppleEvent FAR *theAppleEvent,	

                               AEKeyword theAEKeyword,

                               DescType typeCode,

                               Ptr dataPtr,

                               Size dataSize

#if CompileOnMac

  )  = {0x303C,0x0A16,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEPutAttributeDesc(const AppleEvent FAR *theAppleEvent,	

                                AEKeyword theAEKeyword,

                                const AEDesc FAR *theAEDesc

#if CompileOnMac

   ) = {0x303C,0x0627,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







/*

    *********************************************************************

     The next four calls are basic routines used to create, send, and process AppleEvents.

*/



OSErr FAR ODExport AECreateAppleEvent(AEEventClass theAEEventClass,

                                AEEventID theAEEventID,

                                const AEAddressDesc FAR *target,	

                                SHORT returnID,

                                long transactionID,

                                AppleEvent FAR *result

#if CompileOnMac

  )  = {0x303C,0x0B14,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDFWrpp.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESend(const AppleEvent FAR *theAppleEvent,	

                    AppleEvent FAR *reply,	

                    AESendMode sendMode,

                    AESendPriority sendPriority,

                    long timeOutInTicks,

                    IdleProcPtr idleProc,

                    EventFilterProcPtr filterProc

#if CompileOnMac

  )  = {0x303C,0x0D17,0xA816};

#elif PLATFORM_WINDOWS

			  ) ; /* function definition in AEDF.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */

OSErr FAR ODExport AEProcessAppleEvent(PROCESS_AE_PARAMS);




/*

	 During event processing, an event handler may realize that it is likely

	 to exceed the client's timeout limit. Passing the reply to this

    routine causes a wait event to be generated to ask the client for more time.

*/



OSErr FAR ODExport AEResetTimer(const AppleEvent FAR *reply

#if CompileOnMac

 )   = {0x303C,0x0219,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEIntrAc.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*

      *********************************************************************

    The following four calls are available for applications which need more sophisticated control

    over when and how events are processed. Applications which implement multi-session servers or

    which implement their own internal event queueing will probably be the major clients of these

    routines.



     Can be called from within a handler to prevent the AEM from disposing of

    the AppleEvent when the handler returns. Can be used to asynchronously process the

    event (as in MacApp).

*/



OSErr FAR ODExport AESuspendTheCurrentEvent(const AppleEvent FAR *theAppleEvent	

#if CompileOnMac

  )  = {0x303C,0x022B,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*



         Tells the AppleEvent manager that processing is either about to resume or has

        been completed on a previously suspended event. The procPtr passed in as the

        dispatcher parameter will be called to attempt to redispatch the event. Several

        constants for the dispatcher parameter allow special behavior. They are:

        - kAEUseStandardDispatch means redispatch as if the event was just received, using the

            standard AppleEvent Dispatcher.

        - kAENoDispatch means ignore the parameter.

            Use this in the case where no redispatch is needed, and the event has been handled.

        - non nil means call the routine which dispatcher points to.

*/



OSErr FAR ODExport AEResumeTheCurrentEvent(const AppleEvent FAR *theAppleEvent,	

                                     const AppleEvent FAR *reply,	

                                     EventHandlerProcPtr dispatcher,

                                     long handlerRefcon

#if CompileOnMac

  )  = {0x303C,0x0818,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEDF.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/* Allows application to examine the currently executing event */

OSErr FAR ODExport AEGetTheCurrentEvent(AppleEvent FAR *theAppleEvent	

#if CompileOnMac

  )  = {0x303C,0x021A,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/* Set the current event to the parameter */

OSErr FAR ODExport AESetTheCurrentEvent(const AppleEvent FAR *theAppleEvent

#if CompileOnMac

  )  = {0x303C,0x022C,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*

        *********************************************************************

         The following three calls are used to allow applications to behave courteously

        when a user interaction such as a dialog box is needed.

*/

OSErr FAR ODExport AEGetInteractionAllowed(AEInteractAllowed FAR *level

#if CompileOnMac

  )  = {0x303C,0x021D,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AESetInteractionAllowed(AEInteractAllowed level

#if CompileOnMac

 )   = {0x303C,0x011E,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEUtil.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





OSErr FAR ODExport AEInteractWithUser(long timeOutInTicks,NMRecPtr nmReqPtr,IdleProcPtr idleProc

#if CompileOnMac

 )   = {0x303C,0x061C,0xA816};

#elif PLATFORM_WINDOWS

            ) ; /* function definition in AEIntrAc.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







/*

     *********************************************************************

     These calls are used to set up and modify the event dispatch table  }



    { Add an AppleEvent Handler

*/



OSErr FAR ODExport AEInstallEventHandler(AEEventClass theAEEventClass,

                                   AEEventID theAEEventID,

                                   EventHandlerProcPtr handler,

                                   long handlerRefcon,

                                   Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x091F,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Remove an AppleEvent Handler  */

OSErr FAR ODExport AERemoveEventHandler(AEEventClass theAEEventClass,

                                  AEEventID theAEEventID,

                                  EventHandlerProcPtr handler,

                                  Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0720,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Get the corresponding AppleEvent Handler  */

OSErr FAR ODExport AEGetEventHandler(AEEventClass theAEEventClass,

                               AEEventID theAEEventID,

                               EventHandlerProcPtr FAR *handler,	

                               long FAR *handlerRefcon,	

                               Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0921,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







/*

     *********************************************************************

     These calls are used to set up and modify the coercion dispatch table

*/



OSErr FAR ODExport AEInstallCoercionHandler(DescType fromType,

                                      DescType toType,

                                      ProcPtr handler,

                                      long handlerRefcon,

                                      Boolean fromTypeIsDesc,

                                      Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0A22,0xA816};

#elif PLATFORM_WINDOWS

             ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Remove a Coercion Handler  */

OSErr FAR ODExport AERemoveCoercionHandler(DescType fromType,

                                     DescType toType,

                                     ProcPtr handler,

                                     Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0723,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Get the corresponding Coercion Handler  */

OSErr FAR ODExport AEGetCoercionHandler(DescType fromType,

                                  DescType toType,

                                  ProcPtr FAR *handler,	

                                  long FAR *handlerRefcon,	

                                  Boolean FAR *fromTypeIsDesc,	

                                  Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0B24,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







/*



          *********************************************************************

        These calls are used to set up and modify special hooks into the AppleEvent Manager.



        Install the special handler named by the Keyword

*/



OSErr FAR ODExport AEInstallSpecialHandler(AEKeyword functionClass,

                                     ProcPtr handler,

                                     Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x0500,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Remove the special handler named by the Keyword  */

OSErr FAR ODExport AERemoveSpecialHandler(AEKeyword functionClass,

                                    ProcPtr handler,

                                    Boolean isSysHandler

#if CompileOnMac

 )   = {0x303C,0x0501,0xA816};

#elif PLATFORM_WINDOWS

            ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */





/*  Get the special handler named by the Keyword  */

OSErr FAR ODExport AEGetSpecialHandler(AEKeyword functionClass,

                                 ProcPtr FAR *handler,	

                                 Boolean isSysHandler

#if CompileOnMac

  )  = {0x303C,0x052D,0xA816};

#elif PLATFORM_WINDOWS

           ) ; /* function definition in AEHndTbl.c */

#else      // put your favorite platform/os here

 < generate a syntax error for unknown OS >;

#endif  /* CompileOnMac */







#if PLATFORM_WINDOWS

/*

          *********************************************************************

        These calls are Windows-specifc, and are used to set up and modify

        Globals used to access GlobalRecs which are specific to the calling app.  Since the

		AEMgr is shareable among apps, and since windows doesn't maintain separate low-mem

		globals for each app, as the Mac does, this approach is necessarry.

		

		Before a Windows app can use AEMgr, it MUST call AEInit.

		

		When the app. is done with AEMgr, typically in it's shutdown section, it MUST call

		AERemoveMe.

		

		AEFetchReply is invoked from the servers XTYP_REQUEST section to get the reply previously-prepared

		reply to an XTYP_POKE AE message - this is to accomodate the DDE-imposed protocol of first

		POKEing the AE message which desires a reply, then returning the reply in response to a

		REQUEST.

*/



OSErr FAR ODExport AEInit(DWORD DDEInst);



OSErr FAR ODExport AERemoveMe(void);



BOOL FAR ODExport AEFetchReply(HCONV hConv, DWORD FAR * replyLen, HANDLE FAR * theReply);

										

void FAR ODExport AEDDE_TargID(HCONV	theConv,  // creates TargetID from DDE data

									 HSZ	Service,

									 HSZ	Topic,

									 TargetID FAR * theTargID);



#endif   // end of Windows-specific prototypes

// -----------------------------------------------------------------------------





#ifdef __cplusplus

}

#endif



#endif

