/*
 *  egscrpt1.c
 *
 *  Example CGI Script file for use with HTTPS.  Assumes it is invoked from a form.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char InputBuffer[4096];

/*
 *  Convert all cOld characters in cStr into cNew characters
 */
void strcvrt(char * cStr,char cOld,char cNew) {
int i;

    i = 0;
    while (cStr[i]) {
        if (cStr[i]==cOld) cStr[i] = cNew;
        i++;
    }
}

/*
 *  The string starts with two hex characters.  Return an integer formed from them.
 */
static int TwoHex2Int(char *pC) {
int Hi;
int Lo;
int Result;

    Hi = pC[0];
    if ('0'<=Hi && Hi<='9') {
        Hi -= '0';
    } else
    if ('a'<=Hi && Hi<='f') {
        Hi -= ('a'-10);
    } else
    if ('A'<=Hi && Hi<='F') {
        Hi -= ('A'-10);
    }
    Lo = pC[1];
    if ('0'<=Lo && Lo<='9') {
        Lo -= '0';
    } else
    if ('a'<=Lo && Lo<='f') {
        Lo -= ('a'-10);
    } else
    if ('A'<=Lo && Lo<='F') {
        Lo -= ('A'-10);
    }
    Result = Lo + 16*Hi;
    return Result;
}


/*
 *  Display all the environment variables
 */
void DisplayEnvVars(void) {
int i;

    i = 0;
    while (_environ[i]) {
        printf("%s\n",_environ[i]);
        i++;
    }
    printf("\n");
}


/*
 *  Decode the given string in-place by expanding %XX escapes
 */
void urlDecode(char *p) {
char *pD;

    pD = p;
    while (*p) {
        if (*p=='%') {
            /* Escape: next 2 chars are hex representation of the actual character */
            p++;
            if (isxdigit(p[0]) && isxdigit(p[1])) {
                *pD++ = (char) TwoHex2Int(p);
                p += 2;
            }
        } else {
            *pD++ = *p++;
        }
    }
    *pD = '\0';
}


/*
 *  Parse out and display field=value items.  Don't use strtok!
 */
void DisplayField(char *Item) {
char *p;

    p = strchr(Item,'=');
    if (p==NULL) return;
    *p++='\0';
    urlDecode(Item);
    urlDecode(p);
    strcvrt(p,'\n',' ');
    printf("%s = %s\n",Item,p);
}

/*
 *  Main program
 */
int main(int argc, char *argv[]) {
int ContentLength;
int x;
int i;
char *p;
char *pCGIVersion;
char *pRequestMethod;

    /* Turn buffering off for stdin */
    setvbuf(stdin,NULL,_IONBF,0);

    /* Tell the client what we're going to send */
    printf("Content-type: text/plain\n");

    /* If we are running CGI/1.1 or later, we can send a Status: header */
    pCGIVersion = getenv("GATEWAY_INTERFACE");    
    if (pCGIVersion!=NULL) {
        if (_stricmp(pCGIVersion,"CGI/1.1")>=0) {
            printf("Status: 200 Orl Korrect\n");
        }
    }

    /* Finished sending headers */
    printf("\n");

    /* Print out command line variables */
    printf("argc = %d\n",argc);
    for (i=0;i<argc;i++) {
        printf("argv[%d] = %s\n",i,argv[i]);
    }
    printf("\n");

    /* Display the variables */
    DisplayEnvVars();

    /* What method were we invoked through? */
    pRequestMethod = getenv("REQUEST_METHOD");
    if (pRequestMethod==NULL) {
        return 0;
    }

    if (_stricmp(pRequestMethod,"POST")==0) {
        /* Read in the data from the client */
        p = getenv("CONTENT_LENGTH");
        if (p!=NULL) {
            ContentLength = atoi(p);
        } else {
            ContentLength = 0;
        }
        if (ContentLength>sizeof(InputBuffer)-1) {
            ContentLength = sizeof(InputBuffer)-1;
        }
        i = 0;
        while (i<ContentLength) {
            x = fgetc(stdin);
            if (x==EOF) break;
            InputBuffer[i++] = x;
        }
        InputBuffer[i] = '\0';
        ContentLength = i;

        p = getenv("CONTENT_TYPE");
        if (p==NULL) {
            return 0;
        }
        if (_stricmp(p,"application/x-www-form-urlencoded")==0) {
            /* Parse the data */
            p = strtok(InputBuffer,"&");
            while (p!=NULL) {
                DisplayField(p);
                p = strtok(NULL,"&");
            }
        } else {
            /* Display the data */
            printf("Input = %s\n",InputBuffer);
        }

    } else 
    if (_stricmp(pRequestMethod,"GET")==0) {

        /* Parse the data in the search term */
        p = getenv("QUERY_STRING");
        if (p!=NULL) {
            strncpy(InputBuffer,p,sizeof(InputBuffer));
            p = strtok(InputBuffer,"&");
            while (p!=NULL) {
                DisplayField(p);
                p = strtok(NULL,"&");
            }
        }

    }
    return 0;
}

