require 5.000;

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.

 
package PrmptUsr;
BEGIN { &main::Require("PrmptUsr.nls"); import PrmptUsr_nls; }

BEGIN { &main::Require("MiscUtil.pl"); import MiscUtil; }
 
&main::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw( 
	PromptUsrBool 
	PromptUsrText 
	PromptCycleList 
	GetMenuKey 
	PromptContAbort
);


BEGIN { &main::Require("tty.pl"); }


sub PromptUsrBool {
	local( 
		$prompt, 
		$callerdefault_ref, 
		$indent, 
		$keydefhash_ref, 
		$flag_keyret_ref
	) = @_;


	local( $c, @string );
	local( $default ) = $$callerdefault_ref;
	local($val)	= $default ? 1 : 0;

	local($indent) = " " x $indent;

	local( $longest ) = (length($txt{'true'}) < length($txt{'false'})) ?
		length($txt{'false'}) : length($txt{'true'});

	$string[0] = "$indent$prompt$txt{'default_left_delim'}" .
		$txt{'false'} . " " x ($longest - length($txt{'false'})) .
		$txt{'default_right_delim'};
	$string[1] = "$indent$prompt$txt{'default_left_delim'}" .
		$txt{'true'} . " " x ($longest - length($txt{'true'})) .
		$txt{'default_right_delim'};

	&main::TtyMode("raw");

	if ( ! $keydefhash_ref ) {

		while ( 1 ) {

			print $string[$val];

			$c = &GetMenuKey(
				$codes{'ESC'},
				$codes{'NEWLINE'},
				$codes{'SPACE'},
				$codes{'BACKSPACE'} );

			if ( $c eq $codes{'ESC'} ) {
				return $default;
			} elsif ( $c eq $codes{'NEWLINE'} ) {
				return $val;
			} elsif ( ($c eq $codes{'SPACE'}) || ($c eq $codes{'BACKSPACE'}) ) {
				$val = $val ? 0 : 1;
			}

			print $codes{'CR'};
		}
	} else {

		local( @valid );
        foreach (qw(defret selret nextsel prevsel)) {
            $keydefhash_ref->{$_} &&
                push( @valid, @{$keydefhash_ref->{$_}} );
        }
        $keydefhash_ref->{'keyret'} &&
            push( @valid, @{$keydefhash_ref->{'keyret'}} );


		$$flag_keyret_ref = 0;

		while (1) {
			
			print $string[$val];

			$c = &GetMenuKey( @valid );

			if (&IsMember( $c, @{$keydefhash_ref->{'defret'}} )) {
				return $default;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'selret'}} )) {
				return $val;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'nextsel'}} )) {
				$val = $val ? 0 : 1;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'prevsel'}} )){
				$val = $val ? 0 : 1;    
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'keyret'}} )) {
				$$callerdefault_ref = $val;
				$$flag_keyret_ref = 1;
				return $c;
			}	

			print $codes{'CR'};
		}
	}
}


sub PromptCycleList {
    local( 
		$prompt, 
		$callerdefault_ref, 
		$indent, 
		$tags_ref, 
		$texthash_ref,
		$keydefhash_ref,
		$flag_keyret_ref ) = @_;

	# $keydefhash_ref & $flag_keyret_ref are optional; 
	#see the end of this function

	local( $maxlisttextlen, $maxindex, @prompts, $promptline, $i );
	local( $prompbasis, $preprompt );
	local( $default_index );
	local( $default ) = $$callerdefault_ref;
	local($indent) = " " x $indent;

	$maxindex = scalar(@{$tags_ref}) - 1;

	# determine max list text length
	$maxlisttextlen = 0;
	foreach (@{$tags_ref}) {
		if (length(${$texthash_ref}{$_}) > $maxlisttextlen) {
			$maxlisttextlen = length(${$texthash_ref}{$_});
		}
	}

	# If the prompt is multi-line, print all but the last.
	# The prompt array then becomes the possible last lines,
	# rather than the entire prompt.
	$promptbasis = "$indent$prompt$txt{'default_left_delim'}";
	if ($promptbasis =~ /\n/) {
		($preprompt) = ($promptbasis =~ /(^.*\n)/);
		$promptbasis =~ s/.*\n//;
		print $preprompt;
	}

	# setup an array of prompt lines with each cycle list val
	@prompts = ();
	foreach (@{$tags_ref}) {
		$promptline = "$indent$promptbasis" .
			${$texthash_ref}{$_} .
			" " x ($maxlisttextlen - length(${$texthash_ref}{$_}));
		$promptline .= $txt{'default_right_delim'};
		push( @prompts, $promptline );
	}

	# determine the index of the default 
	foreach (0..$maxindex) {
		if ($default eq ${$tags_ref}[$_]) {
			$default_index = $_;
		}
	}
		
	if ( ! $keydefhash_ref ) {
		$i = $default_index;
	    while ( 1 ) {
 
	        print $prompts[$i];
 
			$c = &GetMenuKey(
				$codes{'ESC'},
				$codes{'NEWLINE'},
				$codes{'SPACE'},
				$codes{'BACKSPACE'} );
 
	        if ( $c eq $codes{'ESC'} ) {
	            return $default;
	        } elsif ( $c eq $codes{'NEWLINE'} ) {
	            return ${$tags_ref}[$i];
	        } elsif ( $c eq $codes{'SPACE'}) {
				$i = ($i == $maxindex) ? 0 : $i + 1;
	        } elsif ( $c eq $codes{'BACKSPACE'} ) {
				$i = ($i == 0) ? $maxindex : $i - 1;
			}
 
	        print $codes{'CR'};
	    }
	} else {

		local( @valid );
		foreach (qw(defret selret nextsel prevsel)) {
			$keydefhash_ref->{$_} &&
				push( @valid, @{$keydefhash_ref->{$_}} );
		}
		$keydefhash_ref->{'keyret'} &&
			push( @valid, @{$keydefhash_ref->{'keyret'}} );

		$$flag_keyret_ref = 0;

		$i = $default_index;
		while (1) {

			print $prompts[$i];
			$c = &GetMenuKey( @valid );

			if (&IsMember( $c, @{$keydefhash_ref->{'defret'}} )) {
				return $default;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'selret'}} )) {
				return ${$tags_ref}[$i];
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'nextsel'}} )) {
				$i = ($i == $maxindex) ? 0 : $i + 1;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'prevsel'}} )){
				$i = ($i == 0) ? $maxindex : $i - 1;
			} elsif (&IsMember( $c, @{$keydefhash_ref->{'keyret'}} )) {
				$$callerdefault_ref = ${$tags_ref}[$i];
				$$flag_keyret_ref = 1;
				return $c;
			}

			print $codes{'CR'};
		}
	}
}


sub PromptUsrText {
	local( $prompt, $default, $indent ) = @_;

	local($in);

	print " " x $indent;
	print $prompt;

	&main::TtyMode("cooked");

	$in = <STDIN>;
	($in eq "\n") && return $default;

	chop( $in );
	$in =~ s/^\s+//;
    $in =~ s/\s+$//;

	return $in;
}


sub GetMenuKey {
	local( @valid_menu_keys ) = @_;
 
    local($c, %validkeyhash);

	for (@valid_menu_keys) {
		$validkeyhash{$_} = 1;
	}
 
	BEGIN { @GetMenuKeyBuf = (); }
 
    &main::TtyMode("cooked");
    &main::TtyMode("raw_min0");
 
    if (@GetMenuKeyBuf) {
        return shift(@GetMenuKeyBuf);
    }
 
    GETLOOP:
    while (1) {
        &WaitStdinReady();
        sysread( STDIN, $c, 1 );
        push( @GetMenuKeyBuf, $c );
		&Nap( 0.25 );
		while (sysread( STDIN, $c, 1)) {
			push( @GetMenuKeyBuf, $c );
		}
 
        @GetMenuKeyBuf || next;
 
        for (@GetMenuKeyBuf) {
            if ( ! $validkeyhash{$_} ) {
                undef @GetMenuKeyBuf;
                next GETLOOP;
            }
        }
 
        return shift(@GetMenuKeyBuf);
    }
}


sub PromptContAbort {
	local( $prompttext ) = @_;

	local( $c ) = "";

	print $prompttext;

	$c = &GetMenuKey( $codes{'TAB'}, $codes{'ESC'} );

	print "\b" x length($prompttext);
	print " "  x length($prompttext);
	print "\b" x length($prompttext);

	return ($c eq $codes{'TAB'}) ? 1 : 0;
}


1;
