# pathutil.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package PathUtil;
require 5.000;
 
&main::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(   BaseName
				DirName
				CleanPath
				LotusDirPath
);






sub BaseName {
    local( $path ) = @_;
 
    local( @comps ) = split( '/', $path );
 
 
    ( ! $path ) && return('.');
 
    return( pop( @comps ) );
}
 
 
sub DirName {
    local( $path ) = @_;
 
    local( $pfx );
    local( @comps ) = split( '/', $path );
 
 
    pop( @comps );
    ( ! @comps ) && return('.');
 
    $_ = $path;
    /^\/[^\/]*$/ && ($pfx = '/');

	return( $pfx . join( '/', @comps ) );
}


 
sub CleanPath {
        local($_) = @_;
 
        s/^\s+//;                       # get rid of any space at beginning
        s/\s+$//;                       # or end of string
        $_ = "$_/";                     # make sure path ends with "/" (temp)
        s#//+#/#g;                      # get rid of multiple //+
        s#/\./#/#g while (m#/\./#);     # remove /./ paths
        s#^\./(\S+)$#$1#;               # remove an initial ./, unless that's
        s#/$## unless (m#^/$#);         # remove ending /, unless root path
 
 
        return($_);
}


sub LotusDirPath {
    local($path) = @_;
 
    local($dir)  = &DirName( $path );
    local($base) = &BaseName( $path );
 
    if ( $base =~ /lotus/i ) {
        $path = "$dir/lotus";
    } else {
        $path = "$dir/$base/lotus";
    }
 
    $path =~ s#//#/#;

	while ( $path =~ /^\.\// ) {
		$path =~ s/^\.\///;
	}
 
    return $path;
}


#


package main;
1;
