# NIIS.pm - InterNotes Web Publisher

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;
package NIIS;

BEGIN { &main::Require("NIIS.nls"); import NIIS_nls; }

BEGIN { &main::Require("IS.pm"); import IS; }

BEGIN { &main::Require("MiscUtil.pl");	import MiscUtil; }
BEGIN { &main::Require("PrmptUsr.pl");	import PrmptUsr; }
BEGIN { &main::Require("PathUtil.pl");	import PathUtil; }


################################################################################
#
sub new {
	local( $class, $rows, $cols, $instdata ) = @_;

	local( $tag );

	$self = {
		screen_tags	=> [qw( 
			ISExit 
			ISWlcm 
			ISHostName
			ISStartInstall
		)],
		screens_objs		=> {},
	};

	foreach (@{$self->{'screen_tags'}}) {

		$self->{'screen_objs'}->{$_} = 
			new $_ (
				$rows, 
				$cols, 
				$instdata->{'top_optset_inst_banner'}, 
				$instdata->{'top_optset_insthelp_banner'} );

		# setting "private" object data
		#
		$self->{'screen_objs'}->{$_}->{'bodytext'} =
			$NIISnls_bodytext{$_};
		$self->{'screen_objs'}->{$_}->{'helptext'} =
			$NIISnls_helptext{$_};
		$self->{'screen_objs'}->{$_}->{'exit'} =
			"ISExit";
		if ( ! $NIISnls_responsetext{$_} ) {
			$self->{'screen_objs'}->{$_}->{'responsetext'} = "\n";
		}
	}

	
	# the following is not necessary for InterNotes (no filesrver install)
	#
	#
	# now instantiate screens for each available platform, oh yah
	#
#
#
#
#


	bless $self;
}
#
################################################################################


################################################################################
#
sub DoChain {
	local( $self, $instdata ) = @_;

	local( @screenstack );
	local( $flag_dontchain ) = 0;

	local( $cur )	= "ISWlcm";
	local( $next )	= "";

	while ($cur) {
		$flag_dontchain = 0;
		$next = 
			$self->{'screen_objs'}->{$cur}->DoIt( 
				$instdata, \$flag_dontchain );

		if ($next == -1) {
			$cur = pop(@screenstack);
		} elsif (($next == 1) || ($next == 2)) {
			$cur = $next;
			last;
		} else {
			$flag_dontchain || push(@screenstack, $cur);
			$cur = $next;
		}
	}

	return $cur;
}
#
################################################################################


################################################################################
#
package ISWlcm;
@ISA = (IS);
sub new {
	local( $class ) = shift;

	$self = new IS ("info", @_);

	$self->{'navtext'} = 
		$self->PrepNavtext( $NIIS::NIISnls_navtext{'ISWlcm'} );

	# because this is the first screen, no "prev"

	$self->{'next'} = "ISHostName";

	bless $self;
}

sub DoIt {
	local( $self, $instdata ) = @_;

	local($ret) = $self->DoScreen();

	($ret eq "prev") && return $self->{'exit'};
	
	return $self->{$ret};
}
#
################################################################################


################################################################################
#
package ISExit;
@ISA = (IS);
sub new {
	local( $class ) = shift;

	$self = new IS ("boolcycle", @_);
	
	$self->{'navtext'} =
		$self->PrepNavtext( $NIIS::NIISnls_navtext{'ISExit'} );

	$self->{'boolcycle_default'}	= 0;
	$self->{'boolcycle_prompt'}		= 
		$NIIS::NIISnls_prompt{'ISExit'};

	$self->{'keydefhash'} = {
		'selret'	=> $IS::ISnls_tagkeys{'next'},
		'nextsel'	=> $IS::ISnls_tagkeys{'cycle'},
		'keyret'	=> $IS::ISnls_tagkeys{'prev'}
	};

	bless $self;
}

sub DoIt {
	local( $self, $instdata, $flag_dontchain_ref ) = @_;


	local($ret) = $self->DoScreen( \$data );

	$$flag_dontchain_ref = 1;

	( $ret eq "prev" ) && return -1;

	return $data ? 1 : -1;
}	
#
################################################################################


################################################################################
#
package ISHostName;
@ISA = (IS);
sub new {
    local( $class ) = shift;

	$self = new IS ("editstr", @_);

	$self->{'navtext'} = 
		$self->PrepNavtext( $NIIS::NIISnls_navtext{'editstr'} );
	$self->{'navtext_edit'} = 
		$self->PrepNavtext( $NIIS::NIISnls_navtext{'editstr_edit'} );

	bless $self;
}

sub DoIt {
	local( $self, $instdata ) = @_;

	local( $ret, $data );

	$self->{'responsetext'} = 
		$NIIS::NIISnls_responsetext{'ISHostName'};
	$self->{'responsetext_edit'} = 
		$NIIS::NIISnls_responsetext{'ISHostName_edit'};

	$data = $instdata->{'usr_single_hostname'};

	$ret = $self->DoScreen( \$data );
	
	($ret eq "prev") && return -1;

	if ($ret eq "next") {
		$instdata->{'usr_single_hostname'} = $data;

		return "ISStartInstall";

	}

	return $self->{$ret};
}
#
################################################################################


################################################################################
#
package ISStartInstall;
@ISA = (IS);
sub new {
	local( $class ) = shift;

	$self = new IS ("info", @_);

	# no help
	$self->{'valid_response_tags'} = [qw( prev exit next )];


	$self->{'navtext'} = 
		$self->PrepNavtext( $NIIS::NIISnls_navtext{'ISStartInstall'} );

	bless $self;
}

sub DoIt {
	local( $self, $instdata ) = @_;

	local($ret) = $self->DoScreen();

	($ret eq "prev") && return -1;

	if ( $ret eq "next" ) {
		return &main::DoInstall( $instdata );
	}

	return $self->{$ret};
}
#
################################################################################


1;
