# IS.pm

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;
package IS;


BEGIN { &main::Require("IS.nls"); import IS_nls; }

BEGIN { &main::Require("PrmptUsr.pl");	import PrmptUsr; }
BEGIN { &main::Require("MiscUtil.pl");	import MiscUtil; }
BEGIN { &main::Require("More.pm");		import More; }





sub new {
	local( $class, $type, $rows, $cols, $banner_text, $helpbanner_text ) = @_;

	$self = {
		'type'				=> $type,
		'screen_rows'		=> $rows,
		'screen_cols'		=> $cols,
		'banner_text'		=> $banner_text,
		'helpbanner_text'	=> $helpbanner_text,

		'navtext'			=> "",
		'bodytext'			=> "",
		'responsetext'		=> "",

		'exit'				=> "",
		'next'				=> "",
		'prev'				=> "",
	};

	bless $self;
}


sub DrawBanner {
	local( $self ) = @_;
	print $self->GenBanner( $self->{'banner_text'} );
}


sub GenBanner {
	local( $self, $text ) = @_;

	local( $out );

	$out = $self->CharLine( $ISnls{'banner_sepchar1'} );
	$out .= 
		" " x (($self->{'screen_cols'} - length($text))/2-1);
	# !!! multiple lines
	$out .= "$text\n";
	$out .= $self->CharLine( $ISnls{'banner_sepchar2'} );

	return $out;
}
	


sub CharLine {
	local( $self, $char ) = @_;
	return $char x ($self->{'screen_cols'}-1) . "\n";
}


sub PrepNavtext {
	local( $self, $navtext ) = @_;

	local( $out );

    $out = $self->CharLine( $ISnls{'nav_sepchar1'} );
	$out .= $navtext;
    $out .= $self->CharLine( $ISnls{'nav_sepchar2'} );

	return $out;
}


sub DoScreen {
	local( $self, $data_ref ) = @_;

	# $data_ref expected for types boolcycle, cycle, & editstr

	local( $sel, $tmp, @valid );
	
	# for type cycle
	local( %keydefhash, $flag_keyret );

	if ( ($self->{'type'} eq "cycle") || ($self->{'type'} eq "boolcycle") ) {
		if ( $self->{'keydefhash'} ) {
			%keydefhash = %{$self->{'keydefhash'}};
		} else {
			$keydefhash{'selret'}	= $ISnls_tagkeys{'next'};
			$keydefhash{'nextsel'}	= $ISnls_tagkeys{'cycle'};
			$keydefhash{'keyret'}	= 
				[	@{$ISnls_tagkeys{'help'}},
					@{$ISnls_tagkeys{'exit'}},
					@{$ISnls_tagkeys{'prev'}}
				];
		}
	}


	while (1) {
		system("$System::clear");
		$self->DrawBanner();
		print $self->{'bodytext'};
		print $self->{'navtext'};

		if ($self->{'type'} eq "info") {

			# "help" is supported within this function
			# otherwise, the response tag is returned

			if ($self->{'valid_response_tags'}) {
				@valid = @{$self->{'valid_response_tags'}};
			} else {
				@valid = qw( help exit prev next );
			}
			$sel = $self->GetScreenResponse( @valid );


		} elsif ($self->{'type'} eq "boolcycle") {
			print $self->{'responsetext'};

			$tmp = &PromptUsrBool(
				$self->{'boolcycle_prompt'},
				\$self->{'boolcycle_default'},
				0,
				\%keydefhash,
				\$flag_keyret );

			if (&IsMember( $tmp, @{$keydefhash{'keyret'}} )) {
				undef $$data_ref;
                &IsMember($tmp, @{$ISnls_tagkeys{'help'}}) && ($sel = "help");
                &IsMember($tmp, @{$ISnls_tagkeys{'exit'}}) && ($sel = "exit");
                &IsMember($tmp, @{$ISnls_tagkeys{'prev'}}) && ($sel = "prev");
            } else {
                $$data_ref = $tmp;
                $sel = "next"  
            }


		} elsif ($self->{'type'} eq "cycle") {
			print $self->{'responsetext'};

			$tmp = &PromptCycleList(
				$self->{'cycle_prompt'},
				\$self->{'cycle_default'},
				0,
				$self->{'cycle_taglist'},
				$self->{'cycle_tagtexthash'},
				\%keydefhash,
				\$flag_keyret );

			if (&IsMember( $tmp, @{$keydefhash{'keyret'}} )) {
				undef $$data_ref;
				&IsMember($tmp, @{$ISnls_tagkeys{'help'}}) && ($sel = "help");
				&IsMember($tmp, @{$ISnls_tagkeys{'exit'}}) && ($sel = "exit");
				&IsMember($tmp, @{$ISnls_tagkeys{'prev'}}) && ($sel = "prev");
			} else {
				$$data_ref = $tmp;
				$sel = "next"	
			}


		} elsif ($self->{'type'} eq "editstr") {
			print "$self->{'responsetext'}${$data_ref}\n";

			@valid = qw( help exit prev edit next );
			$sel = $self->GetScreenResponse( @valid );

			if ($sel eq "edit") {
				local( $str ) = "";

				system("$System::clear");
				$self->DrawBanner();
				print $self->{'bodytext'};
				print $self->{'navtext_edit'};
				print "$self->{'responsetext'}${$data_ref}\n";
				print $self->{'responsetext_edit'};
				
				$str = $self->GetString();

				if ($str) {
					if ($self->{'editstr_processstr'}) {
						$$data_ref = $self->ProcessStr($str);
					} else {
						$$data_ref = $str;
					}
				}

				next;
			}
		}

		if ( $sel eq "help" ) {
			system("$System::clear");
			local( $more ) = new More ($self->{'screen_rows'});
			$more->Print( $self->GenBanner( $self->{'helpbanner_text'} ) );
			$more->Print( $self->{'helptext'} );
			$more->Print( "\n$ISnls{'returnfromhelp'}" );
			$more->Close();

			&GetMenuKey( 
				@{$ISnls_tagkeys{'next'}}, 
				@{$ISnls_tagkeys{'prev'}}
			);

		} else {
			return $sel;
		}
	}
}


sub GetScreenResponse {
	local( $self, @validtags ) = @_;

	local( @validchars, $retkey );

	foreach (@validtags) {
		push( @validchars, @{$ISnls_tagkeys{$_}} );
	}

	$retkey = &GetMenuKey( @validchars );

	foreach (@validtags) {
		&IsMember( $retkey, @{$ISnls_tagkeys{$_}} ) &&
			return $_;
	}
}


sub GetString {
	local( $self ) = @_;

	&main::TtyMode("cooked");
	$_ = <STDIN>;

	chomp;
	s/^\s+//;
	s/\s+$//;

	/\033/ && ($_ = "");

	return $_;
}


1;
