/*
 * Copyright (c) 1995 Danny Gasparovski.
 * 
 * Please read the file COPYRIGHT for the
 * terms and conditions of the copyright.
 */

#include "h/common.h"
#include "h/main.h"
#include "h/socket.h"
#include "h/ip.h"
#include "h/tcp.h"
#include "h/udp.h"
#include "h/mbuf.h"
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#ifdef NO_FILIO
#include <termios.h>
#ifdef USE_IOCTL
#include <sys/ioctl.h>
#endif
#else
#include <sys/filio.h>
#endif

u_int curtime, time_fasttimo, last_slowtimo, tmp_time, lastime;

/*
 * XXX Should let user choose local display.screen
 */
void
redir_x(void)
{
	int i;
	struct in_addr addr;
	
	/* XXX 6100? */
	for (i = 6000; i <= 6100; i++) {
		if (solisten(htons(i), our_addr, htons(6000), 0)) {
			/* Success */
			addr.s_addr = our_addr;
			fprintf(stderr,
				"X Redir: In sh/bash/zsh/etc. type: DISPLAY=%s:%d.0; export DISPLAY\n",
				inet_ntoa(addr), i - 6000);
			fprintf(stderr,
				"X Redir: In csh/tcsh/etc. type:    setenv DISPLAY %s:%d.0\n\n",
				inet_ntoa(addr), i - 6000);
			return;
		}
	}
	fprintf(stderr,"X Redir: Error: Couldn't redirect a port for X. Weird.\n\n");
}

/*
 * curtime kept to an accuracy of 1ms
 */
void
updtime(void)
{
	int inc;
	static int incd = 0;
	static int usec = 0;

	gettimeofday(&tt, 0);
	
	curtime = (u_int)tt.tv_sec * (u_int)1000;
	curtime += (u_int)tt.tv_usec / (u_int)1000;
	
	usec += tt.tv_usec % 1000;
	if (usec >= 1000) {
		curtime++;
		usec -= 1000;
	}

	inc = ((curtime - lastime) * bytesps);
	incd += inc % 1000;
	inc = inc / 1000;
	if (incd >= 1000) {
		inc++;
		incd -= 1000;
	}
	
	if (inc > 0) {
		lastime = curtime;
		towrite += inc;
		if (towrite > TOWRITEMAX) {
			incd = 0; /* Reset the delta */
			towrite = TOWRITEMAX;
		}
	}
}

/*
 * Get our IP address and put it in our_addr
 */
void
getouraddr(void)
{
	char buff[256];
	struct hostent *he;
	
	if (gethostname(buff,256) < 0)
	   return;
	
	if ((he = gethostbyname(buff)) == NULL)
	   return;
	
	our_addr = ((struct in_addr *)he->h_addr)->s_addr;
}

/*
 * Read the config file
 * XXX This is getting REALLY ugly, and the bloat of YACCifying it
 * is looking pale in comparison... I should YACCify it..
 */
void
config(file)
	char *file;
{
	FILE *cfg;
	char buff[256];
	
	cfg = fopen(file, "r");
	if (cfg == NULL)
	   return;
	
	fprintf(stderr,"Reading config file: %s\n", file);
	
	while(fgets(buff, 256, cfg) != NULL)
	   do_config(buff, (struct socket *)NULL, PRN_STDERR);
}

/*
 * XXX I'd have YACCed this, and made it more flexible, 
 * but that would add too much bloat to the code
 */
int
do_config(buff, inso, type)
	char *buff;
	struct socket *inso;
	int type;
{
	char str[256];
	u_long laddr;
	u_int lport, port;
	int x, rtype, (*print)(void *, const char *format, ...);
	char *ptr, *ptr2, **arg;
	struct socket *so;
	struct sbuf *sb = 0;
	
	if (inso)
	   sb = &inso->so_snd;

#ifdef DEBUG
	debug_call(dfd,"do_config(buff, inso, type) called ...\n");
	debug_call(dfd,"    buff = %d\n    inso = %d\n    type = %d\n", buff, sb, type);
	fflush_call(dfd);
#endif

	switch (type) {
	 case PRN_STDERR:
		print = (int (*)(void *, const char *, ...))fprintf;
		ptr2 = (char *)stderr;
		arg = (char **)&ptr2;
		break;
	 case PRN_SPRINTF:
		print = (int (*)(void *, const char *, ...))sprintf;
		ptr = sb->sb_wptr;
		arg = (char **)&ptr;
		if (do_echo)
		   ptr += (*print)(*arg,"\n");
		break;
	 default:
		return 0;
	}
		
	if (buff[0] == '#' || buff[0] == '\n' || buff[0] == ' ' || buff[0] == '\t' || buff[0] == '\r')
		return 0;
	
	/*
	 * These are common to both the config file and on-the-fly configuration
	 * XXX More damn spaghetti code.. ah well
	 */
	if (sscanf(buff, "redironce%*[tcp ]%d%*[to ]%[^:]:%d", &port, str, &lport) == 3) {
		rtype = SS_FACCEPTONCE;
		if ((laddr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad address: %s\n", buff);
			goto done;
		}
		goto doredirtcp;
	} else
	if (sscanf(buff, "redironce%*[tcp ]%d%*[to ]%d", &port, &lport) == 2) {
		rtype = SS_FACCEPTONCE;
		if (type == PRN_STDERR)
		   laddr = inet_addr("192.0.2.15");
		else
		   laddr = inso->so_laddr.s_addr;
		goto doredirtcp;
	} else
	if (sscanf(buff, "redir%*[tcp ]%d%*[to ]%[^:]:%d", &port, str, &lport) == 3) {
		rtype = 0;
		if ((laddr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad address: %s\n", buff);
			goto done;
		}
		goto doredirtcp;
	} else
	if (sscanf(buff, "redir%*[tcp ]%d%*[to ]%d", &port, &lport) == 2) {
		rtype = 0;
		if (type == PRN_STDERR)
		   laddr = inet_addr("192.0.2.15");
		else
		   laddr = inso->so_laddr.s_addr;
		
doredirtcp:
		so = solisten(htons(port), laddr, htons(lport), rtype);
		
		if (so)
		   ptr += (*print)(*arg, "Redirecting TCP port %d to %s:%d\n",
				   ntohs(so->so_fport), inet_ntoa(so->so_laddr), lport);
		else
		   ptr += (*print)(*arg, "Redirection failed: %s\n", strerror(errno));
		goto done;
	} else
	if (sscanf(buff, "redirtime udp %d%*[to ]%[^:]:%d", &port, str, &lport) == 3) {
		rtype = SS_FACCEPTONCE; /* XXX */
		if ((laddr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad address: %s\n", buff);
			goto done;
		}
		goto doredirudp;
	} else
	if (sscanf(buff, "redirtime udp %d%*[to ]%d", &port, &lport) == 2) {
		type = SS_FACCEPTONCE;
		if (type == PRN_STDERR)
		   laddr = inet_addr("192.0.2.15");
		else
		   laddr = so->so_laddr.s_addr;
		goto doredirudp;
	} else
	if (sscanf(buff, "redir udp %d%*[to ]%[^:]:%d", &port, str, &lport) == 3) {
		rtype = 0;
		if ((laddr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad address: %s\n", buff);
			goto done;
		}
		goto doredirudp;
	} else
	if (sscanf(buff, "redir udp %d%*[to ]%d", &port, &lport) == 2) {
		rtype = 0;
		if (type == PRN_STDERR)
		   laddr = inet_addr("192.0.2.15");
		else
		   laddr = so->so_laddr.s_addr;
		
doredirudp:
		so = udp_listen(htons(port), laddr, htons(lport), rtype);
			
		if (so)
		   ptr += (*print)(*arg, "Redirecting UDP port %d to %s:%d\n",
				   ntohs(so->so_fport), inet_ntoa(so->so_laddr), lport);
		else
		   ptr += (*print)(*arg, "Redirection failed: %s\n", strerror(errno));
		goto done;
	} else
	if (sscanf(buff, "baudrate %d", &x) == 1) {
		if (x < 300) {
			ptr += (*print)(*arg,"Error: badurate too low\n");
		} else {
			baud = x;
			bytesps = baud / 10; /* XXX */
			ptr += (*print)(*arg, "Seting baudrate to %d\n", baud);
		}
		goto done;
	} else
	if (sscanf(buff, "special address %s", str) == 1) {
		if ((special_addr = inet_addr(str)) == -1)
		   ptr += (*print)(*arg, "Error: Bad special address: %s\n", str);
		else
		   ptr += (*print)(*arg, "Seting special address to %s\n", str);
		goto done;
	} else
	if (sscanf(buff, "control address %s", str) == 1) {
		if ((ctl_addr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad control address: %s\n", buff);
			ctl_addr = 0;
		} else
			ptr += (*print)(*arg, "Seting control address to %s\n", str);
		goto done;
	} else
	if (sscanf(buff, "host address %s", str) == 1) {
		if ((our_addr = inet_addr(str)) == -1) {
			ptr += (*print)(*arg,"Error: Bad host address: %s\n", str);
			ctl_addr = 0;
		} else
			ptr += (*print)(*arg, "Seting host address to %s\n", str);
		goto done;
	} else
	if (sscanf(buff, "add exec %[^:]:%d", str, &x) == 2) {
		if (x < 0 || x > 65535) {
			ptr += (*print)(*arg,"Error: Port out of range: %d\n", x);
		} else if (add_exec(&exec_list, str, htons(x)) < 0) {
			ptr += (*print)(*arg, "Error: Port allready used: %s\n", buff);
		} else
			ptr += (*print)(*arg, "Adding %s to port %d\n", str, x);
		goto done;
	} else
	if (sscanf(buff, "add ptyexec %[^:]:%d", str, &x) == 2) {
		if (x < 0 || x > 65535) {
			ptr += (*print)(*arg, "Error: Port out of range: %d\n", x);
		} else if (add_exec(&ptyexec_list, str, htons(x)) < 0) {
			ptr += (*print)(*arg, "Error: Port allready used.\n");
		} else
			ptr += (*print)(*arg, "Adding %s to port %d\n", str, x);
		goto done;
	}
	
	/*
	 * These are config-file only
	 */
	if (type == PRN_STDERR) {
		if (strncmp(buff, "compress", 8) == 0) {
			ifp.ifp_flags = IF_COMPRESS;
			ptr += (*print)(*arg, "Using compression.\n");
			goto done;
		} else
		if (strncmp(buff, "nocompress", 10) == 0) {
			ifp.ifp_flags = IF_NOCOMPRESS;
			goto done;
		} else
		if (sscanf(buff, "mtu %d", &x) == 1) {
			if (x < (40+32) || x > 2048) {
				ptr += (*print)(*arg,"Error: mtu out of range\n");
			} else {
				ifp.ifp_mtu = x;
				ptr += (*print)(*arg, "Seting MTU to %d\n", ifp.ifp_mtu);
			}
			goto done;
		} else
		if (sscanf(buff, "shell %s", str) == 1) {
			if (exec_shell)
			   free(exec_shell);
			exec_shell = (char *)strdup(str);
			goto done;
		}
	} else {    /* if (type == PRN_SPRINTF) { */
	/*
	 * And finally, on-the-fly only
	 */
		if (strncmp(buff, "help", 4) == 0) {
			/* Can't be TOO big */
			ptr += (*print)(*arg, "Valid commands:\r\n");
			ptr += (*print)(*arg, "(please read the docs for a more detailed explination)\r\n");
			ptr += (*print)(*arg, "kill N\r\n");
			ptr += (*print)(*arg, "close N\r\n");
			ptr += (*print)(*arg, "stats [mbuf | ip | tcp | udp | tcpsock | udpsock]\r\n");
			ptr += (*print)(*arg, "redir[once|time] [PROTO] PORT [to] LPORT\r\n");
			ptr += (*print)(*arg, "echo [on | off]\r\n");
			ptr += (*print)(*arg, "add [pty]exec PROGRAM:PORT\r\n");
			ptr += (*print)(*arg, "remove [pty]exec PROGRAM:PORT\r\n");
			ptr += (*print)(*arg, "[pty]exec PROGRAM\r\n");
			ptr += (*print)(*arg, "[special | control | host] address ADDRESS\r\n");
			ptr += (*print)(*arg, "baudrate N\r\n");
			goto done;
		} else
		if (sscanf(buff, "remove exec %[^:]:%d", str, &x) == 2) {
			if (remove_exec(&exec_list, str, htons(x)) < 0)
			   ptr += (*print)(*arg, "Error: Exec not found.\n");
			else
			   ptr += (*print)(*arg, "Ok. Removed %s:%d\n", str, x);
			goto done;
		} else
		if (sscanf(buff, "remove ptyexec %[^:]:%d", str, &x) == 2) {
			if (remove_exec(&ptyexec_list, str, htons(x)) < 0)
			   ptr += (*print)(*arg, "Error: Exec not found.\n");
			else
			   ptr += (*print)(*arg, "Ok. Removed %s:%d\n", str, x);
			goto done;
		} else
		if (strncmp(buff, "echo on", 7) == 0) {
			do_echo = 1;
			ptr += (*print)(*arg, "Echo is on.\n");
			goto done;
		} else
		if (strncmp(buff, "echo off", 8) == 0) {
			do_echo = 0;
			ptr += (*print)(*arg, "Echo is off\n");
			goto done;
		} else
		if (strncmp(buff, "echo", 4) == 0) {
			ptr += (*print)(*arg, "Echo is %s\n", do_echo?"on":"off");
			goto done;
		} else
		if (sscanf(buff, "kill %d", &x) == 1) {
			rtype = 1;
			goto dokill;
		} else
		if (sscanf(buff, "close %d\n", &x) == 1) {
			rtype = 0;
dokill:
			for (so = tcb.so_next; so != &tcb; so = so->so_next) {
				if (so->s == x) {
					/* Found it */
					if (rtype == 1) {
						tcp_close(sototcpcb(so));
						ptr += (*print)(*arg,
						    " Ok. Successfully removed the session.\n");
					} else {
						tcp_sockclosed(sototcpcb(so));
						shutdown(so->s, 0); /* XXX */
						shutdown(so->s, 1); /* XXX */
						so->so_state = SS_NOFDREF; /* XXX */
						ptr += (*print)(*arg,
						     " Ok. Successfully closed the session.\n");
					}
					goto done;
				}
			}
			if (so == &tcb) {
				/*
				 * Not TCP, maybe UDP
				 */
				for (so = udb.so_next; so != &tcb; so = so->so_next)  {
					if (so->s == x)
					   udp_detach(so);
					ptr += (*print)(*arg," Ok. Successfully closed the session.\n");
					goto done;
				}
				
				/*
				 * Nup, cant find it
				 */
				if (so == &udb) {
					ptr += (*print)(*arg,
					    " Error: Failed to close the session: Session not found.\n");
				}
			}
			goto done;
		} else
		if (strncmp(buff, "stats ip", 8) == 0) {
			ptr += ipstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (strncmp(buff, "stats tcpsock", 16) == 0) {
			ptr += tcpsockstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (strncmp(buff, "stats tcp", 9) == 0) {
			ptr += tcpstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (strncmp(buff, "stats udpsock", 16) == 0) {
			ptr += udpsockstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (strncmp(buff, "stats udp", 9) == 0) {
			ptr += udpstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (strncmp(buff, "stats mbuf", 10) == 0) {
			ptr += mbufstats(sb, PRN_SPRINTF);
			goto done;
		} else
		if (sscanf(buff, "exec %s", str) == 1) {
			fork_exec(inso, str, 0);
			soisfconnected(inso);
			inso->so_iptos &= ~IPTOS_EMU;
			goto done;
		} else
		if (sscanf(buff, "ptyexec %s", str) == 1) {
			fork_exec(inso, str, 1);
			soisfconnected(inso);
			inso->so_iptos &= ~IPTOS_EMU;
			goto done;
		}
	}
	
	/* Else, we no comprede the command */
	if (type == PRN_SPRINTF)
	   ptr += (*print)(*arg, "Error: Bad command: %s\n", buff);
	else
	   ptr += (*print)(*arg, "Error: Bad config line: %s\n", buff);
done:
	if (do_echo)
	   ptr += (*print)(*arg, "\r");

	if (sb) return ptr - sb->sb_wptr;
}


/* ANSI doesn't like inline functions */
#ifdef ANSI

struct quehead {
	struct quehead *qh_link;
	struct quehead *qh_rlink;
};

void
insque(void *a, void *b)
{
	register struct quehead *element = a, *head = b;
	element->qh_link = head->qh_link;
	head->qh_link = (struct quehead *)element;
	element->qh_rlink = (struct quehead *)head;
	((struct quehead *)(element->qh_link))->qh_rlink
	= (struct quehead *)element;
}

void
remque(void *a)
{
	register struct quehead *element = a;
	((struct quehead *)(element->qh_link))->qh_rlink = element->qh_rlink;
	((struct quehead *)(element->qh_rlink))->qh_link = element->qh_link;
	element->qh_rlink = 0;
}

#endif


int
add_exec(ex_ptr, exec, port)
	struct ex_list **ex_ptr;
	char *exec;
	int port;
{
	struct ex_list *tmp_ptr;
	
	/* First, check if the port is "bound" */
	for (tmp_ptr = *ex_ptr; tmp_ptr; tmp_ptr = tmp_ptr->ex_next) {
		if (port == tmp_ptr->ex_fport)
		   return -1;
	}
	
	tmp_ptr = *ex_ptr;
	*ex_ptr = (struct ex_list *)malloc(sizeof(struct ex_list));
	(*ex_ptr)->ex_fport = port;
	(*ex_ptr)->ex_exec = strdup(exec);
	(*ex_ptr)->ex_next = tmp_ptr;
	return 0;
}

int
remove_exec(ex_ptr, exec, port)
	struct ex_list **ex_ptr;
	char *exec;
	int port;
{
	struct ex_list *tmp_ptr, *last_ptr = 0;
	
	for (tmp_ptr = *ex_ptr; tmp_ptr; tmp_ptr = tmp_ptr->ex_next) {
		if (port == tmp_ptr->ex_fport) {
			/* Found it, now unlink it */
			if (last_ptr)
			   last_ptr->ex_next = tmp_ptr->ex_next;
			else
			   *ex_ptr = tmp_ptr->ex_next;
			/* and free it */
			free(tmp_ptr->ex_exec);
			free(tmp_ptr);
			return 0;
		}
		last_ptr = tmp_ptr;
	}
	
	return -1;
}

#ifdef BAD_SPRINTF

/*
 * SunOS has a sprintf which returns char *
 */

#include <stdarg.h>

int
sprintf_len (char *string, const char *format, ...)
{
	va_list args;
	
	va_start(args, format);
	vsprintf(string, format, args);
	va_end(args);
	return strlen(string);
}

#endif

#ifdef NO_STRERROR

/*
 * For systems with no strerror
 */

extern int sys_nerr;
extern char *sys_errlist[];

char *
strerror(int error)
{
	if (error < sys_nerr)
	   return sys_errlist[error];
	else
	   return "Unknown error.";
}

#endif


/*
 * XXX This is ugly
 * We create and bind a socket, then fork off to another
 * process, which connects to this socket, after which we
 * exec the wanted program.  If something (strange) happens,
 * the accept() call could block us forever.
 */
int
fork_exec(so, ex, do_pty)
	struct socket *so;
	char *ex;
	int do_pty;
{
	struct sbuf *sb = &so->so_snd;
	int s;
	struct sockaddr_in addr;
	int addrlen = sizeof(addr);
	int opt = 1;
	int x;

#ifdef DEBUG
	debug_call(dfd,"fork_exec(so, ex, do_pty) called ...\n");
	debug_call(dfd,"    so = %d\n    ex = %s\n    do_pty = %d\n", so, ex, do_pty);
	fflush_call(dfd);
#endif

	addr.sin_family = AF_INET;
	addr.sin_port = 0;
	addr.sin_addr.s_addr = INADDR_ANY;
	
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0 ||
	    bind(s, (struct sockaddr *)&addr, addrlen) < 0 ||
	    listen(s, 1) < 0)  {
		sb->sb_cc = sprintf(sb->sb_wptr, " Error: %s\n", strerror(errno));
		sb->sb_wptr += sb->sb_cc;
		close(s);
		
		return 0;
	}
	
	x = fork();
	if (x < 0)  {
		sb->sb_cc = sprintf(sb->sb_wptr, " Error: fork failed: %s\n", strerror(errno));
		sb->sb_wptr += sb->sb_cc;
		close(s);
		
		return 0;
	
	} else if (x == 0)   {
		char *argv[256];
		int i = 0;
		/* don't want to clobber the original */
		char *ptr = strdup(ex); /* No need to free() this */
		char *curarg;
		int c;
		
		getsockname(s, (struct sockaddr *)&addr, &addrlen);
		close(s);
		/*
		 * Connect to the socket
		 * XXX If any of these fail, we're in trouble!
		 */
		s = socket(AF_INET, SOCK_STREAM, 0);
		addr.sin_addr.s_addr = inet_addr("127.0.0.1");;
		connect(s, (struct sockaddr *)&addr, addrlen);
		
		dup2(s, 0);
		dup2(s, 1);
		dup2(s, 2);
		for (s = 3; s < 256; s++)
		   close(s);
		
		if (do_pty)  {
			/* Setup "slirp.telnetd -x" */
			argv[i++] = "slirp.telnetd";
			argv[i++] = "-x";
			argv[i++] = strdup(ptr);
		} else
		do  {
			/* Change the string into argv[] */
			curarg = ptr;
			while (*ptr != ' ' && *ptr != (char)0)
			   ptr++;
			c = *ptr;
			*ptr++ = (char)0;
			argv[i++] = strdup(curarg);
		} while (c);
		
		argv[i] = 0;
		execvp(*argv, argv);
		/* Ooops, failed, lets tell the user why */
		{
			char buff[256];
			
			sprintf(buff, "Error: execvp failed: %s\n", strerror(errno));
			write(2, buff, strlen(buff));
		}
		close(0); close(1); close(2); /* XXX */
		exit(1);
	} else {
		/*
		 * XXX this could block us...
		 * XXX Should set a timer here, and if accept() doesnt
		 * return after X seconds, declare it a failure
		 * The only reason this will block forever is if socket()
		 * of connect() fail in the child process
		 */
		so->s = accept(s, (struct sockaddr *)&addr, &addrlen);
		close(s);
		ioctl(so->s, FIONREAD, &opt);
		setsockopt(so->s,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int));
		setsockopt(so->s,SOL_SOCKET,SO_OOBINLINE,&opt,sizeof(int));
		
		return 1;
	}
}
