/*
 * Set this lower if you have an error prone link
 */
#define TCP_SNDSPACE 4096

/*
 * Window size
 */
#define TCP_RCVSPACE 8096

/*
 * Maximum segment lifetime.  This is the maximum
 * "timeout" value for each packet.
 * Set to a low value on error prone links, so that packets
 * timeout fast, hence they can be retransmitted quickly.
 * Shouldn't be too high even on error-free links.
 * Original default is 30 seconds but this is far too high
 * for a simple SLIP connection.  A good value is 5-10 seconds
 * (default 5 seconds)
 * (XXX There are other timing config's you might want to change
 * in tcp_timer.h)
 */
/* #define TCPTV_MSL       ( 30*PR_SLOWHZ)      */   /* max seg lifetime (hah!) */
#define TCPTV_MSL       ( 5*PR_SLOWHZ)          /* max seg lifetime (hah!) */

/*
 * Maximum retransmits before the connections is reset.
 * If you do not have a 8-bit clean link, of have an error-prone
 * link, you'll see sessions spontaneously die because the number
 * of retransmits exceeded this value.
 */
#define TCP_MAXRXTSHIFT 12                      /* maximum retransmits */

/*
 * Change to 1 if you want all connections to have a keep-alive timer.
 */
#define DO_KEEPALIVE 0
 



#define PORT_ANY 23
