@ECHO OFF
ECHO OFF
REM -- PKBACKUP.BAT -- perform backups using PKZIP 2.x's disk spanning feature
REM -- Author:  Phil Hair
REM -- Date:    10 March 1994
REM -- Version: 1.0
REM
REM ************************** CHECK USAGE *************************
IF "%1" == ""        GOTO USAGE
IF "%2" == ""        GOTO USAGE
rem * rem out the following line to not require backup-type (arg #3)
rem * IF "%3" == ""        GOTO USAGE
IF NOT "%4" == ""    GOTO USAGE
rem * rem out/add to following pairs of lines to change source-drives 
rem * permitted (arg #1)
IF "%1" == "C"       GOTO C1
IF "%1" == "c"       GOTO C1
IF "%1" == "D"       GOTO C1
IF "%1" == "d"       GOTO C1
GOTO USAGE
:C1
rem * rem out/add to following pairs of lines to change destination-drives 
rem * permitted (arg #2)
IF "%2" == "A"       GOTO C2
IF "%2" == "a"       GOTO C2
IF "%2" == "B"       GOTO C2
IF "%2" == "b"       GOTO C2
GOTO USAGE
:C2
IF "%3" == "/F"      GOTO FULL
IF "%3" == "/f"      GOTO FULL
IF "%3" == "/W"      GOTO WEEK
IF "%3" == "/w"      GOTO WEEK
IF "%3" == "/D"      GOTO DAILY
IF "%3" == "/d"      GOTO DAILY
IF NOT "%3" == ""    GOTO USAGE
rem * change following lines to change default backup type if default is
rem * permitted (arg #3 omitted)
GOTO DAILY
rem * GOTO WEEK
rem * GOTO FULL
REM ************************** FULL BACKUP *************************
:FULL
CLS
ECHO Full backup of drive %1:
ECHO Put first floppy of backup set in drive A:
ECHO .
ECHO Hit CONTROL-C to stop backup now
ECHO -or-
PAUSE
rem * rem out following line to use default temp drive/path
IF "%PKTMP%" == ""   SET PKTMP=C:\TMP
rem * rem out following line to use default DOS verify option
rem * VERIFY ON
ECHO ON
%1:
PKZIP -a+ -ex -&fs %2:full_%1.zip
@ECHO OFF
ECHO OFF
GOTO ELEV
REM ************************* WEEKLY BACKUP ************************
:WEEK
CLS
ECHO Weekly backup of drive %1:
ECHO Put first floppy of backup set in drive A:
ECHO .
ECHO Hit CONTROL-C to stop backup now
ECHO -or-
PAUSE
rem * rem out following line to use default temp drive/path
IF "%PKTMP%" == ""   SET PKTMP=C:\TMP
rem * rem out following line to use default DOS verify option
rem * VERIFY ON
ECHO ON
%1:
PKZIP -i -ex -&fs %2:week_%1.zip
@ECHO OFF
ECHO OFF
GOTO ELEV
REM ************************* DAILY BACKUP *************************
:DAILY
CLS
ECHO Daily backup of drive %1:
ECHO Put first floppy of backup set in drive A:
ECHO .
ECHO Hit CONTROL-C to stop backup now
ECHO -or-
PAUSE
rem * rem out following line to use default temp drive/path
IF "%PKTMP%" == ""   SET PKTMP=C:\TMP
rem * rem out following line to use default DOS verify option
rem * VERIFY ON
ECHO ON
%1:
PKZIP -i- -ex -&fs %2:daily_%1.zip
@ECHO OFF
ECHO OFF
GOTO ELEV
:ELEV
IF ERRORLEVEL 1 GOTO ERRS
ECHO Backup complete.  Remove last diskette from floppy drive.
GOTO END
REM ************************* ERROR HANDLER ************************
:ERRS
ECHO .
IF ERRORLEVEL 255 GOTO ECTRLC
IF ERRORLEVEL  17 GOTO EFILES
IF ERRORLEVEL  16 GOTO ECLINE
IF ERRORLEVEL  12 GOTO EFILES
IF ERRORLEVEL   4 GOTO EMEMORY
GOTO EFILES
:ECTRLC
ECHO Error: User has hit CONTROL-C, stopping PKZIP
GOTO ECOMMON
:EFILES
ECHO Error: File related problem.
GOTO ECOMMON
:ECLINE
ECHO Error: PKZIP command line usage problem.
GOTO ECOMMON
:EMEMORY
ECHO Error: Memory related problem
GOTO ECOMMON
:ECOMMON
ECHO Backup has failed.  Remove last diskette from floppy drive.
rem * rem out following line to not pause after error
PAUSE
GOTO END
REM ***************************** USAGE ****************************
:USAGE
ECHO Perform backups using PKZIP 2.x from hard drive to floppy using disk spanning
ECHO .
ECHO PKBACKUP source-drive destination-drive [backup-type]
ECHO .
ECHO . source-drive      drive to back up from [do *NOT* use ':']
ECHO .                   (example: C or D)
ECHO . destination-drive drive to back up to [do *NOT* use ':']
ECHO .                   (example: A or B)
ECHO . backup-type       backup type.  allowable values:
ECHO .                   /F -- FULL -- backs up all files, resets archive bits.
ECHO .                   /W -- WEEKLY -- backs up all files modified since
ECHO .                         last FULL or WEEKLY, resets archive bits.
ECHO .                   /D -- DAILY -- backs up all files modified since last
ECHO .                         FULL or WEEKLY, does *not* reset archive bits.
ECHO .                   (if no backup-type is specified, assume DAILY.)
rem * rem out following line to not pause after usage display
rem * PAUSE
:END
