// Filename: VIDEO.CPP
// Program that computes video rental amounts and gives
// appropriate discounts based on the day or customer status.
#include <iostream.h>
#include <iomanip.h>
void main()
{
   float tape_charge, discount, rental_amt;
   char first_name[15];
   char last_name[15];
   int num_tapes;
   char val_day, sp_stat;

   cout << "\n\n *** Video Rental Computation ***\n";
   cout << "     ------------------------\n"; // Underline title

   tape_charge = 2.00;   // Before-discount tape fee-per tape.

   // Receive input data after skipping a line
   cout << "\nWhat is customer's first name? ";
   cin >> first_name;
   cout << "What is customer's last name? ";
   cin >> last_name;

   cout << "\nHow many tapes are being rented? ";
   cin >> num_tapes;

   cout << "Is this a Value day (Y/N)? ";
   cin >> val_day;

   cout << "Is this a Special Status customer (Y/N)? ";
   cin >> sp_stat;

   // Calculate rental amount.
   discount = 0.0;   // Increase discount IF they are eligible.
   if ((val_day == 'Y') || (sp_stat == 'Y'))
     { discount = 0.5;
       rental_amt=(num_tapes*tape_charge)-(discount*num_tapes); }

   // Print the bill.
   cout.setf(ios::fixed);
   cout << "\n\n** Rental Club **\n\n";
   cout << first_name << " " << last_name << " rented "
        << num_tapes << " tapes\n";
   cout << "The total was $" << setprecision(2)
        << rental_amt << "\n";
   cout << "The discount was $" << discount
        << " per tape\n";

   // Print extra message for Special Status customers.
   if (sp_stat == 'Y')
      { cout << "\nThank them for being a Special "
             << "Status customer\n";}
}

