// Filename: OVF1.CPP
// Overloads two absolute value functions.
#include <iostream.h>  // Prototype cout and cin.
#include <iomanip.h>   // Prototype setprecision(2).

int abs(int i);      // abs() is overloaded twice
float abs(float x);  // as shown by these prototypes.

void main()
{
   int ians;       // To hold return values.
   float fans;
   int i = -15;    // To pass to the two overloaded functions.
   float x = -64.53;

   ians = abs(i);    // C++ calls the integer abs().
   cout << "Integer absolute value of -15 is " << ians << "\n";

   fans = abs(x); // C++ calls the floating-point abs().
   cout << "Float absolute value of -64.53 is " <<
           setprecision(2) << fans << "\n";

   // Notice that you no longer have to keep track of two
   // different names.  C++ calls the appropriate
   // function that matches the parameters.
   return;
}

int abs(int i)     // Integer absolute value function
{
   if (i < 0)
   {  return (i * -1); }  // Makes positive.
   else
   {  return (i);  }      // Already positive.
}

float abs(float x)  // Floating-point absolute value function
{
   if (x < 0.0)
   {  return (x * -1.0); }  // Makes positive.
   else
   {  return (x);  }        // Already positive.
}

