// Filename: ARPT.CPP
// Comprehensive reference of arrays and pointers.
#include <iostream.h>
void main()
{
   float ara[] = {100.0, 200.0, 300.0, 400.0, 500.0};
   float *fptr;                 // Floating-point pointer.

   // Make pointer point to array's first value.
   fptr = &ara[0];          // Also could have been this:
                            // fptr = ara;

   cout << *fptr << "\n";                  // Prints 100.0
   fptr++;         // Points to next floating-point value.
   cout << *fptr << "\n";                  // Prints 200.0
   fptr++;         // Points to next floating-point value.
   cout << *fptr << "\n";                  // Prints 300.0
   fptr++;         // Points to next floating-point value.
   cout << *fptr << "\n";                  // Prints 400.0
   fptr++;         // Points to next floating-point value.
   cout << *fptr << "\n";                  // Prints 500.0

   fptr = ara;           // Points to first element again.
   cout << *(fptr+2) << "\n";         // Prints 300.00 but
                                  // does not change fptr.

   // References both array and pointer using subscripts.
   cout << (fptr+0)[0] << " " << (ara+0)[0] << "\n";             // 100.0  100.0
   cout << (fptr+1)[0] << " " << (ara+1)[0] << "\n";             // 200.0  200.0
   cout << (fptr+4)[0] << " " << (ara+4)[0] << "\n";             // 500.0  500.0
   return;
}

