00010 REM  ===============================================================
00020 REM                 Sample Listbox BBASIC Program
00030 REM 
00040 REM                          LISTHOST.BAS
00050 REM  
00060 REM  Demonstrates the use of the LISTBOX.SCR file using listbox 
00070 REM  entries sent from the host system.
00080 REM  
00090 REM  
00100 REM           Copyright CLEARVIEW Software Inc. 1992, 1993
00110 REM                      All Rights Reserved
00120 REM  ===============================================================
00130 REM 
00140 REM 
00150 REM =================================================================
00160 REM  Dimension some string variables and assign the API string prefix
00170 REM =================================================================
00180 DIM MAGIC$[1],STRING$[256],QUOTE$[1]
00190 LET MAGIC$=CHR$(127)
00200 LET QUOTE$=CHR$(34)
00210 REM 
00220 REM  
00230 REM =================================================================
00240 REM  Send the API to Co*Star using the following output:
00250 REM 
00260 REM   Output                  Description
00270 REM   ---------------------   ---------------------------------------
00280 REM   MAGIC$;"UWSCRIPT        API for executing external script file
00290 REM 
00300 REM   sdk\listbox.scr         Path and filename for the script file
00310 REM 
00320 REM   103                     List box type -- information is sent
00330 REM                           from the host as screen output.       
00340 REM                           The listbox is automatically sorted.
00350 REM                           See LISTBOX.SCR for details.
00360 REM 
00370 REM  Sample Listbox           Title for the listbox window.
00380 REM 
00390 REM  1                        Flag to append a CR to the selected 
00400 REM                           item.
00410 REM 
00420 REM  10,30,20,50              Display coordinates for listbox.
00430 REM 
00440 REM  MAGIC$                   API terminator.
00450 REM =================================================================
00460 PRINT "<12>"
00470 REM 
00480 PRINT MAGIC$;"UWSCRIPTsdk\listbox.scr,103,Sample ListBox,1";
00490 PRINT ",10,30,20,50";MAGIC$;
00500 REM 
00510 REM   
00520 REM =================================================================
00530 REM  This section reads the DATA statements and sends the sample
00540 REM  employee names to Co*Star.  Since the employee names contain
00550 REM  a comma (ex. Adams, Frank) the name must be enclosed with
00560 REM  quotes.   Commas are used to delineate entries in the listbox.
00570 REM 
00580 REM  The PRINT@(1,1) statement is used to move the cursor to row 1,
00590 REM  column 1.  This is to prevent the host system from scrolling the
00600 REM  screen as a result of all the print statements.                  
00610 REM       
00620 REM  Once the list is completed the MAGIC$ character is sent to       
00630 REM  signal Co*Star the listbox is ready to display.
00640 REM =================================================================
00650 REM 
00660 REM  Get next string
00670 READ STRING$
00680 REM 
00690 IF STRING$<>"EOF" THEN 
00700   PRINT @(1,1);
00710   PRINT QUOTE$;STRING$;QUOTE$;
00720   PRINT ",";
00730   GOTO 00660 :  Get next string
00740 END IF
00750 REM 
00760 REM 
00770 REM Now, end the listbox
00780 PRINT MAGIC$;
00790 REM 
00800 REM      
00810 REM =================================================================
00820 REM  Wait for the user to  select an item from the list box.
00830 REM  The selected data item will be returned to STRING$.  If no
00840 REM  selection was made then STRING$ will be null.
00860 REM =================================================================
00870 PRINT "<12>"
00880 INPUT USING "","Enter employee name: ",STRING$
00890 REM 
00900 END 
00960 REM 
00970 REM 
00980 REM 
00990 REM 
01000 REM  =================================================================
01010 REM  DATA Statements for the listbox.  The names could be read from a 
01020 REM  file on the host system as well.  Note that the names are not 
01030 REM  sorted.
01040 REM 
01050 REM  Note:  BBASIC requires that DATA strings be enclosed with quotes.
01060 REM   =================================================================
01070 REM  
01080 DATA "Adams, Frank"
01090 DATA "Smith, David"
01100 DATA "Gates, Bill"
01110 DATA "Erickson, George"
01120 DATA "Banta, Fred"
01130 DATA "Baruch, Jay"
01140 DATA "Beck, Bob"
01150 DATA "Brown, Alex M"
01160 DATA "Clarkson, Robert"
01170 DATA "Conners, Richard V"
01180 DATA "Danenbarger, Sharron"
01190 DATA "Daniels, Paul"
01200 DATA "Darling, Scott F"
01210 DATA "Donchess, John"
01220 DATA "Dugan, Donald P"
01230 DATA "Smith, Steven"
01240 DATA "Harper, Lloyd"
01250 DATA "McGuire, Patrick"
01260 DATA "Sawyer, Tony"
01270 DATA "Donovan, Jay"
01280 DATA "EOF"
