// Version KEA! 4.1
//ATMAPI/HLLAPI suport version 1.0 for EPC 5.0
Var ATM_NOTFOUND = 0
var ATM_NOTCONNECTED = -1
var ATM_ISPOWEREDON = 3
var ATM_CHANGEINGPAGE = -31
var ATM_INVALIDFUNCTION = -32
var ATM_NOTAPPLICABLE = -1002
Var  ATM_SUCCESS                 =    0
Var  ATM_INVALIDPSID             =    1
Var  ATM_INVALIDPARAMETER        =    2
Var  ATM_SESSIONOCCUPIED         =    4
Var  ATM_TIMEOUT                 =    4       //*  e.g. Wait (XCLOCK/XSYSTEM)*/
Var  ATM_PROTECTED               =    5
Var  ATM_DATATRUNCATED           =    6       //*  e.g. CopyStringToField  */
Var  ATM_INVALIDPSPOSITION       =    7
Var  ATM_NOPRIORSTARTKEYSTROKE   =    8
Var  ATM_NOPRIORSTARTHOSTNOTIFY  =    8
Var  ATM_NOPRIORSTARTMACRO       =    8
Var  ATM_NOMACRORUNNING          =    8
Var  ATM_NOMACROPAUSED           =    8
Var  ATM_SYSTEMERROR             =    9
Var  ATM_FUNCTIONNOTAVAILABLE    =    10
Var  ATM_RESOURCEUNAVAILABLE     =    11
Var  ATM_SEARCHSTRINGNOTFOUND    =    24      //*  e.g. SearchField    */
Var  ATM_UNFORMATTEDHOSTPS       =    24      //*  e.g. CopyFieldToString  */
Var  ATM_NOHOSTSESSIONUPDATE     =    24      //*  new code for QueryHostUpdate    */
Var  ATM_KEYSTROKESNOTAVAILABLE  =    25
Var  ATM_HOSTSESSIONUPDATE       =    26      //*  end of Pause    */
Var  ATM_KEYSTROKEQUEUEOVERFLOW  =    31

Var  ATM_MEMORYUNAVAILABLE      =     101     //*  cf StartKSIntercept   */
Var  ATM_DELAYENDEDBYCLIENT      =    102     //*  Wait, Pause, GetKey */
Var  ATM_UNCONFIGUREDPSID        =    103     //*  Connect, Intercept    */
Var  ATM_NOEMULATORATTACHED      =    104     //*  keystroke intercept, etc */
Var  ATM_WSCTRLFAILURE           =    105

//********************************
//values for Post Intercept Status
//********************************/
Var  ATM_INTERCEPTACCEPTED       =    0
Var  ATM_INTERCEPTREJECTED       =    1

//Control constants
Var MAX_STRINGEVENTS = 30
Var Max_KeyEvents = 3
Var MAX_CURSORATEVENTS = 5
Var MAX_STRINGNOTATEVENTS= 5
Var MAX_EVENTTABLES = 5   //* Maximum number of tables allowed in waitforevents.

Var ATM_EVENTALLREADYSET = 301
Var ATM_EVENTMAXEXCEEDED = 302

var ATM_TABLEMAXEXCEEDED = 303
var ATM_TABLENOTSET = 304
Var ATM_EVENTIDNOTSET = 305
var KTM_INVALIDPARAMETER = -2
var KTM_ARGNOTOOHIGH = -1001
var KTM_WRAPPERINCOMPLETE = -1002
var KTM_WRAPPEROUTOFPOSITION = -1003
Function ATMAddWait()
Var iRet 
Var sEventString, iSessionHandle
var iEventTable = 1
var iEventNbr = 1
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex = int(KTMParseArg(3,args))
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if	EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <>  ""
	iRet = ATM_EVENTALLREADYSET
	KTMDDEreply(iRet,) 
	Return
end
if iEventTable <= MAX_EVENTTABLES
	if iEventsWaitIndex[iEventTable][iSessionHandle].EVENTNBR = ""
		iEventsWaitIndex[iEventTable][iSessionHandle]= iEventIndex
		iEventsWaitTime[iEventTable][iSessionHandle] = 1
		EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "WAIT"
		bTableValid[iEventTable][iSessionHandle] = TRUE
		iRet = ATM_SUCCESS
	else
		iRet = ATM_EVENTALLREADYSET
	end
else
	iRet = ATM_TABLEMAXEXCEEDED
end
KTMDDEreply(iRet,) 
Return
end //function ATMAddWait()
Function ATMAddWaitForHostConnect()
Var iRet = 10 // ATM_FUNCTION NOT SUPPORTED
KTMDDEreply(iRet,) 
Return
end //Function ATMAddWaitForHostConnect
Function ATMAddWaitForCursor()


//There are several event types:  WaitForString as a location, WaitForString NOT at, WaitForQuiet etc.
//For those with multiple events of one type (e.g., WaitForString) a table of events of that type is built.
//In the case of WaitForString this is saEvent
Var iRet,iRow, iCol ,iEndRow, iEndCol, iSelectType
Var iEventIndex,iEventTable,iSessionHandle, iEventNbr
var iEventTable 
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex= int(KTMParseArg(3,args))
iRow = int(KTMParseArg(4,args))
iCol = int(KTMParseArg(5,args))
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
		iRet = ATM_EVENTALLREADYSET
end
if iRet = ATM_SUCCESS

if caEventsFreeList[iEventTable][iSessionHandle][iSessionHandle] 
	if not("HEADOFFREELIST" in caEventsFreeList[iEventTable][iSessionHandle])
		iLastCursorAtEventNbr[iEventTable][iSessionHandle] = iLastCursorAtEventNbr[iEventTable][iSessionHandle] + 1
		iEventNbr = iLastCursorAtEventNbr[iEventTable][iSessionHandle]
	else
		iEventNbr = caEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
		caEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = 	caEvent[iEventTable][iSessionHandle][iEventNbr].NEXTFREE
		DeleteElement (caEvent[iEventTable][iSessionHandle][iEventNbr],"NEXTFREE")
	//if this was last free one then clear out tail of free list also
		if caEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iEventNbr
			DeleteElement (caEventsFreeList[iEventTable][iSessionHandle], "TAILOFFREELIST")
		end
	end
else
	iLastCursorAtEventNbr[iEventTable][iSessionHandle] = iLastCursorAtEventNbr[iEventTable][iSessionHandle] + 1
	iEventNbr = iLastCursorAtEventNbr[iEventTable][iSessionHandle]
end
	if iEventTable <= MAX_EVENTTABLES
		if iLastCursorAtEventNbr[iEventTable][iSessionHandle] <= MAX_CURSORATEVENTS
			

			if iRow = 0				if iCol > 0
					iSelectType = Select_Block
					iRow = 1
					iEndRow = int(display.lines)
					iEndCol = iCol + 1
				else
					iRet = ATM_INVALIDPARAMETER
					KTMDDEreply(iRet)
					Return
				end
			else
				iSelectType = Select_Stream
				iEndRow = iRow
				if iCol = 0 
					iCol = 1
					iEndCol = int(display.columns) + 1
					iEndRow = iRow
				else
					iEndCol = iCol + 1
				end
			end

			H1AddCursorAtEventRow(caEvent[iEventTable][iSessionHandle][iEventNbr], iRow, iCol,iEventIndex,iEndRow,iEndCol)
			caEvent[iEventTable][iSessionHandle][iEventNbr].TYPE = iSelectType
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr 
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "CURSORAT"
			bTableValid[iEventTable][iSessionHandle] = TRUE
			iRet = ATM_SUCCESS
		else

			iRet = ATM_EVENTMAXEXCEEDED
				iLastCursorAtEventNbr[iEventTable][iSessionHandle] = iLastCursorAtEventNbr[iEventTable][iSessionHandle] - 1
		end
	else
		iRet = ATM_TABLEMAXEXCEEDED
	end
end
 KTMDDEreply(iRet,)  
Return
End
Function H1AddCursorAtEventRow(var RowID,iRow,iCol,iEventIndex,iEndRow, iEndCol)

RowID.ROW = iRow
RowID.COL = iCol
RowID.ENDROW = iEndRow
RowID.ENDCOL = iEndCol
RowID.INDEX = iEventIndex

End //Function H1AddCurstorAtEventRow
Function ATMAddWaitForCursorMove()
Var iRet 
Var iEventIndex = int(KTMParseArg(3,args))
Var iSessionHandle = int(KTMParseArg(1,args))
var iEventTable = int(KTMParseArg(2,args))
Var iEventNbr = 1
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
	iRet = ATM_EVENTALLREADYSET
	KTMDDEreply(iRet,)
	Return
end
if iEventTable <= MAX_EVENTTABLES
	if iEventsCursorMoveIndex[iEventTable][iSessionHandle] = 0
		iEventsCursorMoveIndex[iEventTable][iSessionHandle]= iEventIndex
		iEventsCursorMoveFlag[iEventTable][iSessionHandle] = TRUE
				EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "CURSORMOVE"
		bTableValid[iEventTable][iSessionHandle] = TRUE
		iRet = ATM_SUCCESS
	else
		iRet = ATM_EVENTALLREADYSET
	end
else
	iRet = ATM_TABLEMAXEXCEEDED
end
KTMDDEreply(iRet,) 
Return
End //Function ATMAddWaitForCursorMove
Function ATMAddWaitForHostDisconnect()
Var iRet 
Var iSessionHandle = int(KTMParseArg(1,args))
var iEventTable = int(KTMParseArg(2,args))
var iEventIndex = int(KTMParseArg(3,args))
Var iEventNbr = 1
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
	iRet = ATM_EVENTALLREADYSET
	KTMDDEreply(iRet,)
	Return
end

if iEventTable <= MAX_EVENTTABLES
	if iEventsDisconnectIndex[iEventTable][iSessionHandle] = ""
		iEventsDisconnectIndex[iEventTable][iSessionHandle]= iEventIndex
		iEventsDisconnectFlag[iEventTable][iSessionHandle] = TRUE
				EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "DISCONNECT"
		bTableValid[iEventTable][iSessionHandle] = TRUE
		iRet = ATM_SUCCESS
	else
		iRet = ATM_EVENTALLREADYSET

	end
else
	iRet = ATM_TABLEMAXEXCEEDED
end
 KTMDDEreply(iRet) 
Return


End //Function ATMAddWaitForHostDisconnect
Function ATMAddWaitForKey()


//There are several event types:  WaitForString as a location, WaitForString NOT at, WaitForQuiet etc.
//For those with multiple events of one type (e.g., WaitForString) a table of events of that type is built.
//In the case of WaitForKey this is keyEvent
Var iRet,sWaitKey
Var iEventIndex,iEventTable,iSessionHandle, iEventNbr
var iEventTable 
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex= int(KTMParseArg(3,args))
sWaitKey = KTMParseArg(4,args)

if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
		iRet = ATM_EVENTALLREADYSET
end
if iRet = ATM_SUCCESS
	if len(sWaitKey) > 1 and len(sWaitKey) < 6
		sWaitKey = KTMCodeToKey(sWaitKey) // get down to one char
		if len(sWaitKey) > 1 //means an error was returned
			iRet = int(sWaitKey)

		end
	end
end
if iRet = ATM_SUCCESS

	if keyEventsFreeList[iEventTable][iSessionHandle] 
		if not("HEADOFFREELIST" in keyEventsFreeList[iEventTable][iSessionHandle])
			iLastKeyEventNbr[iEventTable][iSessionHandle] = iLastKeyEventNbr[iEventTable][iSessionHandle] + 1
			iEventNbr = iLastKeyEventNbr[iEventTable][iSessionHandle]
		else
			iEventNbr = keyEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
			keyEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = 		keyEvent[iEventTable][iSessionHandle][iEventNbr].NEXTFREE
			DeleteElement (keyEvent[iEventTable][iSessionHandle][iEventNbr],"NEXTFREE")
			if keyEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iEventNbr
			DeleteElement (keyEventsFreeList[iEventTable][iSessionHandle], "TAILOFFREELIST")
		end
		end
	else
		iLastKeyEventNbr[iEventTable][iSessionHandle] = iLastKeyEventNbr[iEventTable][iSessionHandle] + 1
		iEventNbr = iLastKeyEventNbr[iEventTable][iSessionHandle]
	end
	if iEventTable <= MAX_EVENTTABLES
		if iLastKeyEventNbr[iEventTable][iSessionHandle] <= MAX_KEYEVENTS 
			H1AddKeyEventRow(keyEvent[iEventTable][iSessionHandle][iEventNbr], sWaitKey,iEventIndex)
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "KEY"
			bTableValid[iEventTable][iSessionHandle] = TRUE
			iRet = ATM_SUCCESS
		else
			iRet = ATM_EVENTMAXEXCEEDED
			iLastKeyEventNbr[iEventTable][iSessionHandle] = iLastKeyEventNbr[iEventTable][iSessionHandle] - 1
		end
	else
		iRet = ATM_TABLEMAXEXCEEDED
	end
end
 KTMDDEreply(iRet,) 
Return
End
Function H1AddKeyEventRow(var RowID,sWaitKey,iEventIndex)

RowID.KEY = sWaitKey
RowID.INDEX = iEventIndex

End //Function H1AddCurstorAtEventRow

Function ATMAddWaitHostQuiet()
Var iRet 
Var sEventString, iSessionHandle
var iEventTable = 1
Var iEventNbr = 1
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex = int(KTMParseArg(3,args))
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
		iRet = ATM_EVENTALLREADYSET
	KTMDDEreply(iRet,)
	Return
end
if iEventTable <= MAX_EVENTTABLES
	if iEventsIdleIndex[iEventTable][iSessionHandle].EVENTNBR = ""
		iEventsIdleIndex[iEventTable][iSessionHandle]= iEventIndex
		iEventsIdleTime[iEventTable][iSessionHandle] = int(KTMParseArg(3,args))
				EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "HOSTQUIET"
		bTableValid[iEventTable][iSessionHandle] = TRUE
		iRet = ATM_SUCCESS
	else
		iRet = ATM_EVENTALLREADYSET
	end
else
	iRet = ATM_TABLEMAXEXCEEDED
end
KTMDDEreply(iRet,) 
Return
end //function ATMAddWaitHostQuiet()


Function ATMAddWaitForString()


//There are several event types:  WaitForString as a location, WaitForString NOT at, WaitForQuiet etc.
//For those with multiple events of one type (e.g., WaitForString) a table of events of that type is built.
//In the case of WaitForString this is saEvent
Var iRet,iRow, iCol ,iStartRow, iStartCol,iEndRow, iEndCol,iTypeOfSelect
Var iEventIndex,iEventTable,iSessionHandle, iEventNbr
Var sEventString,iLenOfEventString
Var iDisplayCols = int(display.columns)
Var iDisplayRows = int(display.lines)
var iEventTable 
iRet = ATM_SUCCESS
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex= int(KTMParseArg(3,args))
iRow = int(KTMParseArg(4,args))
iCol = int(KTMParseArg(5,args))
sEventString = KTMParseArg(6,args)
iLenOfEventString= len(sEventString)
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR <> ""
		iRet = ATM_EVENTALLREADYSET
end
if iRet = ATM_SUCCESS

if saEventsFreeList[iEventTable][iSessionHandle] 
	if not("HEADOFFREELIST" in saEventsFreeList[iEventTable][iSessionHandle])
		iLastStringAtEventNbr[iEventTable][iSessionHandle] = iLastStringAtEventNbr[iEventTable][iSessionHandle] + 1
		iEventNbr = iLastStringAtEventNbr[iEventTable][iSessionHandle]
	else
		iEventNbr = saEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
		saEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = 	saEvent[iEventTable][iSessionHandle][iEventNbr].NEXTFREE
		DeleteElement (saEvent[iEventTable][iSessionHandle][iEventNbr],"NEXTFREE")
	//if this was last free one then clear out tail of free list also
		if saEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iEventNbr
			DeleteElement (saEventsFreeList[iEventTable][iSessionHandle], "TAILOFFREELIST")
		end
	end
else
	iLastStringAtEventNbr[iEventTable][iSessionHandle] = iLastStringAtEventNbr[iEventTable][iSessionHandle] + 1
	iEventNbr = iLastStringAtEventNbr[iEventTable][iSessionHandle]
end
	if iEventTable <= MAX_EVENTTABLES
		if iLastStringAtEventNbr[iEventTable][iSessionHandle] <= MAX_STRINGEVENTS 
			iStartRow = iRow
			iStartCol = iCol
			iTypeOfSelect = Select_Stream
				iEndCol = iLenOfEventString - (iDisplayCols * int(iLenOfEventString/iDisplayCols)) + iStartCol -1
				iEndRow = iRow + int(iLenOfEventString/iDisplayCols)
			if iRow = 0 
				iStartRow = 1
				iEndRow = iDisplayRows
				if iLenOfEventString < iDisplayCols - iStartCol + 1
					iTypeOfSelect = Select_Block
				end
			end
			if iCol = 0
				iTypeOfSelect = Select_Stream
				iStartCol = 1
				iEndCol = iDisplayCols
			end
			iEndCol = iEndCol + 1
			saEvent[iEventTable][iSessionHandle][iEventNbr].INDEX = iEventIndex
			saEvent[iEventTable][iSessionHandle][iEventNbr].SELECTTYPE = iTypeOfSelect

			H1AddStringAtEventRow(saEvent[iEventTable][iSessionHandle][iEventNbr],iStartRow, 				iStartCol, iEndRow, iEndCol, sEventString)
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr 
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "STRINGAT"
			bTableValid[iEventTable][iSessionHandle] = TRUE
			iRet = ATM_SUCCESS
		else

			iRet = ATM_EVENTMAXEXCEEDED
				iLastStringAtEventNbr[iEventTable][iSessionHandle] = iLastStringAtEventNbr[iEventTable][iSessionHandle] - 1
		end
	else
		iRet = ATM_TABLEMAXEXCEEDED

	end
end
 KTMDDEreply(iRet,)
Return
End
Function H1AddStringAtEventRow(var RowID,iStartRow,iStartCol,iEndRow, iEndCol,sString)

RowID.STRING = sString
RowID.ROW = iStartRow
RowID.COL = iStartCol
RowID.ENDROW = iEndRow
RowID.ENDCOL = iEndCol

End //Function H1AddStringAtEventRow
Function ATMAddWaitForStringNotAt()
//There are several event types:  WaitForString as a location, WaitForString NOT at, WaitForQuiet etc.
//For those with multiple events of one type (e.g., WaitForString) a table of events of that type is built.
//In the case of WaitForStringNOTAt  this is sNaEvent
Var iRet,iRow, iCol ,iStartRow, iStartCol,iEndRow, iEndCol,iTypeOfSelect
Var iEventIndex,iEventTable,iSessionHandle, iEventNbr
Var sEventString,iLenOfEventString
Var iDisplayCols = int(display.columns)
Var iDisplayRows = int(display.lines)
var iEventTable 
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex= int(KTMParseArg(3,args))
iRow = int(KTMParseArg(4,args))
iCol = int(KTMParseArg(5,args))
sEventString = KTMParseArg(6,args)
iLenOfEventString= len(sEventString)
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,) 
	Return
end

if iEventIndex in EventsIndex[iEventTable][iSessionHandle]
		iRet = ATM_EVENTALLREADYSET
end
if iRet = ATM_SUCCESS

if sNaEventsFreeList[iEventTable][iSessionHandle] 
	if not("HEADOFFREELIST" in sNaEventsFreeList[iEventTable][iSessionHandle])
		iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] = iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] + 1
		iEventNbr = iLastStringNOTAtEventNbr[iEventTable][iSessionHandle]
	else
		iEventNbr = sNaEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
		sNaEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = 	sNaEvent[iEventTable][iSessionHandle][iEventNbr].NEXTFREE
		DeleteElement (sNaEvent[iEventTable][iSessionHandle][iEventNbr],"NEXTFREE")
	//if this was last free one then clear out tail of free list also
		if sNaEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iEventNbr
			DeleteElement (sNaEventsFreeList[iEventTable][iSessionHandle], "TAILOFFREELIST")
		end
	end
else
	iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] = iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] + 1
	iEventNbr = iLastStringNOTAtEventNbr[iEventTable][iSessionHandle]
end
	if iEventTable <= MAX_EVENTTABLES
		if iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] <= MAX_STRINGEVENTS 
			iStartRow = iRow
			iStartCol = iCol
			iTypeOfSelect = Select_Stream
				iEndCol = iLenOfEventString - (iDisplayCols * 							int(iLenOfEventString/iDisplayCols)) + iStartCol -1
				iEndRow = iRow + int(iLenOfEventString/iDisplayCols)
			if iRow = 0 
				iStartRow = 1
				iEndRow = iDisplayRows
				if iLenOfEventString < iDisplayCols - iStartCol + 1
					iTypeOfSelect = Select_Block
				end
			end
			if iCol = 0
				iTypeOfSelect = Select_Stream
				iStartCol = 1
				iEndCol = iDisplayCols
			end
			iEndCol = iEndCol + 1
			sNaEvent[iEventTable][iSessionHandle][iEventNbr].INDEX = iEventIndex
			sNaEvent[iEventTable][iSessionHandle][iEventNbr].SELECTTYPE = iTypeOfSelect

			H1AddStringNOTAtEventRow(sNaEvent[iEventTable][iSessionHandle][iEventNbr],iStartRow, 				iStartCol, iEndRow, iEndCol, sEventString)
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR = iEventNbr 
			EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "STRINGNOTAT"
			bTableValid[iEventTable][iSessionHandle] = TRUE
			iRet = ATM_SUCCESS
		else

			iRet = ATM_EVENTMAXEXCEEDED
				iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] = iLastStringNOTAtEventNbr[iEventTable][iSessionHandle] - 1
		end
	else
		iRet = ATM_TABLEMAXEXCEEDED

	end
end
 KTMDDEreply(iRet,)
Return
End
Function H1AddStringNOTAtEventRow(var RowID,iStartRow,iStartCol,iEndRow, iEndCol,sString)
//Could use string at version her also need to clean up H names
RowID.STRING = sString
RowID.ROW = iStartRow
RowID.COL = iStartCol
RowID.ENDROW = iEndRow
RowID.ENDCOL = iEndCol

End //Function H1AddStringNOTAtEventRow
Function ATMClearEventTable()
Var iRet = ATM_SUCCESS
var iEventCtr = 0
Var iTableSize, iEventIndex,iSessionHandle
var iEventTable
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
if not (iEventTable > 0) 
	iRet = ATM_INVALIDPARAMETER
	KTMDDEreply(iRet) 
	Return
end
iRet = KTMClearEventTable(iSessionHandle,iEventTable)
KTMDDEreply(iRet,)
Return
End


Function ATMCopyPS()
	Var sScreenCopy
	Var iPage, iDisplayCols
	Cursor = GetCursor()
	iPage = Cursor.PAGE
	iDisplayCols = int(display.columns) + 1
	iDisplayRows = int(display.lines)
ScreenRead(Type=Select_Stream,Page=iPage,Row=1,Col=1, EndRow=iDisplayRows,EndCol=iDisplayCols)
sScreenCopy = Result
KTMDDEreply(,sScreenCopy)
Return 
End //Function ATMCopyPS

Function ATMDeleteEvent()

Var iRet = ATM_SUCCESS
Var iSessionHandle
Var iEventIndex
Var iEventTable
Var iNbrToDelete
Var iCurrentTailOfFreeList
iSessionHandle = int(KTMParseArg(1,args))
iEventTable = int(KTMParseArg(2,args))
iEventIndex = int(KTMParseArg(3,args))
if not(iEventTable > 0 and iEventIndex > 0)
	iRet= ATM_INVALIDPARAMETER
	KTMDDEreply(iRet,)
	Return
end
if not (iSessionHandle in bTableValid[iEventTable])
	iRet= ATM_TABLENOTSET
	KTMDDEreply(iRet,)
	Return
end
if iEventTable > MAX_EVENTTABLES
	iRet = ATM_TABLEMAXEXCEEDED
	KTMDDEreply(iRet,)
	Return
end

iNbrToDelete = EventsIndex[iEventTable][iSessionHandle][iEventIndex].EVENTNBR
if EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "CURSORAT"
	if not("HEADOFFREELIST" in caEventsFreeList[iEventTable][iSessionHandle])
		caEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = iNbrToDelete
	else
	end
	if not("TAILOFFREELIST" in caEventsFreeList[iEventTable][iSessionHandle])
		iCurrentTailOfFreeList = caEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
	else
		iCurrentTailOfFreeList = caEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST
	end 

	caEvent[iEventTable][iSessionHandle][iNbrToDelete] = ""	EventsIndex[iEventTable][iSessionHandle][iEventIndex] = ""
	DeleteElement(EventsIndex[iEventTable][iSessionHandle],iEventIndex)

	if iCurrentTailOfFreelist <> iNbrToDelete
		caEvent[iEventTable][iSessionHandle][iCurrentTailOfFreelist].NEXTFREE = iNbrToDelete
	end
	caEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iNbrToDelete

elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "KEY"
	if not("HEADOFFREELIST" in keyEventsFreeList[iEventTable][iSessionHandle])
		keyEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = iNbrToDelete
	else
	end
	if not("TAILOFFREELIST" in keyEventsFreeList[iEventTable][iSessionHandle])
		iCurrentTailOfFreeList = keyEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
	else
		iCurrentTailOfFreeList = keyEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST
	end 

	keyEvent[iEventTable][iSessionHandle][iNbrToDelete] = ""	EventsIndex[iEventTable][iSessionHandle][iEventIndex] = ""
	DeleteElement(EventsIndex[iEventTable][iSessionHandle],iEventIndex)

	if iCurrentTailOfFreelist <> iNbrToDelete
		keyEvent[iEventTable][iSessionHandle][iCurrentTailOfFreelist].NEXTFREE = iNbrToDelete
	end
	keyEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iNbrToDelete


elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "STRINGAT"
	if not("HEADOFFREELIST" in saEventsFreeList[iEventTable][iSessionHandle])
		saEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = iNbrToDelete
	else
	end
	if not("TAILOFFREELIST" in saEventsFreeList[iEventTable][iSessionHandle])
		iCurrentTailOfFreeList = saEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
	else
		iCurrentTailOfFreeList = saEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST
	end 

	saEvent[iEventTable][iSessionHandle][iNbrToDelete] = ""	EventsIndex[iEventTable][iSessionHandle][iEventIndex] = ""
	DeleteElement(EventsIndex[iEventTable][iSessionHandle],iEventIndex)

	if iCurrentTailOfFreelist <> iNbrToDelete
		saEvent[iEventTable][iSessionHandle][iCurrentTailOfFreelist].NEXTFREE = iNbrToDelete
	end
	saEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iNbrToDelete

elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "STRINGNOTAT"
	if not("HEADOFFREELIST" in sNaEventsFreeList[iEventTable][iSessionHandle])
		sNaEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST = iNbrToDelete
	else
	end
	if not("TAILOFFREELIST" in sNaEventsFreeList[iEventTable][iSessionHandle])
		iCurrentTailOfFreeList = sNaEventsFreeList[iEventTable][iSessionHandle].HEADOFFREELIST
	else
		iCurrentTailOfFreeList = sNaEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST
	end 

	sNaEvent[iEventTable][iSessionHandle][iNbrToDelete] = ""	EventsIndex[iEventTable][iSessionHandle][iEventIndex] = ""
	DeleteElement(EventsIndex[iEventTable][iSessionHandle],iEventIndex)

	if iCurrentTailOfFreelist <> iNbrToDelete
		sNaEvent[iEventTable][iSessionHandle][iCurrentTailOfFreelist].NEXTFREE = iNbrToDelete
	end
	sNaEventsFreeList[iEventTable][iSessionHandle].TAILOFFREELIST = iNbrToDelete

elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "CURSORMOVE"
	iEventsCursorMoveIndex[iEventTable][iSessionHandle]= 0
	iEventsCursorMoveFlag[iEventTable][iSessionHandle] = FALSE
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = ""
elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "DISCONNECT"
	iEventsDisconnectIndex[iEventTable][iSessionHandle]= 0
	iEventsDisconnectFlag[iEventTable][iSessionHandle] = FALSE
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = ""
elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "WAIT"
	iEventsWaitIndex[iEventTable][iSessionHandle]= 0
	iEventsWaitTime[iEventTable][iSessionHandle] = 0
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = ""
elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = "HOSTQUIET"
	iEventsIdleIndex[iEventTable][iSessionHandle]= 0
	iEventsIdleTime[iEventTable][iSessionHandle] = 0
	EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = ""
elseif EventsIndex[iEventTable][iSessionHandle][iEventIndex].TYPE = ""
	iRet=ATM_EVENTIDNOTSET
else
	MSGBOX("XTOOLS - ATMDeleteEvent unknown Event type " + NL)
	iRet = ATM_SYSTEMERROR
end

KTMDDEreply(iRet,)
End //Function ATMDeleteEvent
Function ATMExecute()
Var sExecuteString
Var iRet = ATM_SUCCESS
Var iTimeOut
sExecuteString = KTMParseArg(1,args)
iTimeOut = 5 * KTMParseArg(2,args)
if iTimeOut = 0 
	iTimeOut = 100000
end
Begin
	Execute(sExecuteString)
	break
	When timeout(iTimeOut)
		iRet = ATM_TIMEOUT
end
KTMDDEReply(iRet)
End //Function ATMExecute



Function ATMGetCursorLocation()
	Var CurPos,StrPos
	CurPos = GetCursor()

	StrPos = ((Int(CurPos["PAGE"]) - 1)  * Int(display.lines) * Int(display.columns)) 
	+ ((Int(CurPos["ROW"]) -1) * Int(display.columns)) + Int(CurPos["COL"]) 
	DDE_Reply( Request.Channel, 0, StrPos )//This is much faster
	//KTMDDEreply(strPos)
Return 
End

Function ATMGetKeyStroke()
Var iRet = 0
Var iWaitOption
var sKeyReturned = ""
iWaitOption = KTMParseArg(1,args)
if iWaitOption = 3
	 gbWaitingForKeyStroke = FALSE
elseif iWaitOption = 1 or iWaitOption = 2
	gbWaitingForKeyStroke = TRUE
else
	iRet = ATM_INVALIDPARAMETER
	gbWaitingForKeyStroke = FALSE
end
if bKeyStrokeInterceptOn = TRUE and iRet = ATM_SUCCESS

	if len(sKeysIntercepted) > 0 
		sKeyReturned = substr(sKeysIntercepted,1,6) // POP first key descriptor off stack
		sKeysIntercepted = substr(sKeysIntercepted,7)
		iRet = ATM_SUCCESS

	else 
		if iWaitOption = 3
		   iRet = ATM_KEYSTROKESNOTAVAILABLE
		elseif iWaitOption = 1 or iWaitOption = 2
			 iRet = 0 
		else
			iRet = ATM_INVALIDPARAMETER
 		end
	end // if len(sKeysIntercepted) > 0

else
	 iRet =  ATM_NOPRIORSTARTKEYSTROKE  
end // if bKeyStrokeInterceptOn = TRUE 
 

	
if gbWaitingForKeyStroke = TRUE and iRet = 0
	begin
		suspend()
		when Keystroke()
			sKey = Result
			KTMTrapKeyStroke(bKeyStrokeInterceptOn,bAllKeysIntercepted,
sKeysIntercepted,sKey)

				if len(sKeysIntercepted) > 0 
			sKeyReturned = substr(sKeysIntercepted,1,6) // POP first key descriptor off stack
			sKeysIntercepted = substr(sKeysIntercepted,7)
			iRet = ATM_SUCCESS

		else 
			if iWaitOption = 3
			   iRet = ATM_KEYSTROKESNOTAVAILABLE
			elseif iWaitOption = 1 or iWaitOption = 2
				 iRet = 0 
				 continue
			else
				iRet = ATM_INVALIDPARAMETER
 			end
		end // if len(sKeysIntercepted) > 0
			gbWaitingForKeyStroke = FALSE
			iRet = ATM_SUCCESS
 		when timeout(iOtherTimeOut)
			iRet = ATM_TIMEOUT
			gbWaitingForKeyStroke = FALSE
	
	end
end

KTMDDEreply(iRet,sKeyReturned)
Return 
End

Function ATMGetSessionSize()
	Var iRet = ATM_SUCCESS
	Var sRowCol
sRowCol = str(display.lines) + "," + str(display.columns)

	iRet = KTMDDEreply(iRet,sRowCol)

Return 
End

Function ATMGetString()
	Var iPage, iRow, iCol, iLength, iPSP 
	Var sRet, iRet = ATM_SUCCESS
	Var sPosition,iEndRow, iEndCol,iSelectType=Select_Stream
	Var iDisplayCols = int(Display.columns)
	Var iDisplayRows = int(Display.lines)
	
	iPSP = Int(KTMParseArg(1,args))
	
	iLength  = Int(KTMParseArg(2,args))

		if  iPSP < 0 or iCol < 0 or iLength < 0 
		iRet = KTMDDEreply(ATM_INVALIDPARAMETER)
	else
		sPosition = H1PSPtoPRC(iPSP)
		iRow = int(sPosition.Row)
		iCol = int(sPosition.Col)
		iPage = int(sPosition.Page)

		Var iRowsAfterFirst
		iRowsAfterFirst = (iLength -(1 + iDisplayCols- iCol))/iDisplayCols
		iEndCol = 1 + iLength - (int(iRowsAfterFirst) * iDisplayCols + (1 + iDisplayCols- iCol))
		iEndRow = 1 + iRow +int(iRowsAfterFirst)
		ScreenRead(Page=iPage,Row=iRow,Col=iCol, EndRow=iEndRow,EndCol=iEndCol, Type=iSelectType)
		sRet = Result
KTMDDEreply(,sRet)
	end
Return 
End
Function ATMGetParameter()
//we use only parms 20 thru 29
	Var iParamIndex
	Var iRet = ATM_SUCCESS

	iParamIndex = Int(KTMParseArg(1,args))
	if iParamIndex = 20  
     iRet = xfer_protocol
	elseif iParamIndex = 21
	
	iRet = int(iInternalTimeOut / 5)

	elseif iParamIndex = 22
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 23
		iRet = iWaitIdle

	elseif iParamIndex = 24
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 25
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 26
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 27
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 28
		iRet = ATM_INVALIDPARAMETER

	elseif iParamIndex = 29	
		iRet = ATM_INVALIDPARAMETER
  else
		iRet = ATM_INVALIDPARAMETER
 	end
	iRet = KTMDDEreply(iRet)

Return 
End
Function ATMHoldHost()
Var iRet  

iRet = ATM_SUCCESS
If HoldScreen  = FALSE 

	Sendkey("hold")
	bHostHeld = 1

End

iRet = KTMDDEreply(iRet)
Return
End
Function ATMLockKeyboard()
Var iRet = ATM_SUCCESS
echo ("^[[2h")
iRet = KTMDDEreply(iRet)
Return
End //Function ATMLockKeyboard
Function ATMRCToPS()
Var iRow, iCol,iPage, iRet
Var iPSPosition = 0
iRow = int(KTMParseArg(1,args))
iCol = int(KTMParseArg(2,args))
if iRow > 0 and iCol > 0 
	if iCol > Int(display.columns) 
		iPSPosition = ATM_INVALIDPARAMETER
	else
		iPage  = ((iRow-1)/Int(display.lines)) +1

		
		iPSPosition = KTMRCToPS(iPage,iRow,iCol)
		iRet = ATM_SUCCESS
	end
else
	iRet = ATM_INVALIDPARAMETER
end //if iRow >0 and iCol > 0

KTMDDEreply(iRet,str(iPSPosition))
Return 
End


Function ATMReceiveFile()

//Var IdleTime = iWaitIdle

Var BlankInCommand
Var command

var FilesString
var OptionsValue = XFER_PROTOCOL + XFER_STATUSDISPLAY
var PathString
var iLenCommand
command = KTMParseArg(1,args)
iLenCommand = int(KTMParseArg(2,args))
BlankInCommand = Instr(command, " ")
PathString = Substr(command,1,BlankInCommand-1)
FilesString = Substr(command,BlankInCommand+1)

	Var msg, result
	Var xfer = TransferReceive( FilesString, OptionsValue, PathString )
If xFer = xFer_EndOK 
	iRet = ATM_SUCCESS
elseif xFer = XFER_ENDCANCEL
	iRet = ATM_DELAYEDBYCLIENT
else
	iRet = ATM_SYSTEMERROR
End
	KTMDDEreply(iRet)
Return 
End
Function ATMResetSystem()
Var iRet = ATM_SUCCESS
Var iSessionHandle
Var iEventTable = 1
iSessionHandle = KTMParseArg(1,args)
While iEventTable <= MAX_EVENTTABLES
	if iSessionHandle in saEvent[iEventTable] or iSessionHandle in caEvent[iEventTable] or iSessionHandle in keyEvent[iEventTable]
		iRet = KTMClearEventTable(iSessionHandle, iEventTable)
	end
	iEventTable = iEventTable + 1
end
KTMDDEReply(iRet)
End //
Function ATMResumeHost()
Var iRet  

iRet = ATM_SUCCESS
if HoldScreen = TRUE 
		Sendkey("hold")		iRet = ATM_SUCCESS
		bHostHeld = 0 
end 
iRet = KTMDDEreply(iRet) Return
End



Function ATMRowColumn()
var  comma, parenth
var psPosition
var RowOrColumnOption
var RowOrColumnValue
Var sPosition

	psPosition = Int(KTMParseArg(1,args))
	RowOrColumnOption = int(KTMParseArg(2,args))
	sPosition = H1PSPtoPRC(psPosition)
if RowOrColumnOption = 0

	RowOrColumnValue = Int(sPosition.Row)
elseif RowOrColumnOption = 1
	RowOrColumnValue = int(sPosition.Col)
else
	RowOrColumnValue = ATM_INVALIDPARAMETER
end 
var iRet
iRet = KTMDDEreply(RowOrColumnValue,Str(RowOrColumnValue))
Return
End

Function ATMRunMacro()
var MacroName
var SessionShortName
var iRet



SessionShortName = KTMParseArg(1,args)
MacroName = KTMParseArg(2,args)

run(MacroName)
result = 1
	iRet = KTMDDEreply(ATM_SUCCESS)
end


Function ATMSendFile()
Var CurPos
Var IdleTime = iWaitIdle
Var parenth, comma, BlankInCommand
Var command
var FilesString 
var OptionsValue = XFER_PROTOCOL + XFER_STATUSDISPLAY
var PathString 
command = KTMParseArg(1,args)
BlankInCommand = Instr(command, " ")
PathString = Substr(command,1,BlankInCommand-1)
FilesString = Substr(command,BlankInCommand+1)
	Var msg, result

	Var xfer = TransferTransmit( FilesString, OptionsValue, PathString )
If xFer = xFer_EndOK 
	iRet = ATM_SUCCESS
elseif xFer = XFER_ENDCANCEL
	iRet = ATM_DELAYEDBYCLIENT
else
	iRet = ATM_SYSTEMERROR
End
	KTMDDEreply(iRet)
Return 
End
Function ATMSendKey()
	Var sKeyStringIn,sKey,sKeyStringSend, sSavedATSign
	Var iRet, iAtSign
	sKeyStringIn = KTMParseArg(1,args)
	sSavedATSign = ATSign
	ATSign = KTMParseArg(2,args)
			iAtSign = InStr(sKeyStringIn, ATSign)
	if iAtSign
				sKey = substr(sKeyStringIn,iAtSign)
		sKey = KTMCodeToKey(sKey)
		sKeyStringSend = substr(sKeyStringIn,1,iAtSign-1)
		
	Else
		sKeyStringSend = sKeyStringIn
//		KTMCaretHandler(sKeyStringSend)

	End
Send(sKeyStringSend)
SendKey(sKey)
iRet = ATM_SUCCESS
ATSign = sSavedATSign
iRet = KTMDDEreply(iRet)
Return
End
Function ATMSendString()

	Var sString
	Var iRow, iCol, iPage, iPSP
	Var iRet
	Var quote = chr(34)
	Var eolPos, sTemp
 
	iPSP = Int(KTMParseArg(1,args))
	sString = KTMParseArg(2,args)
	
	
	iRow = KTMPSToRow(iPSP)
	iCol = KTMPSToCol(iPSP)
//Removed string positioning of cursor can't do that when ATMAPI hides the row and col 
//	= zero from me.
if iPSP < 0  or sString = str(KTM_WRAPPEROUTOFPOSITION) or sString = str(KTM_INVALIDPARAMETER) or sString = str(KTM_WRAPPERINCOMPLETE)
		iRet = ATM_INVALIDPARAMETER
	else
				if iRow = Int(display.lines)
			iPage = 1
		else
			iPage = (iRow/Int(display.lines)) + 1
		end
		iRow  = iRow - ((iPage - 1)  * Int(display.lines))
				KTMCaretHandler(sString) //fixes ^M etc on the end.
		Send(sString)
	iRet = ATM_SUCCESS
End	
KTMDDEreply(iRet)
Return 
End //Function ATMSendString

Function ATMSessionOff()

	Var iRet
   If IsConnected() 
		Disconnect()
 		If IsConnected()
			iRet = ATM_SYSTEMERROR

		Else
			iRet = ATM_SUCCESS
		End
Else
		iRet = ATM_NOTCONNECTED
  End
	
	iRet = KTMDDEreply(iRet)

Return 
End
Function ATMSessionOn()
	
	Var iRet
	
		Connect()
		If IsConnected()
			iRet =  ATM_SUCCESS
		Else
			iRet = ATM_SYSTEMERROR
		End	
	
	iRet = KTMDDEreply(iRet)

Return 
End


Function ATMSetCursorLocation()
	Var start
	Var sString
	Var iRow, iCol, iPage,ColsDif,RowsDif
	Var iRet
	Var UpKey = "Up"
	var DownKey = "Down"
	var LeftKey = "Left"
	var RightKey = "Right"


	iRow = int(KTMParseArg(1,args))
	iCol = int(KTMParseArg(2,args))
	
			iPage = ((iRow-1)/Int(display.lines)) + 1
	iRow  = iRow - ((iPage - 1)  * Int(display.lines))

	
			start = GetCursor()
		if(start.page <> iPage) 
		iret =  ATM_CHANGEINGPAGE
	end

//This thing times out and then tries again until a larger timeout happens
//I couldn't get it to consistently see that the cursor was where it belonged.
//Begin

	Begin
		if(start.col <> iCol)
				colsDif = iCol - start.Col  
		if colsDif < 0 
			while colsDif
				colsDif = colsDif + 1
				sendkey(LeftKey)
			end		
		elseif colsDif > 0					
			while colsDif
				colsDif = colsDif - 1
				sendkey(RightKey)
			end			
		end
	end 
	if (start.Row <> iRow)
				rowsDif = iRow - start.Row  
		if rowsDif < 0 
			while rowsDif
				rowsDif = rowsDif + 1
				sendkey(UpKey)
			end					
		elseif rowsDif > 0					
			while rowsDif
				rowsDif = rowsDif - 1			
				sendkey(DownKey)
			end			
		end
	end

		suspend()
		When CursorAt(Type=Select_Stream,Row=iRow,Col=iCol, EndRow=iRow,EndCol=iCol+1,Page=iPage)
		iRet = ATM_SUCCESS
	When match(idle= 1)  //Loop this time out if CursorAt fails.  in 4.1 it is not relieable.
		NowCursor = GetCursor()
		if NowCursor.ROW = iRow and NowCursor.Col = iCol and NowCursor.Page = iPage
			iRet = ATM_SUCCESS
			break
		else
			continue
		end	

	When TimeOut(iSetCursorTimeout)
		iRet = ATM_TIMEOUT
//		continue
	End //Begin

//	iRet = KTMWaitForCursor(iPage, iRow,iCol,iTimeOut)
	if iRet = ATM_SUCCESS 
		
 	elseif iRet = ATM_TIMEOUT
	end //Begin inside one with short timeout.
//	when timeout(iSetCursorTimeout)
//		iRet = ATM_TIMEOUT
//		break
//end //Begin outside one with bigger timeout.
iRet = KTMDDEreply(iRet)
Return 
End 
Function ATMSetParameter()

	Var iRet = ATM_SUCCESS
//we use only parms 20 thru 29
	Var iParamIndex
	var sParamValue
Var sEscapeChar

	iParamIndex = Int(KTMParseArg(1,args))
	iParamValue = int(KTMParseArg(2,args))

if iParamIndex = 12
	ATSign = KTMParseArg(3,args)
end
KTMDDEreply(iRet)

Return 
End

Function ATMStartHostNotify()
var iRet = ATM_SUCCESS
Var sCode

gbPSUpdate = 2
gbCursorMoved = 2
gbKeyStrokeIntercepted = 2
gbRowsColsChanged = 2
gbRows = int(display.lines)
gbCols = int(display.columns) 

iRet = KTMDDEreply(iRet)
Return 

End

Function ATMStartKeyStrokeIntercept()
var iRet = ATM_SUCCESS
Var iInterceptCode
iInterceptCode = KTMParseArg(1,args)

bKeyStrokeInterceptOn = TRUE 
if iInterceptCode = 1 //1 means all keystrokes.
	bAllKeysIntercepted = TRUE
else
  bAllKeysintercepted = FALSE
end	
iRet = KTMDDEreply(iRet)
Return 

End
Function ATMStopKeyStrokeIntercept()
var iRet = ATM_SUCCESS
if bKeyStrokeInterceptOn = TRUE 
	bKeyStrokeInterceptOn = FALSE
	bAllKeysIntercepted = FALSE
	sKeysIntercepted = ""
	
else
	iRet =  ATM_NOPRIORSTARTKEYSTROKE  
end

iRet = KTMDDEreply(iRet)
Return 

End
Function ATMStopSession()
var iRet = ATM_SUCCESS
   
	iRet = KTMDDEreply(iRet)
	Exit()
Return 
End
Function ATMWait()
var iRet = ATM_SUCCESS

Begin
suspend()
when match(idle=1)
when timeout(iInternalTimeOut)
iRet = ATM_TIMEOUT
end
KTMDDEreply(iRet)

Return 
End
Function ATMWaitForHostConnect()
	var iRet = ATM_SUCCESS
	Var iTimeOut

	iTimeOut = (int(KTMParseArg(1,args))) * 5 

	Begin
		suspend()
		When match (idle=1)
			if isConnected()
				iRet = ATM_SUCCESS
				break
			else
				continue
			end

	When TimeOut(iTimeOut)
		iRet = ATM_TIMEOUT
	End //Begin
	KTMDDEreply(iRet)
Return 
End

Function ATMWaitForCursor()
	var iRet = ATM_SUCCESS
	Var iRow, iCol, iPage, iEndRow, iEndCol
	Var iTimeOut, iSelectType

	iRow = Int(KTMParseArg(1,args))
	iCol = Int(KTMParseArg(2,args))
	iTimeOut = (int(KTMParseArg(3,args))) * 5 

		iPage = (iRow-1)/Int(display.lines) + 1
	iRow  = iRow - ((iPage - 1)  * Int(display.lines))



if iRow = 0
	if iCol > 0 
		iSelectType = Select_Block
		iRow = 1
		iEndRow = int(display.lines)
		iEndCol = iCol + 1
	else
		iRet = ATM_INVALIDPARAMETER
		KTMDDEreply(iRet)
		Return
	end
else
	iSelectType = Select_Stream
	iEndRow = iRow
	if iCol = 0 
		iCol = 1
		iEndCol = int(display.columns) + 1
		iEndRow = iRow
	else
		iEndCol = iCol + 1
	end
end
	Begin
		suspend()
		When CursorAt(Type= iSelectType,Row=iRow,Col=iCol,EndRow=iEndRow,EndCol=iEndCol,Page=iPage)
		iRet = ATM_SUCCESS
		break
	When match(idle= 1)  //Loop this time out if CursorAt fails.  in 4.1 it is not relieable.
		NowCursor = GetCursor()
		if NowCursor.ROW >= iRow and NowCursor.ROW <= iEndRow and NowCursor.COL >= iCol and NowCursor.COL <= iEndCol and NowCursor.Page = iPage
			iRet = ATM_SUCCESS
			break
		else
			continue
		end	

	When TimeOut(iTimeOut)
		iRet = ATM_TIMEOUT
	End //Begin
	KTMDDEreply(iRet)
Return 
End


Function ATMWaitForCursorMove()
	Var iRet = 0
	Var iPSP = 0
	Var iRow, iCol, iPage
	Var iTimeOut 
	
	iTimeOut = 5 * int(KTMParseArg(1,args))
	if iTimeout <= 
		iRet= ATM_INVALIDPARAMETER
	else
	
		Begin
			suspend()
			When CursorMove()
				iRow = int(Result.row)
				iCol = int(Result.col)
				iPage = int(result.page)
				iPSP = KTMRCToPS(iPage,iRow,iCol)
				iRet = ATM_SUCCESS
				break
			when timeout(iTimeOut)
				iRet = ATM_TIMEOUT 
				break
		end
	
	end
KTMDDEreply(iRet,str(iPSP))
Return 
End
Function ATMWaitForHostDisconnect()
var iTimeOut = int(KTMParseArg(1,args)) * 5
Var iRet = ATM_SUCCESS
if isconnected()
	Begin
		suspend()
			When Disconnected()
				iRet = ATM_SUCCESS
			When timeout(iTimeOut)
				iRet = ATM_TIMEOUT
	end //Begin 
else
	iRet = ATM_SUCCESS
end
KTMDDEreply(iRet,)
Return 
End //ATMWaitForHostDisconnect()
Function ATMWaitForEvent()
var iEventTable = 1
var iTriggeredEventNbr = 0
Var iEventIndex = 0
var iRet = ATM_SUCCESS
var iPage = 1
var iTimeOut = 1  
var iStringDesiredPSP = 0
Var sStringDesired = ""
Var iEventNbr = 0
Var iWaitForQuietTime = 0 
Var iWaitForQuietIndex = 0
Var iSessionHandle
Var sDesiredString, sFoundString //Variables used to check if string is really there.
Var iRow, iEndRow, CurPos,StrPos, iCol
Var sWaitKey
Var isNaSelectType, icaSelectType, bCursorAtWanted = FALSE
iSessionHandle =	int(KTMParseArg(1,args))
iEventTable =		int(KTMParseArg(2,args))
iTimeOut =			int(KTMParseArg(3,args))

var sNAIdentifier = sNaEvent[iEventTable][iSessionHandle]
var CAIdentifier = caEvent[iEventTable][iSessionHandle]
Var bStopNow = FALSE

iTimeOut = 5 * iTimeOut
if bTableValid[iEventTable][iSessionHandle] = TRUE
	if iEventTable in iEventsIdleTime
		iWaitForQuietTime = iEventsIdleTime[iEventTable][iSessionHandle]
		iWaitForQuietIndex = iEventsIdleIndex[iEventTable][iSessionHandle]
	end

	if iEventTable in iEventsWaitTime
		iWaitTime = iEventsWaitTime[iEventTable][iSessionHandle]
		iWaitIndex = iEventsWaitIndex[iEventTable][iSessionHandle]
	end


iEventNbr = 1
while iEventNbr <= MAX_CURSORATEVENTS
	icaSelectType[iEventNbr] = Select_None
	iEventNbr = iEventNbr + 1
end

iEventNbr = 1
while iEventNbr <= MAX_STRINGNOTATEVENTS
	isNaSelectType[iEventNbr] = Select_None
	iEventNbr = iEventNbr + 1
end

	for iEventNbr in sNaEvent[iEventTable][iSessionHandle]
		if sNaEvent[iEventTable][iSessionHandle][iEventNbr].ROW = ""
			isNaSelectType[iEventNbr] = Select_None
		else
			isNaSelectType[iEventNbr] = Select_Stream
		end
	end	for iEventNbr in caEvent[iEventTable][iSessionHandle]
		if caEvent[iEventTable][iSessionHandle][iEventNbr].ROW = ""
			icaSelectType[iEventNbr] = Select_None
		else
			icaSelectType[iEventNbr] = caEvent[iEventTable][iSessionHandle][iEventNbr].TYPE
bCursorAtWanted = TRUE
		end
	end
	if HoldScreen = TRUE and bHostHeld = 1
			Sendkey("hold")
	end 


if isConnected() = FALSE 
	if iEventTable in iEventsDisconnectFlag
		if iSessionHandle in iEventsDisconnectFlag[iEventTable]
			if iEventsDisconnectFlag[iEventTable][iSessionHandle] = TRUE
				iRet = ATM_SUCCESS
				iEventIndex = iEventsDisconnectIndex[iEventTable][iSessionHandle]
				KTMDDEreply(iret,str(iEventIndex))
				return
			end
		end
	end
end
iEventNbr = 1
While iEventNbr <= iLastStringNotAtEventNbr[iEventTable][iSessionHandle]
if sNAIdentifier[iEventNbr].STRING <> "" 
	ScreenRead(Type=Select_Stream,Row= sNAIdentifier[iEventNbr].ROW, Col= sNAIdentifier[iEventNbr].COL,EndRow= sNAIdentifier[iEventNbr].ENDROW, EndCol= sNAIdentifier[iEventNbr].ENDCOL,Page=1)
	if Result <> sNAIdentifier[iEventNbr].STRING
		iRet = ATM_SUCCESS
		iEventIndex = sNAIdentifier[iEventNbr].INDEX
		KTMDDEreply(iret,str(iEventIndex))
		return
	else
	end
end
iEventNbr = iEventNbr + 1
end //while 
	Begin
		if bCursorAtWanted = TRUE
			iEventNbr = 1
			CurPos = GetCursor()
			iRow = int(CurPos.ROW)
			iCol = int(CurPos.COL)
			StrPos = (Int(CurPos["PAGE"]) - 1)  * Int(display.lines) * Int(display.columns) 
	+ ((iRow -1) * Int(display.columns)) + iCol

			While iEventNbr <= iLastCursorAtEventNbr[iEventTable][iSessionHandle]
				if icaSelectType[iEventNbr] <> Select_None

					if (iRow >= caIdentifier[iEventNbr].ROW and iRow <= caIdentifier[iEventNbr].ENDROW and iCol >= caIdentifier[iEventNbr].COL and iCol <= caIdentifier[iEventNbr].ENDCOL-1 and icaSelectType[iEventNbr] = Select_Block)
	or
(StrPos >= (caIdentifier[iEventNbr].ROW -1 )* int(display.columns) + caIdentifier[iEventNbr].COL and StrPos <= (caIdentifier[iEventNbr].ENDROW-1)*int(display.columns) + caIdentifier[iEventNbr].ENDCOL-1 and icaSelectType[iEventNbr] = Select_Stream)
						iEventIndex = caEvent[iEventTable][iSessionHandle][iEventNbr].INDEX
						iRet = ATM_SUCCESS
						KTMDDEreply(iret,str(iEventIndex))
						return
					end
				end
				iEventNbr = iEventNbr + 1
			end //while 
		end // if cursor at wanted
suspend()
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][1].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][1].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][1].ROW, Col=saEvent[iEventTable][iSessionHandle][1].COL,EndRow=saEvent[iEventTable][iSessionHandle][1].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][1].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iRet = ATM_SUCCESS
iEventIndex = saEvent[iEventTable][iSessionHandle][1].INDEX
break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][2].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][2].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][2].ROW, Col=saEvent[iEventTable][iSessionHandle][2].COL,EndRow=saEvent[iEventTable][iSessionHandle][2].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][2].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][2].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][3].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][3].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][3].ROW, Col=saEvent[iEventTable][iSessionHandle][3].COL,EndRow=saEvent[iEventTable][iSessionHandle][3].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][3].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][3].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][4].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][4].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][4].ROW, Col=saEvent[iEventTable][iSessionHandle][4].COL,EndRow=saEvent[iEventTable][iSessionHandle][4].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][4].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][4].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][5].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][5].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][5].ROW, Col=saEvent[iEventTable][iSessionHandle][5].COL,EndRow=saEvent[iEventTable][iSessionHandle][5].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][5].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][5].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][6].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][6].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][6].ROW, Col=saEvent[iEventTable][iSessionHandle][6].COL,EndRow=saEvent[iEventTable][iSessionHandle][6].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][6].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][6].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][7].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][7].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][7].ROW, Col=saEvent[iEventTable][iSessionHandle][7].COL,EndRow=saEvent[iEventTable][iSessionHandle][7].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][7].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][7].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][8].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][8].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][8].ROW, Col=saEvent[iEventTable][iSessionHandle][8].COL,EndRow=saEvent[iEventTable][iSessionHandle][8].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][8].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][8].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][9].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][9].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][9].ROW, Col=saEvent[iEventTable][iSessionHandle][9].COL,EndRow=saEvent[iEventTable][iSessionHandle][9].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][9].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][9].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][10].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][10].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][10].ROW, Col=saEvent[iEventTable][iSessionHandle][10].COL,EndRow=saEvent[iEventTable][iSessionHandle][10].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][10].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][10].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][11].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][11].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][11].ROW, Col=saEvent[iEventTable][iSessionHandle][11].COL,EndRow=saEvent[iEventTable][iSessionHandle][11].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][11].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][11].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][12].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][12].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][12].ROW, Col=saEvent[iEventTable][iSessionHandle][12].COL,EndRow=saEvent[iEventTable][iSessionHandle][12].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][12].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][12].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][13].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][13].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][13].ROW, Col=saEvent[iEventTable][iSessionHandle][13].COL,EndRow=saEvent[iEventTable][iSessionHandle][13].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][13].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][13].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][14].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][14].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][14].ROW, Col=saEvent[iEventTable][iSessionHandle][14].COL,EndRow=saEvent[iEventTable][iSessionHandle][14].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][14].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][14].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][15].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][15].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][15].ROW, Col=saEvent[iEventTable][iSessionHandle][15].COL,EndRow=saEvent[iEventTable][iSessionHandle][15].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][15].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][15].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][16].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][16].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][16].ROW, Col=saEvent[iEventTable][iSessionHandle][16].COL,EndRow=saEvent[iEventTable][iSessionHandle][16].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][16].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][16].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][17].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][17].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][17].ROW, Col=saEvent[iEventTable][iSessionHandle][17].COL,EndRow=saEvent[iEventTable][iSessionHandle][17].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][17].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][17].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][18].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][18].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][18].ROW, Col=saEvent[iEventTable][iSessionHandle][18].COL,EndRow=saEvent[iEventTable][iSessionHandle][18].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][18].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][18].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][19].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][19].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][19].ROW, Col=saEvent[iEventTable][iSessionHandle][19].COL,EndRow=saEvent[iEventTable][iSessionHandle][19].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][19].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][19].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][20].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][20].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][20].ROW, Col=saEvent[iEventTable][iSessionHandle][20].COL,EndRow=saEvent[iEventTable][iSessionHandle][20].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][20].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][20].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][21].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][21].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][21].ROW, Col=saEvent[iEventTable][iSessionHandle][21].COL,EndRow=saEvent[iEventTable][iSessionHandle][21].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][21].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][21].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][22].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][22].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][22].ROW, Col=saEvent[iEventTable][iSessionHandle][22].COL,EndRow=saEvent[iEventTable][iSessionHandle][22].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][22].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)
iEventIndex = saEvent[iEventTable][iSessionHandle][22].INDEX
iRet = ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][23].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][23].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][23].ROW, Col=saEvent[iEventTable][iSessionHandle][23].COL,EndRow=saEvent[iEventTable][iSessionHandle][23].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][23].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

iEventIndex = saEvent[iEventTable][iSessionHandle][23].INDEX
iRet=ATM_SUCCESS

	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][24].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][24].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][24].ROW, Col=saEvent[iEventTable][iSessionHandle][24].COL,EndRow=saEvent[iEventTable][iSessionHandle][24].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][24].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][24].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][25].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][25].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][25].ROW, Col=saEvent[iEventTable][iSessionHandle][25].COL,EndRow=saEvent[iEventTable][iSessionHandle][25].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][25].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][25].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][26].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][26].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][26].ROW, Col=saEvent[iEventTable][iSessionHandle][26].COL,EndRow=saEvent[iEventTable][iSessionHandle][26].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][26].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][26].INDEX
	iRet=ATM_SUCCESS
	break
	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][27].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][27].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][27].ROW, Col=saEvent[iEventTable][iSessionHandle][27].COL,EndRow=saEvent[iEventTable][iSessionHandle][27].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][27].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][27].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][28].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][28].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][28].ROW, Col=saEvent[iEventTable][iSessionHandle][28].COL,EndRow=saEvent[iEventTable][iSessionHandle][28].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][28].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][28].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][29].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][29].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][29].ROW, Col=saEvent[iEventTable][iSessionHandle][29].COL,EndRow=saEvent[iEventTable][iSessionHandle][29].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][29].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][29].INDEX
	iRet=ATM_SUCCESS
	break

	When ScreenMatch(Pat=saEvent[iEventTable][iSessionHandle][30].STRING, Idle= iWaitIdle,Type=saEvent[iEventTable][iSessionHandle][30].SELECTTYPE, Row=saEvent[iEventTable][iSessionHandle][30].ROW, Col=saEvent[iEventTable][iSessionHandle][30].COL,EndRow=saEvent[iEventTable][iSessionHandle][30].ENDROW, EndCol=saEvent[iEventTable][iSessionHandle][30].ENDCOL,Page=gbDefaultPage,Options=gbWaitOption)

	iEventIndex = saEvent[iEventTable][iSessionHandle][30].INDEX
	iRet=ATM_SUCCESS
	break


	When ScreenChanged(Type=isNaSelectType[1],Row= sNAIdentifier[1].ROW, Col= sNAIdentifier[1].COL,EndRow= sNAIdentifier[1].ENDROW, EndCol= sNAIdentifier[1].ENDCOL,Page=1)

ScreenRead(Type=Select_Stream,Row= sNAIdentifier[1].ROW, Col= sNAIdentifier[1].COL,EndRow= sNAIdentifier[1].ENDROW, EndCol= sNAIdentifier[1].ENDCOL,Page=1)
if Result <> sNAIdentifier[1].STRING
	iRet = ATM_SUCCESS
	iEventIndex = sNAIdentifier[1].INDEX
	break
else

	continue
end
	When ScreenChanged(Type=isNaSelectType[2],Row= sNAIdentifier[2].ROW, Col= sNAIdentifier[2].COL,EndRow= sNAIdentifier[2].ENDROW, EndCol= sNAIdentifier[2].ENDCOL,Page=1)

ScreenRead(Type=Select_Stream,Row= sNAIdentifier[2].ROW, Col= sNAIdentifier[2].COL,EndRow= sNAIdentifier[2].ENDROW, EndCol= sNAIdentifier[2].ENDCOL,Page=1)
if Result <> sNAIdentifier[2].STRING
	iRet = ATM_SUCCESS
	iEventIndex = sNAIdentifier[2].INDEX
	break
else

	continue
end

	When ScreenChanged(Type=isNaSelectType[3],Row= sNAIdentifier[3].ROW, Col= sNAIdentifier[3].COL,EndRow= sNAIdentifier[3].ENDROW, EndCol= sNAIdentifier[3].ENDCOL,Page=1)

ScreenRead(Type=Select_Stream,Row= sNAIdentifier[3].ROW, Col= sNAIdentifier[3].COL,EndRow= sNAIdentifier[3].ENDROW, EndCol= sNAIdentifier[3].ENDCOL,Page=1)
if Result <> sNAIdentifier[3].STRING
	iRet = ATM_SUCCESS
	iEventIndex = sNAIdentifier[3].INDEX
	break
else

	continue
end

	When ScreenChanged(Type=isNaSelectType[4],Row= sNAIdentifier[4].ROW, Col= sNAIdentifier[4].COL,EndRow= sNAIdentifier[4].ENDROW, EndCol= sNAIdentifier[4].ENDCOL,Page=1)

ScreenRead(Type=Select_Stream,Row= sNAIdentifier[4].ROW, Col= sNAIdentifier[4].COL,EndRow= sNAIdentifier[4].ENDROW, EndCol= sNAIdentifier[4].ENDCOL,Page=1)
if Result <> sNAIdentifier[4].STRING
	iRet = ATM_SUCCESS
	iEventIndex = sNAIdentifier[4].INDEX
	break
else

	continue
end
	When ScreenChanged(Type=isNaSelectType[5],Row= sNAIdentifier[5].ROW, Col= sNAIdentifier[5].COL,EndRow= sNAIdentifier[5].ENDROW, EndCol= sNAIdentifier[5].ENDCOL,Page=1)

ScreenRead(Type=Select_Stream,Row= sNAIdentifier[5].ROW, Col= sNAIdentifier[5].COL,EndRow= sNAIdentifier[5].ENDROW, EndCol= sNAIdentifier[5].ENDCOL,Page=1)
if Result <> sNAIdentifier[5].STRING
	iRet = ATM_SUCCESS
	iEventIndex = sNAIdentifier[5].INDEX
	break
else

	continue
end

When CursorMove()
if iEventsCursorMoveFlag[iEventTable][iSessionHandle] = TRUE
	iEventIndex = iEventsCursorMoveIndex[iEventTable][iSessionHandle]
		iRet = ATM_SUCCESS
break
else
	if bCursorAtWanted = TRUE
		iEventNbr = 1
		CurPos = GetCursor()
		iRow = int(CurPos.ROW)
		iCol = int(CurPos.COL)
		StrPos = (Int(CurPos["PAGE"]) - 1)  * Int(display.lines) * Int(display.columns) 
	+ ((iRow -1) * Int(display.columns)) + iCol

	While iEventNbr <= iLastCursorAtEventNbr[iEventTable][iSessionHandle]
	if icaSelectType[iEventNbr] <> Select_None

		if (iRow >= caIdentifier[iEventNbr].ROW and iRow <= caIdentifier[iEventNbr].ENDROW and iCol >= caIdentifier[iEventNbr].COL and iCol <= caIdentifier[iEventNbr].ENDCOL-1 and icaSelectType[iEventNbr] = Select_Block)
	or
(StrPos >= (caIdentifier[iEventNbr].ROW -1 )* int(display.columns) + caIdentifier[iEventNbr].COL and StrPos <= (caIdentifier[iEventNbr].ENDROW-1)*int(display.columns) + caIdentifier[iEventNbr].ENDCOL-1 and icaSelectType[iEventNbr] = Select_Stream)
			iEventIndex = caEvent[iEventTable][iSessionHandle][iEventNbr].INDEX
			iRet = ATM_SUCCESS
			//KTMDDEreply(iret,str(iEventIndex))
			//return
			bStopNow = TRUE
			break //the for loop only
		end
	end
	iEventNbr = iEventNbr + 1
	end //while 
			if bStopNow
			break
		else
			continue
		end

	else
		continue
	end
end

	When Keystroke()
		sKey = asc(Result)
		For iEventNbr in keyEvent[iEventTable][iSessionHandle]
			sWaitKey = asc(keyEvent[iEventTable][iSessionHandle][iEventNbr].KEY)
			if sWaitKey = sKey
				iRet = ATM_SUCCESS
			iEventIndex = keyEvent[iEventTable][iSessionHandle][iEventNbr].INDEX
				bStopNow = TRUE
				break
			else
				continue
			end
		end
		if bStopNow
			break
		else
			continue
		end

		When match (Idle = iWaitForQuietTime)
			iEventIndex = iWaitForQuietIndex
			iRet=ATM_SUCCESS
		break

		When match (Idle = iWaitTime)
			iEventIndex = iWaitIndex
			iRet=ATM_SUCCESS
		break

		When Disconnected()


				if iEventTable in iEventsDisconnectFlag
					if iSessionHandle in iEventsDisconnectFlag[iEventTable]
						if iEventsDisconnectFlag[iEventTable][iSessionHandle] = FALSE
							continue
						else
							iEventIndex = iEventsDisconnectIndex[iEventTable][iSessionHandle]
							break
						end
					else
						continue
					end
				else
					continue
				end

		when TimeOut(iTimeout)
	CurPos = GetCursor()
			iRet = ATM_TIMEOUT
	end
else
	iRet = ATM_TABLENOTSET
end
if bHostHeld =1 and HoldScreen = FALSE 

		Sendkey("hold")

end

KTMDDEreply(iret,str(iEventIndex))
return
End
Function ATMWaitForKey()

Var iTimeOut,sWaitKey,sReturnedKeyCode
Var iRet, iAtSign //position of possible @ (or what ever escape in string)

iTimeOut = 5 * KTMParseArg(2,args)
sWaitKey = KTMParseArg(1,args)
if iTimeOut = 0
	iTimeOut = 100000
end
iAtSign = instr(sWaitKey,ATSign)
Begin
	Suspend()
	When Keystroke()
		sReturnedKeyCode = Result
		if iAtSign > 0 
			sReturnedKeyCode = KTMKeyToCode(sReturnedKeyCode)
			if substr(sReturnedKeyCode,1,1) = "M"
				sReturnedKeyCode = substr(sReturnedKeyCode,2)
			end
			if sReturnedKeyCode = sWaitKey
				iRet = ATM_SUCCESS
				break
			else
				continue
			end
		else
			if asc(sWaitKey) = asc(sReturnedKeyCode)
				iRet = ATM_SUCCESS
				break
			else
				continue
			end
		end
	When TimeOut(iTimeOut)
		iRet= ATM_TIMEOUT
end
KTMDDEReply(iRet)
End //Function ATMWaitForKey


Function ATMWaitForString()

	Var IdleTime = iWaitIdle
	Var iRet = ATM_SUCCESS,iPSP = 0
	Var iRow, iCol
	Var sSearch, iTimeOut
		
	iRow = Int(KTMParseArg(1,args))
	iCol = Int(KTMParseArg(2,args))
	sSearch = KTMParseArg(3,args)
		iTimeOut = 5 *  Int(KTMParseArg(4,args))

	if iTimeOut < 0 or iRow < 0 or iCol < 0 
		iRet = ATM_INVALIDPARAMETER
	else
iPSP =  KTMWaitForString(iRow, iCol,sSearch,iTimeOut)
		if iPSP < 0
			iRet = -iPSP
			iPSP = 0
		else
			iRet = ATM_SUCCESS
		end
	end

KTMDDEreply(iRet,str(iPSP))
Return 
End
Function ATMWaitForStringNotAt()

	Var IdleTime = iWaitIdle
	Var iRet = ATM_SUCCESS
	Var iRow, iCol, iEndCol, iEndRow, iStartRow, iStartCol
	Var iTypeOfSelect, iLenOfString
	Var sSearch, iTimeOut
	Var iDisplayCols = int(Display.columns)
	Var iDisplayRows = int(Display.lines)

		
	iRow = Int(KTMParseArg(1,args))
	iCol = Int(KTMParseArg(2,args))
	sSearch = KTMParseArg(3,args)
		iTimeOut = 5 *  Int(KTMParseArg(4,args))

	if iTimeOut < 0 or iRow < 0 or iCol < 0 
		iRet = ATM_INVALIDPARAMETER
	else
		iLenOfString = len(sSearch)
		iStartRow = iRow
		iStartCol = iCol
		iTypeOfSelect = Select_Stream
		iEndCol = iLenOfString - (iDisplayCols * 							int(iLenOfString/iDisplayCols)) + iStartCol -1
		iEndRow = iRow + int(iLenOfString/iDisplayCols)
		if iRow = 0 
			iStartRow = 1
			iEndRow = iDisplayRows
			if iLenOfString < iDisplayCols - iStartCol + 1
				iTypeOfSelect = Select_Block
			end
		end
		if iCol = 0
			iTypeOfSelect = Select_Stream
			iStartCol = 1
			iEndCol = iDisplayCols
		end
		iEndCol = iEndCol + 1

	begin
		suspend()
		When ScreenChanged(Type= iTypeOfSelect,Row=iStartRow, Col=iStartCol,EndRow=iEndRow, EndCol=iEndCol)
			ScreenRead(Type= iTypeOfSelect,Row=iStartRow, Col=iStartCol,EndRow=iEndRow, EndCol=iEndCol,Page=1)
			if Result <> sSearch
				iRet = ATM_SUCCESS
				break
			else
				continue
			end

	when timeout(itimeout)
		iRet = ATM_TIMEOUT
		break
	end //Begin
	end

KTMDDEreply(iRet)
Return 
End
Function KTMCodeToKey(sKey)
Var sTypeAndModifier, sTrappedKey,sKeyDescriptor, sKeyDesignator,sKey
Var iKeyASCII
if substr(skey,1,1) = ATSign and len(sKey) = 2
	sKeyDesignator = substr(sKey,2,1)
	if sKeyDesignator = "\\"
		Return "Backspace"
	elseif sKeyDesignator = "D" 
		Return "Remove"

	elseif sKeyDesignator = "B"
		Return "Select"
	elseif sKeyDesignator = "I"
		Return "Insert Here"
	elseif sKeyDesignator = "N"
		Return "^M" 	
	elseif sKeyDesignator = "E"
		Return "^M"
	elseif sKeyDesignator = "T"
		Return "Tab"	
	elseif sKeyDesignator = "U"
		Return "Up"
	elseif sKeyDesignator = "V"
		Return "Down"
	elseif sKeyDesignator = "Z"
		Return "Right"
	elseif sKeyDesignator = "L"
		Return "Left"
	elseif sKeyDesignator = "p"
		Return "Keypad Enter"
	elseif sKeyDesignator = "0"
		Return "Find"
	elseif sKeyDesignator = "1"
		Return "PF1"
	elseif sKeyDesignator = "2"
		Return "PF2"
	elseif sKeyDesignator = "3"
		Return "PF3"
	elseif sKeyDesignator = "4"
		Return "PF4"
	else
		msgbox ("KTMCodeToKey - Unknown or unsupported ATMAPI Code - call Technical Support" + sKey)
			return str(-ATM_SYSTEMERROR)
	end
end
if (substr(sKey,1,3) = "S" + ATSign + "r") and len(sKey) = 4
	Return chr(asc(substr(sKey,4,1)) - 64)
end

if (substr(sKey,1,2) = "S" + ATSign) and len(skey) = 3
	Return substr(sKey,3,1)
end
msgbox ("KTMCodeToKey " + sKey + " untranslatable code call Technical Support")
return str(-ATM_SYSTEMERROR)
End //Function KTMCodeToKey
Function KTMGetNotifyStatus()
Var iRet = ATM_SUCCESS
Var iDisplayRows = int(display.lines)
var iDisplayCols = int(display.columns)
if gbRows <> iDisplayRows or gbCols <> iDisplayCols 
	gbRowsColsChanged = 1
	gbRows = iDisplayRows
	gbCols = iDisplayCols
else
	gbRowsColsChanged = 2
end

DDE_Reply(Request.Channel,0,str(gbPSUpdate) +",2,"+ str(gbCursorMoved)+ ",2,2,"+str(gbRowsColsChanged)+ ",2,"+str(gbKeyStrokeIntercepted))
gbCursorMoved = 2
gbPSUpdate = 2
gbRowsColsChanged = 2
gbKeyStrokeIntercepted = 2
Return
End
Function KTMHostBusy()
Var iRet = 0var iSettleTime
iSettleTime = 1
	Begin
		suspend()
		When Match(idle=iSettleTime)
			iRet = 1
			break
		When timeout(2)
			iRet = 0
			
	End
	KTMDDEreply(iRet)
Return
End
Function KTMKeyToCode(sKey)
Var sTypeAndModifier, sTrappedKey,sKeyDescriptor
if len(skey) = 1
	if asc(skey) < 27
		if asc(sKey) = 13
			sTypeAndModifier = "M" + ATSign
			sTrappedKey = "N"
		elseif asc(sKey) = 9
			sTypeAndModifier = "M" + ATSign
			sTrappedKey = "T"
		else
			sTypeAndModifier = "S" + ATSign + "r"
			sTrappedKey = chr(asc(skey) + 64)
		end
	else
		sTypeAndModifier = "A"
		sTrappedKey = sKey
	end
elseif len(skey) = 2
	if skey = "Up"
		sTypeAndModifier = "M" + ATSign
		sTrappedKey = "U"
	else
		sTypeAndModifier = "S" + ATSign
		sTrappedKey = substr(sKey,2,1)
		bSingleKey = FALSE
	end
else
	sTypeAndModifier = "M" + ATSign
	sTrappedKey = sKey
	bSingleKey = FALSE
	if sKey <= "Mzzzzzzzzzzz"
		if sKey = "Backspace"
			sTrappedKey = "\\"
		elseif skey = "Down"
			sTrappedKey = "V"
		elseif sTrappedKey = "Find"
			sTrappedKey = "0"
		elseif skey = "Insert Here"
			sTrappedKey = "I"
		elseif skey = "Keypad Enter"
			sTrappedKey = "N"
		elseif skey = "Left"
			sTrappedKey = "L"

		else
			msgbox ("KTMKeyToCode - Unknown ATMAPI Code - call Technical Support" + sKey)
			return str(-ATM_SYSTEMERROR)
		end
	elseif sKey <= "Zzzzzzzzzzzzz"
		If sKey <= "Pzzzzzzzzzzzzzz"
			if skey = "PF1"
				sTrappedKey = "1"
			elseif skey = "PF2"
				sTrappedKey = "2"
			elseif skey = "PF3"
				sTrappedKey = "3"
			elseif skey = "PF4"
				sTrappedKey = "4"
			else
				msgbox ("KTMKeyToCode - Unknown ATMAPI Code - call Technical Support" + sKey)
				return str(-ATM_SYSTEMERROR)
			end
		else
			if skey = "Remove"
				sTrappedKey = "D"
			elseif skey = "Select"
				sTrappedKey = "B"
			elseif skey = "Tab"
				sTrappedKey = "T"
			elseif skey = "Right"
				sTrappedKey = "Z"
			else
				msgbox ("KTMKeyToCode - Unknown ATMAPI Code - call Technical Support" + sKey)
				return str(-ATM_SYSTEMERROR)
			end
		end
end
end

sKeyDescriptor = sTypeAndModifier + sTrappedKey
Return sKeyDescriptor
End //Function KTMKeyToCode
Function ATMWaitHostQuiet()
Var iSettleTime = 0
Var iTimeOut =  0
Var iRet = 0
//Var iWaitedSoFar = 0
//var sStartTime = SystemTIme()
iSettleTime  = int(KTMParseArg(1,args))
iTimeOut = 5 * int(KTMParseArg(2,args))

var currentTime = systemtime()
if iSettleTime < 100
   iSettleTime = 1
else
	iSettleTime = 1 + (iSettleTime / 100)
end
If iTimeOut < iSettleTime or (iSettleTime < 0)
	iRet = ATM_INVALIDPARAMETER
else
	Begin
	suspend()
	When Match(idle=iSettleTime)
		iRet = ATM_SUCCESS
		break
	When Wait(iTimeOut)
		iRet = ATM_TIMEOUT
	End

End
iRet = KTMDDEreply(iRet)
Return
End

Function H1PSPtoPRC (iPSPIn)
Var sRet
Var iRows = int(display.lines)
Var iCols = int(display.columns)
Var iPSP
iPSP = iPSPIn - 1 
sRet.Row = iPSP/iCols
sRet.Col = iPSP - sRet.Row * iCols + 1
sRet.Page = sRet.Row /iRows
sRet.Row = sRet.Row - sRet.Page * iRows
sRet.Row = sRet.Row + 1
sRet.Page = sRet.Page + 1
Return sRet

end
Function H2PageFromRowCol (iRow,iCol)
Var iPage = 1
Var iRows = int(display.lines)
Var iCols = int(display.columns)
iPage = (iRow-1)/iRows + 1
Return iPage


end

Function KTMCaretHandler (var sString)
	Var eolMPos,sLastChar ,eolRPos
//Don't use any more ^ support removed with beta 3.
eolMPos = InStr(sString, "\^M")

	if(eolMPos)
			sLastChar = substr(sString,eolMPos+1,1)
			sTemp = SubStr(sString, 1, eolMPos - 1)
			sString =  sTemp  + "^M"
	Else
		eolRPos = InStr(sString, "\^R")
		if(eolRPos)
			sLastChar = substr(sString,eolRPos+1,1)
			sTemp = SubStr(sString, 1, eolRPos - 1)
			sString =  sTemp  + "^R"
		Else
			sString = sString
		end
	End
End

Function KTMClearEventTable(iSessionHandle,iEventTable)
Var iRet =ATM_SUCCESS
if iEventTable <= MAX_EVENTTABLES and bTableValid[iEventTable][iSessionHandle] = TRUE
	deleteElement(saEvent[iEventTable],iSessionHandle)
	deleteElement(saEventsFreeList[iEventTable],iSessionHandle)
	deleteElement(sNaEvent[iEventTable],iSessionHandle)
	deleteElement(sNaEventsFreeList[iEventTable],iSessionHandle)
	deleteElement(caEvent[iEventTable],iSessionHandle)
	deleteElement(caEventsFreeList[iEventTable],iSessionHandle)
	deleteElement(keyEvent[iEventTable],iSessionHandle)
	deleteElement(keyEventsFreeList[iEventTable],iSessionHandle)

iSessionHandle in iEventsIdleIndex[iEventTable]
	deleteElement(EventsIndex[iEventTable],iSessionHandle)
	deleteElement(iLastStringAtEventNbr[iEventTable],iSessionHandle)
	deleteElement(iLastStringNOTAtEventNbr[iEventTable],iSessionHandle)
	deleteElement(iLastCursorAtEventNbr[iEventTable],iSessionHandle)
	deleteElement(iLastKeyEventNbr[iEventTable],iSessionHandle)
	deleteElement(bTableValid[iEventTable],iSessionHandle)

	deleteElement(iEventsIdleIndex[iEventTable],iSessionHandle)
	deleteElement(iEventsIdleTime[iEventTable],iSessionHandle)

	deleteElement(iEventsWaitIndex[iEventTable],iSessionHandle)
	deleteElement(iEventsWaitTime[iEventTable],iSessionHandle)

deleteElement(iEventsDisconnectFlag[iEventTable],iSessionHandle)
deleteElement(iEventsDisconnectIndex[iEventTable],iSessionHandle)
deleteElement(iEventsCursorMoveFlag[iEventTable],iSessionHandle)
deleteElement(iEventsCursorMoveIndex[iEventTable],iSessionHandle)
	iRet = ATM_SUCCESS
else
	if iEventTable <= MAX_EVENTTABLES
		iRet = ATM_TABLENOTSET
	else
		iRet = ATM_TABLEMAXEXCEEDED
	end

end

Return iRet
End //Funciton KTMClearEventTable

Function KTMDDEreply(iRet, sString)
	
	
var sReturnString
var sSign = "+"
var sReturnCode
var sZeros = "0000"

if len(iRet) > 0 or abs(iRet) > 0
	if iRet < 0
		sSign = "-"
	end
	sReturnCode = str(abs(iRet))
	if len(sReturnCode) < 4
		sReturnCode = substr(sZeros, 1, 4-len(sReturnCode))+ sReturnCode
	elseif len(sReturnCode) > 4
		sReturnCode = "000" + str(ATM_SYSTEMERROR) 
		sSign = "+"
	end
else
	sReturnCode = ""
	sSign = ""
end
sReturnString = sSign+sReturnCode + sString
DDE_Reply(Request.Channel,0,sReturnString)
return

end
Function KTMGetString()
	Var iPage, iRow, iCol, iLength,iEndRow,iEndCol
	Var sRet, iRet = ATM_SUCCESS
	Var iSelect_type = Select_Stream
	Var iDisplayRows = int(display.lines)
	Var iDisplayCols = int(display.columns)
	
	iRow = Int(KTMParseArg(1,args))
	iCol = int(KTMParseArg(2,args))
	iLength = int(KTMParseArg(3,args))

if  iRow < 0 or iCol < 0 or iLength < 0
	KTMDDEreply(ATM_INVALIDPARAMETER)
else

	iPage = (iRow - 1)/ iDisplayRows + 1
	iRow  = iRow - ((iPage - 1)  * iDisplayRows)
	Var iRowsAfterFirst = (iLength -(1 + iDisplayCols- iCol))/iDisplayCols
	iEndCol = 1 + iLength - (int(iRowsAfterFirst) * iDisplayCols + (1 + iDisplayCols- iCol))
	iEndRow = 1 + iRow +int(iRowsAfterFirst)
	ScreenRead(Page=iPage,Row=iRow,Col=iCol, EndRow=iEndRow,EndCol=iEndCol, Type=iSelect_Type)
	sRet = Result
DDE_Reply( Request.Channel, 0, sRet )//This is much faster
//	KTMDDEreply(,sRet)
end
Return 
End

Function KTMParseArg(iArgNo,sArgsIn)
	Var comma, parenth, iWrapper
	Var iNoOfArgs = 0
	Var sArgOut,sTempArgs
	Var bFinished = False
	Var iArgLoop
 	Var sANSIWrapper = chr(30) + chr(30)

parenth = Instr(sArgsIn,")")
if iArgNo < 0 or iArgNo > 10 or parenth = 0
	return str(KTM_INVALIDPARAMETER)
end
iArgLoop = 1
sTempArgs = sArgsIn



if sArgsIn = gsLastArgsIn
	return gsArgsParsed[iArgno]
else //go ahead an parse all the args out.

	While iArgLoop <= 10 and bFinished = False
		comma = instr(sTempArgs,",")
		iWrapper = instr(sTempArgs,sANSIWrapper)
		if iWrapper and iWrapper < comma
		sTempArgs = Substr(sTempArgs, iWrapper + 2)
		iWrapper = instr(sTempArgs,sANSIWrapper)
		if iWrapper
			sArgOut = substr(sTempArgs, 1, iWrapper-1) 
			sTempArgs = Substr(sTempArgs, iWrapper + 2)
			if substr(sTempArgs,1,1) = ","
				sTempArgs = substr(sTempArgs,2)
			end
		else
			return str(KTM_WRAPPERINCOMPLETE)
		end
	else
		if comma 
			sArgOut = Substr(sTempArgs, 1, comma -1 )
			sTempArgs = Substr(sTempArgs, comma + 1)	

		else
			bFinished = True
			
				parenth = Instr(sTempArgs,")")
				iWrapper = instr(sTempArgs,sANSIWrapper)
				if iWrapper > 0 
					if iWrapper = 1
						sTempArgs = Substr(sTempargs,3)
						iWrapper = instr(sTempArgs,sANSIWrapper)
						parenth = Instr(sTempArgs,")")

						if iWrapper > parenth
							sArgOut = Substr(sTempArgs,1,iWrapper-1)
						else

							return str(KTM_WRAPPEROUTOFPOSITION)
						end
					else
						return str(KTM_INVALIDPARAMETER)
					end
				else
					if parenth > 0
						sArgOut = SubStr(sTempArgs,1,parenth-1)
					else
						return str(KTM_INVALIDPARAMETER)
					end
				end
				
		end
	end
		gsArgsParsed[iArgLoop] = sArgOut
		iArgLoop = iArgLoop + 1

	end
end //if gsLastArgsIn = sArgsIn
gsLastArgsIn = sArgsIn
return gsArgsParsed[iArgNo]
end

Function KTMPSToRow(iPSPosition)
	Var iPSPosition
	Var iRow
var  comma, parenth
Var sPosition //Trying both ways to test 
var ModulusPart


if int(display.columns) = 0 
  msgbox("Display.columns are 0 ) can't do a KTMPSToRow")
	iRow = -ATM_SYSTEMERROR
else
	sPosition = H1PSPtoPRC(iPSPosition)

      iRow = (iPSPosition / Int(display.columns))*10000
      ModulusPart = ((iPSPosition * 10000) / int(display.columns)) 
      if  ModulusPart - iRow = 0 
         iRow = (iPSPosition /  int(display.columns)) 
     else
         iRow = (iPSPosition / Int(display.columns)) + 1
      end

end
  if iRow <> int(sPosition.Row)
		MSGBOX  ("KTMPSToRow - internal error ")
	end
Return iRow
End


Function KTMPSToCol(iPSPosition)
	Var iPSPosition
	
	
Var ModulusPart
Var sPosition = H1PSPtoPRC(iPSPosition)
Var iCol


if int(display.columns) = 0 
  msgbox("Display.columns are 0 ) can't do a KTMPSToRow")
	iCol = -ATM_SYSTEMERROR
else
  iCol = (iPSPosition / Int(display.columns))*10000
  ModulusPart = ((iPSPosition * 10000) / int(display.columns)) 
  if  ModulusPart - iCol = 0 and iPSPosition > 0
    iCol = Int(display.columns)
  else
    iCol = iPSPosition / Int(display.columns)
    iCol = iPSPosition - ( iCol * int(display.columns))
  end
end
if iCol <> int(sPosition.Col)
		MSGBOX  ("KTMPSToCol - internal error ")
	end
Return iCol
End

Function KTMRCToPS(iPage, iRow, iCol)
Var iRow, iCol,iPage
Var iPSPosition = 0
Var iDisplayRows = int(display.lines)
Var iDisplayCols = int(display.columns)


iPSPosition = ((iPage -1) *iDisplayRows * iDisplayCols) + ((iRow - 1)* iDisplayCols + iCol)
Return iPSPosition
End

Function KTMSearchPS()

	Var iPSPosition
	Var sSearchString
	Var iSearchDirection
	Var FORWARDSEARCH = 1
	Var sSearchedString // The part of the screen searched.
	Var BACKWARDSEARCH = 0
	Var iFoundAt
	Var iDisplayRows = int(display.lines)
	Var iDisplayCols = int(display.columns)
	Var iStartPage, iStartRow, iStartCol, iEndRow, iEndCol

iFoundAt = 0
sSearchString = KTMParseArg(1,args)
iPSPosition = Int(KTMParseArg(2,args))
iSearchDirection = Int(KTMParseArg(3,args))
	If iSearchDirection = FORWARDSEARCH
		iEndRow = iDisplayRows
		iEndCol = iDisplayCols
		if iPSPosition > 0 
			iStartRow = KTMPSToRow(iPSPosition)
			iStartCol = KTMPSToCol(iPSPosition)
		else
			iStartRow = 1
			iStartCol = 1
		end
	iStartPage = (iStartRow-1)/ iDisplayRows + 1
		ScreenRead(Type=Select_Stream,Page=iStartPage,
Row=iStartRow,Col=iStartCol,EndRow=iEndRow,EndCol=iEndCol)
		iFoundAt = Instr(Result,sSearchString)
		if iFoundAt > 0 
			if iPSPosition > 0
				iFoundAt = iPSPosition + iFoundAt - 1
			else
				iFoundAt = iPSPosition + iFoundAt
			end
		End

	Elseif iSearchDirection = BACKWARDSEARCH //Thisis tricky we must find backwards offset.
		iStartRow = 1
		iStartCol = 1
		if iPSPosition > 0 
			iEndRow = KTMPSToRow(iPSPosition)
			iEndCol = KTMPSToCol(iPSPosition)
		else
			iEndRow = iDisplayRows
			iEndCol = iDisplayCols
		end
	iStartPage = (iStartRow-1)/ iDisplayRows + 1
		ScreenRead(Type=Select_Stream,Page=iStartPage,
Row=iStartRow,Col=iStartCol,EndRow=iEndRow,EndCol=iEndCol)
		sSearchedString = result
		iFoundAt = Instr(sSearchedString,sSearchString)
		if iFoundAt > 0
			Var iLastPos = 0
		Var iCharsChoppedOff = 0
		var sTempString = ""
			iLastPos = iFoundAt
			sTempString = sSearchedString
			While iFoundAt > 0
				sTempString = substr(sTempString,iFoundAt+1)
				iCharsChoppedOff = iFoundAt + iCharsChoppedOff
				iFoundAt = Instr(sTempString,sSearchString)
				if iFoundAt > 0 
					iLastPos = iFoundAt + iCharsChoppedOff
				end
			end // While iFoundAt > 0
			iFoundAt = iLastPos 
			
		End
	End

DDE_Reply(Request.Channel,0,Str(iFoundAt))
Return
End
function KTMSearchScreen(sSearchString,iPage, iStartRow, iStartCol,iEndRow, iEndCol)
Var iFoundAt = 0

ScreenRead(Type=Select_Stream,Page=iPage,
Row=iStartRow,Col=iStartCol,EndRow=iEndRow,EndCol=iEndCol)
iFoundAt = Instr(Result,sSearchString)
Return iFoundAt
End //Function KTMSearchScreen
Function KTMSetCursorLocation(iRow, iCol)
	Var start
	Var sString
	Var iRow, iCol, iPage,ColsDif,RowsDif
	Var iRet
	Var UpKey = "Up"
	var DownKey = "Down"
	var LeftKey = "Left"
	var RightKey = "Right"


	
		iPage = ((iRow-1)/Int(display.lines)) + 1
	iRow  = iRow - ((iPage - 1)  * Int(display.lines))
		start = GetCursor()
		if(start.page <> iPage) 
		iret =  ATM_CHANGEINGPAGE
	end

	Begin
		if(start.col <> iCol)
				colsDif = iCol - start.Col  
		if colsDif < 0 
			while colsDif
				colsDif = colsDif + 1
				sendkey(LeftKey)
			end		
		elseif colsDif > 0					
			while colsDif
				colsDif = colsDif - 1
				sendkey(RightKey)
			end			
		end
	end 
	if (start.Row <> iRow)
				rowsDif = iRow - start.Row  
		if rowsDif < 0 
			while rowsDif
				rowsDif = rowsDif + 1
				sendkey(UpKey)
			end					
		elseif rowsDif > 0					
			while rowsDif
				rowsDif = rowsDif - 1			
				sendkey(DownKey)
			end			
		end
	end

		suspend()
		When CursorAt(Type=Select_Stream,Row=iRow,Col=iCol, EndRow=iRow,EndCol=iCol+1,Page=iPage)
		iRet = ATM_SUCCESS
	When match(idle= 1)  //Loop this time out if CursorAt fails.  in 4.1 it is not relieable.
		NowCursor = GetCursor()
		if NowCursor.ROW = iRow and NowCursor.Col = iCol and NowCursor.Page = iPage
			iRet = ATM_SUCCESS
			break
		else
			continue
		end	

	When TimeOut(iSetCursorTimeout)
		iRet = ATM_TIMEOUT
	End //Begin
	if iRet = ATM_SUCCESS 
		
 	elseif iRet = ATM_TIMEOUT
	end 
return iRet
End 


Function KTMTrapKeyStroke(bKeyStrokeInterceptOn,bAllKeysIntercepted,var sKeysIntercepted,sKey)
Var sKeyDescriptor
					
					
Var sTypeAndModifier
Var sTrappedKey

							
var sRegularKeys = " ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890/?,.<>';:=+-_)(*&^%$#@!\`~"
brk()

if bKeyStrokeInterceptOn = TRUE //This used to be called all the time and so checked
						//I left this in when check was moved to high level for performance.
	sKeyDescriptor = KTMKeyToCode(sKey)
	sKeyDescriptor = sKeyDescriptor + substr("        ",1,6-len(sKeyDescriptor))
	if bAllKeysIntercepted = TRUE
		sKeysIntercepted = sKeysIntercepted + sKeyDescriptor
		gbKeyStrokeIntercepted = 1
	end
else
	sendkey(sKey)
end// bKeyStrokeInterceptOn = TRUE
return 
end
Function ATMUnLockKeyboard()
Var iRet = ATM_SUCCESS
echo ("^[[2l")
iRet = KTMDDEreply(iRet)
Return
End //Function ATMUnLockKeyboard

Function KTMWaitForCursor(iPage, iRow, iCol, iTimeout)
var iRes = 0
	Var start
	Var sString
	Var iRet
	var idletime = iWaitIdle
	Var curpos
	Var iCurPage, iCurRow, iCurCol

		
	start = GetCursor()
   //Are we still at the input position or not.


iCurPage = int(start["PAGE"])

iCurRow = int(start["ROW"])

iCurCol = int(start["COL"])
if iCurPage = iPage AND iCurRow = iRow AND iCurCol = iCol

	 return ATM_SUCCESS
end
debuglog ("KTMWaitForCursor 3 " + " timeout " + itimeout + NL) Begin
	suspend()
	When cursorat(Page=iPage,row=iRow,Col=iCol,EndRow=iRow,EndCol=iCol+1,Type=Select_Stream)
		return ATM_SUCCESS
//     when match (idle=idletime)
//       start = GetCursor() 
//			iCurPage = start["PAGE"]
//			iCurRow = int(start["ROW"])
//			iCurCol = int(start["COL"])
//			if iCurPage = iPage AND iCurRow = iRow AND iCurCol = iCol

//	       return ATM_SUCCESS
//        end
//        continue
when Wait(iTimeout)
Return ATM_TIMEOUT 
 end

End

Function KTMWaitForCursorMove(iPage, iRow, iCol, iTimeout)
var iRes = 0
	Var start
	Var sString
	Var iRet
	Var Idle = iWaitIdle
	Var curpos

		
	start = GetCursor()

  if start.Page <> iPage OR start.Row <> iRow OR start.Coloumn <> iCol
	 return ATM_SUCCESS
  end
    Begin 
			suspend()
       when(idle=idle)
          start = GetCursor()
				if start.Page <> iPage OR start.Row <> iRow OR start.Col <> iCol
            ATM_SUCCESS position not 1
	         return ATM_SUCCESS
         end
         continue
       when Wait(Timeout)
          Return ATM_TIMEOUT 
    end

Return 
End
Function KTMWaitForString(iRow,iCol,sSearch,iTimeOut)

	Var IdleTime = iWaitIdle
	Var iRet = 0
	Var iRow, iCol, iEndRow, iEndCol,iTypeOfSelect,iLenOfString,iPage
	Var comma
	Var sSearch, iTimeOut,iRemainingTimeOut
	Var iDisplayRows = int(display.lines)
	Var iDisplayCols = int(display.columns)

Var iKeyCtr = 0
Var bFinished = FALSE
Var iStartTime = systemtime()
Var iElapsedTime, iEndTime

			
	iLenOfString= len(sSearch)
	iPage = (iRow-1)/iDisplayRows + 1
	iRow  = iRow - ((iPage - 1)  * iDisplayCols)
	iStartRow = iRow
	iStartCol = iCol
	iTypeOfSelect = Select_Stream
	iEndCol = iLenOfString - (iDisplayCols * 					int(iLenOfString/iDisplayCols)) + iStartCol -1
	iEndRow = iRow + int(iLenOfString/iDisplayCols)
	if iRow = 0 
		iStartRow = 1
		iEndRow = iDisplayRows
		if iLenOfString < iDisplayCols - iStartCol + 1
			iTypeOfSelect = Select_Block
		end
	end
	if iCol = 0
		iTypeOfSelect = Select_Stream
		iStartCol = 1
		iEndCol = iDisplayCols
	end
	if iEndCol < iDisplayCols
		iEndCol = iEndCol + 1
	end

	Begin
		suspend()

		when ScreenMatch (pat = sSearch,idle=3,type=iTypeOfSelect,row = iStartRow,col=iStartCol,EndRow = iEndRow,
EndCol = iEndCol,Page = iPage,Options=gbWaitOption)
iRet = (Result.row - 1) * iDisplayCols + Result.col
//			iRet = KTMSearchScreen(sSearch,iPage, iStartRow, iStartCol,iEndRow, iEndCol)
//			iRet = iRet + (iStartRow - 1) * iDisplayCols + iStartCol -1
		When Wait(iTimeOut)

			iRet = -ATM_TIMEOUT
	End

//end
Return iRet
End


Var bHostHeld = 0
						

Var ThisSession
Var Conversation = 0
Var Request

var NL = "^M^J"
var ATSign = "@"
Var Args = ""
Var bKeyStrokeInterceptOn = FALSE
Var bAllKeysIntercepted = FALSE
var sKeysIntercepted = ""
var sKey

Var iTabCtr = 1

while iTabCtr <= MAX_EVENTTABLES

	EventsIndex[iTabCtr] = ""

	saEventsFreeList[iTabCtr] = "" 
	saEvent[iTabCtr] = "" 
	iLastStringAtEventNbr[iTabCtr] = 0

	iLastStringNOTAtEventNbr[iTabCtr] = 0
	sNaEventsFreeList[iTabCtr] = "" 
	sNaEvent[iTabCtr] = ""

	keyEventsFreeList[iTabCtr] = ""
	keyEvent[iTabCtr] = ""
	iLastKeyEventNbr[iTabCtr] = 0

	caEventsFreeList[iTabCtr] = ""
	caEvent[iTabCtr] = ""
	iLastCursorAtEventNbr[iTabCtr] = ""

	iEventsIdleTime[iTabCtr] = ""
	iEventsIdleIndex[iTabCtr]  = ""
	iEventsWaitTime[iTabCtr] = ""
	iEventsWaitIndex[iTabCtr]  = ""

	iEventsDisconnectIndex[iTabCtr]  = ""
	iEventsDisconnectFlag[iTabCtr]  = ""
	iEventsCursorMoveIndex[iTabCtr]  = ""
	iEventsCursorMoveFlag[iTabCtr]  = ""

	iTabCtr = iTabCtr + 1
end //While iTabCtr

Var gbWaitingForKeyStroke = FALSE

Var gbPSUpdate = 2
Var gbCursorMoved = 2
Var gbKeyStrokeIntercepted = 2
Var gbRowsColsChanged = 2
Var gbRows = int(display.lines)
Var gbCols = int(display.columns)
Var gsLastArgsIn = ""
gsArgsParsed[1] = "" 
Var sFunctionName
global gbWaitOption
gbWaitOption=0
global gbDefaultPage
gbDefaultPage=1
//parm 20
var XFER_PROTOCOL
Var XFER_STATUSDISPLAY = Xfer_NoStatus
//Var
//Parm 21
var iInternalTimeOut = 20 * 5

var iOtherTimeOut = 1000 
var iSetCursorTimeOut = 5000 

//Parm 23
var iWaitIdle //Idle cycle time when waiting
XFER_PROTOCOL = GetINI(File="KEA.INI",Section="xtools Filetransfer",key="Protocol",String="Kermit")
if UpperCase(XFER_PROTOCOL) = "KERMIT"
	XFER_PROTOCOL = XFER_KERMIT
elseif UpperCase(XFER_PROTOCOL) = "ZMODEM"
	XFER_PROTOCOL = XFER_ZMODEM
elseif UpperCase(XFER_PROTOCOL) = "FTP"
	XFER_PROTOCOL = XFER_FTP
end
Max_KeyEvents =  GetINI(File="KEA.INI",Section="xtools Limits",key="MaxKeyEvents",String="3")
Max_EVENTTABLES = GetINI(File="KEA.INI",Section="xtools Limits",key="MaxEventTables",String="3")
iInternalTimeOut =  GetINI(File="KEA.INI",Section="xtools Timing",key="Defaulttimeout",String="50000") / 100
iSetCursorTimeOut = GetINI(File="KEA.INI",Section="XTOOLS TIMING",key="SetCursorTimeOut",String="10000") / 100
iWaitIdle = GetINI(File="KEA.INI",Section="xtools Timing",key="DefaultIdle",String="100")/ 100

ThisSession = Substr(WindowList, -1, 1)
ErrorLevel(Level=4)

if autoconnect and not (isConnected())
	connect()
end
DDE_Enable( True )

begin  //for the higher level watching for changes.

	begin // The DDE and lower nesting only
		suspend()
	When DDE_Accept( ThisSession, Request )
		Var RS, CS, LS
		
		If not Conversation		
			Conversation = Request.Channel
		End


		If Request.Type = "CONNECT"
		
			DDE_Enable( False )	
		ElseIf Request.Type = "EXECUTE"
			DDE_Reply( Request.Channel, 256 ) 	
			echo(Request.Item + nl)

		ElseIf Request.Type = "REQUEST"

			args = Request.Item
			parenth = Instr(args, "(")
	   	args = Substr(args, parenth + 1)

sFunctionName = substr(Request.Item,1,instr(Request.item,"(") - 1)
	if sFunctionName < "ATMS"
		if sFunctionName < "ATMGet"
			if sFunctionName < "ATMAddWaitzzzzz"
				if sFunctionName = "ATMAddWaitForCursor"
					ATMAddWaitForCursor()
				ElseIf sFunctionName ="ATMAddWaitForCursorMove"
					ATMAddWaitForCursorMove()
				ElseIf sFunctionName ="ATMAddWaitForHostConnect"
					ATMAddWaitForHostConnect()
				ElseIf sFunctionName ="ATMAddWaitForHostDisconnect"
					ATMAddWaitForHostDisconnect()
				ElseIf sFunctionName ="ATMAddWaitForKey"
					ATMAddWaitForKey()
				ElseIf sFunctionName ="ATMAddWaitForString"
					ATMAddWaitForString()
				ElseIf sFunctionName ="ATMAddWaitForStringNotAt"
					ATMAddWaitForStringNotAt()
				ElseIf sFunctionName ="ATMAddWaitHostQuiet"
					ATMAddWaitHostQuiet()
				ElseIf sFunctionName ="ATMAddWait"
					ATMAddWait()
				else
					KTMDDEreply(ATM_INVALIDFUNCTION)
				end
			else
				If sFunctionName ="ATMClearEventTable"
					ATMClearEventTable()
				ElseIf sFunctionName = "ATMCopyPS"
					ATMCopyPS()
				ElseIf sFunctionName = "ATMDeleteEvent"
					ATMDeleteEvent()
				ElseIf sFunctionName = "ATMExecute"
					ATMExecute()
				Else
					KTMDDEreply(ATM_INVALIDFUNCTION)
				End
			end
		else
			if sFunctionName < "ATMGetS"

				If sFunctionName = "ATMGetConnectionStatus"
					ATMGetConnectionStatus()
				ElseIf sFunctionName = "ATMGetCursorLocation"
					ATMGetCursorLocation()
				ElseIf sFunctionName = "ATMGetEmulatorPath"
					ATMGetEmulatorPath()
				ElseIf sFunctionName = "ATMGetEmulatorVersion"
					ATMGetEmulatorVersion()
				ElseIf sFunctionName = "ATMGetKeyStroke"
					ATMGetKeyStroke()
				ElseIf sFunctionName = "ATMGetParameter"
					ATMGetParameter()
				else
					KTMDDEreply(ATM_INVALIDFUNCTION)
				end
			else
				if sFunctionName < "ATMR"
					If sFunctionName = "ATMGetSessionSize"
						ATMGetSessionSize()
					ElseIf sFunctionName = "ATMGetSessionStatus"
						ATMGetSessionStatus()
					elseIf sFunctionName = "ATMGetString"
						ATMGetString()
					ElseIf sFunctionName = "ATMHoldHost"
						ATMHoldHost()
					ElseIf sFunctionName = "ATMLockKeyboard"
						ATMLockKeyboard()
					ElseIf sFunctionName = "ATMPause"
						ATMPause()
					else
						KTMDDEreply(ATM_INVALIDFUNCTION)
					end
				else
					If sFunctionName = "ATMRCToPS"
						ATMRCToPS()
					ElseIf sFunctionName = "ATMReceiveFile"
						ATMReceiveFile()
					ElseIf sFunctionName = "ATMResetSystem"
						ATMResetSystem()
					ElseIf sFunctionName = "ATMResumeHost"
						ATMResumeHost()
					ElseIf sFunctionName = "ATMRowColumn"
						ATMRowColumn()
					ElseIf sFunctionName = "ATMRunMacro"
						ATMRunMacro()
					else
						KTMDDEreply(ATM_INVALIDFUNCTION)
					end
				end
			end
		end
	elseif sFunctionName < "Zzz"

		if sFunctionName < "ATMSenzzzz"

			If sFunctionName = "ATMSearchSession"
				ATMSearchSession()
			ElseIf sFunctionName = "ATMSendAndWait"
				ATMSendAndWait()
			ElseIf sFunctionName = "ATMSendFile"
				ATMSendFile()
			ElseIf sFunctionName = "ATMSendKey"
				ATMSendKey()
			ElseIf sFunctionName = "ATMSendString"
				ATMSendString()
			else
				KTMDDEreply(ATM_INVALIDFUNCTION)
			end
		elseif sFunctionName < "ATMW"
			If sFunctionName = "ATMSessionOff"
				ATMSessionOff()
			ElseIf sFunctionName = "ATMSessionOn"
				ATMSessionOn()
			ElseIf sFunctionName = "ATMSetCursorLocation"
				ATMSetCursorLocation()
			ElseIf sFunctionName = "ATMSetParameter"
				ATMSetParameter()
			ElseIf sFunctionName = "ATMStartHostNotify"
				ATMStartHostNotify()
			ElseIf sFunctionName = "ATMStartKeyStrokeIntercept"
				ATMStartKeyStrokeIntercept()
			ElseIf sFunctionName = "ATMStopKeyStrokeIntercept"
				ATMStopKeyStrokeIntercept()
			ElseIf sFunctionName = "ATMStopSession"
				ATMStopSession()
			ElseIf sFunctionName = "ATMUnlockKeyboard"
				ATMUnlockKeyboard()
			else
				KTMDDEreply(ATM_INVALIDFUNCTION)
			end  
		elseif sFunctionName < "KTM"

			If sFunctionName = "ATMWait"
				ATMWait()
			ElseIf sFunctionName = "ATMWaitForHostConnect"
				ATMWaitForHostConnect()
			ElseIf sFunctionName = "ATMWaitForCursor"
				ATMWaitForCursor()
			ElseIf sFunctionName = "ATMWaitForCursorMove"
				ATMWaitForCursorMove()
			ElseIf sFunctionName = "ATMWaitForDisconnect" //Temp till removed
				ATMWaitForHostDisconnect()
			ElseIf sFunctionName = "ATMWaitForHostDisconnect"
				ATMWaitForHostDisconnect()
			ElseIf sFunctionName = "ATMWaitForEvent"
				ATMWaitForEvent()
			ElseIf sFunctionName = "ATMWaitForKey"
				ATMWaitForKey()
			ElseIf sFunctionName = "ATMWaitForString"
				ATMWaitForString()
			ElseIf sFunctionName = "ATMWaitForStringNotAt"
				ATMWaitForStringNotAt()
			ElseIf sFunctionName = "ATMWaitHostQuiet"
				ATMWaitHostQuiet()
			else
				KTMDDEreply(ATM_INVALIDFUNCTION)
			end
		else
			If sFunctionName = "KTMGetNotifyStatus"
				KTMGetNotifyStatus()
			ElseIf sFunctionName = "KTMHostBusy"
				KTMHostBusy()
			ElseIf sFunctionName = "KTMSearchPS"
				KTMSearchPS()
		 	ElseIf sFunctionName = "KTMGetString"
				KTMGetString()
			else
				KTMDDEreply(ATM_INVALIDFUNCTION)
			End
		end
	Else

			iRet = KTMDDEreply(ATM_INVALIDFUNCTION)	
	End

		ElseIf Request.Type ="TERMINATE"
			DDE_Terminate( Request.Channel )
			Conversation = 0
			DDE_Enable( True )
		End
		Continue			
	end //Inner begin for dde
when Keystroke()
	sKey = Result
	if bKeyStrokeInterceptOn = TRUE
		KTMTrapKeyStroke(bKeyStrokeInterceptOn,bAllKeysIntercepted,sKeysIntercepted,sKey)
		continue
	else
		sendkey(sKey)
	continue
	end


when screenChanged (select_stream, 1,1,int(display.lines),int(display.columns))
	gbPSUpdate = 1
	continue


		When CursorMove()
		gbCursorMoved = 1
		continue

	End //Outer begin for the above whens.
