@ECHO OFF
CLS
ECHO.
ECHO *********************************************************************
ECHO * NEWNOS.BAT - Updates to latest versions of REDIR and SERVER       *
ECHO *                                                                   *
ECHO * This batch file installs a new version of SERVER.EXE and          *
ECHO * REDIR.EXE that fix the problems listed in README.TXT.             *
ECHO *                                                                  *
ECHO * This batch file should be in the directory where you installed    *
ECHO * the network (normally C:\LANTASTI).                               *
ECHO * Your present copies of REDIR.EXE and SERVER.EXE will be backed    *
ECHO * up to REDIR.BAK and SERVER.BAK                                    *
ECHO *                                                                   *
ECHO * If your computer is not a server, a warning message will be       *
ECHO * printed out and the update process will continue.                 *
ECHO *                                                                   *
ECHO * Press CTRL-C now to abort running this patch.                     *
ECHO *********************************************************************
ECHO.
PAUSE

IF NOT EXIST REDIR.EXE GOTO  ERR1RED
IF NOT EXIST NEWRED.EXE GOTO ERR4RED

IF EXIST REDIR.BAK GOTO ERR2RED

:INSTALLRED
ECHO.
ECHO Copying old redirector to REDIR.BAK ..
COPY REDIR.EXE REDIR.BAK
ECHO.

ECHO Installing new redirector ...
NEWRED INFILE=REDIR.EXE OUTFILE=_REDR_.EXE
IF ERRORLEVEL 1 GOTO    ERR3RED

COPY _REDR_.EXE REDIR.EXE
DEL _REDR_.EXE
GOTO DONERED

:ERR1RED
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO REDIR.EXE not found in this directory - please copy this batch file
ECHO to the directory where REDIR.EXE resides and run NEWNOS again.
ECHO.
GOTO EXIT

:ERR2RED
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO REDIR.BAK already exists ! it will be overwritten.
ECHO Press CTRL-C to abort
ECHO.
PAUSE
GOTO INSTALLRED

:ERR3RED
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO Operation unsuccessful. Repeat NEWNOS in a directory containing only
ECHO original REDIR.EXE and SERVER.EXE programs.
GOTO EXIT

:ERR4RED
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO NEWRED.EXE not found in this directory - please copy this file
ECHO to the directory where REDIR.EXE resides and run NEWNOS again.
GOTO EXIT

:DONERED
ECHO                * Redirector successfully patched *

IF NOT EXIST SERVER.EXE GOTO ERR1SRV
IF NOT EXIST NEWSRV.EXE GOTO ERR4SRV

IF EXIST SERVER.BAK GOTO ERR2SRV

:INSTALLSRV
ECHO.
ECHO Copying old server to server.bak ..
COPY SERVER.EXE SERVER.BAK
ECHO.

ECHO Installing new server ...
NEWSRV INFILE=SERVER.EXE OUTFILE=_SRVR_.EXE
IF ERRORLEVEL 1 GOTO     ERR3SRV

COPY _SRVR_.EXE SERVER.EXE
DEL _SRVR_.EXE
GOTO DONESRV

:ERR1SRV
ECHO.
ECHO                           * WARNING *
ECHO.
ECHO SERVER.EXE not found in this directory - if this computer is a workstation
ECHO then this error is normal.  If this computer is a server, please move the
ECHO files to the directory where SERVER.EXE resides and run NEWNOS again.
ECHO.
GOTO EXIT

:ERR2SRV
ECHO.
ECHO                           * ERROR *
ECHO.
ECHO SERVER.BAK already exists ! it will be overwritten.
ECHO Press CTRL-C to abort
ECHO.
PAUSE
GOTO INSTALLSRV

:ERR3SRV
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO Operation unsuccessful. Repeat NEWNOS in a directory containing only
ECHO original REDIR.EXE and SERVER.EXE program.
GOTO EXIT

:ERR4SRV
ECHO 
ECHO                           * ERROR *
ECHO 
ECHO NEWSRV.EXE not found in this directory - please copy this file
ECHO to the directory where SERVER.EXE resides and run NEWNOS again.
GOTO EXIT

:DONESRV
ECHO                * Server successfully patched *

:EXIT
