/*
	EMSFIX version 1.00
	The MINIMALIST Group 4/20/94
	Lewis Sellers 3
	Written in Borland Turbo C++ 3.00


	This is a companion program to EMSTEST.  It deallocates EMS page handles
	that other programs may have forgotten about.  As this program
	deallocates ALL handles, it is somewhat dangerous, so use it
	with caution and common sense.

	It is primarily intended for use by programmers to regain expanded
	memory after a alpha-test program goes arwy (ie. Abnormal program abortion).

	This program is in the PUBLIC DOMAIN.  All code and information herein
	discussed (except of course references to The MINIMALIST Group and the
	blessed Borland Turbo C++ 3.00) is free for public dispersment and
	usage in whatsoever form desired.
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>

#define FALSE   0
#define TRUE    !FALSE

main()
{
	union REGS regs;
	union SREGS sregs;
	char far *emptr,far *nameptr;
	int n;
	char far *emmstring,far *reference_string;
	unsigned int handle;
	unsigned int numberofhandles;
	unsigned int cursorx,cursory;

	puts("\nEMSFIX quick version 1.00 (PUBLIC DOMAIN)");
	puts("The Minimalist Group in-house developments 4/22/94");
	puts("");

	/* Is the driver installed? Get the address of the EMS386 driver from
	interrupt 0x67, where it always dwells, and then check to see if the
	tag EMMXXXX0 is there.  If all this is true, there is an expanded memory
	manager active here.  */
	nameptr="EMMXXXX0";
	regs.h.ah=0x35;
	regs.h.al=0x67;
	intdosx(&regs,&regs,&sregs);
	emptr=(char *)MK_FP(sregs.es,0);

	emmstring=emptr+10;
	reference_string=nameptr;
	n=8;
	while(*reference_string && n>0) {
		if(*emmstring!=*reference_string) {
			printf("EMS Driver not detected");
			return 1;
		}
		n--;
		emmstring++;
		reference_string++;
	}
	puts("EMS Driver detected!");


	/* is software operating? ask EMM driver if it is ON and taking requests */
	regs.h.ah=0x40;
	int86(0x67,&regs,&regs);

	switch (regs.h.ah) {
		case 0x00:
			puts("EMS is functional");
			break;
		case 0x80:
			puts("Internal error in EMS software");
			break;
		case 0x81:
			puts("Malfunction in EMS hardware");
			break;
		case 0x84:
			puts("Undefined function");
			break;
		default:
			puts("Undefined ERROR");
	}

	/* look for page frame segment.  this is the segment in memory where
	all the expanded memory is banked into as needed. Usually 0xe000.
	it is VERY important for the program to remember this address, because
	all the data you use with EMM can only dwell here at this segment! */
	regs.h.ah=0x41;
	int86(0x67,&regs,&regs);

	switch (regs.h.ah) {
		case 0x00:
			printf("Segment of page frame %u (%Xh)\n",regs.x.bx,regs.x.bx);
			break;
		case 0x80:
			puts("Internal error in EMS software");
			break;
		case 0x81:
			puts("Malfunction in EMS hardware");
			break;
		case 0x84:
			puts("Undefined function");
			break;
		default:
			puts("Undefined ERROR");
	}

	/* get page count.  ask it how many 16k pages this system supports and
	of those how many are actually free to be used by the next program ran. */
	regs.h.ah=0x42;
	int86(0x67,&regs,&regs);

	switch (regs.h.ah) {
		case 0x00:
			printf("Number of unallocated pages %u (%uk)\n",regs.x.bx,regs.x.bx*16);
			printf("Total number of pages in system %u (%uk)\n",regs.x.dx,regs.x.dx*16);
			break;
		case 0x80:
			puts("Internal error in EMS software");
			break;
		case 0x81:
			puts("Malfunction in EMS hardware");
			break;
		case 0x84:
			puts("Undefined function");
			break;
		default:
			puts("Undefined ERROR");
	}

	/* get EMM version.  the version as of this writting is 4.0 */
	regs.h.ah=0x46;
	int86(0x67,&regs,&regs);

	switch (regs.h.ah) {
		case 0x00:
			printf("EMM version number %u.%u\n",(regs.h.al>>4)&0xf,regs.h.al&0xf);
			break;
		case 0x80:
			puts("Internal error in EMS software");
			break;
		case 0x81:
			puts("Malfunction in EMS hardware");
			break;
		case 0x84:
			puts("Undefined function");
			break;
		default:
			puts("Undefined ERROR");
	}


	/* get handle count. ask how many groups of expanded memory are being
	currently used. When asking for memory from EMM you specify how many
	blocks of 16K pages you need for each data grouping.  That is, say I
	need 64K to hold a 320x200 256 color background in memory.  I would
	ask for 4 pages (of 16K giving me 64K total) and the expanded memory
	manager would give me a handle number back (say, for example 17).
	From then on out, when ever I need that infomation, I would ask EMM
	to please bring the data at group 17 into memory at the frame segment.
	This is sort of like validated parking where you get a number stub.
	EMM parks the car/data somewhere (don't ask) and when ever you need it
	you show it the stub number and it's brought around for you.
	The following code asks EMM how many of these handles other programs
	(mainly TSRs) are currently using. */
	regs.h.ah=0x4B;
	int86(0x67,&regs,&regs);
	numberofhandles=regs.x.bx;
	switch (regs.h.ah) {
		case 0x00:
			printf("Number of active EMS handles %u\n",regs.x.bx);
			break;
		case 0x80:
			puts("Internal error in EMS software");
			break;
		case 0x81:
			puts("Malfunction in EMS hardware");
			break;
		case 0x84:
			puts("Undefined function");
			break;
		default:
			puts("Undefined ERROR");
	}


	/* */
	puts("Fixing undeallocated EMS handles...");
	if(numberofhandles<=1) {
		puts("  No handles allocated above the normal.");
		puts("  EMS Fix aborted.");
		return 1;
	}
	printf("  Deallocating handles 1 through ");
	cursorx=wherex();
	cursory=wherey();
	for(n=1;n<numberofhandles;n++) {
		regs.h.ah=0x45;
		regs.x.dx=n;
		int86(0x67,&regs,&regs);
		gotoxy(cursorx,cursory);
		printf("%u...",n);
		switch (regs.h.ah) {
			case 0x00:
				printf("  Success!                             ");
				break;
			case 0x80:
				printf("  Internal error in EMS software       ");
				break;
			case 0x81:
				printf("  Malfunction in EMS hardware          ");
				break;
			case 0x84:
				printf("  Undefined function                   ");
				break;
			case 0x86:
				printf("  Error in save/restore mapping context");
			default:
				printf("  Undefined ERROR                      ");
		}
	}
	printf("\n  Success!");
	return 0;
}

/* finis! */
