program DiskReady;

{$I-}

var
  oldDir, firstParm : String;
  letter : Char;
  errorLevel : Byte;

begin
{At start, assume no disks in drives}
errorLevel := 0;
{Save old directory}
GetDir(0,oldDir);
{Check parameter, if any, for drive letter}
firstParm := ParamStr(1);
if Length(firstParm) <> 1 then
  letter := ' '
  else
  letter := UpCase(firstParm[1]);
{Test drive A, if required}
if (letter <> 'B') then
begin
  {Try to make it current}
  ChDir('A:\');
  case IOResult of
    0: errorLevel := 1; {Disk in drive}
    152 : {Do nothing}; {Not ready}
    else
    errorLevel := 4 {Unknown error}
    end
  end;
{Test drive B, if required}
if (letter <> 'A') and
   (errorLevel <> 4) then
   begin
  ChDir('B:\');
  case IOResult of
    0: errorLevel := errorLevel + 2;
    152 : {Do nothing};
  else
    errorLevel := 4
    end
  end;
ChDir(oldDir);
if IOResult <> 0 then
  errorLevel := 4;
Halt(errorLevel)
end.
