COMMENT @
 ************************************************************************
 *                                                                      *
 *     Copyright (c) 1992 Intel Corporation                             *
 *     All Rights Reserved                                              *
 *                                                                      *
 *     INTEL CORPORATION PROPRIETARY INFORMATION                        *
 *                                                                      *
 *     This software is supplied under the terms of a licence           *
 *     agreement with Intel Corporation and may not be copied nor       *
 *     disclosed except in accordance with the terms of that agreement. *
 *                                                                      *
 ************************************************************************
@

COMMENT @

 Description:  Read an indexed register

 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   HISTORY:

 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@

INCLUDE  DCIMACRO.INC

ASM_TEXT SEGMENT PARA USE16 PUBLIC 'CODE'
         OPTION  LANGUAGE:PASCAL
        .386

COMMENT @
Function ReadIndex:
Read an indexed register

Entry:  AL = Index
        DX = Base address
Exit:   Success  AH = value          Failure  AH = 0
                 CY = 0                       CY = 1
        All other registers, including al, are preserved.

This function is not callable from a C function.
@
ReadIndex PROC    USES BX CX
         mov     cx, 100          ; Arbritrary retry counter
         mov     ah, al           ; Save the index
LoopRead:
         mov     al, ah           ; Get the index
         out     dx, al           ; Select the index
         inc     dx               ; Next higher I/O address
         in      al, dx           ; Get the value
         mov     bl, al           ; Save the value in the BL
         dec     dx               ; Restore original I/O address
         in      al, dx           ; Read the current index
         cmp     al, ah           ; Did we read the right index?
         je      Success          ; Skip if we read the right index
         dec     cx               ; Try again
         jg      LoopRead         ; Loop until the counter is exhausted
         mov     ah, 0            ; Set failure return codes
         stc                      ;
         jmp     Exit             ; Go to common exit

Success:
         mov     ah, bl           ; Put the value in AH
         clc                      ; Set successful return code
Exit:
         ret                      ; Return to caller
ReadIndex ENDP

ASM_TEXT ENDS
         END

