
COMMENT @
 ************************************************************************
 *                                                                      *
 *     Copyright (c) 1992 Intel Corporation                             *
 *     All Rights Reserved                                              *
 *                                                                      *
 *     INTEL CORPORATION PROPRIETARY INFORMATION                        *
 *                                                                      *
 *     This software is supplied under the terms of a licence           *
 *     agreement with Intel Corporation and may not be copied nor       *
 *     disclosed except in accordance with the terms of that agreement. *
 *                                                                      *
 ************************************************************************

 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   HISTORY:

 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
@

COMMENT @
Data values
@
CommonVersion EQU 1


COMMENT @
Video dispatch codes

These should match the VID_DISPATCH enumerated values in VDIHDW.H
@
VDSP_SETBANK     EQU  1
VDSP_SAVECONTEXT EQU  2
VDSP_RESTCONTEXT EQU  3
VDSP_SETTARGET   EQU  4
VDSP_IDENTIFY    EQU  5
VDSP_VERSION     EQU  6
VDSP_QUERYBANK   EQU  7
VDSP_SCANWIDTH   EQU  8
VDSP_TERMINATE   EQU  9


COMMENT @
Macro Dispatch:
Code common to all hardware dispatchers
@
Dispatch MACRO
         PUSH    BP               ;; Establish stack addressability
         MOV     BP, SP           ;;
         XCHG    [BP+6], AX       ;; Get dispatch code, save AX
         POP     BP               ;; Restore register and stack pointer
         CMP     AX, VDSP_SAVECONTEXT
         JE      SaveBank         ;; Skip if SaveBank
         CMP     AX, VDSP_RESTCONTEXT
         JE      RestBank         ;; Skip if RestoreBank
         CMP     AX, VDSP_SETTARGET
         JE      SetTarget        ;; Skip if SetTarget
         CMP     AX, VDSP_SETBANK
         JE      SetBank          ;; Skip if SetBank
         CMP     AX, VDSP_IDENTIFY
         JE      Identify         ;; Skip if Identify
         CMP     AX, VDSP_VERSION
         JE      GetVersion       ;; Skip if GetVersion
         CMP     AX, VDSP_QUERYBANK
         JE      QueryBank        ;; Skip if Banktable
         CMP     AX, VDSP_SCANWIDTH
         JE      ScanWidth        ;; Skip if ScanWidth
         CMP     AX, VDSP_TERMINATE
         JE      Terminate        ;; Skip if Terminate
                                  ;; Unknown dispatch code
         MOV     AX, [BP+6]       ;; Restore caller's register
         RET                      ;; Return to caller
         ENDM


COMMENT @
Macro DispStubs:
Default versions of any undefined dispatch routines

Identify is the one routine that must be defined
@
DispStubs MACRO

         IFNDEF  SaveBank
         ALIGN   16
SaveBank PROC    FAR SaveAX:WORD, HideCursor:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET
SaveBank ENDP
         ENDIF                    ;; of IFNDEF SaveBank

         IFNDEF  RestBank
         ALIGN   16
RestBank PROC    FAR SaveAX:WORD, ShowCursor:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET
RestBank ENDP
         ENDIF                    ;; of IFNDEF RestBank

         IFNDEF  SetTarget
         ALIGN   16
SetTarget PROC   FAR SaveAX:WORD, OffsetLo:WORD, OffsetHi:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET                      ;; Return to caller
SetTarget ENDP
         ENDIF                    ;; of IFNDEF SetTarget

         IFNDEF  SetBank
         ALIGN   16
SetBank  PROC    FAR SaveAX:WORD, BankID:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET
SetBank  ENDP
         ENDIF                    ;; of IFNDEF SetBank

         IFNDEF  GetVersion
GetVersion PROC  FAR SaveAX:WORD
         MOV     AX, CommonVersion ;; Set return code to common version
         RET
GetVersion ENDP
         ENDIF                    ;; of IFNDEF GetVersion

         IFNDEF  QueryBank
QueryBank PROC   FAR SaveAX:WORD
         XOR     AX, AX           ;; Set return code to FALSE
         RET
QueryBank ENDP
         ENDIF                    ;; of IFNDEF QueryBank

         IFNDEF  ScanWidth
ScanWidth PROC   FAR SaveAX:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET
ScanWidth ENDP
         ENDIF                    ;; of IFNDEF ScanWidth

         IFNDEF  Terminate
         ALIGN   16
Terminate PROC   FAR SaveAX:WORD
         MOV     AX, SaveAX       ;; Restore caller's AX
         RET                      ;; Return to caller
Terminate ENDP
         ENDIF                    ;; of IFNDEF Terminate

         ENDM                     ;; of DispStubs MACRO

