
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit VirtIntf;

interface

const
  FaultHandlerSignature = '__VCLFAULTHANDLER';

type
  TInterface = class
  public
    procedure Free;
    procedure Release; virtual; export;
    function GetVersion: Integer; virtual; export;
  end;

  { TIStream - This provides a pure virtual interface to a physical stream }

  TIStream = class(TInterface)
  public
    function Read(var Buffer; Count: Longint): Longint; virtual; export; abstract;
    function Write(const Buffer; Count: Longint): Longint; virtual; export; abstract;
    function Seek(Offset: Longint; Origin: Word): Longint; virtual; export; abstract;
    function GetModifyTime: Longint; virtual; export; abstract;
  end;

function ReleaseException: string;

implementation

uses SysUtils;

{ TInterface }

procedure TInterface.Free;
begin
  if Self <> nil then Release;
end;

procedure TInterface.Release;
begin
  Destroy;
end;

function TInterface.GetVersion: Integer;
begin
  Result := 0;
end;

{ Exception handling }

function ReleaseException: string;
type
  TRaiseFrame = record
    NextRaise: Word;
    ExceptAddr: Pointer;
    ExceptObject: TObject;
    NextExcept: Word;
  end;
begin
  with TRaiseFrame(Ptr(SSeg, RaiseList)^) do
  begin
    Result := Exception(ExceptObject).Message;
    ExceptObject.Destroy;
    RaiseList := NextRaise;
    ExceptList := NextExcept;
  end;
end;

end.
