
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit ToolIntf;

interface

uses WinTypes, VirtIntf;

type
  { The Tool services object is created on the application side, and is
    passed to the VCS/Expert Manager DLL during initialization.  Note that
    the application is responsible for creating and freeing the interface
    object, and the client should never free the interface.

    The following functions are available to the client:

    ( Actions )

    CloseProject     - returns True if no project open, or if the currently
                       open project can be closed.

    OpenProject      - returns True if the named project can be opened.  Pass an
                       empty string to create a new project and main form.

    OpenProjectInfo  - returns True if the named project file can be opened.
                       This routine bypasses all the normal project load
                       features (such as loading a desktop file, showing
                       the source code, etc), and simply opens the .DPJ and
                       .OPT files.

    SaveProject      - returns True if the project is unmodified, if there
                       is no project open, or if the open project can be saved.

    CloseFile        - returns True if the specified file is not currently
                       open, or if it can be closed.

    OpenFile         - returns True if the specified file is already open
                       or can be opened.

    ReloadFile       - returns True if the file is already open and was
                       reloaded from disk.  (NOTE: This will not perform any
                       checking of the current editor state).

    RefreshBuffers   - causes the IDE to check the time/date stamp of each open
                       file to determine if the file has changed on disk.  If so,
                       the file is re-read.

    ModalDialogBox   - used by non-VCL DLL's to present a dialog box which is
                       modal.  Note that DLLs written using VCL can simply call
                       a form's ShowModal function.

    CreateModule     - Will create new module from memory images of the source
                       and, optionally, the form file.  The TCreateModuleFlags are:
      cmAddToProject - Add the new module to the currently open project.
      cmShowSource   - Show the source file in the top-most editor window.
      cmShowForm     - If a form is created, show it above the source.
      cmUnNamed      - Will mark the module as unnamed which will cause the
                       SaveAs dialog to show the first time the user attempts to
                       save the file.
      cmNewUnit      - Creates a new unit and adds it to the current project.
                       NOTE: all other parameters are ignored.
      cmNewForm      - Creates a new form and adds it to the current project.
                       NOTE: all other parameters are ignored.
      cmMainForm     - If the module includes a form, make it the main form of
                       the currently open project. Only valid with the
                       cmAddToProject option.
      cmMarkModified - Will insure that the new module is marked as modified.

    ( Informational )

    GetParentHandle  - returns a HWND, which should be used as the parent for
                       any windows created by the client.

    GetProjectName   - returns a fully qualified path name of the currently
                       open project file, or an empty string if no project is
                       open.

    GetUnitCount     - returns the current number of units belonging to the
                       project.

    GetUnitName      - returns a fully qualified name of the specified unit.

    GetFormCount     - returns the current number of forms belonging to the
                       project.

    GetFormName      - returns a fully qualified name of the specified form
                       file.

    GetCurrentFile   - returns a fully qualified name of the current file,
                       which could either be a form or unit (.PAS).
                       Returns a blank string if no file is currently selected.

    IsFileOpen       - returns True if the named file is currently open.

    GetNewModuleName - Automatically generates a valid Filename and Unit
                       identifier.  Uses the same mechanism as used by the IDE.

    ( Component library interface )

    GetModuleCount   - Returns the number of currently installed modules in the
                       component library.

    GetModuleName    - Returns then name of the module given its index.

    GetComponentCount- Returns the number of components installed in a particular
                       module.

    GetComponentName - Returns the name of the component given its module index
                       and index in that mnodule.

    ( Error handling )

    RaiseException   - This will cause an Exception to be raised with the IDE
                       with the string passed to this function.  ***NOTE: This
                       will cause the stack to unwind and control will **NOT**
                       return to this point.  It is the resposibility of the
                       Library to be sure it has correctly handled the error
                       condition before calling this procedure.
    }

  TCreateModuleFlags = set of (cmAddToProject, cmShowSource, cmShowForm,
    cmUnNamed, cmNewUnit, cmNewForm, cmMainForm, cmMarkModified);

  TIToolServices = class(TInterface)
  public
    { Action interfaces }
    function CloseProject: Boolean; virtual; export; abstract;
    function OpenProject(const ProjName: string): Boolean; virtual; export; abstract;
    function OpenProjectInfo(const ProjName: string): Boolean; virtual; export; abstract;
    function SaveProject: Boolean; virtual; export; abstract;
    function CloseFile(const FileName: string): Boolean; virtual; export; abstract;
    function SaveFile(const FileName: string): Boolean; virtual; export; abstract;
    function OpenFile(const FileName: string): Boolean; virtual; export; abstract;
    function ReloadFile(const FileName: string): Boolean; virtual; export; abstract;
    function ModalDialogBox(Instance: THandle; TemplateName: PChar;  WndParent: HWnd;
      DialogFunc: TFarProc; InitParam: LongInt): Integer; virtual; export; abstract;
    function CreateModule(const ModuleName: string; Source, Form: TIStream;
      CreateFlags: TCreateModuleFlags): Boolean; virtual; export; abstract;

    { Project/UI information }
    function GetParentHandle: HWND; virtual; export; abstract;
    function GetProjectName: string; virtual; export; abstract;
    function GetUnitCount: Integer; virtual; export; abstract;
    function GetUnitName(Index: Integer): string; virtual; export; abstract;
    function GetFormCount: Integer; virtual; export; abstract;
    function GetFormName(Index: Integer): string; virtual; export; abstract;
    function GetCurrentFile: string; virtual; export; abstract;
    function IsFileOpen(const FileName: string): Boolean; virtual; export; abstract;
    function GetNewModuleName(var UnitIdent, FileName: string): Boolean; virtual; export; abstract;

    { Component Library interface }
    function GetModuleCount: Integer; virtual; export; abstract;
    function GetModuleName(Index: Integer): string; virtual; export; abstract;
    function GetComponentCount(ModIndex: Integer): Integer; virtual; export; abstract;
    function GetComponentName(ModIndex, CompIndex: Integer): string; virtual; export; abstract;
    {function InstallModule(const ModuleName: string): Boolean; virtual; export; abstract;
    function CompileLibrary: Boolean; virtual; export; abstract;}

    { Error handling }
    procedure RaiseException(const Message: string); virtual; export; abstract;
  end;

implementation

end.
