
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit ProcDlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, DBTables;

type
  TProcParams = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ParamValue: TEdit;
    Label2: TLabel;
    NullValue: TCheckBox;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label3: TLabel;
    TypeList: TComboBox;
    ParamTypeList: TComboBox;
    Label4: TLabel;
    ParamList: TListBox;
    AddButton: TBitBtn;
    DeleteButton: TBitBtn;
    ClearButton: TBitBtn;
    HelpBtn: TBitBtn;
    procedure ParamListChange(Sender: TObject);
    procedure TypeListChange(Sender: TObject);
    procedure ParamValueExit(Sender: TObject);
    procedure NullValueClick(Sender: TObject);
    procedure ParamTypeListChange(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
  private
    InitList: TParams;
    PressedOK: Boolean;
    AlterParamList: Boolean;
    InValueExit: Boolean;
    InParamChange: Boolean;
    function AcceptFieldClass(Value: TFieldClass): Boolean;
    procedure CheckValue;
    procedure Edit;
    procedure InitValues;
    procedure SetControls(Value: Boolean);
    procedure Unbind;
  end;

function EditProcParams(DataSet: TStoredProc; List: TParams): Boolean;

implementation

uses DBConsts, Paramdlg, LibHelp;

{$R *.DFM}

var
  FieldTypes: array[TFieldType] of PString;
  ParamTypes: array[TParamType] of PString;

procedure FillFieldTypes;
var
  ParamString: string;
  I: Integer;
  J: TFieldType;
begin
  ParamString := LoadStr(SDataTypes);
  J := Low(TFieldType);
  I := 1;
  while I <= Length(ParamString) do
  begin
    AssignStr(FieldTypes[J], ExtractFieldName(ParamString, I));
    Inc(J);
  end;
end;

function GetFieldType(const Value: string): TFieldType;
begin
  for Result := Low(TFieldType) to High(TFieldType) do
    if FieldTypes[Result]^ = Value then Exit;
  Result := ftUnknown;
end;

procedure ClearFieldTypes;
var
  I: TFieldType;
begin
  for I := Low(TFieldType) to High(TFieldType) do
    DisposeStr(FieldTypes[I]);
end;

procedure FillParamTypes;
var
  I: Integer;
  J: TParamType;
  ParamString: string;
begin
  ParamString := LoadStr(SParameterTypes);
  J := Low(ParamTypes);
  I := 1;
  while I <= Length(ParamString) do
  begin
    AssignStr(ParamTypes[J], ExtractFieldName(ParamString, I));
    Inc(J);
  end;
end;

function GetParamType(const Value: string): TParamType;
begin
  for Result := Low(TParamType) to High(TParamType) do
    if ParamTypes[Result]^ = Value then Exit;
  Result := ptUnknown;
end;

procedure ClearParamTypes;
var
  I: TParamType;
begin
  for I := Low(TParamType) to High(TParamType) do
    DisposeStr(ParamTypes[I]);
end;

function EditProcParams(DataSet: TStoredProc; List: TParams): Boolean;
begin
  with TProcParams.Create(Application) do
  try
    Caption := Format(LoadStr(SParamEditor), [DataSet.Owner.Name, DataSet.Name]);
    InitList := List;
    AlterParamList := not DataSet.DescriptionsAvailable;
    Edit;
    Result := PressedOk;
  finally
    Free;
  end;
end;

procedure TProcParams.SetControls(Value: Boolean);
begin
  ParamValue.Enabled := Value;
  NullValue.Enabled := Value;
  TypeList.Enabled := Value;
  ParamTypeList.Enabled := Value;
end;

procedure TProcParams.InitValues;
begin
  TypeList.ItemIndex := -1;
  ParamTypeList.ItemIndex := -1;
  ParamValue.Text := '';
  NullValue.Checked := False;
end;

function TProcParams.AcceptFieldClass(Value: TFieldClass): Boolean;
begin
  Result := (Value <> TBlobField) and (Value <> TGraphicField) and
    (Value <> TMemoField);
end;

procedure TProcParams.Edit;
var
  I: Integer;
  J: TFieldType;
  K: TParamType;
  Field: TFieldClass;
  ParamString: string;
begin
  for J := Low(TFieldType) to High(TFieldType) do
    if FieldTypes[J]^ <> '' then TypeList.Items.Add(FieldTypes[J]^);

  for K := Low(ParamTypes) to High(ParamTypes) do
    if ParamTypes[K]^ <> '' then ParamTypeList.Items.Add(ParamTypes[K]^);

  if AlterParamList then
  begin
    AddButton.Enabled := True;
    ClearButton.Enabled := InitList.Count <> 0;
    DeleteButton.Enabled := InitList.Count <> 0;
  end;
  if InitList.Count = 0 then SetControls(False)
  else begin
    for I := 0 to InitList.Count - 1 do
      if ParamList.Items.IndexOf(InitList[I].Name) = -1 then
        ParamList.Items.Add(InitList[I].Name);
    ParamList.ItemIndex := 0;
    if ParamList.Items.Count > 0 then ParamListChange(Self);
    ActiveControl := OkBtn;
  end;
  PressedOk := ShowModal = mrOK;
end;

procedure TProcParams.ParamListChange(Sender: TObject);
begin
  InParamChange := True;
  try
    with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
    begin
      if FieldTypes[DataType]^ <> '' then
      begin
        with TypeList do ItemIndex := Items.IndexOf(FieldTypes[DataType]^);
        if Bound then ParamValue.Text := AsString
        else ParamValue.Text := '';
        with ParamTypeList do ItemIndex := Items.IndexOf(ParamTypes[ParamType]^);
        ParamTypeListChange(Sender);
        NullValue.Checked := IsNull;
      end
      else InitValues;
    end;
  finally
    InParamChange := False;
  end;
end;

procedure TProcParams.TypeListChange(Sender: TObject);
begin
  with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
  begin
    DataType := GetFieldType(TypeList.Text);
    ParamValue.Text := '';
    NullValue.Checked := IsNull;
  end;
end;

procedure TProcParams.ParamValueExit(Sender: TObject);
begin
  if InValueExit or (ActiveControl = CancelBtn) then Exit;
  InValueExit := True;
  try
    if ParamValue.Text <> '' then NullValue.Checked := False;
    if TypeList.Text = '' then
    begin
      TypeList.SetFocus;
      raise Exception.Create(LoadStr(SInvalidParamFieldType));
    end;
    if ParamValue.Text = '' then
      with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
      begin
        if NullValue.Checked then Clear
        else Unbind;
      end
    else CheckValue;
  finally
    InValueExit := False;
  end;
end;

procedure TProcParams.CheckValue;
begin
  try
    InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]).Text := ParamValue.Text;
  except
    with ParamValue do
    begin
      SetFocus;
      SelectAll;
    end;
    raise;
  end;
end;

procedure TProcParams.Unbind;
begin
  with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
  begin
    AsInteger := 1;
    DataType := GetFieldType(TypeList.Text);
    Bound := False;
  end;
end;

procedure TProcParams.NullValueClick(Sender: TObject);
begin
  if InParamChange then Exit;
  if NullValue.Checked then
    with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
    begin
      Clear;
      ParamValue.Text := '';
    end
  else Unbind;
end;

procedure TProcParams.ParamTypeListChange(Sender: TObject);
begin
  with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
  begin
    ParamType := GetParamType(ParamTypeList.Text);
    if ParamType in [ptResult, ptOutput] then
    begin
      ParamValue.Text := '';
      NullValue.Checked := False;
    end;
    NullValue.Enabled := not (ParamType in [ptOutput, ptResult]);
    ParamValue.Enabled := not (ParamType in [ptOutput, ptResult]);
  end;
end;

procedure TProcParams.AddButtonClick(Sender: TObject);
begin
  with TParamDlg.Create(Self) do
  try
    ActiveControl := ParamName;
    ParamName.Text := '';
    ParamTypes.Items.Assign(TypeList.Items);
    if (ShowModal = mrOK) and (ParamName.Text <> '') then
    begin
      SetControls(True);
      ClearButton.Enabled := True;
      DeleteButton.Enabled := True;
      with TParam.Create(InitList, ptUnknown) do
      begin
        Name := ParamName.Text;
        DataType := GetFieldType(ParamTypes.Text);
        ParamList.ItemIndex := ParamList.Items.Add(Name);
        ParamListChange(Self);
      end;
    end;
  finally
    Free;
  end;
end;

procedure TProcParams.DeleteButtonClick(Sender: TObject);
begin
  with ParamList do
    if ItemIndex <> -1 then
    begin
      InitList.ParamByName(Items[ItemIndex]).Free;
      Items.Delete(ItemIndex);
    end;
  if InitList.Count = 0 then ClearButtonClick(Sender)
  else begin
    ParamList.ItemIndex := 0;
    ParamListChange(Self);
  end;
end;

procedure TProcParams.ClearButtonClick(Sender: TObject);
begin
  ParamList.Clear;
  InitValues;
  SetControls(False);
  ClearButton.Enabled := False;
  DeleteButton.Enabled := False;
  InitList.Clear;
end;

procedure TProcParams.OkBtnClick(Sender: TObject);
begin
  if not TypeList.Enabled then Exit;
  try
    ParamValueExit(Sender);
  except
    ModalResult := 0;
    raise;
  end;
end;

procedure DoneDlg; far;
begin
  ClearFieldTypes;
  ClearParamTypes;
end;

procedure TProcParams.FormCreate(Sender: TObject);
begin
  HelpContext := hcDStoredProcedure;
end;

begin
  FillFieldTypes;
  FillParamTypes;
  AddExitProc(DoneDlg);
end.
