
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit Exptintf;

interface

uses WinTypes, VirtIntf, ToolIntf;

const
  isExperts = 'Experts';
  ExpertEntryPoint = 'INITEXPERT0012';

type
  TExpertStyle = (esStandard, esForm, esProject);
  TExpertState = set of (esEnabled, esChecked);

  {
    This is the declaration of the pure-virtual base class for the expert
    interface within the Delphi IDE.

    GetName -      REQUIRED.  This must return a unique descriptive name
                   identifying this expert.
    GetComment -   REQUIRED if style is esForm or es Project.  This should
                   return a 1 - 2 sentence describing the function of this
                   expert.
    GetGlyph -     REQUIRED if style is esForm or esProject.  This should
                   return a handle to a bitmap to be displayed in the form or
                   project list boxes or dialogs.  This bitmap should be
                   60x40 pixels.
    GetStyle -     REQUIRED.  Returns one of three possible values:
                   esStandard - Tells the IDE to treat the interface to
                                this expert as a menu item on the Help menu.
                   esForm     - Tells the IDE to treat this expert interface
                                in a fashion similar to form templates.
                   esProject  - Tells the IDE to treat this interface in a
                                fashion similar to project templates.
    GetState -     REQUIRED. If the style is esStandard, esChecked will cause
                   the menu to display a checkmark. NOTE: This function is
                   called each time the expert is shown in a menu or listbox in
                   order to determine how it should be displayed.
    GetIDString -  REQUIRED. This ID string should be unique to all experts
                   that could be installed.  By convention, the format of the
                   string is:
                   CompanyName.ExpertFunction, ex. Borland.WidgetExpert
    GetMenuText -  REQURED if style is esStandard.  This should return the
                   actual text to display for the menu item. NOTE: This
                   function is called each time the parent menu is pulled-down,
                   so it is possible to provide context sensative text.

    Execute -      REQUIRED. Called whenever this expert is invoked via the
                   menu, form gallery dialog, or project gallery dialog.  The
                   style will determine how the expert was invoked.


    TExpertInitProc - defines the number and types of parameters passed to the
                      single exported entry-point to the expert DLL.
                      ToolServices - a pure-virtual class containing all the
                                     tool services provided by the IDE.
                      RegisterProc - The function to call in order to register
                                     an expert.  NOTE: This function is called
                                     once for each expert instance that the DLL
                                     wants to register with the IDE.
                      Terminate -    Set this parameter to point to a procedure
                                     that will be called immediately before the
                                     expert DLL is unloaded by the IDE.  Leave
                                     nil, if not needed.
  }

  TIExpert = class(TInterface)
  public
    { Expert UI strings }
    function GetName: string; virtual; export; abstract;
    function GetComment: string; virtual; export; abstract;
    function GetGlyph: HBITMAP; virtual; export; abstract;
    function GetStyle: TExpertStyle; virtual; export; abstract;
    function GetState: TExpertState; virtual; export; abstract;
    function GetIDString: string; virtual; export; abstract;
    function GetMenuText: string; virtual; export; abstract;

    { Launch the Expert }
    procedure Execute; virtual; export; abstract;
  end;

  TExpertRegisterProc = function(Expert: TIExpert): Boolean;
  TExpertTerminateProc = procedure;
  TExpertInitProc = function(ToolServices: TIToolServices;
    RegisterProc: TExpertRegisterProc;
    var Terminate: TExpertTerminateProc): Boolean;

const
  LibraryExpertProc: TExpertRegisterProc = nil;
  ToolServices: TIToolServices = nil;

procedure RegisterLibraryExpert(Expert: TIExpert);

implementation

procedure RegisterLibraryExpert(Expert: TIExpert);
begin
  if @LibraryExpertProc <> nil then
    LibraryExpertProc(Expert);
end;

end.

