
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Termination Procedures Module			*
; *							*
; *	Copyright (c) 1988,95 Borland International	*
; *							*
; *******************************************************

	TITLE	EXIT

	INCLUDE	SE.ASM

    IF DPMIVersion
	.286P
    ENDIF

CONST	SEGMENT	WORD PUBLIC

; Runtime error message string

ErrorStr	DB	'Runtime error '
ErrorCodeStr	DB	'000 at '
ErrorAddrStr	DB	'0000:0000.'

    IF WindowsVersion
	DB	0
    ELSE
	DB	cr,lf,'$'
    ENDIF

CONST	ENDS

DATA	SEGMENT WORD PUBLIC

; Externals

	EXTRN	ExitProc:DWORD,ExitCode:WORD,ErrorAddr:DWORD
	EXTRN	PrefixSeg:WORD,InOutRes:WORD,ErrorProc:DWORD
    IF WindowsVersion OR DPMIVersion
	EXTRN	HaltVector:WORD
    ENDIF
    IF NOT WindowsVersion AND NOT DPMIVersion
	EXTRN	OvrLoadList:WORD
    ENDIF

DATA	ENDS

DGROUP	GROUP	CONST,DATA

    IF WindowsVersion
	EXTRN	MessageBox:FAR
    ENDIF

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DGROUP

; Publics

	PUBLIC	Error,ErrorStack,HaltTurbo,HaltError
	PUBLIC	Terminate,DoExitProcs

; Runtime error with address on stack
; In	AX = Error code

ErrorStack:

	POP	CX
	POP	BX

; Runtime error
; In	AX    = Error code
;	BX:CX = Error address

Error:

    IF NOT WindowsVersion
	MOV	DX,SEG DATA		;Reset DS
	MOV	DS,DX
	STI				;Enable interrupts
    ENDIF
	MOV	DX,ErrorProc.ofs	;Error handler installed?
	OR	DX,ErrorProc.seg
	JE	@@1			;No, @@1
	PUSH	AX			;Push error code
	PUSH	BX			;Push error address
	PUSH	CX
	CALL	ErrorProc		;Call error handler (never returns)
@@1:	MOV	DI,AX
	MOV	AX,InOutRes
	OR	DI,DI			;Was it an I/O error?
	JE	Terminate		;Yes, Terminate
	MOV	AL,CS:ErrorTable[DI-1]	;Convert to runtime error code
	XOR	AH,AH
	JMP	SHORT Terminate		;Terminate

; Runtime error code conversion table

ErrorTable	LABEL	BYTE

	DB	203			;reOutOfMemory
	DB	204			;reInvalidPtr
	DB	200			;reDivByZero
	DB	201			;reRangeError
	DB	215			;reIntOverflow
	DB	207			;reInvalidOp
	DB	200			;reZeroDivide
	DB	205			;reOverflow
	DB	206			;reUnderflow
	DB	219			;reInvalidCast

; RunError standard procedure

HaltError:

	POP	CX
	POP	BX
	JMP	SHORT Terminate

; Halt standard procedure

HaltTurbo:

	XOR	CX,CX
	XOR	BX,BX

; Terminate program
; In	AX    = Exit code
;	BX:CX = Error address (or NIL)

Terminate:

    IF NOT WindowsVersion
	MOV	DX,SEG DATA		;Reset DS
	MOV	DS,DX
	STI				;Enable interrupts
    ENDIF
	MOV	ExitCode,AX		;Save exit code
	MOV	AX,CX			;Is error address NIL?
	OR	AX,BX
	JE	@@10			;Yes, @@10
    IF WindowsVersion
	CMP	BX,0FFFFH		;Unknown address?
	JE	@@10			;Yes, @@10
	MOV	ES,BX			;Get logical segment number
	MOV	BX,WORD PTR ES:0
    ELSE
    IF DPMIVersion
	VERR	BX			;Valid selector?
	JE	@@1			;Yes, @@1
	MOV	BX,0FFFFH		;Unknown address
	MOV	CX,BX
 	JMP	SHORT @@10
@@1:	MOV	ES,BX			;Get logical segment number
	MOV	BX,WORD PTR ES:0
    ELSE
	MOV	AX,OvrLoadList		;Convert physical overlay
@@1:	OR	AX,AX			;address to virtual address
	JE	@@4
	MOV	ES,AX
	MOV	AX,ES:ovSegment
	OR	AX,AX
	JE	@@2
	SUB	AX,BX
	JA	@@2
	NEG	AX
	CMP	AX,1000H
	JAE	@@2
	MOV	DX,16
	MUL	DX
	ADD	AX,CX
	JC	@@2
	CMP	AX,ES:ovCodeSize
	JB	@@3
@@2:	MOV	AX,ES:ovNext
	JMP	@@1
@@3:	MOV	CX,AX
	MOV	BX,ES
@@4:	SUB	BX,PrefixSeg		;Adjust address
	SUB	BX,10H
    ENDIF
    ENDIF
@@10:	MOV	ErrorAddr.ofs,CX	;Save error address
	MOV	ErrorAddr.seg,BX
    IF WindowsVersion OR DPMIVersion
	CMP	HaltVector,0		;In library initialization code?
	JNE	@@11			;Yes, do exit procs
	CMP	PrefixSeg,0		;Is this a library?
	JE	@@12			;Yes, WEP will do exit procs
    ENDIF
@@11:	CALL	DoExitProcs		;Execute exit procedures
@@12:	MOV	AX,ErrorAddr.ofs	;Runtime error?
	OR	AX,ErrorAddr.seg
	JE	@@13			;No, @@13
	MOV	CX,10
	MOV	AL,ExitCode.b0
	XOR	AH,AH
	MOV	BX,OFFSET ErrorCodeStr+3
	CALL	Num2Str
	MOV	CX,16
	MOV	AX,ErrorAddr.seg
	MOV	BX,OFFSET ErrorAddrStr+4
	CALL	Num2Str
	MOV	AX,ErrorAddr.ofs
	MOV	BX,OFFSET ErrorAddrStr+9
	CALL	Num2Str
    IF WindowsVersion
	XOR	AX,AX
	PUSH	AX			;hWndParent
	MOV	BX,OFFSET ErrorStr
	PUSH	DS			;lpText
	PUSH	BX
	PUSH	AX			;lpCaption
	PUSH	AX
	MOV	AX,1010H		;MB_OK+MB_ICONHAND+MB_SYSTEMMODAL
	PUSH	AX			;wType
	CALL	MessageBox
    ELSE
	MOV	AH,9
	MOV	DX,OFFSET ErrorStr
	INT	DOS
    ENDIF
@@13:
    IF WindowsVersion OR DPMIVersion
	MOV	AX,HaltVector
	OR	AX,AX
	JE	@@14
	JMP	AX
    ENDIF
@@14:	MOV	AL,ExitCode.b0		;Get exit code
	MOV	AH,dosExit		;Terminate application
	INT	DOS

; Execute exit procedures

DoExitProcs:

@@1:	LES	BX,ExitProc
	MOV	AX,ES
	OR	AX,BX
	JE	@@2
	XOR	AX,AX
	MOV	ExitProc.ofs,AX
	MOV	ExitProc.seg,AX
	MOV	InOutRes,AX
	MOV	AX,OFFSET @@1
	PUSH	CS
	PUSH	AX
	PUSH	ES
	PUSH	BX
	RETF
@@2:	RET

; Convert number to string
; In	AX = Number
;	BX = Pointer to end of buffer
;	CX = Number base

Num2Str:

@@1:	XOR	DX,DX
	DIV	CX
	ADD	DL,'0'
	CMP	DL,'0'+10
	JB	@@2
	ADD	DL,'A'-'0'-10
@@2:	DEC	BX
	MOV	[BX],DL
	OR	AX,AX
	JNE	@@1
	RET

; Copyright notice

Copyright	DB	'Borland Delphi',cr,lf
		DB	'Portions Copyright (c) 1983,95 Borland',cr,lf
		DB	0

CODE	ENDS

	END
