
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Exception handling				*
; *							*
; *	Copyright (c) 1993,95 Borland International	*
; *							*
; *******************************************************

	TITLE	EXCP

	INCLUDE	SE.ASM

DATA	SEGMENT	WORD PUBLIC

; Externals

	EXTRN	ExceptList:WORD,RaiseList:WORD,ExceptProc:DWORD
	EXTRN	ExceptionClass:DWORD,ExceptDebugPtr:DWORD

; Debugger interface record

DebugRec	LABEL	BYTE

	DD	0		;dhMagic1
	DD	0		;dhZero
	DD	0		;dhMagic1
        DD	0		;dhHookProc
	DD	0		;dhDebugHooked
	DW	0		;dhKind
	DD	6 DUP(0)	;dhAddr, dhCookie, dhName, dhMsg
        DD	0		;dhWantException
	DD	0		;dhDoneExcept

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

; Externals

	EXTRN	HaltError:NEAR,HaltTurbo:NEAR,CheckInstance:NEAR

; Publics

	PUBLIC	RaiseExcept,RaiseAgain,DoneExcept,TryStatExit
	PUBLIC	InitExceptHook

; Re-raise exception

RaiseAgain:

	MOV	BP,ExceptList		;Remove finally handler for
	MOV	AX,[BP].efNext		;current exception
	MOV	ExceptList,AX
	MOV	SP,RaiseList		;Re-raise current exception
	POP	RaiseList
	JMP	SHORT ContinueRaise	;Don't notify debugger of a re-raise

; Raise exception

RaiseExcept:

	CALL	NotifyRaise

ContinueRaise:

	PUSH	DS
	MOV	BP,ExceptList
	JMP	SHORT @@5
@@1:	LES	DI,[BP].efDescriptor
	MOV	CX,ES:[DI].edCount
	JCXZ	ExecFinally
	INC	DI
	INC	DI
@@2:	MOV	AX,ES:[DI].ehClass.ofs
	MOV	DX,ES:[DI].ehClass.seg
	MOV	BX,AX
	OR	BX,DX
	JE	ExecHandler
	MOV	SI,SP
	LDS	SI,SS:[SI+6]
	LDS	SI,[SI]
@@3:	CMP	SI,AX
	JNE	@@4
	MOV	BX,DS
	CMP	BX,DX
	JE	ExecHandler
@@4:	LDS	SI,[SI].vtParent
	MOV	BX,DS
	OR	BX,SI
	JNE	@@3
	ADD	DI,ehRecSize
	LOOP	@@2
	MOV	BP,[BP].efNext
@@5:	OR	BP,BP
	JNE	@@1
	POP	DS
	MOV	AX,ExceptProc.ofs
	OR	AX,ExceptProc.seg
	JE	@@6
	CALL	NotifyUnexpected
	CALL	ExceptProc
@@6:	MOV	AX,217
	JMP	HaltError

; Execute finally handler

ExecFinally:

	POP	DS
	MOV	AX,[BP].efNext
	MOV	ExceptList,AX
	MOV	BP,[BP].efStackFrame
	CALL	NotifyFinally
	CALL	ES:[DI].edFinally
	JMP	ContinueRaise

; Execute exception handler

ExecHandler:

	POP	DS			;Restore DS
	POP	CX			;Pop exception address
	POP	BX
	POP	AX			;Pop exception object pointer
	POP	DX
	MOV	SP,BP			;Unwind the stack
	MOV	ExceptList,BP		;Unwind exception handler chain
	MOV	[BP].efDescriptor.ofs,OFFSET CS:ExceptFinally
	MOV	[BP].efDescriptor.seg,CS
	MOV	BP,[BP].efStackFrame	;Unwind BP
	PUSH	DX			;Push exception object pointer
	PUSH	AX
	PUSH	BX			;Push exception address
	PUSH	CX
	PUSH	RaiseList		;Push raised exception list
	MOV	RaiseList,SP		;Insert new entry on raised list
	CALL	NotifyExcept		;Notify debugger of an exception
	JMP	ES:[DI].ehAddress	;Execute handler (DX:AX = object)

; Exception handler cleanup

DoneExcept:

	CALL	NotifyTerminated
	PUSH	BP
	PUSH	CS			;Destroy exception object
	CALL	DestroyExcept
	MOV	BP,ExceptList		;Remove finally handler
	MOV	AX,[BP].efNext
	MOV	ExceptList,AX
	POP	BP
	RETF	18

; Finally handler for exception handler

ExceptFinally	LABEL	BYTE

	DW	0
	DD	DestroyExcept

; Destroy current exception object

DestroyExcept:

	MOV	BP,RaiseList
	MOV	AL,1
	PUSH	AX
	LES	DI,[BP+6]
	PUSH	ES
	PUSH	DI
	LES	DI,ES:[DI]
	CALL	ES:[DI].vtDestroy
	MOV	AX,[BP]
	MOV	RaiseList,AX
	RETF

; Exit from TRY statement

TryStatExit:

	MOV	BX,SP
	MOV	AX,SS:[BX+4].efNext
	MOV	ExceptList,AX
	LES	DI,SS:[BX+4].efDescriptor
	CMP	ES:[DI].edCount,0
	JNE	@@1
	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@0
	MOV	DebugRec.dhKind,evFinally
	PUSH	ES:[DI].edFinally.ofs
	POP	DebugRec.dhAddr.ofs
	PUSH	ES:[DI].edFinally.seg
	POP	DebugRec.dhAddr.seg
	CALL	HookProc
@@0:	CALL	ES:[DI].edFinally
@@1:	RETF	8

; Debugger Hook

HookProc:

	NOP
	RET

; Notify debugger of a raise

NotifyRaise:

	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@2
	MOV	BX,SP
	MOV	SI,6
	CALL	IsExceptionClass
	JNE	@@2
	PUSH	BP
	MOV	BP,SP
	MOV	AX,[BP+4].ofs		;Return address
	MOV	DebugRec.dhAddr.ofs,AX
        MOV	AX,[BP+4].seg
	MOV	DebugRec.dhAddr.seg,AX
	XOR	AX,AX
	MOV	DebugRec.dhNameLen.w0,AX
	MOV	DebugRec.dhMsgLen.w0,AX
	LES	DI,[BP+8]		;Exception object
	MOV	AX,ES
	OR	AX,DI
	JE	@@2
	LES	DI,ES:[DI]
	MOV	DI,ES:[DI].vtClassName
	MOV	AL,ES:[DI]
	INC	DI
	MOV	DebugRec.dhNameLen.b0,AL
	MOV	DebugRec.dhName.ofs,DI
	MOV	DebugRec.dhName.seg,ES
	LES	DI,[BP+8]
	LES	DI,ES:[DI+4]
	MOV	AX,ES
	OR	AX,DI
	JE	@@1
	MOV	AL,ES:[DI]
	INC	DI
	MOV	DebugRec.dhMsgLen.b0,AL
	MOV	DebugRec.dhMsg.ofs,DI
	MOV	DebugRec.dhMsg.seg,ES
@@1:	MOV	DebugRec.dhKind,evRaise
	POP	BP
	CALL	HookProc
@@2:	RET

; Notify debugger of a finally style catch

NotifyFinally:

	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@1
	MOV	BX,SP
	MOV	SI,6
	CALL	IsExceptionClass
	JNE	@@1
	MOV	DebugRec.dhKind,evFinally
	PUSH	ES:[DI].edFinally.ofs
	POP	DebugRec.dhAddr.ofs
	PUSH	ES:[DI].edFinally.seg
	POP	DebugRec.dhAddr.seg
	CALL	HookProc
@@1:	RET

; Notify debugger of an except style catch

NotifyExcept:

	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@1
	MOV	BX,RaiseList
	MOV	SI,6
	PUSH	DX
	PUSH	AX
	CALL	IsExceptionClass
	POP	AX
	POP	DX
	JNE	@@1
	MOV	DebugRec.dhKind,evExcept
	PUSH	ES:[DI].ehAddress.ofs
	POP	DebugRec.dhAddr.ofs
	PUSH	ES:[DI].ehAddress.seg
	POP	DebugRec.dhAddr.seg
	CALL	HookProc
@@1:	RET

; Notify debugger that the current exception chain is completed

NotifyTerminated:

	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@1
	MOV	BX,RaiseList
	MOV	SI,6
	CALL	IsExceptionClass
	JNE	@@1
       	MOV	DebugRec.dhKind,evTerminate
	POP	BX				; This routine's return address
	POP	DebugRec.dhAddr.ofs		; Final destination
	POP	DebugRec.dhAddr.seg
	PUSH	DebugRec.dhAddr.seg
	PUSH	DebugRec.dhAddr.ofs
	PUSH	BX
	CALL	HookProc
@@1:	RET

; Notify debugger that no handler was found for the current exception

NotifyUnexpected:

	CMP	DebugRec.dhDebugHooked.w0,0
	JE	@@1
	MOV	BX,SP
	MOV	SI,6
	CALL	IsExceptionClass
	JNE	@@1
	MOV	DebugRec.dhKind,evUnexpected
	PUSH	ExceptProc.ofs
	POP	DebugRec.dhAddr.ofs
	PUSH	ExceptProc.seg
	POP	DebugRec.dhAddr.seg
	CALL	HookProc
@@1:	RET

; Check except object for decendant of ExceptionClass
; SS:[BX+SI] - Exception object

IsExceptionClass:

	MOV	AX,SS:[BX+SI]
	OR	AX,SS:[BX+SI+2]
	JZ	@@1
	PUSH	ES
	PUSH	DI
	LES	DI,SS:[BX+SI]
	MOV	CX,ExceptionClass.ofs
	MOV	BX,ExceptionClass.seg
	CALL	CheckInstance
	POP	DI
	POP	ES
	RET
@@1:    OR	BX,1
	RET

; Initialize exception hook

InitExceptHook:

	MOV	DebuggerHook.ofs,OFFSET DebugRec
	MOV	DebuggerHook.seg,DS
	MOV	DebugRec.dhHookProc.ofs,OFFSET HookProc
	MOV	DebugRec.dhHookProc.seg,CS
	MOV	DebugRec.dhDoneExcept.ofs,OFFSET DoneExcept
	MOV	DebugRec.dhDoneExcept.seg,CS
	MOV	AX,ExceptDebugPtr.ofs
	OR	AX,ExceptDebugPtr.seg
	JE	@@1
	MOV	AX,OFFSET DebugRec
	MOV	DX,DS
	CALL	ExceptDebugPtr
@@1:	RET

CODE	ENDS

	END


