
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Class constructor and destructor support	*
; *							*
; *     Copyright (c) 1989,95 Borland International     *
; *							*
; *******************************************************

	TITLE	CLSH

	INCLUDE	SE.ASM

DATA	SEGMENT	WORD PUBLIC

; Externals

	EXTRN	ExceptList:WORD

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

; Externals

	EXTRN	RaiseAgain:NEAR,NewMemory:NEAR,DisMemory:NEAR
	EXTRN	HaltError:NEAR

; Publics

	PUBLIC	ObjectVTable,ObjectCreate,ObjectDestroy,ObjectFree
	PUBLIC	NewInstance,FreeInstance,ClassCtr,ClassDtr,ITObject
	PUBLIC	CallDynaInst,CallDynaClass,Dispatch,Abstract
	PUBLIC	FindDynaInst,FindDynaClass

; TObject virtual table

	DW	ITObject		;vtTypeInfo
	DW	0			;vtFieldTable
	DW	0			;vtMethodTable
	DW	0			;vtDynamicTable
	DW	ObjectName		;vtClassName
	DW	4			;vtInstSize
	DD	0			;vtParent
	DD	DefaultHandler		;vtDefault
	DD	NewInstance		;vtNewInst
	DD	FreeInstance		;vtFreeInst
	DD	ObjectDestroy		;vtDestroy

ObjectVTable	LABEL	WORD

; TObject class name

ObjectName	DB	7,'TObject'

; TObject type information

ITObject	LABEL	BYTE

	DB	7			;ttClass
	DB	7,'TObject'
	DD	ObjectVTable
	DD	0
	DW	0
	DB	6,'System'
	DW	0

; constructor TObject.Create

ObjectCreate:

	MOV	BX,SP
	CMP	BYTE PTR SS:[BX+8],0
	JE	@@1
	LES	DI,SS:[BX+4]
	PUSH	ES
	PUSH	DI
	CALL	ES:[DI].vtNewInst
@@1:	RETF	6

; destructor TObject.Destroy

ObjectDestroy:

	MOV	BX,SP
	CMP	BYTE PTR SS:[BX+8],0
	JE	@@1
	LES	DI,SS:[BX+4]
	PUSH	ES
	PUSH	DI
	LES	DI,ES:[DI]
	CALL	ES:[DI].vtFreeInst
@@1:	RETF	6

; procedure TObject.Free

ObjectFree:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	AX,ES
	OR	AX,DI
	JE	@@1
	MOV	AL,1
	PUSH	AX
	PUSH	ES
	PUSH	DI
	LES	DI,ES:[DI]
	CALL	ES:[DI].vtDestroy
@@1:	RETF	4

; class function TObject.NewInstance: TObject

NewInstance:

	PUSH	BP
	MOV	BP,SP
	LES	DI,[BP+6]
	MOV	AX,ES:[DI].vtInstSize
	PUSH	AX
	CALL	NewMemory
	POP	CX
	MOV	BX,AX
	MOV	DI,AX
	MOV	ES,DX
	CLD
	MOV	AX,[BP+6].ofs
	STOSW
	MOV	AX,[BP+6].seg
	STOSW
	XOR	AX,AX
	SUB	CX,4
	SHR	CX,1
	REP	STOSW
	ADC	CX,AX
	REP	STOSB
	MOV	AX,BX
	POP	BP
	RETF	4

; procedure TObject.FreeInstance

FreeInstance:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	CX,DI
	MOV	BX,ES
	LES	DI,ES:[DI]
	MOV	AX,ES:[DI].vtInstSize
	CALL	DisMemory
	RETF	4

; Class constructor support routine
; In	BP = Constructor stack frame

ClassCtr:

	LES	DI,[BP+6]
	PUSH	ES
	PUSH	DI
	CALL	ES:[DI].vtNewInst
	MOV	[BP+6].ofs,AX
	MOV	[BP+6].seg,DX
	MOV	BX,SP
	ADD	BX,4
	MOV	SS:[BX].efDescriptor.ofs,OFFSET CS:ClassExcept
	MOV	SS:[BX].efDescriptor.seg,CS
	MOV	SS:[BX].efStackFrame,BP
	MOV	AX,ExceptList
	MOV	SS:[BX].efNext,AX
	MOV	ExceptList,BX
	RETF

; Class destructor support routine
; In	BP = Constructor stack frame

ClassDtr:

	LES	DI,[BP+6]
	PUSH	ES
	PUSH	DI
	LES	DI,ES:[DI]
	CALL	ES:[DI].vtFreeInst
	RETF

; Constructor exception descriptor

ClassExcept	LABEL	BYTE

	DW	1
	DD	0
	DD	ExceptHandler

; Constructor exception handler

ExceptHandler:

	MOV	AL,1
	PUSH	AX
	LES	DI,[BP+6]
	PUSH	ES
	PUSH	DI
	LES	DI,ES:[DI]
	CALL	ES:[DI].vtDestroy
	JMP	RaiseAgain

; procedure TObject.Dispatch(var Message)

Dispatch:

	MOV	BX,SP
	LES	DI,SS:[BX+8]
	MOV	AX,ES:[DI]
	OR	AX,AX
	JLE	@@2
	LES	DI,SS:[BX+4]
	LES	DI,ES:[DI]
	CALL	GetDynaMethod
	JE	@@1
	JMP	DWORD PTR ES:[DI]
@@1:	MOV	BX,SP
@@2:	LES	DI,SS:[BX+4]
	LES	DI,ES:[DI]
	JMP	ES:[DI].vtDefault

; procedure TObject.DefaultHandler(var Message)

DefaultHandler:

	RETF	8

; Abstract method handler

Abstract:

	MOV	AX,210
	JMP	HaltError

; Call dynamic instance method

CallDynaInst:

	LES	DI,ES:[DI]

; Call dynamic class method

CallDynaClass:

	CALL	GetDynaMethod
	JE	Abstract
	JMP	DWORD PTR ES:[DI]

; Find dynamic instance method

FindDynaInst:

	LES	DI,ES:[DI]

; Find dynamic class method

FindDynaClass:

	CALL	GetDynaMethod
	JE	Abstract
	MOV	AX,ES:[DI].w0
	MOV	DX,ES:[DI].w2
	RETF

; Find dynamic method
; In	AX    = Dynamic method index
;	ES:DI = Virtual method table pointer
; Out	ES:DI = Pointer to method vector
;	ZF    = 0 if found

GetDynaMethod:

	MOV	BX,DI
	CLD
@@1:	MOV	DI,ES:[BX].vtDynamicTable
	OR	DI,DI
	JE	@@2
	MOV	CX,ES:[DI].dtCount
	MOV	DX,CX
	INC	DI
	INC	DI
	REPNE	SCASW
	JE	@@3
@@2:	LES	BX,ES:[BX].vtParent
	MOV	CX,ES
	OR	CX,BX
	JNE	@@1
	RET
@@3:	DEC	DX
	SHL	DX,1
	SUB	DX,CX
	SHL	DX,1
	ADD	DI,DX
	RET

CODE	ENDS

	END
