
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Class standard methods				*
; *							*
; *	Copyright (c) 1993,95 Borland International	*
; *							*
; *******************************************************

	TITLE	CLSF

	INCLUDE	SE.ASM

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE

; Externals

	EXTRN	ErrorStack:NEAR

; Publics

	PUBLIC	InitInstance,ClassType,ClassName,ClassParent
	PUBLIC	InstanceSize,ClassInfo,MethodAddress,MethodName
	PUBLIC	FieldAddress,InheritsFrom,IsOperator,AsOperator
	PUBLIC	CheckInstance

; class function TObject.InitInstance(Instance: Pointer): TObject

InitInstance:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	CX,ES:[DI].vtInstSize
	MOV	AX,DI
	MOV	DX,ES
	LES	DI,SS:[BX+8]
	MOV	BX,DI
	CLD
	STOSW
	MOV	AX,DX
	STOSW
	XOR	AX,AX
	SUB	CX,4
	SHR	CX,1
	REP	STOSW
	ADC	CX,AX
	REP	STOSB
	MOV	AX,BX
	MOV	DX,ES
	RETF	8

; function TObject.ClassType: TClass

ClassType:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	AX,ES:[DI].ofs
	MOV	DX,ES:[DI].seg
	RETF	4

; class function TObject.ClassName: string

ClassName:

	MOV	BX,SP
	PUSH	DS
	CLD
	LDS	SI,SS:[BX+4]
	MOV	SI,[SI].vtClassName
	LES	DI,SS:[BX+8]
	LODSB
	STOSB
	MOV	CL,AL
	XOR	CH,CH
	REP	MOVSB
	POP	DS
	RETF	4

; class function TObject.ClassParent: TClass

ClassParent:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	AX,ES:[DI].vtParent.ofs
	MOV	DX,ES:[DI].vtParent.seg
	RETF	4

; class function TObject.InstanceSize: Word

InstanceSize:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	AX,ES:[DI].vtInstSize
	RETF	4

; class function TObject.ClassInfo: Pointer

ClassInfo:

	MOV	BX,SP
	LES	DI,SS:[BX+4]
	MOV	AX,ES:[DI].vtTypeInfo
	MOV	DX,AX
	OR	AX,AX
	JE	@@1
	MOV	DX,ES
@@1:	RETF	4

; class function TObject.MethodAddress(const Name: string): Pointer

MethodAddress:

	ARG	NamePtr,DWORD,1
	ARG	Self,DWORD,1

	ENTRY	FAR
	PUSH	DS
	CLD
	LDS	SI,NamePtr
	MOV	AH,[SI]
	LDS	SI,Self
	XOR	BX,BX
@@1:	MOV	DI,[SI].vtMethodTable
	OR	DI,DI
	JE	@@4
	MOV	DX,[DI].mtCount
	INC	DI
	INC	DI
@@2:	MOV	BL,[DI].meName
 	CMP	BL,AH
	JE	@@5
@@3:	LEA	DI,[DI].meName[BX+1]
	DEC	DX
	JNE	@@2
@@4:	LDS	SI,[SI].vtParent
	MOV	CX,DS
	OR	CX,SI
	JNE	@@1
	XOR	AX,AX
	CWD
	JMP	SHORT @@6
@@5:	PUSH	DI
	PUSH	SI
	LEA	SI,[DI].meName[1]
	LES	DI,NamePtr
	INC	DI
	CALL	CompareName
	POP	SI
	POP	DI
	JNE	@@3
	MOV	AX,[DI].meVector.ofs
	MOV	DX,[DI].meVector.seg
@@6:	POP	DS
	EXIT

; class function TObject.MethodName(Address: Pointer): string

MethodName:

	ARG	Result,DWORD,1
	ARG	Address,DWORD,1
	ARG	Self,DWORD,1

	ENTRY	FAR
	PUSH	DS
	CLD
	LDS	SI,Self
	MOV	AX,Address.ofs
	MOV	DX,Address.seg
	XOR	BX,BX
@@1:	MOV	DI,[SI].vtMethodTable
	OR	DI,DI
	JE	@@4
	MOV	CX,[DI].mtCount
	INC	DI
	INC	DI
@@2:	CMP	AX,[DI].meVector.ofs
	JE	@@5
@@3:	MOV	BL,[DI].meName
	LEA	DI,[DI].meName[BX+1]
	LOOP	@@2
@@4:	LDS	SI,[SI].vtParent
	MOV	CX,DS
	OR	CX,SI
	JNE	@@1
	LES	DI,Result
	XOR	AL,AL
	STOSB
	JMP	SHORT @@6
@@5:	CMP	DX,[DI].meVector.seg
	JNE	@@3
	LEA	SI,[DI].meName
	LES	DI,Result
	LODSB
	STOSB
	MOV	CL,AL
	XOR	CH,CH
	REP	MOVSB
@@6:	POP	DS
	EXIT	8

; function TObject.FieldAddress(const Name: string): Pointer

FieldAddress:

	ARG	NamePtr,DWORD,1
	ARG	Self,DWORD,1

	ENTRY	FAR
	PUSH	DS
	CLD
	LDS	SI,NamePtr
	MOV	AH,[SI]
	LDS	SI,Self
	LDS	SI,[SI]
	XOR	BX,BX
@@1:	MOV	DI,[SI].vtFieldTable
	OR	DI,DI
	JE	@@4
	MOV	DX,[DI].ftCount
	ADD	DI,OFFSET ftEntries
@@2:	MOV	BL,[DI].feName
	CMP	BL,AH
	JE	@@5
@@3:	LEA	DI,[DI].feName[BX+1]
	DEC	DX
	JNE	@@2
@@4:	LDS	SI,[SI].vtParent
	MOV	CX,DS
	OR	CX,SI
	JNE	@@1
	XOR	AX,AX
	CWD
	JMP	SHORT @@6
@@5:	PUSH	DI
	PUSH	SI
	LEA	SI,[DI].feName[1]
	LES	DI,NamePtr
	INC	DI
	CALL	CompareName
	POP	SI
	POP	DI
	JNE	@@3
	MOV	AX,Self.ofs
	MOV	DX,Self.seg
	ADD	AX,[DI].feOffset
@@6:	POP	DS
	EXIT

; Case insensitive string compare

CompareName:

	MOV	CL,AH
	XOR	CH,CH
@@1:	LODSB
	XOR	AL,ES:[DI]
	INC	DI
	AND	AL,0DFH
	LOOPE	@@1
	RET

; class function TObject.InheritsFrom(AClass: TClass): Boolean

InheritsFrom:

	ARG	Class,DWORD,1
	ARG	Self,DWORD,1

	ENTRY	FAR
	LES	DI,Self
	MOV	CX,Class.ofs
	MOV	BX,Class.seg
	XOR	AX,AX
	CALL	CheckClass
	JNE	@@1
	INC	AX
@@1:	EXIT

; IS operator

IsOperator:

	ARG	Instance,DWORD,1
	ARG	Class,DWORD,1

	ENTRY	FAR
	LES	DI,Instance
	MOV	AX,ES
	OR	AX,DI
	JE	@@1
	MOV	CX,Class.ofs
	MOV	BX,Class.seg
	XOR	AX,AX
	CALL	CheckInstance
	JNE	@@1
	INC	AX
@@1:	EXIT

; AS operator

AsOperator:

	ARG	Instance,DWORD,1
	ARG	Class,DWORD,1

	ENTRY	FAR
	LES	DI,Instance
	MOV	AX,DI
	MOV	DX,ES
	MOV	SI,AX
	OR	SI,DX
	JE	@@1
	MOV	CX,Class.ofs
	MOV	BX,Class.seg
	CALL	CheckInstance
	JNE	@@2
@@1:	EXIT
@@2:	POP	BP
	MOV	AX,reInvalidCast
	JMP	ErrorStack

; Check for derived instance
; In	ES:DI = Source instance pointer
;	BX:CX = Target class pointer
; Out	ZF    = 1 if source derived from target

CheckInstance:

	LES	DI,ES:[DI]

; Check for derived class
; In	ES:DI = Source class pointer
;	BX:CX = Target class pointer
; Out	ZF    = 1 if source derived from target

CheckClass:

@@1:	CMP	DI,CX
	JNE	@@2
	MOV	SI,ES
	CMP	SI,BX
	JE	@@3
@@2:	LES	DI,ES:[DI].vtParent
	MOV	SI,ES
	OR	SI,DI
	JNE	@@1
	DEC	SI
@@3:	RET

CODE	ENDS

	END
