{
  Delphi form to source file generator.

  Copyright (c) 1995 by Borland International

}

unit Dfm2pas;

interface

uses Winprocs, Wintypes, SysUtils, Classes, LibIntf, LibMain;

procedure FormSourceFromBinary(const UnitIdent: String; Input, Output: TStream);
procedure FormSourceFromResource(const UnitIdent: String; Input, Output: TStream);

implementation

procedure AddIfUnique(List: TStrings; const S: String);
var
  X: Integer;
begin
  for X := 0 to List.Count-1 do
    if CompareText(List[X], S) = 0 then
      Exit;
  List.Add(S);
end;

type
  TUnitsList = class(TStringlist)
  public
    constructor Create;
    procedure CollectUnits(const UnitName: String);
  end;

constructor TUnitsList.Create;
begin
  inherited Create;
  Add('WinProcs');
  Add('WinTypes');
  Add('SysUtils');
  Add('Messages');
  Add('Classes');
  Add('Graphics');
  Add('Controls');
  Add('Forms');
  Add('Dialogs');
end;

procedure TUnitsList.CollectUnits(const UnitName: String);
begin
  AddIfUnique(Self, UnitName);
end;

procedure FormSourceFromBinary(const UnitIdent: String; Input, Output: TStream);
var
  Reader: TReader;
  Writer: TWriter;
  Units: TUnitsList;
  ComponentNames, ComponentTypes: TStringList;

  procedure SkipValue;

    function ReadValue: TValueType;
    begin
      Reader.Read(Result, SizeOf(Result));
    end;

    procedure SkipList;
    begin
      while not Reader.EndOfList do SkipValue;
      Reader.ReadListEnd;
    end;

    procedure SkipBytes(Count: Longint);
    var
      Bytes: array[0..255] of Char;
    begin
      while Count > 0 do
        if Count > SizeOf(Bytes) then
        begin
          Reader.Read(Bytes, SizeOf(Bytes));
          Dec(Count, SizeOf(Bytes));
        end
        else
        begin
          Reader.Read(Bytes, Count);
          Count := 0;
        end;
    end;

    procedure SkipBinary;
    var
      Count: Longint;
    begin
      Reader.Read(Count, SizeOf(Count));
      SkipBytes(Count);
    end;

  begin
    case ReadValue of
      vaNull: begin end;
      vaList: SkipList;
      vaInt8: SkipBytes(1);
      vaInt16: SkipBytes(2);
      vaInt32: SkipBytes(4);
      vaExtended: SkipBytes(SizeOf(Extended));
      vaString, vaIdent: Reader.ReadStr;
      vaFalse, vaTrue: begin end;
      vaBinary: SkipBinary;
      vaSet:   while Reader.ReadStr <> '' do ;
    end;
  end;


  procedure ConvertObject;
  var
    ClassName, ObjectName: string[63];
  begin
    ClassName := Reader.ReadStr;
    AddIfUnique(ComponentTypes, ClassName);
    ObjectName := Reader.ReadStr;
    if ObjectName <> '' then
      ComponentNames.Add(Format('    %s: %s;'#13#10,[ObjectName, ClassName]));
    while not Reader.EndOfList do
    begin
      Reader.ReadStr;  { skip property name }
      SkipValue;
    end;
    Reader.ReadListEnd;
    while not Reader.EndOfList do ConvertObject;
    Reader.ReadListEnd;
  end;

  procedure Write(const S: String);
  begin
    Output.Write(S[1], Length(S));
  end;

var
  X: Integer;
  LineStart: Longint;
begin
  ComponentNames := nil;
  ComponentTypes := nil;
  Units := nil;
  try
    ComponentNames := TStringList.Create;
    ComponentTypes := TStringList.Create;
    Units := TUnitsList.Create;
    try
      Reader := TReader.Create(Input, 4096);
      Reader.ReadSignature;
      ConvertObject;
    finally
      Reader.Free;
    end;
    if Assigned(CompLib) then
    begin
      for X := 0 to ComponentTypes.Count-1 do
        Complib.GetClassUnits(ComponentTypes[X], Units.CollectUnits);
    end;
    Write(Format('unit %s;'#13#10#13#10'interface'#13#10#13#10,[UnitIdent]));
    LineStart := Output.Position;
    Write('uses'#13#10'  ');
    for X := 0 to Units.Count-1 do
    begin
      if (Output.Position - LineStart) + Length(Units[x]) > 75 then
      begin
        Write(#13#10);
        LineStart := Output.Position;
        Write('  ');
      end;
      Write(Units[x]);
      if X < Units.Count-1 then
        Write(', ');
    end;
    Write(Format(
          ';'#13#10+
          #13#10+
          'type'#13#10+
          '  %s = class(TForm)'#13#10,[ComponentTypes[0]]));
    for X := 1 to ComponentNames.Count-1 do { don't do 0, the form name }
      Write(ComponentNames[x]);
    Write(Format(
          '  private'#13#10+
          '    { Private declarations }'#13#10+
          '  public'#13#10+
          '    { Public declarations }'#13#10+
          '  end;'#13#10+
          #13#10+
          'var'#13#10+
          '  %s: %s;'#13#10#13#10,
          [Copy(ComponentTypes[0], 2,255), ComponentTypes[0]]));
    Write('implementation'#13#10+
          #13#10+
          '{$R *.DFM}'#13#10+
          #13#10+
          'end.'#13#10);
  finally
    ComponentNames.Free;
    ComponentTypes.Free;
    Units.Free;
  end;
end;

procedure FormSourceFromResource(const UnitIdent: String; Input, Output: TStream);
begin
  Input.ReadResHeader;
  FormSourceFromBinary(UnitIdent, Input, Output);
end;

end.

