// ssview.cpp : implementation file
//

#include "stdafx.h"
#include "demo5.h"
#include "demo5doc.h"
#include "ssview.h"
#include "vtss.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSSView

IMPLEMENT_DYNCREATE(CSSView, CFormView)

CSSView::CSSView()
	: CFormView(CSSView::IDD)
{
	//{{AFX_DATA_INIT(CSSView)
	m_EditBar = NULL;
	m_Sheet = NULL;
	//}}AFX_DATA_INIT
}

CSSView::~CSSView()
{
}

void CSSView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSSView)
	DDX_Control(pDX, IDC_EDIT1, m_Location);
	DDX_VBControl(pDX, IDC_SSEDIT1, m_EditBar);
	DDX_VBControl(pDX, IDC_SHEET1, m_Sheet);
	//}}AFX_DATA_MAP
}

//***************************************************************************
//
//              *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//                The following function is called the first time the view is
//              updated.  The most important thing done here is the storing of the
//              pointer to this view object (this) by the function pDoc->SetView(this).
//
//                After this function call, the document object can easily refer to 
//              the view object, and the view object can easily refer to the document
//              object.
//  
//              For more information, see your 'notes.doc', or 'notes.wri' file.
//
//
//***************************************************************************

void CSSView::OnInitialUpdate()
{
	CDemo5Doc*      pDoc = NULL;
	
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit(/*FALSE*/);   // default argument is TRUE
	
	pDoc = (CDemo5Doc*)GetDocument();
    ASSERT(pDoc!=NULL);
    
	pDoc->SetView(this);    
	pDoc->UpdateMenu();
	pDoc->UpdateSheet();            
}

//***************************************************************************
//
//              *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//                The following function does most of the work of updating the
//              appearance of the spreadsheet when the user makes menu selections.
//
//                the document actually gets the menu update event, sets a document
//              member variable, which we reference here, and calls UpdateAllViews(),
//              with the message ID as an argument.  UpdateAllViews() eventually 
//              makes a call to the function below.
//  
//                It also demonstrates using the CSS wrapper class to access the DLL
//
//              For more information, see your 'notes.doc', or 'notes.wri' file.
//
//
//***************************************************************************

void CSSView::OnUpdate(CView*, LPARAM param, CObject*)
{
	CDemo5Doc*      pDoc = NULL;
	SSERROR         sserr = NULL;
	BOOL            flag = FALSE;
	RC                      max_col = 0;
	RC                      r1 = 0, c1 = 0, r2 = 0, c2 = 0;
	
	pDoc = (CDemo5Doc*)GetDocument();
	CSS ss(m_Sheet);
		
	switch (param)
	{
		case ID_VIEW_GRIDLINES:
			if (pDoc->GridLines())
				ss.SetShowGridLines(TRUE);
			else
				ss.SetShowGridLines(FALSE);
			break;
				
		case ID_VIEW_COLUMNHEADING:
			if (pDoc->ColHeading())
				ss.SetShowColHeading(TRUE);
			else
				ss.SetShowColHeading(FALSE);                            
			break;
			
		case ID_VIEW_ROWHEADING:
			if (pDoc->RowHeading())
				ss.SetShowRowHeading(TRUE);
			else
				ss.SetShowRowHeading(FALSE);                            
			break;
			
		case ID_VIEW_FORMULAS:
			if (pDoc->ShowFormulas())
				ss.SetShowFormulas(TRUE);
			else
				ss.SetShowFormulas(FALSE);                              
			break;
			
		case ID_VIEW_ZEROS:
			if (pDoc->ShowZeros())
				ss.SetShowZeroValues(TRUE);
			else
				ss.SetShowZeroValues(FALSE);                            
			break;
			
		case ID_FORMAT_ALIGNMENT:
			ss.FormatAlignmentDlg();
			break;
			
		case ID_FORMAT_FONT:
			ss.FormatFontDlg();
			break;
			
		case ID_FORMAT_BORDER:
			ss.FormatBorderDlg();
			break;
			
		case ID_FORMAT_PATTERN:
			ss.FormatPatternDlg();
			break;
			
		case ID_FORMAT_CELLPROTECTION:
			ss.ProtectionDlg();
			break;
			
		case ID_FORMAT_ENABLEPROTECTION:
			if (pDoc->CellProtection())
				ss.SetEnableProtection(TRUE);
			else
				ss.SetEnableProtection(FALSE);
			break;
			
		case ID_FORMAT_GENERAL:
			ss.FormatGeneral();
			break;
			
		case ID_FORMAT_CURRENCY0:
			ss.FormatCurrency0();
			break;
			
		case ID_FORMAT_CURRENCY2:
			ss.FormatCurrency2();
			break;
			
		case ID_FORMAT_FIXED:
			ss.FormatFixed();
			break;
			
		case ID_FORMAT_PERCENT:
			ss.FormatPercent();
			break;
			
		case ID_FORMAT_FRACTION:
			ss.FormatFraction();
			break;
			
		case ID_FORMAT_SCEINTIFIC:
			ss.FormatScientific();
			break;
			
		case ID_FORMAT_MDYY:
			ss.FormatMdyy();
			break;
			
		case ID_FORMAT_HMMAMPM:
			ss.FormatHmmampm();
			break;
			
		case ID_FORMAT_CUSTOMNUMBER:
			ss.FormatNumberDlg();
			break;
			
		case ID_FORMAT_COLUMNWIDTH:
			ss.ColWidthDlg();
			break;
			
		case ID_FORMAT_ROWHEIGHT:
			ss.RowHeightDlg();
			break;
			
		case ID_FORMAT_COLORPALETTE:
			ss.ColorPaletteDlg();
			break;
			
		case ID_EDIT_CUT:
			ss.EditCut();
			ss.CanEditPaste( (BOOL FAR *)&flag);
			pDoc->SetModifiedFlag(flag);
			pDoc->Pasteable(flag);
			break;
			
		case ID_EDIT_COPY:
			ss.EditCopy();
			ss.CanEditPaste( (BOOL FAR *)&flag);
			pDoc->Pasteable(flag);
			break;
			
		case ID_EDIT_PASTE:
			ss.CanEditPaste( (BOOL FAR *)&flag);
			pDoc->Pasteable(flag);
			if (flag)
			{
				pDoc->SetModifiedFlag();
				ss.EditPaste();
			}
			break;
			
		case ID_EDIT_CLEAR:
			ss.EditClear( kClearAll);
			break;
			
		case ID_EDIT_INSERT:
		{
			ss.GetMaxCol((LPRC)&max_col);
			ss.GetSelection( 0, (LPRC)&r1, (LPRC)&c1, (LPRC)&r2, (LPRC)&c2);
			if (r1 == 1 && r2 >= max_col)
				ss.EditInsert( ITP_RIGHT);
			else
				ss.EditInsert( ITP_DOWN);
			break;
		}       
		case ID_EDIT_DELETE:
		{
			ss.GetMaxCol((LPRC)&max_col);
			ss.GetSelection( 0, (LPRC)&r1, (LPRC)&c1, (LPRC)&r2, (LPRC)&c2);
			if (r1 == 1 && r2 >= max_col)
				ss.EditDelete( ITP_RIGHT);
			else
				ss.EditDelete( ITP_DOWN);
				
			break;
		}       
		case ID_EDIT_COPYRIGHT:
			ss.EditCopyRight();
			break;
			
		case ID_EDIT_COPYDOWN:
			ss.EditCopyDown();
			break;
			
		case ID_EDIT_GOTO:
			ss.GotoDlg();
			break;
			
		case ID_EDIT_RECALC:
			ss.Recalc();
			break;
			
		case ID_EDIT_CALCULATION:
			ss.CalculationDlg();
			break;
			
		case ID_EDIT_SORT:
			ss.SortDlg();
			break;
			
		case ID_EDIT_DEFINENAME:
			ss.DefinedNameDlg();
			break;
			
		case ID_FILE_PRINT:
			ss.FilePrint( TRUE);
			break;
			
		case ID_FILE_PRINTSETUP:
			ss.FilePrintSetupDlg();
			break;
			
		case ID_FILE_PAGESETUP:
			ss.FilePageSetupDlg();
			break;
			
		case ID_FILE_PRINTTITLES:
			ss.SetPrintTitlesFromSelection() ;
			break;
			
		case ID_FILE_PRINTAREA:
			ss.SetPrintAreaFromSelection();
			break;
			
	};      
}

BEGIN_MESSAGE_MAP(CSSView, CFormView)
	//{{AFX_MSG_MAP(CSSView)
	ON_VBXEVENT(VBN_SELCHANGE, IDC_SHEET1, OnSelchangeSheet1)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSSView message handlers


//***************************************************************************
//
//              *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//                The following function updates the active cell location display
//              box in the upper left corner of the spreadsheet.
//
//                The view object receives a VBN_SELCHANGE message when the user
//              changes the selection.
//
//                When handling messages from the spreadsheet, you need to use the
//              Class Wizard to both generate message map entry and an empty function
//              shell.
//  
//              For more information, see your 'notes.doc', or 'notes.wri' file.
//
//
//***************************************************************************

void CSSView::OnSelchangeSheet1(UINT, int, CWnd*, LPVOID)
{

	long            ss = 0;
	RC                      row = 0, col = 0;
	SSERROR         sserr = NULL;
	char            lbuff[16];
	CDemo5Doc*      pDoc = NULL;
	
	pDoc = (CDemo5Doc*)GetDocument();
	if (!pDoc) return;
	ss = m_Sheet->GetNumProperty("SS");
	sserr = SSGetActiveCell((HSS)ss,(LPRC)&row, (LPRC)&col);
	sserr = SSFormatRCNr((HSS)ss, row, col, FALSE, (LPSTR)lbuff, 16);
	m_Location.SetWindowText(lbuff);
	pDoc->Selection(m_Sheet->GetStrProperty("Selection"));
	pDoc->ActiveCellRow(row);
	pDoc->ActiveCellCol(col);
}

//***************************************************************************
//
//              *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//                The following function handles the Windows WM_SIZE message.  When
//              the user changes the size of the application window, we want to
//              resize the spreadsheet control and the edit bar control to match.
//
//              For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CSSView::OnSize(UINT nType, int cx, int cy)
{
	int     eb_left = 0, eb_bottom = 0;
	
	if (!m_EditBar || !m_Sheet) return;
	
	eb_left = (int)m_EditBar->GetNumProperty("Left");
	eb_bottom = (int)m_EditBar->GetNumProperty("Height");
	m_EditBar->SetNumProperty("Width",cx - eb_left);
	m_Sheet->SetNumProperty("Left",0);
	m_Sheet->SetNumProperty("Top",eb_bottom + 1);
	m_Sheet->SetNumProperty("Width",cx);
	m_Sheet->SetNumProperty("Height",cy - eb_bottom - 1);
	
}
