// demo5doc.h : interface of the CDemo5Doc class
//
/////////////////////////////////////////////////////////////////////////////
#include "ssview.h"

#define SAVE_EXT ".ini"

class CDemo5Doc : public CDocument
{
public:
	
protected: // create from serialization only
	CDemo5Doc();
//	DECLARE_DYNCREATE(CDemo5Doc)
	DECLARE_SERIAL(CDemo5Doc)

// Attributes
protected:
	static int	m_DocCount;
	BYTE		m_Saved;
	BYTE		m_Modified;
	BYTE		m_GridLines;
	BYTE		m_RowHeading;
	BYTE		m_ColHeading;
	BYTE		m_ShowZeros;
	BYTE		m_ShowFormulas;
	BYTE		m_CellProtection;
	BYTE		m_Pasteable;
	CString		m_Selection;
	WORD		m_ActiveCellRow;
	WORD		m_ActiveCellCol;
	CString		m_FileName;
	CSSView*	m_View;

// Operations
public:

// Implementation
public:
	int			Modified()	{ return m_Modified; }
	void		MakeClean() { m_Modified = 0; }
	int			GridLines() { return m_GridLines; }
	int			RowHeading() { return m_RowHeading; }
	int			ColHeading() { return m_ColHeading; }
	int			ShowZeros() { return m_ShowZeros; }
	int			ShowFormulas() { return m_ShowFormulas; }
	int			CellProtection() { return m_CellProtection; }
	int			Pasteable() { return m_Pasteable; }
	void		Pasteable(BOOL p) { m_Pasteable = p; }
	CString		Selection() { return m_Selection; }
	void		Selection(CString sel) { m_Selection = sel; }
	int			ActiveCellRow() { return m_ActiveCellRow; }
	void		ActiveCellRow(int r) { m_ActiveCellRow = r; }
	int			ActiveCellCol() { return m_ActiveCellCol; }
	void		ActiveCellCol(int c) { m_ActiveCellCol = c; }
	CString		FileName() { return m_FileName; }
	void		FileName(CString fn) { m_FileName = fn; m_FileName.MakeLower(); }
	CSSView*	GetView() { return m_View; }
	void		SetView(CSSView* v) { m_View = v; }
	
	CString		BaseName();
	CString		PathName();
	CString		Extension();
	CString		SaveName();
	void		Empty();
	void		UpdateMenu();
	void		UpdateSheet();
	void		ClearSheet();
	char FAR*	CellReference(int row, int col);
	CString		GetNewDocName();
	CString		GetDocTitle();
	void		ShowDocTitle();
	BOOL		Exist(const char* fn);
	
	virtual ~CDemo5Doc();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
protected:
//	virtual	BOOL	OnNewDocument();
	virtual BOOL	SaveModified();
	void			AppExit();

// Generated message map functions
protected:
	//{{AFX_MSG(CDemo5Doc)
	afx_msg void OnViewGridlines();
	afx_msg void OnUpdateViewGridlines(CCmdUI* pCmdUI);
	afx_msg void OnViewColumnheading();
	afx_msg void OnUpdateViewColumnheading(CCmdUI* pCmdUI);
	afx_msg void OnViewRowheading();
	afx_msg void OnUpdateViewRowheading(CCmdUI* pCmdUI);
	afx_msg void OnViewFormulas();
	afx_msg void OnUpdateViewFormulas(CCmdUI* pCmdUI);
	afx_msg void OnViewZeros();
	afx_msg void OnUpdateViewZeros(CCmdUI* pCmdUI);
	afx_msg void OnFormatAlignment();
	afx_msg void OnFormatBorder();
	afx_msg void OnFormatCellprotection();
	afx_msg void OnFormatColorpalette();
	afx_msg void OnFormatColumnwidth();
	afx_msg void OnFormatCurrency0();
	afx_msg void OnFormatCurrency2();
	afx_msg void OnFormatCustomnumber();
	afx_msg void OnFormatEnableprotection();
	afx_msg void OnFormatFixed();
	afx_msg void OnFormatFont();
	afx_msg void OnFormatFraction();
	afx_msg void OnFormatGeneral();
	afx_msg void OnFormatTime();
	afx_msg void OnFormatDate();
	afx_msg void OnFormatPattern();
	afx_msg void OnFormatPercent();
	afx_msg void OnFormatRowheight();
	afx_msg void OnFormatSceintific();
	afx_msg void OnUpdateFormatEnableprotection(CCmdUI* pCmdUI);
	afx_msg void OnEditCut();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditClear();
	afx_msg void OnEditCopydown();
	afx_msg void OnEditCopyright();
	afx_msg void OnEditInsert();
	afx_msg void OnEditDelete();
	afx_msg void OnEditGoto();
	afx_msg void OnEditRecalc();
	afx_msg void OnEditCalculation();
	afx_msg void OnEditDefinename();
	afx_msg void OnEditSort();
	afx_msg void OnFilePagesetup();
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintarea();
	afx_msg void OnFilePrintsetup();
	afx_msg void OnFilePrinttitles();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	afx_msg void OnAppExit();
	afx_msg void OnFileNew();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
