// demo5doc.cpp : implementation of the CDemo5Doc class
//

#include "stdafx.h"
#include "demo5.h"
#include "demo5doc.h"
#include "vtss.h"

extern CDemo5App theApp;
int   CDemo5Doc::m_DocCount = 1;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemo5Doc

//IMPLEMENT_DYNCREATE(CDemo5Doc, CDocument)
IMPLEMENT_SERIAL(CDemo5Doc, CDocument, 1);

BEGIN_MESSAGE_MAP(CDemo5Doc, CDocument)
	//{{AFX_MSG_MAP(CDemo5Doc)
	ON_COMMAND(ID_VIEW_GRIDLINES, OnViewGridlines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_GRIDLINES, OnUpdateViewGridlines)
	ON_COMMAND(ID_VIEW_COLUMNHEADING, OnViewColumnheading)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COLUMNHEADING, OnUpdateViewColumnheading)
	ON_COMMAND(ID_VIEW_ROWHEADING, OnViewRowheading)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ROWHEADING, OnUpdateViewRowheading)
	ON_COMMAND(ID_VIEW_FORMULAS, OnViewFormulas)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FORMULAS, OnUpdateViewFormulas)
	ON_COMMAND(ID_VIEW_ZEROS, OnViewZeros)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZEROS, OnUpdateViewZeros)
	ON_COMMAND(ID_FORMAT_ALIGNMENT, OnFormatAlignment)
	ON_COMMAND(ID_FORMAT_BORDER, OnFormatBorder)
	ON_COMMAND(ID_FORMAT_CELLPROTECTION, OnFormatCellprotection)
	ON_COMMAND(ID_FORMAT_COLORPALETTE, OnFormatColorpalette)
	ON_COMMAND(ID_FORMAT_COLUMNWIDTH, OnFormatColumnwidth)
	ON_COMMAND(ID_FORMAT_CURRENCY0, OnFormatCurrency0)
	ON_COMMAND(ID_FORMAT_CURRENCY2, OnFormatCurrency2)
	ON_COMMAND(ID_FORMAT_CUSTOMNUMBER, OnFormatCustomnumber)
	ON_COMMAND(ID_FORMAT_ENABLEPROTECTION, OnFormatEnableprotection)
	ON_COMMAND(ID_FORMAT_FIXED, OnFormatFixed)
	ON_COMMAND(ID_FORMAT_FONT, OnFormatFont)
	ON_COMMAND(ID_FORMAT_FRACTION, OnFormatFraction)
	ON_COMMAND(ID_FORMAT_GENERAL, OnFormatGeneral)
	ON_COMMAND(ID_FORMAT_HMMAMPM, OnFormatTime)
	ON_COMMAND(ID_FORMAT_MDYY, OnFormatDate)
	ON_COMMAND(ID_FORMAT_PATTERN, OnFormatPattern)
	ON_COMMAND(ID_FORMAT_PERCENT, OnFormatPercent)
	ON_COMMAND(ID_FORMAT_ROWHEIGHT, OnFormatRowheight)
	ON_COMMAND(ID_FORMAT_SCEINTIFIC, OnFormatSceintific)
	ON_UPDATE_COMMAND_UI(ID_FORMAT_ENABLEPROTECTION, OnUpdateFormatEnableprotection)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_COMMAND(ID_EDIT_COPYDOWN, OnEditCopydown)
	ON_COMMAND(ID_EDIT_COPYRIGHT, OnEditCopyright)
	ON_COMMAND(ID_EDIT_INSERT, OnEditInsert)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_COMMAND(ID_EDIT_GOTO, OnEditGoto)
	ON_COMMAND(ID_EDIT_RECALC, OnEditRecalc)
	ON_COMMAND(ID_EDIT_CALCULATION, OnEditCalculation)
	ON_COMMAND(ID_EDIT_DEFINENAME, OnEditDefinename)
	ON_COMMAND(ID_EDIT_SORT, OnEditSort)
	ON_COMMAND(ID_FILE_PAGESETUP, OnFilePagesetup)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINTAREA, OnFilePrintarea)
	ON_COMMAND(ID_FILE_PRINTSETUP, OnFilePrintsetup)
	ON_COMMAND(ID_FILE_PRINTTITLES, OnFilePrinttitles)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo5Doc construction/destruction

CDemo5Doc::CDemo5Doc()
{
	Empty();
	m_FileName = GetNewDocName();
	m_DocCount++;
}

CDemo5Doc::~CDemo5Doc()
{
}

void CDemo5Doc::Empty()
{
	m_Saved = FALSE;
	m_Modified = FALSE;
	m_GridLines = TRUE;
	m_RowHeading = TRUE;
	m_ColHeading = TRUE;
	m_ShowZeros = TRUE;
	m_ShowFormulas = FALSE;
	m_CellProtection = FALSE;
	m_ActiveCellRow = 1;
	m_ActiveCellCol = 1;
	m_Selection.Empty();
	m_FileName.Empty();
	m_View = NULL;
}

//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//    The following three functions update the apperance of the user
//    interface.
//  
//    *  UpdateMenu() makes the menus reflect the state of the
//       document member variables.
//    *  UpdateSheet() makes the spreadsheet control itself reflect
//       the state of the document member variables
//    *  ClearSheet() clears all data from the spreadsheet control,
//       resets the column width to the default setting, and sets the
//       active cell to A1.
//
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CDemo5Doc::UpdateMenu()
{
	CMenu*   pMenu = NULL;
	CWnd* pParent = NULL;
	
	if (!m_View) return;
	
	pParent = m_View->GetParent();
	pMenu = pParent->GetMenu();
	
	if (!pMenu) return;
	
	if (m_GridLines)
		pMenu->CheckMenuItem(ID_VIEW_GRIDLINES, MF_BYCOMMAND|MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_VIEW_GRIDLINES, MF_BYCOMMAND|MF_UNCHECKED);
		
	if (m_RowHeading)
		pMenu->CheckMenuItem(ID_VIEW_ROWHEADING, MF_BYCOMMAND|MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_VIEW_ROWHEADING, MF_BYCOMMAND|MF_UNCHECKED);
		
	if (m_ColHeading)
		pMenu->CheckMenuItem(ID_VIEW_COLUMNHEADING, MF_BYCOMMAND|MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_VIEW_COLUMNHEADING, MF_BYCOMMAND|MF_UNCHECKED);
		
	if (m_ShowZeros)
		pMenu->CheckMenuItem(ID_VIEW_ZEROS, MF_BYCOMMAND|MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_VIEW_ZEROS, MF_BYCOMMAND|MF_UNCHECKED);
		
	if (m_ShowFormulas)
		pMenu->CheckMenuItem(ID_VIEW_FORMULAS, MF_BYCOMMAND|MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_VIEW_FORMULAS, MF_BYCOMMAND|MF_UNCHECKED);
	
}

void CDemo5Doc::UpdateSheet()
{
	long     ss = 0L;
	SSERROR     err;
	CString     fn;
	
	if (!m_View) return;
	
	ss = m_View->m_Sheet->GetNumProperty("SS");
	
	if (m_GridLines)
		err = SSSetShowGridLines((HSS)ss,TRUE);
	else
		err = SSSetShowGridLines((HSS)ss,FALSE);
		
	if (m_RowHeading)
		err = SSSetShowRowHeading((HSS)ss,TRUE);
	else
		err = SSSetShowRowHeading((HSS)ss,FALSE);
		
	if (m_ColHeading)
		err = SSSetShowColHeading((HSS)ss,TRUE);
	else
		err = SSSetShowColHeading((HSS)ss,FALSE);
		
	if (m_ShowZeros)
		err = SSSetShowZeroValues((HSS)ss,TRUE);
	else
		err = SSSetShowZeroValues((HSS)ss,FALSE);
		
	if (m_ShowFormulas)
		err = SSSetShowFormulas((HSS)ss,TRUE);
	else
		err = SSSetShowFormulas((HSS)ss,FALSE);
		
	if (!m_Selection.IsEmpty())
		m_View->m_Sheet->SetStrProperty("Selection",m_Selection);
		
	err = SSSetActiveCell((HSS)ss, m_ActiveCellRow, m_ActiveCellCol);
	m_View->m_Location.SetWindowText(CellReference(m_ActiveCellRow,m_ActiveCellCol));   
	m_View->m_Sheet->SetStrProperty("FileName",m_FileName);
	m_View->GetParent()->SetWindowText((const char*)GetDocTitle());   
}

void CDemo5Doc::ClearSheet()
{
	long     ss = 0L;
	RC       row = 0, col = 0, max = 0;
	int         width = 0;
	
	if (!m_View) return;
	
	ss = m_View->m_Sheet->GetNumProperty("SS");
	if (!ss) return;
	
	SSGetLastRow((HSS)ss, (LPRC)&row);
	SSGetLastCol((HSS)ss, (LPRC)&col);
	SSGetMaxCol((HSS)ss, (LPRC)&max);
	SSGetColWidth((HSS)ss, max, &width);
	SSSetColWidth((HSS)ss, 1, col, width, TRUE);
	SSSetSelection((HSS)ss, 1, 1, row, col);
	SSEditClear((HSS)ss, kClearAll);
	SSSetSelection((HSS)ss, 1, 1, 1, 1);
	m_View->m_Location.SetWindowText("A1");
}


//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//    The following function takes care of serializing the member variables.
//    It is simple enough to implement, but it is possible you may not want
//    to have document member variables or to make them persistent.
//       You may simply want the spreadsheet control to save its data table.
//    In this case, do not make document mber variables or serialize their
//    data.
//  
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//
//***************************************************************************

void CDemo5Doc::Serialize(CArchive& ar)
{
	if (ar.IsStoring()) // Writing
	{
		ar << m_Modified;
		ar << m_GridLines;
		ar << m_RowHeading;
		ar << m_ColHeading;
		ar << m_ShowZeros;
		ar << m_ShowFormulas;
		ar << m_CellProtection;
		ar << m_Selection;
		ar << m_ActiveCellRow;
		ar << m_ActiveCellCol;
	}
	else  // Reading
	{
		ar >> m_Modified;
		ar >> m_GridLines;
		ar >> m_RowHeading;
		ar >> m_ColHeading;
		ar >> m_ShowZeros;
		ar >> m_ShowFormulas;
		ar >> m_CellProtection;
		ar >> m_Selection;
		ar >> m_ActiveCellRow;
		ar >> m_ActiveCellCol;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDemo5Doc diagnostics

#ifdef _DEBUG
void CDemo5Doc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDemo5Doc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG


//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//    This is where your command handlers are implemented.  The best way to
//    install command handlers is to create a shell handler function via the
//    Class Wizard.  Class Wizard adds an entry to the message map and places
//    an empty handler function in your class file.  All you have to do is
//    fill out the function.  Sometimes, this can be quite easy.
//
//    For more information, see 'Document event handlers and View event handlers'
//    in your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CDemo5Doc::OnViewGridlines()
{
	m_GridLines = !m_GridLines;
	SetModifiedFlag();
	UpdateAllViews(NULL, ID_VIEW_GRIDLINES);
}

void CDemo5Doc::OnUpdateViewGridlines(CCmdUI* ui)
{
	if (m_GridLines)
		ui->SetCheck();
	else
		ui->SetCheck(FALSE);
}

void CDemo5Doc::OnViewColumnheading()
{
	m_ColHeading = !m_ColHeading;
	SetModifiedFlag();
	UpdateAllViews(NULL, ID_VIEW_COLUMNHEADING);
}

void CDemo5Doc::OnUpdateViewColumnheading(CCmdUI* ui)
{
	if (m_ColHeading)
		ui->SetCheck();
	else
		ui->SetCheck(FALSE);
}

void CDemo5Doc::OnViewRowheading()
{
	m_RowHeading = !m_RowHeading;
	SetModifiedFlag();
	UpdateAllViews(NULL, ID_VIEW_ROWHEADING);
}

void CDemo5Doc::OnUpdateViewRowheading(CCmdUI* ui)
{
	if (m_RowHeading)
		ui->SetCheck();
	else
		ui->SetCheck(FALSE);
}

void CDemo5Doc::OnViewFormulas()
{
	m_ShowFormulas = !m_ShowFormulas;
	SetModifiedFlag();
	UpdateAllViews(NULL, ID_VIEW_FORMULAS);
}

void CDemo5Doc::OnUpdateViewFormulas(CCmdUI* ui)
{
	if (m_ShowFormulas)
		ui->SetCheck();
	else
		ui->SetCheck(FALSE);
}

void CDemo5Doc::OnViewZeros()
{
	m_ShowZeros = !m_ShowZeros;
	SetModifiedFlag();
	UpdateAllViews(NULL, ID_VIEW_ZEROS);
}

void CDemo5Doc::OnUpdateViewZeros(CCmdUI* ui)
{
	if (m_ShowZeros)
		ui->SetCheck();
	else
		ui->SetCheck(FALSE);
}

void CDemo5Doc::OnFormatAlignment()
{
	UpdateAllViews(NULL, ID_FORMAT_ALIGNMENT);
}

void CDemo5Doc::OnFormatBorder()
{
	UpdateAllViews(NULL, ID_FORMAT_BORDER);
}

void CDemo5Doc::OnFormatCellprotection()
{
	UpdateAllViews(NULL, ID_FORMAT_CELLPROTECTION);
}

void CDemo5Doc::OnFormatColorpalette()
{
	UpdateAllViews(NULL, ID_FORMAT_COLORPALETTE);
}

void CDemo5Doc::OnFormatColumnwidth()
{
	UpdateAllViews(NULL, ID_FORMAT_COLUMNWIDTH);
}

void CDemo5Doc::OnFormatCurrency0()
{
	UpdateAllViews(NULL, ID_FORMAT_CURRENCY0);
}

void CDemo5Doc::OnFormatCurrency2()
{
	UpdateAllViews(NULL, ID_FORMAT_CURRENCY2);
}

void CDemo5Doc::OnFormatCustomnumber()
{
	UpdateAllViews(NULL, ID_FORMAT_CUSTOMNUMBER);
}

void CDemo5Doc::OnFormatEnableprotection()
{
	m_CellProtection = !m_CellProtection;
	UpdateAllViews(NULL, ID_FORMAT_ENABLEPROTECTION);
}

void CDemo5Doc::OnFormatFixed()
{
	UpdateAllViews(NULL, ID_FORMAT_FIXED);
}

void CDemo5Doc::OnFormatFont()
{
	UpdateAllViews(NULL, ID_FORMAT_FONT);
}

void CDemo5Doc::OnFormatFraction()
{
	UpdateAllViews(NULL, ID_FORMAT_FRACTION);
}

void CDemo5Doc::OnFormatGeneral()
{
	UpdateAllViews(NULL, ID_FORMAT_GENERAL);
}

void CDemo5Doc::OnFormatTime()
{
	UpdateAllViews(NULL, ID_FORMAT_HMMAMPM);
}

void CDemo5Doc::OnFormatDate()
{
	UpdateAllViews(NULL, ID_FORMAT_MDYY);
}

void CDemo5Doc::OnFormatPattern()
{
	UpdateAllViews(NULL, ID_FORMAT_PATTERN);
}

void CDemo5Doc::OnFormatPercent()
{
	UpdateAllViews(NULL, ID_FORMAT_PERCENT);
}

void CDemo5Doc::OnFormatRowheight()
{
	UpdateAllViews(NULL, ID_FORMAT_ROWHEIGHT);
}

void CDemo5Doc::OnFormatSceintific()
{
	UpdateAllViews(NULL, ID_FORMAT_SCEINTIFIC);
}

void CDemo5Doc::OnUpdateFormatEnableprotection(CCmdUI* ui)
{
	if (m_CellProtection)
		ui->SetText("Disa&ble Protection");
	else
		ui->SetText("Ena&ble Protection");  
}

void CDemo5Doc::OnEditCut()
{
	UpdateAllViews(NULL, ID_EDIT_CUT);
}

void CDemo5Doc::OnUpdateEditCut(CCmdUI* ui)
{
	if (!m_Selection.IsEmpty())
		ui->Enable(TRUE);
	else
		ui->Enable(FALSE);
}

void CDemo5Doc::OnEditCopy()
{
	UpdateAllViews(NULL, ID_EDIT_COPY);
}

void CDemo5Doc::OnUpdateEditCopy(CCmdUI* ui)
{
	if (!m_Selection.IsEmpty())
		ui->Enable(TRUE);
	else
		ui->Enable(FALSE);
}

void CDemo5Doc::OnEditPaste()
{
	UpdateAllViews(NULL, ID_EDIT_PASTE);
}

void CDemo5Doc::OnUpdateEditPaste(CCmdUI* ui)
{
	if (m_Pasteable)
		ui->Enable(TRUE);
	else
		ui->Enable(FALSE);   
}

void CDemo5Doc::OnEditClear()
{
	UpdateAllViews(NULL, ID_EDIT_CLEAR);
}

void CDemo5Doc::OnEditCopydown()
{
	UpdateAllViews(NULL, ID_EDIT_COPYDOWN);
}

void CDemo5Doc::OnEditCopyright()
{
	UpdateAllViews(NULL, ID_EDIT_COPYRIGHT);
}

void CDemo5Doc::OnEditInsert()
{
	UpdateAllViews(NULL, ID_EDIT_INSERT);
}

void CDemo5Doc::OnEditDelete()
{
	UpdateAllViews(NULL, ID_EDIT_DELETE);
}

void CDemo5Doc::OnEditGoto()
{
	UpdateAllViews(NULL, ID_EDIT_GOTO);
}

void CDemo5Doc::OnEditRecalc()
{
	UpdateAllViews(NULL, ID_EDIT_RECALC);
}

void CDemo5Doc::OnEditCalculation()
{
	UpdateAllViews(NULL, ID_EDIT_CALCULATION);
}

void CDemo5Doc::OnEditDefinename()
{
	UpdateAllViews(NULL, ID_EDIT_DEFINENAME);
}

void CDemo5Doc::OnEditSort()
{
	UpdateAllViews(NULL, ID_EDIT_SORT);
}

void CDemo5Doc::OnFilePagesetup()
{
	UpdateAllViews(NULL, ID_FILE_PAGESETUP);
}

void CDemo5Doc::OnFilePrint()
{
	UpdateAllViews(NULL, ID_FILE_PRINT);
}

void CDemo5Doc::OnFilePrintarea()
{
	UpdateAllViews(NULL, ID_FILE_PRINTAREA);
}

void CDemo5Doc::OnFilePrintsetup()
{
	UpdateAllViews(NULL, ID_FILE_PRINTSETUP);
}

void CDemo5Doc::OnFilePrinttitles()
{
	UpdateAllViews(NULL, ID_FILE_PRINTTITLES);
}

//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//       The following three functions implement saving and storing of both
//    spreadsheet control data and document data. 
//       These functions handle messages and should be installed via the
//    Class Wizard because they need entries in the message map.
//
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CDemo5Doc::OnFileSaveAs()
{
	char        buff[64];
	long        ss = 0L;
	int         lpfiletype;
	
	if (!m_View)
		return;
	ss = m_View->m_Sheet->GetNumProperty("SS");
	if (!m_FileName.IsEmpty())
		strcpy(buff,(const char*)m_FileName);
	SSSaveFileDlg((HSS)ss, "Save Spreadsheet As", (LPSTR)buff, 64, &lpfiletype);
	if (*buff != '\0')
	{
		m_View->m_Sheet->SetStrProperty("FileName",buff);
		m_View->m_Sheet->SetStrProperty("WriteFile",buff);
		m_FileName = buff;
		m_FileName.MakeLower();
		OnSaveDocument((const char*)SaveName());  // Calls Serialization code
		MakeClean();
		SetModifiedFlag(FALSE);
		ShowDocTitle();
		m_Saved = TRUE;
	}
}

void CDemo5Doc::OnFileOpen()
{
	char        buff[64];
	SSERROR        sserr;
	HWND        hParent = NULL;
	CFile       file;
	
	if (!m_View)
		return;
	hParent = m_View->GetParent()->m_hWnd;
	sserr = SSOpenFileDlg("Open Spreadsheet", hParent, (LPSTR)buff, 64);
	if (*buff != '\0')
	{
		m_View->m_Sheet->SetStrProperty("ReadFile",buff);
		m_FileName = buff;
		m_FileName.MakeLower();
		if ( Exist( (const char*)SaveName() ) )
			OnOpenDocument((const char*)SaveName());  // Calls Serialization code
		UpdateMenu();
		UpdateSheet();
	}
}

void CDemo5Doc::OnFileSave()
{
	if (!m_View)
		return;
	
	if (m_FileName.IsEmpty() || !m_Saved) // No filename in View Class
		OnFileSaveAs();
	else  // Got a filename in View Class
	{  
		m_View->m_Sheet->SetStrProperty("WriteFile",(const char*)m_FileName);
		m_View->m_Sheet->SetStrProperty("FileName",(const char*)m_FileName);
		OnSaveDocument((const char*)SaveName());  // Calls Serialization code
		MakeClean();
		SetModifiedFlag(FALSE);
	}
}

//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//       The following three functions implement application exit pro-
//    cedures. They are more involved than if you were simply saving
//    a document's data members.
//       OnAppExit() handles a message and should be installed via the
//    Class Wizard because it needs an entry in the message map.
//       SaveModified() is an overrideable function and doesn't need a
//    message map entry.
//
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CDemo5Doc::AppExit()
{
	CString  msg;
	int         save = 0;
	
	if (!m_View)
		return;
		
	if (Modified() || IsModified() || m_View->m_Sheet->GetNumProperty("Modified"))
	{
		msg = "Do you want to save \"" + BaseName() + "." + Extension() + "\"?";
		save = AfxMessageBox((const char*)msg, MB_YESNO);
		if (save == IDYES)
			OnFileSaveAs();
	}
} // AppExit()

void CDemo5Doc::OnAppExit()
{
	 AppExit();
	theApp.m_pMainWnd->PostMessage(WM_COMMAND,ID_FILE_CLOSE);   
}


BOOL CDemo5Doc::SaveModified()
{
	AppExit();
	theApp.m_pMainWnd->PostMessage(WM_COMMAND,ID_APP_EXIT);  
	return TRUE;
}


//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//       The following function simply clears the spreadsheet control and
//    resets the menus and document member variables to their default values.
//
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

void CDemo5Doc::OnFileNew()
{
	if (!m_View) return;
	
	CSSView* pView = NULL;
	
	pView = m_View;   
	Empty();
	m_View = pView;
	
	if (!m_FileName.IsEmpty())
		m_FileName = PathName() + GetNewDocName() + Extension();
	else
		m_FileName = GetNewDocName();

	m_DocCount++;
	
	UpdateMenu();
	UpdateSheet();
	ClearSheet();
}


//***************************************************************************
//
//    *** Notes For VISUAL TOOLS Formula One VBX Control Users ***
//
//    The following section contains utility functions for the document
//    class.
//
//    For more information, see your 'notes.doc', or 'notes.wri' file.
//
//***************************************************************************

BOOL CDemo5Doc::Exist(const char* fn)
{
	CFile file;
	
	if ( file.Open(fn, CFile::modeRead | CFile::shareDenyNone ) )
	{
		file.Close();
		return TRUE;
	}
	
	return FALSE;
}

CString CDemo5Doc::GetNewDocName()
{
	char  buff[20];
	
	return CString("Sheet") + itoa(m_DocCount,buff,10);
}

CString CDemo5Doc::GetDocTitle()
{
	CString title;
	
	title.LoadString(AFX_IDS_APP_TITLE);
	if (!title.IsEmpty())
		title += " - " + BaseName();
	else
		title = BaseName();
	return title;
}

void CDemo5Doc::ShowDocTitle()
{
	if (!m_View) return;
	m_View->GetParent()->SetWindowText((const char*)GetDocTitle());   
}


CString  CDemo5Doc::BaseName()
{
	CString     base;
	CString     fn = m_FileName;
	int         ib = -1; // Index to start of extension
	int         ip = -1; // Index to end of path
	
	 if (fn.IsEmpty()) 
	{
		fn = "";
		return fn;
	} 
	
	ib = fn.Find('.');
	ip = fn.ReverseFind('\\');
	
	if (ib == -1 && ip == -1)
		return fn;
	
	base = fn;
	
	if (ib > -1)         // Remove Extension
		base = base.Left(ib);
		
	if (ip > -1)         // Remove Path
		base = base.Right(base.GetLength()-ip-1);
		
	return base;   
}

CString  CDemo5Doc::PathName()
{
	CString     fn = m_FileName;
	int         ip = -1;
	
	 if (fn.IsEmpty()) 
	{
		fn = "";
		return fn;
	} 
	
	ip = fn.ReverseFind('\\');
	
	if (ip < 0)
	{
		fn = "";
		return fn;
	}
	
	fn = fn.Left(ip + 1);
	fn.MakeLower();
	return fn;
}

CString  CDemo5Doc::Extension()
{
	CString     fn = m_FileName;
	int         ie = -1;
	  
	 if (fn.IsEmpty()) 
	{
		fn = "";
		return fn;
	} 
	
	ie = fn.Find('.');
	
	if (ie < 0)
	{
		fn = "";
		return fn;
	}
	
	fn = fn.Right(fn.GetLength()-ie-1);
	fn.MakeLower();
	return fn;
}

CString CDemo5Doc::SaveName()
{
	CString     ret;
	
	if (!m_FileName.IsEmpty())
		ret = PathName() + BaseName() + SAVE_EXT;
	ret.MakeLower();
	return ret;
}
			 
char FAR* CDemo5Doc::CellReference(int row, int col)
{
	static char buff[16];
	long     ss = 0L;

	if (!m_View) return NULL;
	
	ss = m_View->m_Sheet->GetNumProperty("SS");
	SSFormatRCNr((HSS)ss, row, col, FALSE, buff, 16);
	return buff;
}
