//	custfunc.cpp
//
//	This is an example of how to write a custom function
//	to be called from a formula in Formula One.
//

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

////////////////////////////////////////////////////////////////////////////      
// NOTE:
// 	For Borland C++ you can not return a double as in the function
// Quotient() below.  You can return a pointer to a double as in
// Quotient2().  This is bacause Microsoft and Borland expect floating 
// point values to be returned differently on the stack.
////////////////////////////////////////////////////////////////////////////      
 

#ifndef __BORLANDC__
//	Quotient(numerator, denominator)
//
//	Returns the integer portion of a division. If denominator
//	is zero, zero will be returned.
//
//	To call from Formula One use the following syntax:
//
//		CALL("CUSTFUNC.DLL", "QUOTIENT", "BBB", 3, 2)
//
//	The previous example would pass 3 for the numerator,
//	2 for the denominator, and return 1.
//

double FAR PASCAL __export Quotient(double numerator, double denominator)
{
	double ret;

	if (denominator == 0.0)
		ret = 0.0;			// Cannot divide by zero

	else
	{
		numerator /= denominator;
		ret = (numerator < 0.0) ? ceil(numerator) : floor(numerator);
	}

	return ret;
}
#endif // __BORLANDC__

//	Quotient2(numerator, denominator)
//
//	Returns the integer portion of a division.  If denominator
//	is zero, #NUM! will be returned.
//
//	To call from Formula One use the following syntax:
//
//		CALL("CUSTFUNC.DLL", "QUOTIENT2", "EBB", 3, 2)
//
//	The previous example would pass 3 for the numerator,
//	2 for the denominator, and return 1.
//

double FAR *PASCAL __export Quotient2(double numerator, double denominator)
{
	static double ret;

	if (denominator == 0.0)
		return 0;			// Cannot divide by zero - force #NUM! error

	else
	{
		numerator /= denominator;
		ret = (numerator < 0.0) ? ceil(numerator) : floor(numerator);
	}

	return &ret;
}

//	AllTypes(a,b,c,d,e,f,g,h,i,j,l,m,n)
//
//	Takes one of each possible type of argument
//	and modified the one which may be modified.
//
//	To call from Formula One use the following syntax:
//
//		CALL("CUSTFUNC.DLL", "ALLTYPES", "CABCDEFGHIJLMN",
//			TRUE(),
//			2.0,
//			"C String",
//			"D String",
//			3.0,
//			"F String",
//			"G String",
//			4,
//			5,
//			6,
//			FALSE(),
//			7,
//			8)

char FAR * FAR PASCAL __export AllTypes(
		short int aLogical,
		double bDouble,
		const char FAR *cString,
		const unsigned char FAR *dByteCountedString,
		double FAR *eDoubleRef,
		char FAR *fStringRef,
		unsigned char FAR *gByteCountedStringRef,
		unsigned short int hUnsignedShort,
		short int iShort,
		long int jLong,
		short int FAR *lLogicalRef,
		short int FAR *mShortRef,
		long int FAR *nLongRef)
{
	static unsigned char RetBuf[2048];		// Just to be safe make it big.
	unsigned char dBuf[256];
	unsigned char gBuf[256];
	int nLen;

	memcpy(dBuf, dByteCountedString + 1, dByteCountedString[0]);
	dBuf[dByteCountedString[0]] = 0;

	memcpy(gBuf, gByteCountedStringRef + 1, gByteCountedStringRef[0]);
	gBuf[gByteCountedStringRef[0]] = 0;

	nLen = sprintf(RetBuf, "AllTypes(%s,%g,%s,%s,%g,%s,%s,%u,%d,%ld,%s,%d,%ld)",
			aLogical ? "TRUE" : "FALSE",
			bDouble,
			cString,
			dBuf,
			*eDoubleRef,
			fStringRef,
			gBuf,
			hUnsignedShort,
			iShort,
			jLong,
			(*lLogicalRef) ? "TRUE" : "FALSE",
			*mShortRef,
			*nLongRef
			);

	if (nLen > 255)
		sprintf(RetBuf,
				"AllTypes: String had a length of %d which is too long to return",
				nLen);

	strcpy(fStringRef, "This string was copied into fStringRef");

	strcpy(gByteCountedStringRef + 1,
			"This string was copied into gByteCountedStringRef");

	gByteCountedStringRef[0] = strlen(gByteCountedStringRef + 1);

	*eDoubleRef = *eDoubleRef + 1.0;
	*lLogicalRef = !*lLogicalRef;
	(*mShortRef)++;
	(*nLongRef)++;

	return RetBuf;
}
