Option Explicit


' ListIndexes IndexAttributes values
Global Const DB_UNIQUE = 1
Global Const DB_PRIMARY = 2
Global Const DB_PROHIBITNULL = 4
Global Const DB_IGNORENULL = 8

' ListIndexes FieldAttributes value
Global Const DB_DESCENDING = 1  'For each field in Index

' TableDef Attributes
Global Const DB_ATTACHEXCLUSIVE = &H10000
Global Const DB_ATTACHSAVEPWD = &H20000
Global Const DB_SYSTEMOBJECT = &H80000002
Global Const DB_ATTACHEDTABLE = &H40000000
Global Const DB_ATTACHEDODBC = &H20000000

'Demo Constants
Global Const MAX_FIELD_DISPLAY = 9
Global Const EM_EDIT = 1
Global Const EM_ADD = 2

'Demo Global Variables
Type SelectionType
    Row1 As Integer
    Col1 As Integer
    Row2 As Integer
    Col2 As Integer
End Type

Type CellType
    Row As Integer
    Col As Integer
End Type

Global PubBookmark
Global SheetRow%
Global TheDatabase$
Global TheTable$
Global TheError$
Global Selections() As SelectionType
Global SelectionCount%
Global ActiveCell As CellType
Global MarkedCell As CellType
Global TableLoaded%
Global EditMode%
Global PaintingSheet%

Sub DB_Add ()
    Dim SS As Control, rn%

    On Error GoTo adderr

    Set SS = startup.Sheet1
    rn = SS.Row
    
    dataentry.Data1.Recordset.AddNew
    EditMode = EM_ADD
    startup.Hide
    dataentry.Show 1

    startup.Data1.Refresh
    startup.Show
    startup.Sheet1.SetFocus
    SS.Row = rn
    Exit Sub
adderr:
    Beep
    MsgBox "Add Record Error. Exiting Sample Demo"
    End
End Sub

Sub DB_Delete ()
    Dim dt As Dynaset, bm
    Dim msg As String
    Dim dgdef As Integer, response As Integer

    On Error GoTo deleteerr

    Set dt = startup.Data1.Recordset
    If dt.RecordCount < 1 Then
        MsgBox "No records to delete."
    Else
        msg = " Do you really want to delete this record? "
        dgdef = MB_YESNO + MB_ICONSTOP + MB_DEFBUTTON2
        response = MsgBox(msg, dgdef)
        If response = IDYES Then
            dt.Delete
            startup.Data1.Refresh
        End If
    End If
    Exit Sub
deleteerr:
    Beep
    MsgBox "Error deleting this record; Exiting sample Demo"
    End
End Sub

Sub DB_Edit ()
    Dim rn%, i%
    Dim SS As Control, ds As Dynaset

    On Error GoTo editerr

    Set SS = startup.Sheet1
    Set ds = dataentry.Data1.Recordset
    rn = SS.Row
    SS.Col = 1

    ds.MoveFirst
    If rn > 1 Then
        For i = 1 To rn - 1
            ds.MoveNext
        Next
    End If
    
    startup.Hide
    dataentry.UpdateCmd.Enabled = True
    EditMode = EM_EDIT
    dataentry.Show 1

    startup.Data1.Refresh
    startup.Show
    startup.Sheet1.SetFocus
    SS.Row = rn
    Exit Sub
editerr:
    Beep
    MsgBox "Edit Error Occured. Exiting Sample Demo "
    End
End Sub

Sub disablerecordbuttons ()
    Dim i%

    For i = 0 To 2
        startup.OptionsCmd(i).Enabled = False
    Next
    startup.Data1.Enabled = False
    startup.Database(2).Enabled = False
    startup.Database(4).Enabled = False
    'close current Database; enable opening new DB
    startup.Database(1).Enabled = True
    startup.RecordMenu.Enabled = False
End Sub

Sub EnableRecordButtons ()
    Dim i%

    For i = 0 To 2
        startup.OptionsCmd(i).Enabled = True
    Next
    startup.Data1.Enabled = True
    startup.Database(2).Enabled = True
    startup.Database(4).Enabled = True
    'disable opening a new DB until current is closed
    startup.Database(1).Enabled = False
    startup.RecordMenu.Enabled = True
End Sub

Function GetTable (db_name$)
    
    Dim de As Control

    On Error GoTo GT_Err1
    Set de = dataentry.Data1
    GetTable = False

    GetTableNames db_name
    TableSelect.Show 1
    If TheTable <> "" Then
        startup.Data1.RecordSource = TheTable
        startup.Data1.Caption = TheTable
        startup.Data1.Refresh
        de.DatabaseName = ""
        de.RecordSource = ""
        de.Refresh
        SetupRecordEdit
        de.DatabaseName = TheDatabase
        de.RecordSource = TheTable
        de.Refresh
        de.Caption = TheTable
        TableLoaded = True
        TableSelect.CancelCmd.Enabled = True
        GetTable = True
    End If
    Exit Function

GT_Err1:
    GetTable = False
    Beep
    MsgBox "GetTable Error: Exiting sample demo "
    End

End Function

Sub GetTableNames (db_name$)
    Dim db As Database, tb As table, td As TableDefs
    Dim i%, tn$

    On Error GoTo GTN_Err1

    If TheDatabase = "" Then
        MsgBox "No database selected."
        Exit Sub
    End If
    TableSelect.TableList.Clear
    Set db = OpenDatabase(db_name)
    Set td = db.TableDefs
    For i = 0 To td.Count - 1
        tn = td(i).Name
        If (td(i).Attributes And DB_SYSTEMOBJECT) = 0 Then
            TableSelect.TableList.AddItem td(i).Name
        End If
    Next i
    db.Close
    Exit Sub

GTN_Err1:
    db.Close
    Beep
    MsgBox "GetTableNames Error: Exiting sample demo"
    End
End Sub

Sub OpenDB ()
    Dim i%, de As Control, fn$, t$, rn%, cn%, tl%
    Dim sserror

    TheError = ""
    On Error GoTo OpenErr

    Set de = dataentry.Data1
    'initialize the file name to null; the first time
    'anyway it is null; for second time this helps to
    'set file name in dialog box to *.mdb
    startup.DBDialog.Filename = ""
    startup.DBDialog.Action = 1 ' Open
    fn$ = startup.DBDialog.Filename
    t$ = Dir$(fn)
    TheDatabase = fn$
    If TheDatabase = "" Or IsNull(TheDatabase) Then
        Exit Sub
    End If

    'If TableLoaded = False Then 'Unselect selections
    '    tl = TableLoaded
    '    rn = startup.sheet1.Row
    '    cn = startup.sheet1.Col
    'End If

    startup.Data1.DatabaseName = TheDatabase
    i = GetTable(TheDatabase)
    If i = False Then
        Exit Sub
    End If
    'If tl = False Then
    '    i = SSSetSelection(startup.sheet1.SS, rn, cn, rn, cn)
    'End If

    startup.Data1.Enabled = True
    'once DB is loaded, enable rowmode
    rn = startup.Sheet1.Row
    cn = startup.Sheet1.Col
    sserror = sssetselection(startup.Sheet1.SS, rn, cn, rn, cn)
    startup.Sheet1.AllowSelections = False
    startup.Sheet1.AllowSelections = True
    EnableRecordButtons
    startup.Sheet1.SetFocus
    startup.Sheet1.RowMode = True
    sserror = sssetactivecell(startup.Sheet1.SS, 1, 1)
    If startup.Data1.Recordset.RecordCount > 1 Then
        startup.Data1.Recordset.MoveNext
        startup.Data1.Recordset.MovePrevious
    Else
        startup.Data1.Recordset.MoveFirst
    End If
    Exit Sub

OpenErr:
    Beep
    MsgBox "DataBase Open Error: Exiting Sample Demo "
    End
End Sub

Sub SelectOK ()
    Dim tl As Control

    Set tl = TableSelect.TableList
    If tl.ListIndex < 0 Then
        If TableLoaded = True Then
            MsgBox "You must select a table or click the 'Cancel' button"
        Else
            MsgBox "Please select a table."
        End If
        Exit Sub
    End If
    If tl.ListIndex >= 0 Then
        TheTable = tl.List(tl.ListIndex)
    Else
        TheTable = ""
    End If
    TableSelect.Hide
End Sub

Sub SetupRecordEdit ()
    Dim ef As Control, i%, rc%
    Dim db As Database, tb As table
    Dim fd As Fields, td As TableDefs

    On Error GoTo setuprecorderr

    Set db = OpenDatabase(TheDatabase)
    Set td = db.TableDefs
    Set fd = td(TheTable).Fields
    Set ef = dataentry.Data1
    rc = fd.Count
    
    For i = 0 To MAX_FIELD_DISPLAY - 1
        If i < rc Then
            dataentry.DataField(i).Visible = True
            dataentry.DataLabel(i).Visible = True
            dataentry.DataField(i).DataField = fd(i).Name
            dataentry.DataLabel(i).Caption = fd(i).Name
            'disable editing a field if it is not updatable
            'if fd(i).attributes and DB_UPDATABLEFIELD = 0 then
            '    dataentry.DataField(i).Enabled = False
            'End If
        Else
            dataentry.DataField(i).Visible = False
            dataentry.DataLabel(i).Visible = False
            dataentry.DataField(i).DataField = ""
            dataentry.DataLabel(i).Caption = ""
        End If
    Next i
    db.Close
    Exit Sub
setuprecorderr:
    Beep
    MsgBox "Record Editing mode setup error: Exiting sample Demo"
    End
End Sub

