/*
*
*	Copyright (c) 1992-93, Coromandel Industries, Inc.
*
*	You have a royalty-free right to use, modify, reproduce and 
*	distribute the source files that form part of the class library 
*	(and / or any modified version) in any way you find useful, 
*	provided that you agree that Coromandel has no warranty, 
*	obligations, or liability including for consequential damages 
*	for any such usage, modification, reproduction and distribution.
*
*		Coromandel Industries, Inc.
*		70-15, Austin Street, 3rd Floor 
*		Forest Hills, NY 11375, USA.
* 
*	System:		Integra VDB 
*	Module:		Class library for database controls 
*	Filename:	VDB.H
*	Author:		Coromandel
*	Date:		Oct 25, 1993
*	Description:    Header file for classes
*			CVDBApp, CVDBDataSource,
*			CVDBForm and CVDBQuery
*/

#if !defined (_VDB_H )
#define _VDB_H

#define VDB_NAMEMAX	32
#define HDBC VOID FAR *
#if defined (__BCPLUSPLUS__)
#define CVDBString string
#define CONSTSTR(s) 	s.c_str()
#else
#define CVDBString CString
#define CONSTSTR(s)  (s)
#endif


#include "sqcmain.h"

// Constants
const long VDB_DefaultAccessMode = SQC_ACC_MODIFY | 
			   SQC_ACC_BROWSE |
			   SQC_ACC_QUERY |
			   SQC_ACC_ENBUTTON |
			   SQC_ACC_ENSUB |
			   SQC_ACC_FETCHEVENT |
			   SQC_ACC_FETCHALL |
			   SQC_ACC_MODIFYEVENT |
			   SQC_ACC_STATEEVENT |
			   SQC_ACC_FIELDEVENT |
			   SQC_ACC_ROWSEL;


// Enumerations
enum VDB_DataType {
	VDB_Char = SQC_CHAR,
	VDB_Numeric = SQC_NUMERIC,
	VDB_Decimal = SQC_DECIMAL,
	VDB_Integer = SQC_INTEGER,
	VDB_SmallInt = SQC_SMALLINT,
	VDB_Float = SQC_FLOAT,
	VDB_Real = SQC_REAL,
	VDB_Double = SQC_DOUBLE,
	VDB_Date = SQC_DATE,
	VDB_Time = SQC_TIME,
	VDB_TimeStamp = SQC_TIMESTAMP,
	VDB_VarChar = SQC_VARCHAR,
	VDB_LongVarChar = SQC_LONGVARCHAR,
	VDB_Binary = SQC_BINARY,
	VDB_VarBinary = SQC_VARBINARY,
	VDB_LongVarBinary = SQC_LONGVARBINARY,
	VDB_BigInt = SQC_BIGINT,
	VDB_TinyInt = SQC_TINYINT,
	VDB_Bit = SQC_BIT
};

enum VDB_QueryType {
	VDB_Columns = SQC_COLUMNS,
	VDB_Export = SQC_EXPORT,
	VDB_Generic = SQC_GENERIC,
	VDB_Import = SQC_IMPORT,
	VDB_Lookup = SQC_LOOKUP,
	VDB_Memory = SQC_MEMORY,
	VDB_ProcColumns = SQC_PROCCOLS,
	VDB_Procedure = SQC_PROCEDURE,
	VDB_ProcList = SQC_PROCLIST,
	VDB_Select = SQC_SELECT,
	VDB_SpecialColumns = SQC_SPECIALCOLS,
	VDB_Statistics = SQC_STATISTICS,
	VDB_Tables = SQC_TABLES,
	VDB_TypeInfo = SQC_TYPEINFO
};

enum VDB_QueryMode {
	VDB_Query_AND = SQC_QRY_AND,
	VDB_Query_OR = SQC_QRY_OR,
	VDB_Query_preLIKE = SQC_QRY_LIKEPRE,
	VDB_Query_postLIKE = SQC_QRY_LIKEPOST,
	VDB_Query_External = SQC_QRY_EXTERN
};

enum VDB_FetchPos {
	VDB_FetchNext = SQC_CURS_NEXT,
	VDB_FetchFirst = SQC_CURS_FIRST,
	VDB_FetchLast = SQC_CURS_LAST,
	VDB_FetchPrev = SQC_CURS_PREV,
	VDB_FetchAbs = SQC_CURS_ABS,
	VDB_FetchRel = SQC_CURS_REL,
	VDB_FetchCurrent = SQC_CURS_CURR
};

enum VDB_ObjectType {
	VDB_Environment = SQC_ENVIRONMENT,
	VDB_Connection = SQC_CONNECTION,
	VDB_DBMode = SQC_DBPROP,
	VDB_Query = SQC_DATASTREAM,
	VDB_Form = SQC_FORM
};

enum VDB_DateFormat {
	VDB_WinIni,
	VDB_MMDDYY,
	VDB_MMDDYYYY,
	VDB_DDMMYY,
	VDB_DDMMYYYY,
	VDB_DDMMMYY,
	VDB_DDMMMYYYY,
	VDB_YYYYMMDD,
	VDB_ODBCDATE,
	VDB_DefaultDateFormat
};

enum VDB_DateCvt {
	VDB_DispToIso = SQC_DATE_FRDISP,
	VDB_DrvToIso = SQC_DATE_FRDRV,
	VDB_IsoToDisp = SQC_DATE_TODISP,
	VDB_IsoToDrv = SQC_DATE_TODRV 
} ;

enum VDB_Isolation {
	VDB_ReadUncommitted = SQC_DBM_ISO0,
	VDB_ReadCommitted = SQC_DBM_ISO1,
	VDB_RepeatableRead = SQC_DBM_ISO2,
	VDB_Serializable = SQC_DBM_ISO3,
	VDB_Versioning = SQC_DBM_ISO3,
	VDB_DefaultIsolation = 0
};

enum VDB_ScopeOption {
	VDB_Transaction,
	VDB_Session,
	VDB_CurrentRow,
	VDB_DefaultScope
};

enum VDB_ControlType {
	VDB_TextControl = SQC_CTI_ThTXB,
	VDB_ListBox = SQC_CTI_LB,
	VDB_Frame = SQC_CTI_FRAME,
	VDB_RadioButton = SQC_CTI_RB,
	VDB_CheckBox = SQC_CTI_CHKBOX,
	VDB_MSGrid = SQC_CTI_MGRID,
	VDB_CommandButton = SQC_CTI_CBUTTON,
	VDB_CIGrid = SQC_CTI_CGRID,
	VDB_ThirdPartyControl = SQC_CTI_3rdPARTY
};

enum VDB_ButtonOp {
	VDB_OPClearQuery = OP_CLEARQUERY,
	VDB_OPCloseCursor = OP_CLOSECURSOR,
	VDB_OPDelete = OP_DELETE,
	VDB_OPCurrent = OP_CURR,
	VDB_OPFirst = OP_FIRST,
	VDB_OPLast = OP_LAST,
	VDB_OPNext = OP_NEXT,
	VDB_OPPrev = OP_PREV,
	VDB_OPInsert = OP_INSERT,
	VDB_OPOpen = OP_OPEN,
	VDB_OPQueryByForm = OP_QBF,
	VDB_OPUpdate = OP_UPDATE,
	VDB_OPExecuteChain = OP_EXECUTECHAIN
};


enum VDB_JustType {
	VDB_LeftJust,
	VDB_RightJust,
	VDB_CenterJust
} ;

enum VDB_ConnectTypes {
	VDB_DrvConnect,
	VDB_Connect
} ;

enum VDB_FetchEventType {
	VDB_FetchFromDb = SQC_FETCH_FIRST,
	VDB_FetchBrowse = SQC_FETCH_BROWSE,
	VDB_FetchLastRec
} ;

enum VDB_StreamType {
	VDB_OdbcStream = SQC_DSI_ODBC,
	VDB_CursorView = SQC_DSI_CURSORVIEW 
} ;


#define		MAX_QUERIES	256
// ********************************************************************
//  class CVDBApp
//  The application class.  Also the base class for
//  CVDBDataSource, CVDBForm and CVDBQuery.
// ********************************************************************

class CVDBApp 
{
public:
	CVDBApp();
	virtual ~CVDBApp() ;

	int Connect() ;
	int Disconnect() ;
	CVDBString& GetClassString();
	long GetAppHandle();
	long GetRevision();
	VOID FAR * GetHEnv();
	int CheckVersion();
	int GetError(CVDBString& cvSQLSTATE,
		     long &lNativeError,
		     CVDBString& cvErrorMsg,
		     int &nReturnCode);
	int GetErrorMsg(int nErrorNo,
			CVDBString& cvErrorMsg);
	int EnableErrorDisplay(BOOL bDisplay = TRUE);
	int EnableStmtDisplay(BOOL bDisplay = TRUE);
	int SetAppMode(short sMode = SQC_APP_SHOWERR);
	short GetAppMode();
	int ActOnForms();
	CVDBString &GetCurrentForm(CVDBString &CurrentForm) ;
	int GetObjectHandle(const char *pszObjectName,
				 long &Handle,
				 VDB_ObjectType ObjectType);
	CVDBString& GetObjectName(long lHandle,
				  VDB_ObjectType ObjectType, CVDBString &TmpStr);
	int BindAll(const char *pszControlList, const char *pszColumnList );
	int BindExpr(const char *pszControl, const char *pszExprStmt) ;
	int ExecuteCursors(const char *pszCursorList, long &hLastCursor);
	CVDBString& FormatDate(VDB_DateCvt sFormat,
					 const char *pszDateIn,
					 const char *pszFormat, CVDBString &TmpStr);
	int Trigger(const char *pszControlName, long lRowNum);


	protected:

	CVDBString 	m_ClassString;
	long 		m_lAppHand;
	long 		m_lRevision;
	int 		m_RetCod ;

	private:

	VOID FAR 	*m_hEnv;
	short 		m_sMode;
	short 		m_sState;
	BOOL 		m_bLog;
	BOOL 		m_bTrace;
};


// ********************************************************************
//  class CVDBDataSource
//  The database connection class.
//
// ********************************************************************

class CVDBDataSource : public CVDBApp 
{

public:
	CVDBDataSource();
	virtual ~CVDBDataSource();

	int Connect(const char *pszConnectionName,
			 const char *pszConnectStr,
			 HWND hWnd);
	int Connect(const char *pszConnectionName,
			 const char *pszConnectStr,
			 CVDBString& cvConnectStrOut,
			 HWND hWnd);
	int Connect(const char *pszConnectionName,
			 const char *pszDataSourceName,
			 const char *pszUserId,
			 const char *pszPassword,
			 VDB_ConnectTypes ConnectType,
			 CVDBString& cvConnectStrOut,
			 HWND hWnd);
	int Attach(const char *pszConnectionName);
	int Detach();
	int Disconnect();
	int SetIsolation(VDB_Isolation Isolation
				= VDB_DefaultIsolation);
	int SetAutoCommit(BOOL bSet = TRUE);
	int SetScope(VDB_ScopeOption ScopeOption
				= VDB_DefaultScope);
	int SetDatabaseMode(unsigned long lDBMode = 0);
	unsigned long GetDatabaseMode() ;
	int SetDateFormat(const char *DispFmt, const char *DrvFmt);
	int SetDateDisplayFormat(VDB_DateFormat DisplayFormat
					= VDB_WinIni, CVDBString Seperator = (CVDBString) "/");
	int SetDriverDateFormat(VDB_DateFormat DriverFormat
					= VDB_DefaultDateFormat,CVDBString Seperator = "/");
	int GetHDBC(HDBC &hDbc);
	CVDBString &GetConnectionName() ;
	int CommitWork();
	int RollbackWork();
	BOOL IsConnected() ;


private:
	CVDBString m_ConnectionName;
	CVDBString m_ConnectionStr;	
	short m_sConnectType;
	BOOL	m_bConnected ;
	BOOL	m_bAttached ;
	HDBC m_hDbc;
	long m_lDataBaseMode;
	CVDBString m_DateDisplayFormat;
	CVDBString m_DateDriverFormat;
};


// ********************************************************************
//  class CVDBForm                   
//  The form class - represents a dialog, form view or
//  scroll view.
// ********************************************************************

class CVDBForm : public CVDBApp 
{

public:
	CVDBForm(const char *pszFormName = NULL, HWND hWnd = NULL);
	virtual ~CVDBForm() ;
	int AttachForm(const char *pszFormName, HWND hWnd);
	int AttachForm(const char *pszFormName);
	int DetachForm();
	int Clear();
	int SetCurrent();
	int AttachControl(const char *pszControlName,
			  VDB_ControlType ControlType,
			  HWND hWnd);
	int DetachControl(const char *pszControlName);
	int Bind(const char *pszControlList, const char *pszColumnList);


private:
	CVDBString m_FormName;
	short m_sFormState;
	BOOL m_bAttached ;
	HWND m_hFrmWnd ;
	BOOL m_bValidForm;	// flag that indicates
				// if this is a valid 
				// form object
};


// ********************************************************************
//  class CVDBQuery                  
//  The query class - represents a query object.
//  
// ********************************************************************

class CVDBQuery : public CVDBApp 
{

public:
	CVDBQuery();
	CVDBQuery(const char *pszQuery);
	virtual ~CVDBQuery();	

	int Attach(const char *pszQuery);
	int AttachOnLoad(const char *pszQuery);
	int Detach() ;
	int BatchEdit(const char *pszIUDStr, short Mode);
	int BindColumn(short sCol,
		       void FAR *pszColBuf,
				 long lMaxBufSize,
				 short FAR *sNullFlag = NULL,
				 VDB_DataType DataType = VDB_Char);
	int BindColumn(const char *pszColumnName,
				 void FAR *pszColBuf,
				 long lMaxBufSize,
				 short FAR *sNullFlag = NULL,
				 VDB_DataType = VDB_Char);
	int BindTrigger(const char *pszTriggerList);
	int Build(const char *pszStatement,
			CVDBDataSource VDBDataSource,
			VDB_QueryType QueryType = VDB_Select,
			long lAccessMode = VDB_DefaultAccessMode);
	int Build(const char *pszStatement,
			const char *pszConnectionName,
			VDB_QueryType QueryType = VDB_Select,
			long lAccessMode = VDB_DefaultAccessMode);
	int BuildBindAndExecute(const char *pszControlList,
				  const char *pszStatement,
				  CVDBDataSource& VDBDataSource,
				  VDB_QueryType QueryType = VDB_Select,
				  long lAccessMode = VDB_DefaultAccessMode);
	int BuildBindAndExecute(const char *pszControlList,
				  const char *pszStatement,
				  const char *pszConnectionName,
				  VDB_QueryType QueryType = VDB_Select,
				  long lAccessMode = VDB_DefaultAccessMode);
	int ButtonControl(VDB_ButtonOp ButtonOp,
			  HWND hWnd);
	int Bind(const char *pszControlList, const char *pszColumnList);
	int BindCursor(const char *pszControlList);
	int CreateDataStream(const char *pszQueryName, 
			VDB_StreamType StreamType = VDB_OdbcStream) ;
	int DeleteDataStream() ;
	int Clear();
	int Close();
	int CloseAndUnbind();
	int ConvertToMemCursor(long &lRecNum);
	int DeleteFromForm();
	int DeleteRecord(long lRecNum = 0);
	int Fetch(VDB_FetchPos FetchPos = VDB_FetchNext, 
		  long lRecNum = 0);
	long GetCurrentRowNumber();
	int GetColInfo(short sCol, CVDBString& cvColumnName,
				 int &nDataType,
				 long &lPrecision,
				 int &nScale,
				 long &lDisplayWidth);
	int GetColInfo(SQCCOLINFO &VDBColInfo,
		       short sCol);
	int GetCursorInfo(CVDBString& cvDBMSName,
			  CVDBString& cvCursorName,
			  long &plNoofRows,
			  int &pnNoofCols);
	int GetCursorInfo(SQCCURSINFO &VDBCursorInfo);
	int GetLogicalRecord(long &lLRecNum,	
			     long lPRecNum);
	int GetPhysicalRecord(long &lPRecNum,	
			      long lLRecNum);
        long GetHandle() ;
	CVDBString &GetQueryName() ;
	int InsertFromForm();
	int InsertRecord(long &NewRecNum);   
	int InsertRecord();
	int NewRecord(short sMode, long &NewRecNum);
	int Open(const char *pszActionStr = NULL);
	int QueryByForm(const char *pszActionStr = NULL,
			short sMode = VDB_Query_AND);
	long Find(const char *FindStr, long m_StartRow) ;
	int ReadPhysicalRecord(long lRec, 
			       long &plRecFlags);
	int ReadColumn(short sCol,
		       void FAR *pszColBuf,
		       long lMaxBufSize,
		       long lRec = 0,
		       short FAR *sNullFlag = NULL,
		       VDB_DataType DataType = VDB_Char);
	int ReadColumn(const char *pszColumnName,
		       void FAR *pszColBuf,
		       long lMaxBufSize,
		       long lRec = 0,
		       short FAR *sNullFlag = NULL,
		       VDB_DataType DataType = VDB_Char);
/* FIXME : LATER
	int ReadColumn(short sCol, 
		       int *pnColumnValue,
		       long lRec = 0);
	int ReadColumn(short sCol,
		       long *plColumnValue,
		       long lRec = 0);
	int ReadColumn(short sCol,
		       float *pfColumnValue,
		       long lRec = 0);
	int ReadColumn(short sCol,
		       double *pdColumnValue,
		       long lRec = 0);
*/
	int ReadRecord(long lRecNum = 0);
	int SetColAttr(short sCol,
		       const char *pszHeaderName,
		       const char *pszDefaultValue,
		       int nColWidth,
		       const char *pszTableName,
		       VDB_JustType Justify = VDB_LeftJust ,
		       BOOL bUpdatePermitted = TRUE,
		       BOOL bQueryPermitted = TRUE);
	int SetColAttr(const char *pszColAttrStr,
		       short sCol = 1);
	int SetColInfo(short sCol, const char *pszColumnName,
		       VDB_DataType DataType,
		       long lPrecision,
		       int nScale,
		       long lDisplayWidth);		
	int SetColInfo(short sCol, SQCCOLINFO *pVDBColInfo);
	int SetCursorInfo(int nCols);
	int SetCursorInfo(SQCCURSINFO *pVDBCursInfo);
	int SetTopRow(long lRecNum = 1);
	int UnbindColumns();
	int UpdateFromForm();
	int UpdateRecord(long lRec = 0);
	int FilterAndSort(const char *szFilter, const char *SortSpec = NULL, 
			BOOL Distinct = FALSE) ;
	virtual void OnOpen();
	virtual void OnPostOpen(long RetVal);
	virtual void OnExecute(const char FAR *szStatement);
	virtual void OnFetch(VDB_FetchEventType FetchType, long RowNum);
	virtual void OnRowSel(long RowNum);
	virtual void OnLastRec(long NumRecs);
	virtual int PreInsert(long lRecNum);
	virtual void OnInsert(long RetVal, long lRecNum);
	virtual int PreUpdate(long lRecNum);
	virtual void OnUpdate(long RetVal, long lRecNum);
	virtual int PreDelete(long lRecNum);
	virtual void OnDelete(long RetVal, long lRecNum);
	virtual void OnError(int nOperation,
			    int nReturnCode);
	virtual void OnClose();
	virtual void OnDestroy();


private:
	CVDBString 	m_QueryName;
	CVDBString	m_FilterSpec ;
	CVDBString	m_SortSpec ;
	BOOL		m_Distinct ;
	long 		m_hQuery;
	short 		m_sType;
	VDB_StreamType  m_StreamType ;
	long 		m_lModeMask;
	long 		m_lCurrentRow;
	short 		m_sQueryState;
	BOOL		m_bAttached ;
	BOOL 		m_bDesignObject;	// flag that indicates
				// if this query object 
				// was created in design mode 
};

class CVDBView : public CVDBQuery {
public :
	CVDBView() ;
	virtual ~CVDBView() ;

	int CreateDataStream(const char *ViewName) {
		return CVDBQuery::CreateDataStream(ViewName, VDB_CursorView) ;
	} ;
	int CreateView(const char *BaseQuery, const char *ViewColumns = NULL,
		long lAccessMode = VDB_DefaultAccessMode) ;
	int CreateView(CVDBQuery &BaseQuery, const char *ViewColumns = NULL,
		long lAccessMode = VDB_DefaultAccessMode) ;
} ;


		
class CVDBCallbackClass : public CVDBQuery
{
	friend void FAR PASCAL _export CVDBCallBack(
			int		Event,
			void 		FAR *pContext,
			long		lParam,
			CIGENEVENT 	FAR *pEventInfo
	) ;
};
//  build data source modes and action codes


#define SQC_QueryFromStmt	1		// open the cursor from qry
#define SQC_QueryFromForm	2		// open cursor from interactive
#define SQC_UpdateFromForm 	3		//
#define SQC_InsertFromForm	4		//
#define SQC_DeleteFromForm	5		//
#define SQC_Fetch		6		//
#define SQC_Close		7		// close the cursor if open
#define SQC_Clear		8		// clear all controls attached
#define SQC_UpdateRecord 	9		//
#define SQC_InsertRecord	10		//
#define SQC_DeleteRecord	11		//
#define SQC_ReadRecord		12		//
#define SQC_CursorInfo		13		//
#define SQC_ColumnInfo		14		//
#define SQC_Evaluate		15
#define SQC_GenericStmt		16
#define SQC_SetTopRow		17
#define SQC_LogRecord		18
#define SQC_LtoP		19
#define SQC_PtoL		20
#define SQC_ConvertToMemCursor	21
#define SQC_MoveMemtoTable	22
#define SQC_ReadPhRecord	23		//
#define SQC_ButtonControl	24		//
#define SQC_NewRecord		25		//
#define SQC_SetMaskMode		26		//
#define SQC_Search		27		//
#define SQC_SetRowFlags		28		//
#define SQC_UpdateTable		29		//
#define SQC_DeleteTable		30		//
#define SQC_InsertTable		31		//
#define SQC_ReadColumn		32		//
#define SQC_WriteColumn		33		//
#define SQC_UpdateCurBuf	34		//
#define SQC_InsertCurBuf	35		//
#define SQC_FilterAndSort	36		//
#define SQC_Find		37		//

#endif	/* _VDB_H */
