/*  Project nextapp
    
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    nextapp.exe Application
    FILE:         nxtppapp.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of nextappApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\vbxctl.h>


#include "nxtppapp.h"
#include "nxtppabd.h"                        // Definition of about dialog.
#include "sqcmain.h"

//{{nextappApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(nextappApp, TApplication)
//{{nextappAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
	 EV_COMMAND(CM_FILEOPEN, CmFileOpen),
    EV_COMMAND(CM_FILECLOSE, CmFileClose),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
    EV_COMMAND(CM_EXIT, CmExit),
//{{nextappAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
				TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      {  }
};


//////////////////////////////////////////////////////////
// nextappApp
// =====
//
nextappApp::nextappApp () : TApplication("NextApp")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


nextappApp::~nextappApp ()
{
	 // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// nextappApp
// =====
// Application intialization.
//
void nextappApp::InitMainWindow ()
{
    Client = new TEditFile(0, 0, 0);
	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, FALSE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

	 //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);

    //
    // Associate with the accelerator table.
    //
	 frame->Attr.AccelTable = SDI_MENU;

  
    MainWindow = frame;

}


//////////////////////////////////////////////////////////
// nextappApp
// ===========
// Menu File New command
void nextappApp::CmFileNew ()
{
    Client->NewFile();
}


//////////////////////////////////////////////////////////
// nextappApp
// ===========
// Menu File Open command
void nextappApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
	 //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
				OpenFile();
}


void nextappApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

	 Client->ReplaceWith(FileData.FileName);
}


//////////////////////////////////////////////////////////
// nextappApp
// =====
// Menu File Close command
void nextappApp::CmFileClose ()
{
	 if (Client->CanClose())
	         Client->DeleteSubText(0, UINT(-1));
}


//////////////////////////////////////////////////////////
// nextappApp
// ===========
// Menu Help About nextapp.exe command
void nextappApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
	 //
	 nextappAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
	 TBIVbxLibrary   vbxSupport;                 // This application has VBX controls.
	 nextappApp     App;
	 int             result;

	 SQcConnect(&App.AppHand, &App.Revision);
	 result = App.Run();
	 SQcDisconnect(App.AppHand);

	 return result;
}

void nextappApp::InitInstance ()
{
	 TApplication::InitInstance();
	 DocDlg = new TDocDlg(MainWindow, TResId(IDD_DOCTORS));
	 DocDlg->Create();
    PatDlg = new TPatDlg(MainWindow, TResId(IDD_PATIENTS));
    PatDlg->Create();
	 SQcGo(AppHand,0);
}


void nextappApp::CmExit ()
{
	 delete DocDlg;
	 DocDlg = NULL;
	 delete PatDlg ;
	 PatDlg = NULL ;
}

