/*  Project vbx

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    vbx.exe Application
	 FILE:         vbxmdich.cpp
	 AUTHOR:


	 OVERVIEW
	 ========
	 Source file for implementation of vbxMDIChild (TMDIChild).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "vbxapp.h"
#include "vbxmdich.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled
// by the application.
//
//DEFINE_RESPONSE_TABLE1(vbxMDIChild, TMDIChild)
DEFINE_RESPONSE_TABLE2(vbxMDIChild, TMDIChild, TVbxEventHandler)
//{{vbxMDIChildRSP_TBL_BEGIN}}
	EV_VBXEVENTINDEX( IDC_MHSPIN1, Event_MhSpin_Change1, EvChange1 ),
	EV_WM_LBUTTONDOWN,
	EV_WM_ERASEBKGND,
//{{vbxMDIChildRSP_TBL_END}}
END_RESPONSE_TABLE;

//{{vbxMDIChild Implementation}}

//////////////////////////////////////////////////////////
// vbxMDIChild
// ==========
// Construction/Destruction handling.
vbxMDIChild::vbxMDIChild (TMDIClient &parent, const char far *title, TWindow *clientWnd, BOOL shrinkToClient, TModule *module)
	 : TMDIChild (parent, title, clientWnd, shrinkToClient, module)
// This was modified, since AppExpert assumes that an MDI app is a text window
// rather than a graphics app.
//	 : TMDIChild (parent, title, clientWnd == 0 ? new TEditFile(0, 0, 0) : clientWnd, shrinkToClient, module)
{
	 // INSERT>> Your constructor code here.
	VbxMhSpin = new TVbxMhSpin(	this,
											IDC_MHSPIN1,
											"Test Spinner",
											10,	// X coord
											10,	// Y coord
											100,	// width
											40,	// height
											sizeof(MhSpinData),
											MhSpinData);
}


vbxMDIChild::~vbxMDIChild ()
{
	Destroy();

	// INSERT>> Your destructor code here.
	delete VbxMhSpin;

}

void vbxMDIChild::EvLButtonDown (UINT modKeys, TPoint& point)
{
	TMDIChild::EvLButtonDown(modKeys, point);

	// INSERT>> Your code here.
	MessageBox("Left Button Pressed", "Mouse Event");

}


BOOL vbxMDIChild::EvEraseBkgnd (HDC dc)
{
	BOOL result;

	result = TMDIChild::EvEraseBkgnd(dc);

	// INSERT>> Your code here.
	TRect			windowSize			=	GetClientRect();

	// Note that move uses twips for units instead of pixels (constructor uses
	// pixels).
	VbxMhSpin->Move(	1440/2, 										//1 inch over
							1440,  										//1 inch down
							VBXPix2TwpX(100),
							VBXPix2TwpY(40));

	 VbxMhSpin->SetProp("ValueRight",(int)600);
	 VbxMhSpin->SetProp("PictureLeft",(int)1000);

	return result;
}


void vbxMDIChild::EvChange1(VBXEVENT FAR*)
{
	// PartBar As Integer
	long		CurrentVbxValue;
	VbxMhSpin->GetPropValue(CurrentVbxValue);

	char s[6];
	TClientDC dc(*this);

	wsprintf(s, "%3d  ", CurrentVbxValue);
	dc.TextOut(10, 10, s, strlen(s));

}

